# An Awesome List of Awesomes

<p align="center">
  <img width="300" src="https://i.imgur.com/Ky2jxnj.png" "Awesome!">
</p>


[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](http://makeapullrequest.com)

This is a simple aggregation of all of the "Awesome --Topic name--" github repos I've found till date and I feel are important to get started in the corresponding Topic.

The topics are relevant to Data lifecycle, Machine Learning, Deep learning research and some distributed computing.

Note: Not all of these links are actively maintained but some of them may serve as good starting points. 
There are multiple lists for certain topics which may or may not have common links, I have added them with a serial number under the topic in no particular order.

# Topic wise ML and DL research

* [Math](https://github.com/rossant/awesome-math)
* Data augmentation
    * [Data Augmentation link 1](https://github.com/CrazyVertigo/awesome-data-augmentation)
    * [Data Augmentation link 2](https://brunokrinski.github.io/awesome-data-augmentation/)
    * [Data Augmentation review](https://github.com/AgaMiko/data-augmentation-review)
* [Multitask learning](https://github.com/SimonVandenhende/Awesome-Multi-Task-Learning)
* Diffusion models
    * [Diffusion models link 1](https://github.com/heejkoo/Awesome-Diffusion-Models)
    * [Diffusion models link 2](https://github.com/hyungkwonko/awesome-diffusion-models)
    * [Stable Diffusion](https://github.com/awesome-stable-diffusion/awesome-stable-diffusion)
* Self supervised learning
    * [Self supervised learning link 1](https://github.com/jason718/awesome-self-supervised-learning)
    * [Self supervised learning link 2](https://github.com/wvangansbeke/Self-Supervised-Learning-Overview)
* [Semi supervised learning](https://github.com/yassouali/awesome-semi-supervised-learning)
* Weakly Supervised Learning
    * [Weak Supervision](https://github.com/JieyuZ2/Awesome-Weak-Supervision)
    * [Weakly Supervised Image Segmentation link 1](https://github.com/gyguo/awesome-weakly-supervised-semantic-segmentation-image)
    * [Weakly Supervised Image Segmentation link 2](https://github.com/YimingCuiCuiCui/awesome-weakly-supervised-segmentation)
* [Learning with Label noise](https://github.com/subeeshvasu/Awesome-Learning-with-Label-Noise)
* Adversarial ML/DL
    * [Adversarial ML](https://github.com/yenchenlin/awesome-adversarial-machine-learning)
    * [Adversarial Examples for Deep learning](https://github.com/chbrian/awesome-adversarial-examples-dl)
* [Architecture Search](https://github.com/markdtw/awesome-architecture-search)
* [Contrastive self supervised learning](https://github.com/asheeshcric/awesome-contrastive-self-supervised-learning)
* Zero shot learning
    * [Zero shot learning link 1](https://github.com/sbharadwajj/awesome-zero-shot-learning)
    * [Zero shot learning link 2](https://github.com/WilliamYi96/Awesome-Zero-Shot-Learning)
* [One shot learning](https://awesomeopensource.com/projects/one-shot-learning)
* Few shot learning
    * [Few shot learning link 1](https://github.com/e-271/awesome-few-shot-learning)
    * [Few shot learning link 2](https://github.com/Duan-JM/awesome-papers-fewshot)
* [Siamese networks](https://awesomeopensource.com/projects/siamese-network)
* [Image Classification](https://github.com/weiaicunzai/awesome-image-classification)
* [Contrastive learning](https://github.com/VainF/Awesome-Contrastive-Learning)
* [Visual transformers](https://github.com/dk-liang/Awesome-Visual-Transformer)
* [Transformers for vision](https://github.com/lijiaman/awesome-transformer-for-vision)
* [Transformers in Medical Imaging](https://github.com/fahadshamshad/awesome-transformers-in-medical-imaging)
* Transformers
    * [Transformers link 1](https://github.com/ictnlp/awesome-transformer)
    * [Treasure-of-Transformers](https://github.com/ashishpatel26/Treasure-of-Transformers)
    * [Transformers link 2](https://github.com/abacaj/awesome-transformers)
* [OpenSetRecognition list](https://github.com/iCGY96/awesome_OpenSetRecognition_list)
* [Incremental learning](https://github.com/xialeiliu/Awesome-Incremental-Learning)
* Meta Learning
    * [Meta learning link 1](https://github.com/dragen1860/awesome-meta-learning)
    * [Meta learning link 2](https://github.com/sudharsan13296/Awesome-Meta-Learning)
* [Deep learning uncertainty](https://github.com/ahmedmalaa/deep-learning-uncertainty)
* [Semantic segmentation](https://github.com/mrgloom/awesome-semantic-segmentation)
* [Instance Segmentation](https://github.com/YimingCuiCuiCui/awesome-instance-segmentation)
* [Box supervised Instance Segmentation](https://github.com/LiWentomng/Box-supervised-instance-segmentation)
* [Referring Segmentation](https://github.com/MarkMoHR/Awesome-Referring-Image-Segmentation)
* [Image Delineation](https://github.com/subeeshvasu/Awsome_Delineation)
* Long tailed recognition/learning
    * [Long tailed recognition link 1](https://github.com/zzw-zwzhang/Awesome-of-Long-Tailed-Recognition)
    * [Long tailed recognition link 2](https://github.com/Stomach-ache/awesome-long-tailed-learning)
    * [Long tailed recognition link 3](https://github.com/Vanint/Awesome-LongTailed-Learning)
* [Image matting](https://github.com/michaelowenliu/awesome-image-matting)
* [Image inpainting](https://github.com/1900zyh/Awesome-Image-Inpainting)
* [Image Harmonization](https://github.com/subeeshvasu/Awesome-ImageHarmonization)
* Face
    * [Face Recognition](https://github.com/ChanChiChoi/awesome-Face_Recognition)
    * [Face related resources](https://github.com/polarisZhao/awesome-face)
* [Conformal predictions](https://github.com/valeman/awesome-conformal-prediction)
* [Scene understanding](https://github.com/bertjiazheng/awesome-scene-understanding)
* Panoptic Segmentation
    * [Panoptic Segmentation link 1](https://github.com/Angzz/awesome-panoptic-segmentation)
    * [Panoptic Segmentation link 2](https://github.com/YimingCuiCuiCui/Awesome-Panoptic-Segmentation-Papers)
* Object Tracking and Detection
    * [Object Detection link 1](https://github.com/amusi/awesome-object-detection)
    * [Object Detection link 2](https://github.com/daicoolb/Awesome-Object-Detections)
    * [Object Tracking and Detection](https://github.com/abhineet123/Deep-Learning-for-Tracking-and-Detection)
    * [Object Detection papers](https://github.com/hoya012/deep_learning_object_detection)
    * [YOLO Object detection](https://github.com/dotnet-rs-py/awesome-yolo-object-detection)
* Image Denoising
    * [Image Denoising link 1](https://github.com/oneTaken/Awesome-Denoise)
    * [Image Denoising link 2](https://github.com/z-bingo/awesome-image-denoising-state-of-the-art)
* [Image Distortion correction](https://github.com/subeeshvasu/Awesome-Image-Distortion-Correction)
* [Image Deblurring](https://github.com/subeeshvasu/Awesome-Deblurring)
* [Continual Learning/Lifelong learning](https://github.com/prprbr/awesome-lifelong-continual-learning)
* Multimodal learning
    * [Multimodal learning link 1](https://github.com/pliang279/awesome-multimodal-ml)
    * [Multimodal learning link 2](https://github.com/Eurus-Holmes/Awesome-Multimodal-Research)
* [Multimodal Conversational AI](https://github.com/holylovenia/awesome-multimodal-convai)
* Active learning
    * [Active learning link 1](https://github.com/yongjin-shin/awesome-active-learning)
    * [Active learning link 2](https://github.com/2006pmach/awesome-active-learning)
* Deep Reinforcement Learning
    * [Deep Reinforcement Learning Link 1](https://github.com/brianspiering/awesome-deep-rl)
    * [Deep Reinorcement Learning Link 2](https://github.com/kengz/awesome-deep-rl)
* Knowledge Distillation
    * [Knowledge distillation link 1](https://github.com/FLHonker/Awesome-Knowledge-Distillation)
    * [Knowledge distillation link 2](https://github.com/dkozlov/awesome-knowledge-distillation)
* [Anomaly detection](https://github.com/hoya012/awesome-anomaly-detection)
* [Local Global Descriptors](https://github.com/shamangary/awesome-local-global-descriptor)
* Image Captioning
    * [Image Captioning link 1](https://github.com/zhjohnchan/awesome-image-captioning)
    * [Image Captioning link 2](https://github.com/forence/Awesome-Visual-Captioning)
* [Image to Image translation](https://github.com/weihaox/awesome-image-translation)
* Image Registration
    * [Image Registration](https://github.com/Awesome-Image-Registration-Organization/awesome-image-registration)
    * [Point Cloud registration link 1](https://github.com/Awesome-Image-Registration-Organization/Point-cloud-registration)
    * [Point Cloud registration link 2](https://github.com/XuyangBai/awesome-point-cloud-registration)
    * [2D-3D Matching](https://github.com/Awesome-Image-Registration-Organization/2D-3D-matching)
* [Text To Speech](https://github.com/seungwonpark/awesome-tts-samples)
* Text to Image synthesis
    * [Text to Image link 1](https://github.com/Yutong-Zhou-cv/Awesome-Text-to-Image)
    * [Text to Image link 2](https://github.com/kunli-cs/Awesome-Text-to-Image-Synthesis)
* [Deep HDR Image synthesis](https://github.com/vinthony/awesome-deep-hdr)
* [Speech recognition & synthesis](https://github.com/zzw922cn/awesome-speech-recognition-speech-synthesis-papers)
* [Speaker Diarization](https://github.com/wq2012/awesome-diarization)
* Video Analysis
    * [Video analysis](https://github.com/HuaizhengZhang/Awsome-Deep-Learning-for-Video-Analysis)
    * [Video Action Recognition](https://github.com/jinwchoi/awesome-action-recognition)
    * [Video understanding](https://github.com/sujiongming/awesome-video-understanding)
    * [Video Object Detection](https://github.com/ZHANGHeng19931123/awesome-video-object-detection)
    * [Video Text Retrieval](https://github.com/danieljf24/awesome-video-text-retrieval)
* [Video Generation](https://github.com/matthewvowels1/Awesome-Video-Generation)
* Pose Estimation
    * [Pose estimation link 1](https://github.com/wangzheallen/awesome-human-pose-estimation)
    * [Pose estimation link 2](https://github.com/cbsudux/awesome-human-pose-estimation)
* [Machine translation](https://github.com/maidis/awesome-machine-translation)
* Visual Question Answering (VQA)
    * [Visual Question Answering link 1](https://github.com/jokieleung/awesome-visual-question-answering)
    * [Visual Question Answering link 2](https://github.com/Taaccoo/awesome-vqa-latest)
* Question Answering (QA)
    * [Question Answering link 1](https://github.com/seriousran/awesome-qa)
    * [Question Answering link 2](https://github.com/dapurv5/awesome-question-answering)
    * [Question Answering link 3](https://github.com/monk1337/Awesome-Question-Answering)
* [Vision and Language Pretrained models](https://github.com/yuewang-cuhk/awesome-vision-language-pretraining-papers)
* [Vision-Language Navigation](https://github.com/daqingliu/awesome-vln)
* [Explainable Graph Reasoning](https://github.com/AstraZeneca/awesome-explainable-graph-reasoning)
* [Knowledge Graph Question Answering](https://github.com/BshoterJ/awesome-kgqa)
* [Sentence embeddings](https://github.com/Separius/awesome-sentence-embedding)
* [Embedding Models](https://github.com/Hironsan/awesome-embedding-models)
* Text Summarization
    * [Text Summarization link 1](https://github.com/mathsyouth/awesome-text-summarization)
    * [Text Summarization link 2](https://github.com/icoxfog417/awesome-text-summarization)
    * [Text Summarization link 3](https://github.com/xcfcode/Summarization-Papers)
* Optical Character Recognition (OCR)
    * [Optical Character Recognition (OCR) link 1](https://github.com/kba/awesome-ocr)
    * [Optical Character Recognition (OCR) link 2](https://github.com/zacharywhitley/awesome-ocr)
* [Document understanding](https://github.com/tstanislawek/awesome-document-understanding)
* Graph Neural Networks (GNN)
    * [Graph Neural Networks (GNN) link 1](https://github.com/GRAND-Lab/Awesome-Graph-Neural-Networks)
    * [Graph Neural Networks (GNN) link 2](https://github.com/thunlp/GNNPapers)
    * [Graph Neural Networks (GNN) link 3](https://github.com/mengliu1998/awesome-deep-gnn)
    * [Expressive GNN](https://github.com/mengliu1998/awesome-expressive-gnn)
* Generative Adversarial Networks (GAN)
    * [Generative Adversarial Networks (GAN) link 1](https://github.com/nightrome/really-awesome-gan)
    * [Generative Adversarial Networks (GAN) link 2](https://github.com/kozistr/Awesome-GANs)
    * [GAN Training](https://github.com/subeeshvasu/Awsome-GAN-Training)
    * [GAN Applications](https://github.com/nashory/gans-awesome-applications)
* [AI Art Image Synthesis](https://github.com/altryne/awesome-ai-art-image-synthesis)
* [Generative Modelling](https://github.com/zhoubolei/awesome-generative-modeling)
* [Optical Flow](https://github.com/antran89/awesome-optical-flow-algorithm)
* [360 vision](https://github.com/hsientzucheng/awesome-360-vision)
* [Image Alignment and Stitching](https://github.com/tzxiang/awesome-image-alignment-and-stitching)
* [Energy based models](https://github.com/yataobian/awesome-ebm)
* [Decision Trees](https://github.com/benedekrozemberczki/awesome-decision-tree-papers)
* Gradient Boosting Models
    * [XGBoost](https://github.com/dmlc/xgboost/tree/master/demo)
    * [Gradient Boosting Machines (GBMs)](https://github.com/szilard/awesome-GBMs)
    * [Gradient Boosting](https://github.com/talperetz/awesome-gradient-boosting)
* [Metric Learing](https://githubmate.com/repo/Adamdad/Awesome-metrics-learning)
* Recommendation Systems
    * [Recommendation Systems link 1](https://github.com/jihoo-kim/awesome-RecSys)
    * [Recommendation Systems link 2](https://github.com/scnu-dil/awesome-RecSys)
    * [Recommendation Systems link 3](https://github.com/xue-pai/xuepai-recommender-systems)
* [Point Cloud Analysis](https://github.com/Yochengliu/awesome-point-cloud-analysis)
* [Pruning](https://github.com/he-y/Awesome-Pruning)
* [Neural Ordinary Differential Equations (ODE)](https://github.com/Zymrael/awesome-neural-ode)
* Autonomous Vehicles (FSD)
    * [Autonomous Vehicles (FSD) link 1](https://github.com/manfreddiaz/awesome-autonomous-vehicles)
    * [Autonomous Vehicles (FSD) link 2](https://github.com/daohu527/awesome-self-driving-car)
* [Robotics](https://github.com/kiloreux/awesome-robotics)
* [Curriculum Learning](https://github.com/Openning07/awesome-curriculum-learning)
* Causal Inference/ML
    * [Causal Inference/ML Link 1](https://github.com/rguo12/awesome-causality-algorithms)
    * [Causal Inference/ML Link 2](https://github.com/imirzadeh/awesome-causal-inference)
    * [Causal Inference/ML Link 3](https://shubhanshu.com/awesome-causality/)
    * [Causal Inference Visual Guides](https://github.com/kathoffman/causal-inference-visual-guides)
* [Satellite Image Deep Learning](https://github.com/robmarkcole/satellite-image-deep-learning)
* Transfer learning, Domain Adaption & Domain Generalization
    * [Transfer learning, Domain Adaption & Domain Generalization link 1](https://github.com/artix41/awesome-transfer-learning)
    * [Transfer learning, Domain Adaption & Domain Generalization link 2](https://github.com/sun254/awesome-transfer-learning)
    * [Transfer learning, Domain Adaption & Domain Generalization link 3](https://github.com/zhaoxin94/awesome-domain-adaptation)
    * [Transfer learning, Domain Adaption & Domain Generalization link 4](https://github.com/amber0309/Domain-generalization)
    * [Domain Adaption - Object detection](https://github.com/wangs311/awesome-domain-adaptation-object-detection)
* [Image Restoration](https://github.com/oneTaken/Awesome-restoration)
* [Variational Autoencoders](https://github.com/matthewvowels1/Awesome-VAEs)
* Bayesian inference/Bayesian DL
    * [Bayesian inference/Bayesian DL link 1](https://github.com/robi56/awesome-bayesian-deep-learning)
    * [Bayesian inference/Bayesian DL link 2](https://github.com/dimenwarper/awesome-bayes)
* [Deep Geometrical Learning](https://github.com/subeeshvasu/Awsome_Deep_Geometry_Learning)
* [Drug Discovery](https://github.com/xnuohz/awesome-drug-discovery)
* [Representation Learning](https://github.com/Mehooz/awesome-representation-learning)
* Disentangled Representations
    * [Disentangled Representations link 1](https://github.com/koukyo1994/awesome-disentangled-representations)
    * [Disentangled Representations link 2](https://github.com/sootlasten/disentangled-representation-papers)
* Time series
    * [Time series link 1](https://github.com/cuge1995/awesome-time-series)
    * [Time series link 2](https://github.com/MaxBenChrist/awesome_time_series_in_python)
* [Unsupervised/Weakly supervised learning](https://github.com/LongLong-Jing/awesome-unsupervised-learning)
* [Neural Rendering](https://github.com/weihaox/awesome-neural-rendering)
* [Neural Radiance Fields](https://github.com/yenchenlin/awesome-NeRF)
* Neural Art & Style Transfer
    * [Neural Art](https://github.com/crypdick/awesome-neural-art)
    * [Style Transfer](https://github.com/neuralchen/awesome_style_transfer)
* Deepfakes
    * [Deepfakes link 1](https://github.com/aerophile/awesome-deepfakes)
    * [Deepfakes link 2](https://github.com/Qingcsai/awesome-Deepfakes)
* [Makeup transfer](https://github.com/thaoshibe/awesome-makeup-transfer)
* [Audio/Music](https://github.com/ybayle/awesome-deep-learning-music)
* [Inverse Graphics](https://github.com/collinskatie/awesome-inverse-graphics)
* Model Quantization
    * [Model Quantization link 1](https://github.com/htqin/awesome-model-quantization)
    * [Model Quantization link 2](https://github.com/ysbsb/awesome-quantization)
* [Quantum Machine Learning](https://github.com/krishnakumarsekar/awesome-quantum-machine-learning)
* Game AI
    * [Game AI link 1](https://github.com/tirthajyoti/Papers-Literature-ML-DL-RL-AI/tree/master/AI-Game-Theory)
    * [Game AI link 2](https://github.com/datamllab/awesome-game-ai)
* Biomedical ML
    * [Biomedical ML](https://github.com/DenseAI/awesome-biomedical-machine-learning)
    * [ML in Biomed Healthcare imaging](https://github.com/XindiWu/Awesome-Machine-Learning-in-Biomedical-Healthcare-Imaging)
    * [Neuron segmentation in EM images](https://github.com/subeeshvasu/Awesome-Neuron-Segmentation-in-EM-Images)
    * [Medical imaging](https://github.com/fepegar/awesome-medical-imaging)
* Financial ML/Quantitative Finance
    * [Financial ML](https://github.com/firmai/financial-machine-learning)
    * [Quantitative Finance](https://github.com/wilsonfreitas/awesome-quant)
    * [AI in Finance](https://github.com/georgezouq/awesome-ai-in-finance)
* [Embodied Vision](https://github.com/ChanganVR/awesome-embodied-vision)
* Embedded and Mobile ML
    * [Mobile Machine Learning](https://giters.com/mzkaramat/Awesome-Mobile-Machine-Learning)
    * [Embedded and Mobile ML](https://github.com/csarron/awesome-emdl)
* [3D Machine Learning](https://github.com/timzhang642/3D-Machine-Learning)
* AutoML
    * [AutoML link 1](https://github.com/windmaple/awesome-AutoML)
    * [AutoML link 2](https://github.com/hibayesian/awesome-automl-papers)
    * [AutoML link 3](https://github.com/oskar-j/awesome-auto-ml)
* Chatbot projects
    * [Chatbot projects link 1](https://github.com/fendouai/Awesome-Chatbot)
    * [Chatbot projects link 2](https://github.com/JStumpp/awesome-chatbots)
* [Conversational AI](https://awesomeopensource.com/projects/conversational-ai)
* AI for climate change
    * [AI for climate change link 1](https://github.com/shankarj67/Awesome-Climate-Change-AI)
    * [AI for climate change link 2](https://github.com/juannat7/Awesome-Climate-AI)
* Federated Learning
    * [Federated Learning link 1](https://github.com/poga/awesome-federated-learning)
    * [Federated Learning link 2](https://github.com/weimingwill/awesome-federated-learning)
    * [Federated Machine Learning](https://github.com/innovation-cat/Awesome-Federated-Machine-Learning)
    * [Federated Computing](https://github.com/tushar-semwal/awesome-federated-computing)
* [Relational Extraction](https://github.com/roomylee/awesome-relation-extraction)
* Attention Mechanisms in Computer Vision
    * [Attention Mechanism in Computer Vision](https://github.com/pprp/awesome-attention-mechanism-in-cv)
    * [Vision Attentions Survey](https://github.com/MenghaoGuo/Awesome-Vision-Attentions) 
    * [Transformers in Computer Vision](https://github.com/Yangzhangcst/Transformer-in-Computer-Vision)
* [Masked Image Modelling](https://github.com/ucasligang/awesome-MIM)
* [Table Recognition](https://github.com/cv-small-snails/Awesome-Table-Recognition)
* [Imbalanced Learning](https://github.com/ZhiningLiu1998/awesome-imbalanced-learning)
* [Music Generation](https://github.com/AI-Guru/music-generation-research)
* [3D Generation](https://github.com/justimyhxu/awesome-3D-generation)
* [Small Molecule - Drug Discovery ML](https://github.com/benb111/awesome-small-molecule-ml)
* [Low light Image Enhancement](https://github.com/dawnlh/awesome-low-light-image-enhancement)
* [DehazeZoo](https://github.com/cxtalk/DehazeZoo)
* [ML for cybersecurity](https://github.com/jivoi/awesome-ml-for-cybersecurity)
* [Various Attention implementations in PyTorch](https://github.com/sooftware/attentions)
* [Transformer Attention](https://github.com/cmhungsteve/Awesome-Transformer-Attention)
* [Radiology Report generation](https://github.com/zhjohnchan/awesome-radiology-report-generation)
* [Vision and Language](https://github.com/sangminwoo/awesome-vision-and-language)
* [Machine Learning for Combinatorial Optimization](https://github.com/Thinklab-SJTU/awesome-ml4co)
* [Dataset Distillation/Condensation](https://github.com/Guang000/Awesome-Dataset-Distillation)
* [Virtual Try on](https://github.com/minar09/awesome-virtual-try-on)
* [Protein Design using DL](https://github.com/Peldom/papers_for_protein_design_using_DL)
* [Novel Class Discovery](https://github.com/JosephKJ/Awesome-Novel-Class-Discovery)
* [Music Informatics](https://github.com/yamathcy/awesome-music-informatics)
* [Discovery of Physical Laws](https://github.com/usccolumbia/Awesome-Machine-learning-for-discovery-of-physical-laws)
* [CLIP (Contrastive Language-Image Pre-Training)](https://github.com/yzhuoning/Awesome-CLIP)
* Content Based Image Retrieval
    * [Content Based Image Retrieval Link 1](https://github.com/willard-yuan/awesome-cbir-papers)
    * [Content Based Image Retrieval Link 2](https://github.com/lgbwust/awesome-image-retrieval-papers)
* [Topic Modeling](https://github.com/jonaschn/awesome-topic-models)
* [Vector Search](https://github.com/currentslab/awesome-vector-search)
* [Clinical NLP](https://github.com/OHNLP/awesome-clinical-nlp)
* [Medical Coding NLP](https://github.com/acadTags/Awesome-medical-coding-NLP)
* [Content Moderation](https://github.com/fcakyon/content-moderation-deep-learning)
* [Pretrained Chinese NLP models](https://github.com/lonePatient/awesome-pretrained-chinese-nlp-models)
* [Computer Vision in the Wild](https://github.com/Computer-Vision-in-the-Wild/CVinW_Readings)
* [Mixture of Experts](https://github.com/codecaution/Awesome-Mixture-of-Experts-Papers)
* [Reasoning in Large Language Models](https://github.com/jeffhj/LM-reasoning)
* [LLM Robotics](https://github.com/GT-RIPL/Awesome-LLM-Robotics)
* [Networks Beyond Attention](https://github.com/FocalNet/Networks-Beyond-Attention)
* [Matching tasks](https://github.com/ZhengZixiang/MatchPapers)
* Semantic Search
    * [Semantic Search link 1](https://github.com/rom1504/awesome-semantic-search)
    * [Semantic Search link 2](https://github.com/Agrover112/awesome-semantic-search)
* [GAN Inversion](https://github.com/weihaox/awesome-gan-inversion)
* [Dynamic Graph Learning](https://github.com/SpaceLearner/Awesome-DynamicGraphLearning)
* [Molecular Generation](https://github.com/amorehead/awesome-molecular-generation)
* [Failed ML](https://github.com/kennethleungty/Failed-ML)
* [Generative AI Applications](https://github.com/ai-collection/ai-collection)
* ChatGPT
    * [ChatGPT link 1](https://github.com/shoaibahmed/awesome-ChatGPT)
* [Prompt Engineering](https://github.com/promptslab/Awesome-Prompt-Engineering)
* [Generative AI](https://github.com/filipecalegario/awesome-generative-ai)
* [Conditional Content Generation](https://github.com/haofanwang/awesome-conditional-content-generation)
* Large Language Models (LLM)
    * [Large Language Models (LLM) link 1](https://github.com/Hannibal046/Awesome-LLM)
    * [Large Language Models (LLM) link 2](https://github.com/TikkunCreation/awesome-llm)
    * [LLM Zoo](https://github.com/FreedomIntelligence/LLMZoo)
    * [LLM Practical Guide](https://github.com/Mooler0410/LLMsPracticalGuide)
    * [LLM Data hub](https://github.com/Zjh-819/LLMDataHub)
* [LLM Robotics](https://github.com/GT-RIPL/Awesome-LLM-Robotics)
* [LangChain](https://github.com/kyrolabs/awesome-langchain)
* Reinforcement Learning with Human Feedback(RLHF)
    * [RLHF Link 1](https://github.com/opendilab/awesome-RLHF)
    * [RLHF Link 2](https://github.com/jordimas/awesome-RLHF-language-models)
* [LLMOps](https://github.com/tensorchord/Awesome-LLMOps)
* [Instruction Dataset](https://github.com/yaodongC/awesome-instruction-dataset)
* [Totally open ChatGPT](https://github.com/nichtdax/awesome-totally-open-chatgpt)
* [6D Object Pose Estimation and Reconstruction](https://github.com/ZhongqunZHANG/awesome-6d-object)
* [Awesome Anything](https://github.com/VainF/Awesome-Anything)
* [Pretrained models for Information Retrieval](https://github.com/ict-bigdatalab/awesome-pretrained-models-for-information-retrieval)
* [AI Tools for Game development](https://github.com/simoninithomas/awesome-ai-tools-for-game-dev)
* [Human Video Generation](https://github.com/yule-li/Human-Video-Generation)
* [Medical Vision-Language Models](https://github.com/yangzhou12/awesome-medical-vision-language-models)
* [Video Diffusion](https://github.com/showlab/Awesome-Video-Diffusion)
* [Multimodal Large Language Models](https://github.com/BradyFU/Awesome-Multimodal-Large-Language-Models)

# Generic ML, DL, CV, NLP lists
* Data collection search engines
    * [Google Dataset Search](https://datasetsearch.research.google.com/)
    * [Kaggle](https://www.kaggle.com/)
    * [Harvard Dataverse](https://dataverse.harvard.edu/)
    * [Mendeley Data](https://data.mendeley.com/research-data/)
    * [Academic Torrents](https://academictorrents.com/)
* [Deep Learning Drizzle](https://deep-learning-drizzle.github.io/)
* [Deep Vision](https://github.com/kjw0612/awesome-deep-vision)
* [Deep Learning](https://github.com/ChristosChristofidis/awesome-deep-learning)
* [Machine Learning](https://github.com/josephmisiti/awesome-machine-learning)
* [Computer vision](https://github.com/jbhuang0604/awesome-computer-vision)
* [Image processing applications with OpenCV](https://github.com/spmallick/learnopencv)
* [DL papers](https://github.com/terryum/awesome-deep-learning-papers)
* [DL paper reading roadmap](https://github.com/floodsung/Deep-Learning-Papers-Reading-Roadmap)
* [ML Acronyms](https://github.com/AgaMiko/machine-learning-acronymss)
* [Applied Deep Learning](https://github.com/maziarraissi/Applied-Deep-Learning)
* NLP
    * [NLP link 1](https://github.com/keon/awesome-nlp)
    * [NLP link 2](https://github.com/brianspiering/awesome-dl4nlp)
    * [NLP link 3](https://github.com/ivan-bilan/The-NLP-Pandect)
* Jupyter
    * [Jupyter](https://github.com/markusschanta/awesome-jupyter)
    * [Naas.ai Jupyter Templates for data projects](https://github.com/jupyter-naas/awesome-notebooks)
    * [Jupyter lab](https://github.com/mauhai/awesome-jupyterlab)
* GPT 3
    * [GPT 3 link 1](https://github.com/mikhail-bot/awesome-gpt3)
    * [GPT 3 link 2](https://github.com/elyase/awesome-gpt3)
* [Made With ML](https://github.com/GokuMohandas/MadeWithML)
* [Guide to Pytorch Learning Rate Scheduling](https://www.kaggle.com/isbhargav/guide-to-pytorch-learning-rate-scheduling)
* PyTorch
    * [PyTorch link 1](https://github.com/bharathgs/Awesome-pytorch-list)
    * [PyTorch link 2](https://github.com/rickiepark/awesome-pytorch)
    * [PyTorch link 3](https://www.ritchieng.com/the-incredible-pytorch/)
* TensorFlow
    * [TensorFlow link 1](https://github.com/jtoy/awesome-tensorflow)
    * [TensorFlow link 2](https://github.com/Amin-Tgz/awesome-tensorflow-2)
* JAX
    * [JAX link 1](https://github.com/n2cholas/awesome-jax)
    * [JAX link 2](https://giters.com/nikhilroxtomar/awesome-jax)
* [500 AI ML projects](https://github.com/ashishpatel26/500-AI-Machine-learning-Deep-learning-Computer-vision-NLP-Projects-with-code)
* [Tensorflow.js](https://github.com/aaronhma/awesome-tensorflow-js)
* [HuggingFace](https://github.com/huggingface/awesome-huggingface)
* FastAI
    * [FastAI link 1](https://github.com/ucalyptus/awesome-fastai)
    * [FastAI link 2](https://github.com/isymbo/awesome-fastai)
* [NLP recipes/Best practices](https://github.com/microsoft/nlp-recipes)
* [Computer vision recipes/Best practices](https://github.com/microsoft/computervision-recipes)
* [Time Series Forecasting - Best practices](https://github.com/microsoft/forecasting)
* [Access amd modify layes of pretrained models in PyTorch](https://github.com/mortezamg63/Accessing-and-modifying-different-layers-of-a-pretrained-model-in-pytorch)
* [ML in Digital Signal Processing](https://github.com/GuitarML/mldsp-papers)
* Paper and literature search websites, twitter accounts
    * [Papers With Code](https://paperswithcode.com/)
    * [Crossminds](https://crossminds.ai/)
    * [DeepAI](https://deepai.org/)
    * [Arxiv Daily](https://twitter.com/arXiv_Daily)
* [Math for ML](https://github.com/dair-ai/Mathematics-for-ML)
* [ML Papers explained](https://github.com/dair-ai/ML-Papers-Explained)
* [Transfer Learning](https://github.com/jindongwang/transferlearning)
# Data and ML lifecycle, ML Infra
* [Data Collection](https://medium.com/mlearning-ai/how-to-build-a-scalable-data-collection-system-9703a2367735)
* [Public APIs](https://github.com/public-apis/public-apis)
* [Robotics Datasets](https://github.com/mint-lab/awesome-robotics-datasets)
* [Medical Imaging Datasets](https://github.com/sfikas/medical-imaging-datasets)
* [Robotic Tooling](https://github.com/protontypes/awesome-robotic-tooling)
* Public Datasets
    * [Public Datasets link 1](https://github.com/awesomedata/awesome-public-datasets)
    * [Public Datasets link 2](https://github.com/datasets/awesome-data)
* Web Scraping
    * [Web Scraping link 1](https://github.com/lorien/awesome-web-scraping)
    * [Web Scraping link 2](https://github.com/duyet/awesome-web-scraper)
* Data Engineering
    * [Data Engineering link 1](https://github.com/igorbarinov/awesome-data-engineering)
    * [Data Engineering link 2](https://github.com/gunnarmorling/awesome-opensource-data-engineering)
* Feature Engineering
    * [Feature Engineering link 1](https://github.com/aikho/awesome-feature-engineering)
    * [Feature Engineering link 2](https://github.com/ashishpatel26/Amazing-Feature-Engineering)
* SQL
    * [SQL Link 1](https://awesome-tech.readthedocs.io/databases/)
    * [SQL Link 2](https://github.com/danhuss/awesome-sql)
    * [SQL Link 3](https://github.com/mbiesiad/awesome-sql)
    * [SQLAlchemy](https://github.com/dahlia/awesome-sqlalchemy)
* NoSQL
    * [NoSQL link 1](https://github.com/erictleung/awesome-nosql-guides)
    * [NoSQL link 2](https://github.com/jasonkying/awesome-NoSQL)
* [DynamoDB](https://github.com/alexdebrie/awesome-dynamodb)
* [MongoDB](https://github.com/ramnes/awesome-mongodb)
* Firebase
    * [Firebase link 1](https://github.com/jthegedus/awesome-firebase)
    * [Firebase link 2](https://www.tefter.io/~awesome/lists/awesome-firebase)
* Redis
    * [Redis](https://github.com/JamzyWang/awesome-redis)
    * [Redis optimizations](https://github.com/pranavgupta1234/awesome-redis-optimizations)
* [Apache Spark](https://github.com/awesome-spark/awesome-spark)
* [BigQuery](https://github.com/coty/awesome-bigquery)
* BigData
    * [BigData link 1](https://project-awesome.org/onurakpolat/awesome-bigdata)
    * [BigData link 2](https://github.com/0xnr/awesome-bigdata)
* Workflow Engines/Pipelines/DAG schedulers
    * [Workflow Engines](https://github.com/meirwah/awesome-workflow-engines)
    * [Pipeline](https://github.com/pditommaso/awesome-pipeline)
    * [Apache Airflow](https://github.com/jghoman/awesome-apache-airflow)
* [Pandas](https://github.com/tommyod/awesome-pandas)
* [Dask](https://github.com/fkromer/awesome-dask)
* [Graph Databases](https://github.com/jbmusso/awesome-graph)
* Data Annotation
    * [Data Labelling link 1](https://github.com/heartexlabs/awesome-data-labelinhttps://github.com/heartexlabs/awesome-data-labelingg)
    * [Data Labelling link 2](https://github.com/zenml-io/awesome-open-data-annotation)
    * [Data Labelling link 3](https://github.com/jsbroks/awesome-dataset-tools)
    * [Data Labelling link 4](https://github.com/doccano/awesome-annotation-tools)
    * [Data Labelling link 5](https://github.com/taivop/awesome-data-annotation)
* Data Visualization
    * [Data Visualization](https://github.com/javierluraschi/awesome-dataviz)
    * [Dash/Plotly](https://github.com/ucg8j/awesome-dash)
* [Tools to Design or Visualize Architecture of Neural Network](https://github.com/ashishpatel26/Tools-to-Design-or-Visualize-Architecture-of-Neural-Network)
* Power BI
    * [Power BI link 1](https://github.com/NajiElKotob/Awesome-Power-BI)
    * [Power BI link 2](https://github.com/Rulikkk/awesome-power-bi)
* [Network analysis](https://github.com/briatte/awesome-network-analysis)
* [Software Engineering for Machine Learning](https://github.com/SE-ML/awesome-seml)
* [Scikit Learn](https://github.com/fkromer/awesome-scikit-learn)
* Production level ML/DL
    * [Production level DL link 1](https://github.com/alirezadir/Production-Level-Deep-Learning)
    * [Production level DL link 2](https://github.com/ahkarami/Deep-Learning-in-Production)
    * [Production level ML](https://github.com/EthicalML/awesome-production-machine-learning)
* [ML system design](https://github.com/chiphuyen/machine-learning-systems-design)
* [Applied ML](https://github.com/eugeneyan/applied-ml)
* [ML Infrastructure](https://github.com/GHGmc2/awesome-ml-infra)
* MLOps
    * [MLOps link 1](https://github.com/visenger/awesome-mlops)
    * [MLOps link 2](https://github.com/kelvins/awesome-mlops)
    * [MLOps link 3](https://github.com/fuzzylabs/awesome-open-mlops)
* [AIOps](https://github.com/fititnt/awesome-aiops)
* Explainable AI(XAI)
    * [Explainable AI (XAI) link 1](https://github.com/wangyongjie-ntu/Awesome-explainable-AI)
    * [Explainable AI (XAI) link 2](https://github.com/altamiracorp/awesome-xai)
* [ML Interpretability](https://github.com/jphall663/awesome-machine-learning-interpretability)
* [Fairness in AI](https://github.com/datamllab/awesome-fairness-in-ai)
* [Kaggle Solutions](https://farid.one/kaggle-solutions/)
* [Ethical AI Guidelines](https://github.com/EthicalML/awesome-artificial-intelligence-guidelines)
* [SageMaker](https://github.com/aws/amazon-sagemaker-examples)
* [CoreML models](https://github.com/likedan/Awesome-CoreML-Models)
* [Terraform](https://github.com/shuaibiyy/awesome-terraform)
* DataBricks
    * [DataBricks link 1](https://github.com/reisdebora/awesome-databricks)
    * [DataBricks official resources](https://databricks.com/resources)
* [ML stack of blogs of companies](https://github.com/enochkan/awesome-ml-stack)
* [Colab notebooks](https://github.com/amrzv/awesome-colab-notebooks)
* [ML Libraries and tooling](https://github.com/ml-tooling/best-of-ml-python)

# Cool books for modern ML, DL applications
* [ML Design Patterns](https://github.com/GoogleCloudPlatform/ml-design-patterns)
* [Distributed ML Patterns](https://github.com/terrytangyuan/distributed-ml-patterns)
* [Deep Learning Design Patterns](https://github.com/GoogleCloudPlatform/keras-idiomatic-programmer/tree/master/books/deep-learning-design-patterns)
* [PyTorch Computer Vision Cookbook - 70 recipes](https://github.com/PacktPublishing/PyTorch-Computer-Vision-Cookbook)

# System Design, Distributed systems and more
* System Design
  * [System Design link 1](https://github.com/madd86/awesome-system-design)
  * [System Design link 2](https://github.com/karanpratapsingh/system-design)
* [RESTful API](https://github.com/Kikobeats/awesome-api)
* [Dev Ops Exercises](https://github.com/bregman-arie/devops-exercises)
* Webhooks
    * [Webhooks link 1](https://github.com/realadeel/awesome-webhooks)
    * [Webhooks link 2](https://github.com/CompSciLauren/awesome-webhooks)
* [ASGI](https://github.com/florimondmanca/awesome-asgi)
* [Flask](https://github.com/humiaozuzu/awesome-flask)
* Django
    * [Django link 1](https://github.com/wsvincent/awesome-django)
    * [Django link 2](https://github.com/shahraizali/awesome-django)
    * [Django link 3](https://django.awesome-programming.com)
* [FastAPI](https://github.com/mjhea0/awesome-fastapi)
* [Distributed systems](https://github.com/theanalyst/awesome-distributed-systems)
* Python
    * [Python link 1](https://github.com/vinta/awesome-python)
    * [Python link 2](https://github.com/huangsam/ultimate-python)
    * [F-ing awesome python](https://github.com/trananhkma/fucking-awesome-python)
* GraphQL
    * [GraphQL link 1](https://github.com/chentsulin/awesome-graphql)
    * [GraphQL link 2](https://github.com/joshblack/awesome-graphql)
    * [GraphQL link 3](https://awesomerank.github.io/lists/chentsulin/awesome-graphql.html)
* [Scientific Python](https://github.com/rossant/awesome-scientific-python)
* [CUDA](https://github.com/Erkaman/Awesome-CUDA)
* [Parallel Computing](https://github.com/taskflow/awesome-parallel-computing)
* [Docker](https://github.com/veggiemonk/awesome-docker)
* [Docker Compose](https://github.com/docker/awesome-compose)
* Kubernetes
    * [Kubernetes link 1](https://github.com/ramitsurana/awesome-kubernetes)
    * [Kubernetes link 2](https://github.com/tomhuang12/awesome-k8s-resources)
    * [Kubernetes link 3](https://ramitsurana.github.io/awesome-kubernetes/projects/projects/)
    * [K8s Security](https://github.com/magnologan/awesome-k8s-security)
* Ansible
    * [Ansible link 1](https://github.com/KeyboardInterrupt/awesome-ansible)
    * [Ansible link 2](https://github.com/jdauphant/awesome-ansible)
* High Performance Computing (HPC)
    * [HPC link 1](https://github.com/koallen/awesome-hpc)
    * [HPC link 2](https://github.com/foxtrot9/awesome-hpc)
* Microservices
    * [Microservices link 1](https://github.com/mfornos/awesome-microservices)
    * [Microservices link 2](https://github.com/ivan-bilan/The-Microservices-Pandect)
    * [Domain Driven Design](https://github.com/heynickc/awesome-ddd)
* [Low Level Design Primer](https://github.com/prasadgujar/low-level-design-primer)
* [System Design Primer](https://github.com/donnemartin/system-design-primer)
* [Design Patterns](https://github.com/DovAmir/awesome-design-patterns)
* [Software Architecture](https://github.com/mehdihadeli/awesome-software-architecture)
* [Asyncio Python](https://github.com/timofurrer/awesome-asyncio)
* Knowledge graphs
    * [Knowledge graphs link 1](https://github.com/totogo/awesome-knowledge-graph)
    * [Knowledge graphs link 2](https://github.com/frutik/awesome-knowledge-graphs)
* [GRPC](https://github.com/grpc-ecosystem/awesome-grpc)
* [Peer-to-Peer](https://github.com/kgryte/awesome-peer-to-peer)
* [RabbitMQ](https://github.com/johanrhodin/awesome-rabbitmq)
* Kafka
    * [Kafka link 1](https://github.com/semantalytics/awesome-kafka)
    * [Kafka link 2](https://github.com/infoslack/awesome-kafka)
    * [Kafka link 3](https://github.com/monksy/awesome-kafka)
    * [Kafka link 4](https://github.com/dharmeshkakadia/awesome-kafka)
* [ML-tooling: Best of Python](https://github.com/ml-tooling/best-of-python)
* Amazon Web Services (AWS)
    * [AWS link 1](https://github.com/donnemartin/awesome-aws)
    * [AWS security](https://github.com/jassics/awesome-aws-security)
* [Google Cloud Platform (GCP) Certifications](https://github.com/sathishvj/awesome-gcp-certifications)
* Azure
    * [Azure](https://github.com/kristofferandreasen/awesome-azure)
    * [Azure learning](https://github.com/kristofferandreasen/awesome-azure)
* [Digital Ocean (DO)](https://github.com/jonleibowitz/awesome-digitalocean)
# Other Awesome lists
Note: These lists are related to general concepts in Software architecture. They may or may not be completely related to Data lifecycle, ML and DL topics.
* [Full Text Search](https://github.com/Kikobeats/awesome-full-text-search)
* [MapReduce](https://awesomeopensource.com/projects/mapreduce)
* [Build Your Own X](https://github.com/danistefanovic/build-your-own-x)
* [Falsehoods](https://github.com/kdeldycke/awesome-falsehood)
* [CTO](https://github.com/kuchin/awesome-cto)
* [Raspberry Pi](https://github.com/thibmaek/awesome-raspberry-pi)
* [Creative Coding](https://github.com/terkelg/awesome-creative-coding)
* [Site Reliability Engineering(SRE)](https://github.com/dastergon/awesome-sre)
* [Web Security](https://github.com/qazbnm456/awesome-web-security)
* [Chaos Engineering](https://github.com/dastergon/awesome-chaos-engineering)
* [ElasticSearch](https://github.com/dzharii/awesome-elasticsearch)
* [Database Internals](https://github.com/pingcap/awesome-database-learning)
* [Cryptography](https://github.com/sobolevn/awesome-cryptography)
* [Tech Stacks](https://github.com/stackshareio/awesome-stacks)
* [Geographic Information System(GIS)](https://github.com/sshuair/awesome-gis)
* [GeoSpatial Tools](https://github.com/sacridini/Awesome-Geospatial)
* [IoT](https://github.com/HQarroum/awesome-iot)
* Quantum Computing
    * [Quantum Computing](https://github.com/desireevl/awesome-quantum-computing)
    * [Quantum software](https://github.com/qosf/awesome-quantum-software)
* Regex
    * [Regex link 1](https://github.com/aloisdg/awesome-regex)
    * [regex link 2](https://github.com/OpenCode/awesome-regex)
* [CS Video courses](https://github.com/Developer-Y/cs-video-courses)
* [ML-YouTube Courses](https://github.com/dair-ai/ML-YouTube-Courses)
* [AI Expert Roadmap](https://github.com/AMAI-GmbH/AI-Expert-Roadmap)
* [Hacking](https://github.com/Hack-with-Github/Awesome-Hacking)
* [Concepts and Laws](https://github.com/lukasz-madon/awesome-concepts)
* [CS books and Digests](https://github.com/wx-chevalier/Awesome-CS-Books-and-Digests)
* [Self Hosted SaaS solutions](https://github.com/awesome-selfhosted/awesome-selfhosted)
* [Search](https://github.com/frutik/awesome-search)
* [UI](https://github.com/kevindeasis/awesome-ui)
# Contributing
Check CONTRIBUTING.md

# TODOs
- [ ] Convert README to a tabular format
- [ ] Rearrange the topics in alphabetical order
- [ ] Add definitions for tasks if needed

