# Bug

Before submitting an issue, please review the existing issues to avoid duplicates.

Please preface the title with [bug].

## Issue description

Provide a short description.

## Code example

Please try to provide a minimal reproducable example.
Error messages and stack traces are also helpful.

## System Info

Please copy and paste the output of PyTorch's [environment collection script](https://raw.githubusercontent.com/pytorch/pytorch/master/torch/utils/collect_env.py).
Alternatively, manually fill out the list below.

You can get the script and run it with:

```bash
wget https://raw.githubusercontent.com/pytorch/pytorch/master/torch/utils/collect_env.py
# For security purposes, please check the contents of collect_env.py before running it.
python collect_env.py
```

- OS platform and distribution:
- PyTorch version:
- Python version:
- CUDA/cuDNN version:
- GPU models and configuration:
- Versions of any other relevant libraries:

## Modulus Info

Please fill out the list below:

- Modulus version:
- How Modulus is used (Docker image/ bare-metal installation):
- (If using OptiX) OptiX version:
- Exact command to reproduce:
- (If using Modulus Docker image): Exact docker-run command:
