# learn-web-development
从2017年里最好的文章中学习 Web 开发

<img src="background.png" width="800" alt="Mybridge"></a>

[English Version](./README.md) | [中文版本](./CN.md)

在过去的一年间（2017年），我们对比了近16000篇 Web 开发相关的文章，并从中挑出了最好的45篇。

我们相信，向经验丰富的 Web 开发者学习会是促进你事业进步一个非常好的方式。该清单组织收录了2017年里最有用的那些学习指南，旨在让你学习起来更加轻松。在这些学习指南中，经验丰富的 Web 开发人员分享了他们在构建和发布 Web 应用方面的经验与教训。

这份清单有20个关键主题：

<img src="chart.png" width="1400" alt="Mybridge"></a>

如果你想查看带图片的版本：[查看 Medium 链接](https://goo.gl/oh4HXE)

## 目录
1. [通用指南](#通用指南)
1. [AWS](#aws)
1. [Docker](#docker)
1. [安全](#安全)
1. [编程最佳实践](#编程最佳实践)
1. [Git](#git)
1. [Google Analytics](#google-analytics)
1. [Bootstrap](#bootstrap)
1. [HTTPS](#https)
1. [Vim](#vim)
1. [Web Font](#web-font)
1. [HTML Email](#html-email)
1. [WebAssembly](#webassembly)
1. [Chrome DevTools](#chrome-devtools)
1. [案例分析](#案例分析)
1. [性能](#性能)
1. [Progressive Web App](#progressive-web-app)
1. [面试](#面试)
1. [从业收获](#从业收获)
1. [用户界面](#用户界面)

### 推荐学习课程

A) 游戏 AI：[使用 Unity 构建人工智能应用的新手指南。](http://bit.ly/2nbsc5n)

5,041 推荐，4.7/5 星

B) 计算机视觉：[深度学习与计算机视觉 A-Z™: 学习 OpenCV, SSD 和 GANs 并创建一个图像识别应用。](http://bit.ly/2DGORkq)

8,161 推荐，4.5/5 星

### 通用指南
* [2017 前端开发手册 - Cody Lindley](https://frontendmasters.gitbooks.io/front-end-handbook-2017/content?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [2017 Web 开发者技能学习路线图](https://github.com/kamranahmedse/developer-roadmap?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [前端清单：为现代网站和细心开发者准备的完美的前端清单](http://frontendchecklist.com/?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [我们这超过 500 名工程师都在使用这份前端开发指南](https://medium.freecodecamp.com/grabs-front-end-guide-for-large-teams-484d4033cc41?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### AWS
* [Amazon Web Services 开放学习指南](https://github.com/open-guides/og-aws?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [亚马逊 ECS 与 Docker 服务的打包指南](http://start.jcolemorrison.com/the-hitchhikers-guide-to-aws-ecs-and-docker?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### Docker
* [从这里了解你该如何开始使用 Docker](http://djangostars.com/blog/heres-how-you-start-using-docker?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [Docker 介绍](https://tobiastom.name/explains/docker?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### 安全
* [Web 开发者安全清单](https://simplesecurity.sensedeep.com/web-developer-security-checklist-f2e4f43c9c56?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [Auth-Boss: 了解 Web 上不同的认证方法](https://github.com/teesloane/Auth-Boss?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [用伪密码字段绕过浏览器安全警告](https://www.troyhunt.com/bypassing-browser-security-warnings-with-pseudo-password-fields?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### 编程最佳实践
* [程序员需要了解的设计模式](https://github.com/kamranahmedse/design-patterns-for-humans?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [Google 的软件工程实践精选[PDF]](https://arxiv.org/abs/1702.01715?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### Git
* [Git-flight-rules: 为使用 git 的程序员准备的指南，他会在你遇到问题时告诉你该怎么做](https://github.com/k88hudson/git-flight-rules?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### Google Analytics
* [我在构建的每个网站上都会使用的 Google Analytics 设置](https://philipwalton.com/articles/the-google-analytics-setup-i-use-on-every-site-i-build?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### Bootstrap
* [关于 Bootstrap 4 你所需要知道的一切](https://medium.freecodecamp.org/bootstrap-4-everything-you-need-to-know-c750991f6784?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### HTTPS
* [通向 HTTPS 的六步“快乐之路”](https://www.troyhunt.com/the-6-step-happy-path-to-https?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### Vim
* [15年后的 Vim](https://statico.github.io/vim3.html?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### Web Font
* [Web fonts: 你究竟什么时候才需要它](https://hackernoon.com/web-fonts-when-you-need-them-when-you-dont-a3b4b39fe0ae?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### HTML Email
* [向 Web 开发者发送 HTML 电子邮件的构建指南 – Smashing Magazine](https://www.smashingmagazine.com/2017/01/introduction-building-sending-html-email-for-web-developers?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### WebAssembly
* [漫画简介 WebAssembly – Smashing Magazine](https://www.smashingmagazine.com/2017/05/abridged-cartoon-introduction-webassembly?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### Chrome DevTools
* [增强你的 Web 开发技能树：在 Chrome 开发者工具的150个动画提示](https://medium.com/dev-channel/increase-your-web-development-skill-set-150-animated-tips-on-chrome-devtools-4a30155e6b8e?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [Chrome 开发者工具：2017发展概况 (Google I/O '17)](https://www.youtube.com/watch?v=PjjlwAvV8Jg?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [使用 Chrome 开发者工具获取 Taylor Swift的下一场演唱会门票](https://medium.com/@amyngyn/look-what-you-made-me-do-chrome-b85eb2a90540?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [Chrome 中的预加载，预取和优先级 - Addy Osmani, Google 工程师](https://medium.com/dev-channel/preload-prefetch-and-priorities-in-chrome-776165961bbf?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### 案例分析
* [我们是如何开发出 r/Place 的](http://redditblog.com/2017/04/13/how-we-built-rplace?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [我是如何在两个月内学会编程，开发了一个 Web 应用并将其发布到 Product Hunt 上的](https://medium.com/@AndreyAzimov/i-learned-to-code-and-build-a-web-app-in-2-months-da8f2932c139?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### 性能
* [Web 发展状态：有效性能改进的推进指南](https://medium.com/@fox/talk-the-state-of-the-web-3e12f8e413b3?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [基本图像优化 - Addy Osmani](https://images.guide?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [有关 Web 缓存你所需要了解的一切](http://kamranahmed.info/blog/2017/03/14/quick-guide-to-http-caching?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [用一点机器学习的知识来加速你的网站](https://hackernoon.com/speed-up-your-site-with-a-little-machine-learning-fa9eb7c86dbb?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### Progressive Web App
* [Pinterest Progressive Web App 性能分析](https://medium.com/@addyosmani/a-pinterest-progressive-web-app-performance-case-study-3bd6ed2e6154?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [Progressive Web Apps 与 Web 开发新手指南](https://hackernoon.com/a-beginners-guide-to-progressive-web-apps-the-frontend-web-424b6d697e35?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [使用 JavaScript 框架开发 Progressive Web Apps (Google I/O '17)](https://www.youtube.com/watch?v=aCMbSyngXB4?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### 面试
* [我刚拿到 Facebook 的工作机会，我是这样准备我的面试的……](https://medium.freecodecamp.org/software-engineering-interviews-744380f4f2af?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [30分钟备战你的下一个编程面试](https://medium.freecodecamp.org/coding-interviews-for-dummies-5e048933b82b?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [我刚拿到 Snapchat 的工作机会，我从中学到了什么以及它能如何帮助你找到工作](https://medium.freecodecamp.com/a-dynamic-framework-for-finding-your-first-programming-job-b4eb0605b4f3?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [Google 编程测试问题与答案 #1: First Recurring Character](https://www.youtube.com/watch?v=GJdiM-muYqc?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### 从业收获
* [我该如何向一位来自2007年的时间旅行者解释这十年里的 Web 发展](https://medium.freecodecamp.org/web-development-explained-to-a-time-traveler-from-ten-years-ago-600fad81170d?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [我从事 Web 开发已经17年了，这是我所学到的一切 - Daniel Khan](http://community.risingstack.com/ive-been-a-web-developer-for-17-years-and-this-is-what-i-learned-daniel-khan?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [开发者优势：如果成为一名高级开发工程师](https://hackernoon.com/developers-edge-how-to-become-a-senior-developer-f1ec1738cf45?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [资深首席技术官（多次成功经历）为你解答最受关注的创业问题](http://firstround.com/review/veteran-cto-with-20-years-experience-answers-your-top-startup-building-questions?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)

### 用户界面
* [重新思考拖拽（drag and drop）操作：简化操作，使其优美](https://medium.com/@alexandereardon/rethinking-drag-and-drop-d9f5770b4e6b?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [Grid 内容展开动画](https://tympanus.net/codrops/2017/11/08/expanding-grid-item-animation?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)
* [菜单悬停效果带来的灵感启示](https://tympanus.net/codrops/2017/08/01/inspiration-for-menu-hover-effects?utm_source=mybridge&utm_medium=email&utm_campaign=read_more)