import numpy as np
from mushroom_rl.solvers.dynamic_programming import policy_iteration, value_iteration


def test_value_iteration():
    p = np.array([[[1., 0., 0., 0.],
                   [0.1, 0., 0.9, 0.],
                   [1., 0., 0., 0.],
                   [0.1, 0.9, 0., 0.]],
                  [[0., 1., 0., 0.],
                   [0., 0.1, 0., 0.9],
                   [0.9, 0.1, 0., 0.],
                   [0., 1., 0., 0.]],
                  [[0.9, 0., 0.1, 0.],
                   [0., 0., 1., 0.],
                   [0., 0., 1., 0.],
                   [0., 0., 0.1, 0.9]],
                  [[0., 0., 0., 0.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 0.]]])
    r = np.array([[[0., 0., 0., 0.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 0.]],
                  [[0., 0., 0., 0.],
                   [0., 0., 0., 1.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 0.]],
                  [[0., 0., 0., 0.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 1.]],
                  [[0., 0., 0., 0.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 0.]]])
    gamma = .95
    eps = 1e-1

    q = value_iteration(p, r, gamma, eps)
    test_q = np.array([0.93653921, 0.99439414, 0.99439414, 0.])

    assert np.allclose(q, test_q)


def test_policy_iteration():
    p = np.array([[[1., 0., 0., 0.],
                   [0.1, 0., 0.9, 0.],
                   [1., 0., 0., 0.],
                   [0.1, 0.9, 0., 0.]],
                  [[0., 1., 0., 0.],
                   [0., 0.1, 0., 0.9],
                   [0.9, 0.1, 0., 0.],
                   [0., 1., 0., 0.]],
                  [[0.9, 0., 0.1, 0.],
                   [0., 0., 1., 0.],
                   [0., 0., 1., 0.],
                   [0., 0., 0.1, 0.9]],
                  [[0., 0., 0., 0.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 0.]]])
    r = np.array([[[0., 0., 0., 0.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 0.]],
                  [[0., 0., 0., 0.],
                   [0., 0., 0., 1.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 0.]],
                  [[0., 0., 0., 0.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 1.]],
                  [[0., 0., 0., 0.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 0.],
                   [0., 0., 0., 0.]]])
    gamma = .95

    q, p = policy_iteration(p, r, gamma)
    q_test = np.array([0.93953176, 0.99447514, 0.99447514, 0.])
    p_test = np.array([1, 1, 3, 0])

    assert np.allclose(q, q_test) and np.allclose(p, p_test)
