package org.example.crm.workbench.mapper;

import org.example.crm.workbench.domain.Activity;

import java.util.List;
import java.util.Map;

public interface ActivityMapper {
    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table tbl_activity
     *
     * @mbggenerated Tue Aug 08 17:12:25 CST 2023
     */
    int deleteByPrimaryKey(String id);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table tbl_activity
     *
     * @mbggenerated Tue Aug 08 17:12:25 CST 2023
     */
    int insert(Activity record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table tbl_activity
     *
     * @mbggenerated Tue Aug 08 17:12:25 CST 2023
     */
    int insertSelective(Activity record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table tbl_activity
     *
     * @mbggenerated Tue Aug 08 17:12:25 CST 2023
     */
    Activity selectByPrimaryKey(String id);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table tbl_activity
     *
     * @mbggenerated Tue Aug 08 17:12:25 CST 2023
     */
    int updateByPrimaryKeySelective(Activity record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table tbl_activity
     *
     * @mbggenerated Tue Aug 08 17:12:25 CST 2023
     */
    int updateByPrimaryKey(Activity record);

    /**
     * 保存创建的市场活动
     */
    int insertActivity(Activity activity);

    /**
     * 查询市场活动进行分页
     * 根据条件分页查询市场活动
     * @param map
     * @return
     */
    List<Activity> selectActivityByConditionForPage(Map<String,Object> map);

    /**
     * 根据条件查询市场活动的总条数
     * @param map
     * @return
     */
    int selectCountOfActivityByCondition(Map<String,Object> map);

    /**
     * 根据 id 数组批量删除市场活动
     * @param ids
     * @return
     */
    int deleteActivityByIds(String[] ids);

    /**
     * 根据 id 查询市场活动，只查询 1 条数据，不用 List
     * @param id
     * @return
     */
    Activity selectActivityById(String id);

    /**
     * 更新修改后的市场活动
     * @param activity
     * @return
     */
    int updateActivity(Activity activity);

    /**
     * 查询所有的市场活动
     * @return
     */
    List<Activity> selectAllActivity();

    /**
     * 根据 id 数组选择查询市场活动
     * @param ids
     * @return
     */
    List<Activity> selectActivityByIds(String[] ids);

    /**
     * 保存导入市场活动列表
     * @param activityList
     * @return
     */
    int insertActivityByList(List<Activity> activityList);

    /**
     * 编写根据 id 查询市场活动
     * @param id
     * @return
     */
    Activity selectDetailActivityById(String id);

    /**
     * 根据 clueId 查询线索相关的市场活动的明细信息
     * @param clueId
     * @return
     */
    List<Activity> selectActivityForDetailByClueId(String clueId);

    /**
     * 根据 name 模糊查询市场活动，且把已经跟 clueId 关联过的市场活动排除
     * @param map
     * @return
     */
    List<Activity> selectActivityForDetailByNameAndClueId(Map<String,Object> map);

    /**
     * 根据 ids 查询与线索相关联的市场活动的明细信息
     * @param ids
     * @return
     */
    List<Activity> selectActivityForDetailByIds(String[] ids);

    /**
     * 根据 name 模糊查询已经跟 clueId 关联过的市场活动
     * @param map
     * @return
     */
    List<Activity> selectActivityForConvertByNameAndClueId(Map<String,Object> map);

    List<Activity> selectActivityForSaveByName(String name);
}