import { ReactNode } from 'react';
import {
    FontSizeOutlined,
    PictureOutlined,
    BlockOutlined,
    BoldOutlined,
    AppstoreAddOutlined,
    SoundOutlined,
    TableOutlined,
    BorderOutlined,
    StarOutlined,
    LineOutlined,
    HarmonyOSOutlined,
    PlayCircleOutlined,
    ArrowUpOutlined,
    AreaChartOutlined,
    BarChartOutlined,
    PieChartOutlined,
    LineChartOutlined,
    PlaySquareOutlined,
    RadarChartOutlined,
} from '@ant-design/icons';

export type ToolItemType = {
    type: string,
    icon: ReactNode,
    text: string,
    cate: string,
    auth: 0 | 1 | 2 | 3
}

const toolBarMap = {
    base: '基础',
    shape: '形状',
    form: '表单',
    chart: '图表',
    compound: '复合'
}

const toolbar = {
    base: [
        {
            type: 'Text',
            icon: <FontSizeOutlined />,
            auth: 0,
            text: '文本',
            cate: 'base',
            width: 100,
            height: 30,
        },
        {
            type: 'Image',
            icon: <PictureOutlined />,
            auth: 0,
            text: '图片',
            cate: 'base',
            width: 100,
            height: 100,
        },
        {
            type: 'Button',
            icon: <BoldOutlined />,
            auth: 0,
            text: '按钮',
            cate: 'base',
            onlyWeb: true,
            width: 100,
            height: 30,
        },
        {
            type: 'Icon',
            icon: <AppstoreAddOutlined />,
            auth: 0,
            text: '图标',
            cate: 'base',
            width: 40,
            height: 40,
        },
        {
            type: 'Carousel',
            icon: <BlockOutlined />,
            auth: 0,
            text: '轮播图',
            cate: 'base',
            width: 300,
            height: 180,
        },
        {
            type: 'Table',
            icon: <TableOutlined />,
            auth: 0,
            text: '表格',
            cate: 'base',
            width: 400,
            height: 100,
        },
        {
            type: 'Audio',
            icon: <SoundOutlined />,
            auth: 0,
            text: '音频',
            cate: 'base',
            width: 100,
            height: 30,
        },
        {
            type: 'Video',
            icon: <PlaySquareOutlined />,
            auth: 0,
            text: '视频',
            cate: 'base',
            width: 300,
            height: 300,
        },
    ],
    shape: [
        {
            type: 'Line',
            icon: <LineOutlined />,
            auth: 0,
            text: '直线',
            cate: 'shape',
            width: 50,
            height: 50,
        },
        {
            type: 'Rect',
            icon: <BorderOutlined />,
            auth: 0,
            text: '矩形',
            cate: 'shape',
            width: 50,
            height: 50,
        },
        {
            type: 'Circle',
            icon: <HarmonyOSOutlined />,
            auth: 0,
            text: '圆形',
            cate: 'shape',
            width: 50,
            height: 50,
        },
        {
            type: 'Triangle',
            icon: <PlayCircleOutlined />,
            auth: 0,
            text: '三角形',
            cate: 'shape',
            width: 50,
            height: 50,
        },
        {
            type: 'Star',
            icon: <StarOutlined />,
            auth: 0,
            text: '五角星',
            cate: 'shape',
            width: 50,
            height: 50,
        },
        {
            type: 'Arrow',
            icon: <ArrowUpOutlined />,
            auth: 0,
            text: '箭头',
            cate: 'shape',
            width: 50,
            height: 50,
        },
    ],
    form: [
        {
            type: 'Input',
            auth: 0,
            text: '输入框',
            cate: 'form',
            onlyWeb: true,
            width: 200,
            height: 30,
        }, 
        {
            type: 'Select',
            auth: 0,
            text: '下拉框',
            cate: 'form',
            onlyWeb: true,
            width: 200,
            height: 30,
        }, 
        {
            type: 'Radio',
            auth: 0,
            text: '单选框',
            cate: 'form',
            onlyWeb: true,
            width: 200,
            height: 30,
        }, 
        {
            type: 'Checkbox',
            auth: 0,
            text: '复选框',
            cate: 'form',
            onlyWeb: true,
            width: 200,
            height: 30,
        }, 
        {
            type: 'Upload',
            auth: 0,
            text: '上传',
            cate: 'form',
            onlyWeb: true,
            width: 200,
            height: 30,
        }, 
        {
            type: 'Submit',
            auth: 0,
            text: '提交',
            cate: 'form',
            onlyWeb: true,
            width: 200,
            height: 30,
        }, 
    ],
    chart: [
        {
            type: 'Bar',
            icon: <BarChartOutlined />,
            auth: 0,
            text: '柱状图',
            cate: 'chart',
            width: 360,
            height: 300,
        },
        {
            type: 'Pie',
            icon: <PieChartOutlined />,
            auth: 0,
            text: '饼图',
            cate: 'chart',
            width: 360,
            height: 300,
        },
        {
            type: 'Line',
            icon: <LineChartOutlined />,
            auth: 0,
            text: '折线图',
            cate: 'chart',
            width: 360,
            height: 300,
        },
        {
            type: 'Area',
            icon: <AreaChartOutlined />,
            auth: 0,
            text: '面积图',
            cate: 'chart',
            width: 360,
            height: 300,
        },
        {
            type: 'Radar',
            icon: <RadarChartOutlined />,
            auth: 0,
            text: '雷达图',
            cate: 'chart',
            width: 360,
            height: 300,
        },
    ],
    compound: [

    ]
}

export {
    toolBarMap,
    toolbar
}