<h1><img src="https://i.imgur.com/oXZ9m9E.png" height=80 /><div>Colir (BackEnd)</div></h1>
<p>
  <a href="https://dotnet.microsoft.com"><img src="https://img.shields.io/badge/.NET-gray?color=6B47C1&logo=data:image/svg%2bxml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IndoaXRlIiBkPSJNMS4xOTQgNy41NDN2OC45MTNjMCAxLjEwMy41ODggMi4xMjIgMS41NDQgMi42NzRsNy43MTggNC40NTZhMy4wOSAzLjA5IDAgMCAwIDMuMDg4IDBsNy43MTgtNC40NTZhMy4wOSAzLjA5IDAgMCAwIDEuNTQ0LTIuNjc0VjcuNTQzYTMuMDggMy4wOCAwIDAgMC0xLjU0NC0yLjY3M0wxMy41NDQuNDE0YTMuMDkgMy4wOSAwIDAgMC0zLjA4OCAwTDIuNzM4IDQuODdhMy4wOSAzLjA5IDAgMCAwLTEuNTQ0IDIuNjczbTUuNDAzIDIuOTE0djMuMDg3YS43Ny43NyAwIDAgMCAuNzcyLjc3MmEuNzczLjc3MyAwIDAgMCAuNzcyLS43NzJhLjc3My43NzMgMCAwIDEgMS4zMTctLjU0NmEuNzguNzggMCAwIDEgLjIyNi41NDZhMi4zMTQgMi4zMTQgMCAxIDEtNC42MzEgMHYtMy4wODdjMC0uNjE1LjI0NC0xLjIwMy42NzktMS42MzdhMi4zMSAyLjMxIDAgMCAxIDMuMjc0IDBjLjQzNC40MzQuNjc4IDEuMDIzLjY3OCAxLjYzN2EuNzcuNzcgMCAwIDEtLjIyNi41NDVhLjc2Ny43NjcgMCAwIDEtMS4wOTEgMGEuNzcuNzcgMCAwIDEtLjIyNi0uNTQ1YS43Ny43NyAwIDAgMC0uNzcyLS43NzJhLjc3Ljc3IDAgMCAwLS43NzIuNzcybTEyLjM1IDMuMDg3YS43Ny43NyAwIDAgMS0uNzcyLjc3MmgtLjc3MnYuNzcyYS43NzMuNzczIDAgMCAxLTEuNTQ0IDB2LS43NzJoLTEuNTQ0di43NzJhLjc3My43NzMgMCAwIDEtMS4zMTcuNTQ2YS43OC43OCAwIDAgMS0uMjI2LS41NDZ2LS43NzJIMTJhLjc3MS43NzEgMCAxIDEgMC0xLjU0NGguNzcydi0xLjU0M0gxMmEuNzcuNzcgMCAxIDEgMC0xLjU0NGguNzcydi0uNzcyYS43NzMuNzczIDAgMCAxIDEuMzE3LS41NDZhLjc4Ljc4IDAgMCAxIC4yMjYuNTQ2di43NzJoMS41NDR2LS43NzJhLjc3My43NzMgMCAwIDEgMS41NDQgMHYuNzcyaC43NzJhLjc3Mi43NzIgMCAwIDEgMCAxLjU0NGgtLjc3MnYxLjU0M2guNzcyYS43NzYuNzc2IDAgMCAxIC43NzIuNzcybS0zLjA4OC0yLjMxNWgtMS41NDR2MS41NDNoMS41NDR6Ii8+PC9zdmc+" /></a>
  <a href="https://dotnet.microsoft.com/en-us/apps/aspnet"><img src="https://img.shields.io/badge/ASP.NET-gray?color=2A4FBD&logo=dotnet" /></a>
  <a href="https://docs.docker.com/get-docker/"><img src="https://img.shields.io/badge/Docker-gray?color=1C90ED&logo=docker&logoColor=FFFFFF" /></a>
  <a href="https://www.postgresql.org/"><img src="https://img.shields.io/badge/PostgreSQL-gray?color=2A92CA&logo=postgresql&logoColor=FFFFFF" /></a>
  <a href="https://learn.microsoft.com/en-us/ef/core/"><img src="https://img.shields.io/badge/EF_Core-gray?color=F07427&logo=dotnet" /></a>
    <a href="https://dotnet.microsoft.com/en-us/apps/aspnet/signalr"><img src="https://img.shields.io/badge/SignalR-gray?color=8BBE1B&logo=data:image/svg%2bxml;base64,PHN2ZyB3aWR0aD0iNzUwIiBoZWlnaHQ9Ijc1MCIgdmlld0JveD0iMCAwIDc1MCA3NTAiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxwYXRoIGQ9Ik0zMDUuNjgyIDU0NS40NTVMMzQ3LjcyNyA0NDMuMTgySDQ0Mi4wNDVDNDc5LjU0NiA0NDMuMTgyIDUxMC4yMjcgNDEyLjUgNTEwLjIyNyAzNzVDNTEwLjIyNyAzMzcuNSA0NzkuNTQ2IDMwNi44MTggNDQyLjA0NSAzMDYuODE4SDEzNS4yMjdMMzA1LjY4MiAxMzYuMzY0VjIwNC41NDVINDQyLjA0NUM1MzYuMzYzIDIwNC41NDUgNjEyLjUgMjgwLjY4MSA2MTIuNSAzNzVDNjEyLjUgNDY3LjA0NSA1MzkuNzczIDU0MC45MDkgNDUwIDU0NC4zMThMNTg4LjYzNyA2ODIuOTU0QzY4Ni4zNjQgNjE0Ljc3MiA3NTAgNTAyLjI3MyA3NTAgMzc1Qzc1MCAxNjguMTgyIDU4MS44MTggMCAzNzUgMEMxNjguMTgyIDAgMCAxNjguMTgyIDAgMzc1QzAgNTgxLjgxOCAxNjguMTgyIDc1MCAzNzUgNzUwQzQxNS45MDkgNzUwIDQ1NS42ODIgNzQzLjE4MiA0OTIuMDQ2IDczMC42ODFMMzA1LjY4MiA1NDUuNDU1WiIgZmlsbD0id2hpdGUiLz4KPC9zdmc+Cg==" /></a>
</p>

<b>Colir — fast & secure <ins>messaging platform</ins> </b>with<b> end-to-end</b> encryption. <br>

<b>Web Client</b> can be found <a href="https://github.com/MrQuackDuck/ColirWebClient/">here</a>.

## 🌈 The idea
The main goal of **Colir** is to provide an ability to **communicate securely**. <br>

To implement that, **end-to-end encryption** was chosen. Before using the application, **users should discuss a secret key** that will be **used to encrypt & decrypt** the data.<br>
> [!NOTE]
> The **encryption keys** for rooms are stored **on the client only**. They're **not being sent to the server**.

This **API's role** is **to transfer** and **store** the encrypted data.

## 🌠 Features
Besides that, **Colir** **has** a couple of **features**, which can interest you in:
- **Rooms** are places where the encrypted communication happens. When a user **creates** a room, he/she chooses an **encryption key** (which will be stored at the client) and receives a **room GUID**. **They can share that GUID** with someone else so they **can join** that room. **Anyone** who has **the GUID** of a certain room **can join** it, but it will be **impossible to decrypt** the data **if** the **wrong encryption** key was provided.
- **Expiry date** can be provided for **rooms**. **When** the **expiry date comes**, all **data won't be accessible** and **will be deleted** forever.
- There's only **one voice channel** per room.
- **Passwordless authentication**. There are **three ways to authenticate**: **anonymous** (gives you a one-time JWT), **GitHub** account, and **Google** account.
- Each user has a unique **"Colir ID"**, which is a **6 symbol-length hexadecimal number** to identify a user.
> [!CAUTION]
> If you authenticate as **anonymous**, you **won't be able to login** into that account again.<br>
> **Therefore**, use **3rd party providers** such as **GitHub** and **Google** to be able to login as much as you want.

## 🐳 Deployment
1. Install <a href="https://docs.docker.com/get-docker/">Docker</a>
2. Clone this repo <br>
   **>** `git clone https://github.com/MrQuackDuck/ColirBackend.git`
3. Jump into the folder <br>
   **>** `cd .\ColirBackend\`
4. Run the container <br>
   **>** `docker compose up`

> [!IMPORTANT]
> When you've cloned the repository, make sure to configure these variables in `appsettings.json`:<br>
> - `Authentication:JwtKey` - a **secret key** used to sign **JWT tokens**
> - `Authentication:RefreshTokenKey` - a **secret key** used to sign **refresh tokens**
> - `OAuth2:GitHubClientId` - **GitHub Client Id** (see <a href="https://docs.github.com/en/apps/oauth-apps/building-oauth-apps/authorizing-oauth-apps">Authorizing OAuth apps</a>)
> - `OAuth2:GitHubSecret` - **GitHub Client Secret** (see <a href="https://docs.github.com/en/apps/oauth-apps/building-oauth-apps/authorizing-oauth-apps">Authorizing OAuth apps</a>)
> - `OAuth2:GoogleClientId` - **Google Client Id** (see <a href="https://developers.google.com/identity/protocols/oauth2#1.-obtain-oauth-2.0-credentials-from-the-dynamic_data.setvar.console_name-.">Using OAuth 2.0 to Access Google APIs</a>)
> - `OAuth2:GoogleClientSecret` - **Google Client Secret** (see <a href="https://developers.google.com/identity/protocols/oauth2#1.-obtain-oauth-2.0-credentials-from-the-dynamic_data.setvar.console_name-.">Using OAuth 2.0 to Access Google APIs</a>)
> - `OAuth2:GoogleRedirectLink` - **Google Redirect Link** (the callback-link after **Google OAuth2** consent you've configured in <a href="https://console.cloud.google.com">Google Cloud Console</a>)
> - `DatabaseEncryption:EncryptionPassword` - The **16-char password** that will be used to encrypt some data on writing/reading into/from the database.
> - `DatabaseEncryption:InitializationVector` - The **16-char initialization vector** that will be used to encrypt some data on writing/reading into/from the database.

## 🖥 Development server

1. Install <a href="https://dotnet.microsoft.com/en-us/download/dotnet/8.0">.NET 8</a>
2. Clone this repo
3. Run `dotnet run --project Colir.WebApi` command
