﻿namespace Colir.BLL.Tests.Interfaces;

public interface IRoomServiceTests
{
	Task GetRoomInfoAsync_ReturnsRoomInfo();
	Task GetRoomInfoAsync_ThrowsRoomExpiredException_WhenRoomExpired();
	Task GetRoomInfoAsync_ThrowsRoomNotFoundException_WhenRoomWasNotFound();
	Task GetRoomInfoAsync_ThrowsIssuerNotInRoomException_WhenIssuerIsNotInRoom();
	Task GetRoomInfoAsync_ThrowsUserNotFoundException_WhenIssuerWasNotFound();

	Task CreateAsync_CreatesRoom();
	Task CreateAsync_ReturnsRoomModel();
	Task CreateAsync_AddsToStatistics_WhenItsEnabled();
	Task CreateAsync_ThrowsArgumentException_WhenWrongExpiryDateWasProvided();
	Task CreateAsync_ThrowsUserNotFoundException_WhenIssuerWasNotFound();

	Task RenameAsync_RenamesTheRoom();
	Task RenameAsync_ThrowsStringTooLongException_WhenNewNameIsTooLong();
	Task RenameAsync_ThrowsStringTooShortException_WhenNewNameIsTooShort();
	Task RenameAsync_ThrowsRoomNotFoundException_WhenRoomWasNotFound();
	Task RenameAsync_ThrowsNotEnoughPermissionsException_WhenIssuerIsNotOwnerOfRoom();
	Task RenameAsync_ThrowsUserNotFoundException_WhenIssuerWasNotFound();

	Task DeleteAsync_DeletesTheRoom();
	Task DeleteAsync_ThrowsRoomNotFoundException_WhenRoomWasNotFound();
	Task DeleteAsync_ThrowsNotEnoughPermissionsException_WhenIssuerIsNotOwnerOfRoom();
	Task DeleteAsync_ThrowsUserNotFoundException_WhenIssuerWasNotFound();

	Task GetLastTimeUserReadChatAsync_ReturnsLastTimeUserReadChat();
	Task GetLastTimeUserReadChatAsync_ThrowsRoomNotFoundException_WhenRoomWasNotFound();
	Task GetLastTimeUserReadChatAsync_ThrowsIssuerNotInRoomException_WhenIssuerIsNotInRoom();
	Task GetLastTimeUserReadChatAsync_ThrowsUserNotFoundException_WhenIssuerWasNotFound();

	Task UpdateLastReadMessageByUser_UpdatesLastTimeUserReadChatWithMessageProvided();
	Task UpdateLastReadMessageByUser_ThrowsInvalidActionException_WhenOlderMessageWasProvided();
	Task UpdateLastReadMessageByUser_ThrowsMessageNotFoundException_WhenMessageWasNotFound();
	Task UpdateLastReadMessageByUser_ThrowsRoomNotFoundException_WhenRoomWasNotFound();
	Task UpdateLastReadMessageByUser_ThrowsIssuerNotInRoomException_WhenIssuerIsNotInRoom();
	Task UpdateLastReadMessageByUser_ThrowsUserNotFoundException_WhenIssuerWasNotFound();

	Task JoinMemberAsync_JoinsUserToRoom();
	Task JoinMemberAsync_AddsToStatistics_WhenItsEnabled();
	Task CreateAsync_NotAddsToStatistics_WhenItsNotEnabled();
	Task JoinMemberAsync_ThrowsRoomNotFoundException_WhenRoomWasNotFound();
	Task JoinMemberAsync_ThrowsUserNotFoundException_WhenIssuerWasNotFound();

	Task KickMemberAsync_KicksUserFromRoom();
	Task KickMemberAsync_ThrowsRoomNotFoundException_WhenRoomWasNotFound();
	Task KickMemberAsync_ThrowsUserNotFoundException_WhenIssuerWasNotFound();
	Task KickMemberAsync_ThrowsUserNotFoundException_WhenTargetWasNotFound();
	Task KickMemberAsync_ThrowsIssuerNotInRoomException_WhenIssuerIsNotInRoom();
	Task KickMemberAsync_ThrowsNotEnoughPermissionsException_WhenIssuerIsNotOwnerOfRoom();

	Task LeaveAsync_RemovesUserFromRoom();
	Task LeaveAsync_ThrowsRoomNotFoundException_WhenRoomWasNotFound();
	Task LeaveAsync_ThrowsUserNotFoundException_WhenIssuerWasNotFound();
	Task LeaveAsync_ThrowsIssuerNotInRoomException_WhenIssuerIsNotInRoom();

	Task ClearRoomAsync_ReturnsIRoomCleanerObject();
	Task ClearRoomAsync_ThrowsRoomNotFoundException_WhenRoomWasNotFound();
	Task ClearRoomAsync_ThrowsUserNotFoundException_WhenIssuerWasNotFound();
	Task ClearRoomAsync_ThrowsNotEnoughPermissionsException_WhenIssuerIsNotOwnerOfRoom();
}