﻿namespace Colir.BLL.Tests.Interfaces;

public interface IMessageServiceTests
{
	Task GetLastMessagesAsync_ReturnsLastMessages();
	Task GetLastMessagesAsync_ThrowsUserNotFoundException_WhenIssuerWasNotFound();
	Task GetLastMessagesAsync_ThrowsRoomNotFoundException_WhenRoomWasNotFound();
	Task GetLastMessagesAsync_ThrowsArgumentException_WhenCountLessThanZero();
	Task GetLastMessagesAsync_ThrowsArgumentException_WhenSkipLessThanZero();
	Task GetLastMessagesAsync_ThrowsIssuerNotInRoomException_WhenIssuerIsNotInRoom();
	Task GetLastMessagesAsync_ThrowsRoomExpiredException_WhenRoomIsExpired();

	Task GetSurroundingMessagesAsync_ThrowsArgumentException_WhenCountLessThanZero();
	Task GetSurroundingMessagesAsync_ThrowsMessageNotFoundException_WhenMessageWasNotFound();
	Task GetSurroundingMessagesAsync_ThrowsIssuerNotInRoomException_WhenIssuerIsNotInRoom();
	Task GetSurroundingMessagesAsync_ThrowsRoomExpiredException_WhenRoomIsExpired();

	Task GetMessagesRangeAsync_ReturnsMessagesRange();
	Task GetMessagesRangeAsync_ThrowsArgumentException_WhenStartIdLessThanZero();
	Task GetMessagesRangeAsync_ThrowsArgumentException_WhenEndIdLessThanZero();
	Task GetMessagesRangeAsync_ThrowsMessageNotFoundException_WhenStartIdIsNotInRoom();
	Task GetMessagesRangeAsync_ThrowsMessageNotFoundException_WhenEndIdIsNotInRoom();
	Task GetMessagesRangeAsync_ThrowsIssuerNotInRoomException_WhenIssuerIsNotInRoom();

	Task GetUnreadRepliesAsync_ReturnsUnreadReplies();
	Task GetUnreadRepliesAsync_ThrowsUserNotFoundException_WhenIssuerWasNotFound();
	Task GetUnreadRepliesAsync_ThrowsRoomNotFoundException_WhenRoomWasNotFound();
	Task GetUnreadRepliesAsync_ThrowsIssuerNotInRoomException_WhenIssuerIsNotInRoom();

	Task GetMessageById_ReturnsCorrectMessage();
	Task GetMessageById_ThrowsMessageNotFoundException_WhenNotFound();
	Task GetMessageById_ThrowsRoomExpiredException_WhenRoomExpired();
	Task GetMessageById_ThrowsIssuerNotInRoomException_WhenIssuerIsNotInRoom();

	Task SendAsync_SendsMessage();
	Task SendAsync_AddsToStatistics_WhenItsEnabled();
	Task SendAsync_ThorwsAttachmentNotFoundException_WhenAttachmentWasNotFound();
	Task SendAsync_ThrowsAttachmentNotFoundException_WhenAttachmentIsNotInRoom();
	Task SendAsync_ThrowsStringTooLongException_WhenMessageContentIsTooLong();
	Task SendAsync_ThrowsArgumentException_WhenMessageIsEmpty();
	Task SendAsync_ThrowsUserNotFoundException_WhenIssuerWasNotFound();
	Task SendAsync_ThrowsMessageNotFoundException_WhenNotExistingReplyMessageIdProvided();
	Task SendAsync_ThrowsAttachmentNotFoundException_WhenNotExistingAttachmentIdProvided();
	Task SendAsync_ThrowsRoomNotFoundException_WhenRoomWasNotFound();
	Task SendAsync_ThrowsIssuerNotInRoomException_WhenIssuerIsNotInRoom();
	Task SendAsync_ThrowsRoomExpiredException_WhenRoomIsExpired();

	Task EditAsync_EditsMessage();
	Task EditAsync_ThrowsArgumentException_WhenMessageIsEmpty();
	Task EditAsync_ThrowsStringTooLongException_WhenMessageContentIsTooLong();
	Task EditAsync_ThrowsMessageNotFoundException_WhenMessageWasNotFound();
	Task EditAsync_ThrowsIssuerNotInRoomException_WhenIssuerIsNotInRoom();
	Task EditAsync_ThrowsNotEnoughPermissionsException_WhenIssuerIsNotAuthorOfMessage();
	Task EditAsync_ThrowsRoomExpiredException_WhenRoomIsExpired();

	Task DeleteAsync_DeletesMessage();
	Task DeleteAsync_ThrowsMessageNotFoundException_WhenMessageWasNotFound();
	Task DeleteAsync_ThrowsIssuerNotInRoomException_WhenIssuerIsNotInRoom();
	Task DeleteAsync_ThrowsNotEnoughPermissionsException_WhenIssuerIsNotAuthorOfMessage();
	Task DeleteAsync_ThrowsRoomExpiredException_WhenRoomIsExpired();

	Task AddReaction_AddsReaction();
	Task AddReaction_AddsToStatistics_WhenItsEnabled();
	Task AddReaction_ThrowsMessageNotFoundException_WhenMessageWasNotFound();
	Task AddReaction_ThrowsIssuerNotInRoomException_WhenIssuerIsNotInRoom();
	Task AddReaction_ThrowsRoomExpiredException_WhenRoomIsExpired();

	Task RemoveReaction_RemovesReaction();
	Task RemoveReaction_ThrowsReactionNotFoundException_WhenReactionWasNotFound();
	Task RemoveReaction_ThrowsIssuerNotInRoomException_WhenIssuerIsNotInRoom();
	Task RemoveReaction_ThrowsNotEnoughPermissionsException_WhenIssuerIsNotAuthorOfReaction();
	Task RemoveReaction_ThrowsRoomExpiredException_WhenRoomIsExpired();
}