## Qustion

> 以下代码使用的折叠表达式语法，以及它的效果，详细解析，使用 Markdown 语法。

```cpp
template<class ...Args>
auto Reverse(Args&&... args) {
    std::vector<std::common_type_t<Args...>> res{};
    bool tmp{ false };
    (tmp = ... = (res.push_back(args), false));
    return res;
}
```

## Answer

### 二元左折叠

1. 二元折叠,因为`= ... =` 符合 `(运算符 ... 运算符)` 的形式
2. 左折叠，因为 `...` 在形参包（args）左边

### 详细解析

> 二元左折叠语法,根据`二元左折叠 (I 运算符 ... 运算符 E) 成为 ((((I 运算符 E1) 运算符 E2) 运算符 ...) 运算符 EN) （其中 N 是包展开中的元素数量）`

- 运算符是`=`
- 初值是`tmp`
- 表达式为`(res.push_back(args), false)`

### 执行效果
以样例数据展开表达式
```cpp
auto res = Reverse(1, 2, 3); // (((tmp = (res.push_back(1), false))= (res.push_back(2), false))= (res.push_back(3), false))
```

而`(((tmp = (res.push_back(1), false))= (res.push_back(2), false))= (res.push_back(3), false))`这个表达式,会先执行`res.push_back(3), false`，然后再执行`res.push_back(2), false`，最后再执行`res.push_back(1), false`。所以最后执行结果为 `res{3,2,1}`;
