# 原题

```cpp
template <class... Args>
auto Reverse(Args&&... args) {
    std::vector<std::common_type_t<Args...>> res{};
    bool                                     tmp{false};
    (tmp = ... = (res.push_back(args), false));
    return res;
}
```

	*简述代码使用的折叠表达式的语法、效果、详细解析。*



# 作业

#### 分析

```cpp
(tmp = ... = (res.push_back(args), false));
```

	代码中存在`= ... =`，符合`运算符 ... 运算符`形势，即为二元折叠。又因`...`在“形参包（args）”左边，折叠表达式为一个二元左折叠。

#### 根据教案

> 二元左折叠`(I 运算符 ... 运算符 E)`成为`((((I 运算符 E1) 运算符 E2) 运算符 ...) 运算符 EN)`。

#### 展开为

```cpp
((((tmp = (res.push_back(args0), false)) = (res.push_back(args1), false)) = ...) = (res.push_back(argsN), false));
```

#### 参考以下调用

```cpp
auto vec = Reverse(3.5, 1, 2);

for (auto& it : vec) {
    cout << it << ", ";
}
```

**折叠表达式展开为**

```cpp
(((tmp = (res.push_back(3.5), false)) = (res.push_back(1), false)) = (res.push_back(2), false));
```

	赋值表达式从右向左，所以从后向前push到res。逗号表达式返回右边的false，tmp为flase（没什么用）。

**输出为**

`2, 1, 3.5`