# Gamified Speech Therapy System

## Overview

This project is a comprehensive, cloud-based application designed to assist children with speech impediments. The system delivers gamified speech exercises (built and managed by the child's therapist) that utilize speech recognition, phonetic analysis, and Gemini AI to provide real-time, personalized feedback. The app is cross-platform, supporting iOS, Android, and Web, and offers detailed progress tracking with statistical reports that can be shared with parents and therapists, enabling a holistic approach...

## Features

- **Gamified Exercises**: Engaging speech therapy exercises designed to improve children's speech skills in a fun and interactive way.
- **Speech Recognition & Phonetic Analysis**: Analyzes children's pronunciation to provide accurate feedback and track progress.
- **Gemini AI Integration**: Offers personalized encouragement and tips based on the child’s performance.
- **Real-time Progress Tracking**: Provides insights and detailed reports for parents and therapists to monitor and guide the therapy process.
- **Cross-Platform Support**: Built with Flutter to ensure compatibility with iOS, Android, and Web.

## Technology Stack

- **Flutter**: Cross-platform framework used to build the mobile and web applications.
- **Google Cloud Functions**: Backend services for processing speech recognition, phonetic analysis, and AI-driven feedback.
- **Firebase**: Used for real-time database management, authentication, and hosting.
- **Gemini AI**: Integrated for delivering personalized feedback based on speech analysis.

## Project DEMO Only(5 Minutes)

<a href="https://www.youtube.com/watch?v=rUjPT7o85RQ&feature=youtu.be" target="_blank">
    <img src="https://img.youtube.com/vi/rUjPT7o85RQ/0.jpg" alt="Project Demo On Youtube!(5 Minutes)" width="300"/>
</a>


## Project Presentation Video (15 Minutes)

<a href="https://www.youtube.com/watch?v=LhAOmmmKtj4" target="_blank">
    <img src="https://img.youtube.com/vi/LhAOmmmKtj4/0.jpg" alt="Project Demo On Youtube!(15 Minutes)" width="300"/>
</a>


## Project Poster

<img src="./Poster%20PDF%20Final%20Project.jpeg" alt="Speech Therapy App Poster" width="1000"/>

- [View Poster in High Resolution (PDF)](./POSTER%20PDF.pdf)

## Simplified Use Case Diagram 

<img src="./Speech%20Therapy%20App%20Use%20Case%20UML%20-%20Use%20Case%20Diagram.jpeg" alt="Speech Therapy Process" width="1000"/>

## Main Scoring Algorithm 
<img src="Speech%20therapy%20steps%20png.png" alt="Speech Therapy Process" width="1000"/>

## Academic Report From Newest To Oldest
- [View Final Project Report (PDF)](https://github.com/MosheT01/Speech-Therapy-For-Kids-With-Speech-impediments-Using-Speech-Recognition-Technologies/blob/main/Final%20Report%20Final%20Project.pdf)
- [View Alpha Report (PDF)](https://github.com/MosheT01/Speech-Therapy-For-Kids-With-Speech-impediments-Using-Speech-Recognition-Technologies/blob/main/Alpha%20REPORT%20PDF%20FINAL.pdf)
- [View Academic Paper (PDF)](https://github.com/MosheT01/Speech-Therapy-For-Kids-With-Speech-impediments-Using-Speech-Recognition-Technologies/blob/main/speech-therapy-proposal-moussa-tams-.pdf)

For more information, feel free to contact us at [mousatams@hotmail.com].
