let data = {
    "name": "制图特效",
    "category": [
        "构图"
    ],
    "content": {
        "chromatic aberration": {
            "image": "ed9212bfc31f8e84315260751b5ffebde059d0748e3c9305d7597752a187fcdf",
            "name": "色差",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/chromatic_aberration.html"
        },
        "lens flare": {
            "alias": [
                "lensflare"
            ],
            "description": "光线直射镜头而产生的光晕。",
            "image": "19fa91640e970b3f3b308ae8271560886129fa28f0e43fec31c07969c80550d7",
            "name": "镜头光晕",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/lens_flare.html"
        },
        "motion blur": {
            "description": "由于高速移动产生的模糊。",
            "image": "cac868c0805633e6a08afbf3ad0e58e5a12ead8d8c70752bdbc0c2c1d50bf1f7",
            "name": "动态模糊",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/motion_blur.html"
        },
        "sparkle": {
            "image": "e90b24b2020f41af85f44d60aaa0ac1c41d63f78cff277170c80f40dec190ecb",
            "name": "闪耀效果",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/sparkle.html",
            "alias": [
                "sparkles",
                "sparkling"
            ]
        },
        "jpeg artifacts": {
            "name": "JPEG 压缩失真",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/jpeg_artifacts.html",
            "alias": [
                "jpeg artefacts",
                "jpg artifacts"
            ]
        },
        "blurry": {
            "name": "模糊的",
            "image": "6daa85881f293c2188f7315cc61d41d032dea8af525e51d6293a20cef5e2aec9",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/blurry.html",
            "alias": [
                "blurred"
            ]
        },
        "cinematic lighting": {
            "name": "电影光效",
            "image": "8029429ec07e77a763ffce45c4f5fa11605a1968c017e8eb94122daefd909135"
        },
        "glowing light": {
            "name": "荧光",
            "image": "3bc6cf378c04b9a02d32110a224e555ca6f83ec75b7016b880aaa9aa8ef0c86f"
        },
        "god rays": {
            "name": "自上而下的光",
            "image": "3616d10a6cf155698fa4265898f5447ee943ad79db63e639870fed926788986f"
        },
        "ray tracing": {
            "name": "光线追踪",
            "image": "32bab9a1ad321971752de2ed337f3822074e5a61593ac9ca9270b81bbeb74d0f"
        },
        "reflection light": {
            "name": "反射光",
            "image": "63587120baf82bb6ce0fa2bd82e6cacd532442e0a735fef4a34c12ca31dc7127"
        },
        "overexposure": {
            "name": "过曝",
            "image": "7294f5926ad976a4c7f65ee5b6554ba59a33661dd45408287cca7a49715965fe",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/overexposure.html"
        },
        "backlighting": {
            "name": "逆光",
            "image": "840f02ef30da0f1d4a32980e9f6205974ede74b1a05d45fec4265ee6a1c67a7d",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/backlighting.html",
            "alias": [
                "backlit"
            ]
        },
        "blending": {
            "name": "混合",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/blending.html"
        },
        "bloom": {
            "name": "盛开",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/bloom.html"
        },
        "bokeh": {
            "name": "背景散焦",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/bokeh.html",
            "image": "43f693f30ecd36322da1d800160989a45b9009bf4f869dc637869a1eb4d54dc4"
        },
        "caustics": {
            "alias": [
                "caustic lighting"
            ],
            "name": "焦散",
            "description": "光线通过另一个物体反射或折射而投射到表面上的光图案。",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/caustics.html",
            "image": "5847768a27d24d8a6c1612f457b28582405529a208527019616bf6839100c3e9"
        },
        "chiaroscuro": {
            "name": "明暗对比",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/chiaroscuro.html"
        },
        "chromatic aberration abuse": {
            "name": "色差滥用",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/chromatic_aberration_abuse.html"
        },
        "diffraction spikes": {
            "name": "衍射十字星",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/diffraction_spikes.html"
        },
        "depth of field": {
            "name": "背景虚化",
            "description": "由于镜头焦距，图片的背景产生了一定程度的虚化。",
            "alias": [
                "focus blur"
            ],
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/depth_of_field.html",
            "image": "8b6f9e21dadc3c879eede5f4f939ef4cae8b154b3df98153b4706e12480cde22"
        },
        "dithering": {
            "name": "抖动",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/dithering.html"
        },
        "drop shadow": {
            "name": "立绘阴影",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/drop_shadow.html"
        },
        "emphasis lines": {
            "name": "集中线",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/emphasis_lines.html"
        },
        "film grain": {
            "name": "胶片颗粒感/老电影滤镜",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/film_grain.html",
            "alias": [
                "noise (visual)",
                "grainy"
            ]
        },
        "foreshortening": {
            "name": "正前缩距透视法",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/foreshortening.html"
        },
        "halftone": {
            "name": "一种漫画中常见的网点状的组色组图画法",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/halftone.html"
        },
        "image fill": {
            "name": "图像填充",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/image_fill.html"
        },
        "lens flare abuse": {
            "name": "镜头光晕滥用",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/lens_flare_abuse.html",
            "image": "3ba21c19d88db5a3ea9e34f0768480949d9f54512c985471cafcec6fb5ff535f"
        },
        "motion lines": {
            "name": "体现运动的线",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/motion_lines.html",
            "image": "9b4bab37adf5e7369350b204cdfe3364403c65515ec9f6abef8baa02ef3eb272"
        },
        "multiple monochrome": {
            "name": "多个单色结构拼接成的",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/multiple_monochrome.html"
        },
        "optical illusion": {
            "name": "视错觉",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/optical_illusion.html"
        },
        "anaglyph": {
            "name": "互补色",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/anaglyph.html"
        },
        "stereogram": {
            "name": "立体画",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/stereogram.html"
        },
        "scanlines": {
            "name": "扫描线",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/scanlines.html"
        },
        "silhouette": {
            "image": "a0f1f26d90b3d6009e8343d8d087b1598e1421614d88b9b9584c03fa2d3e9886",
            "name": "剪影",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/silhouette.html"
        },
        "speed lines": {
            "name": "速度线",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/speed_lines.html",
            "image": "fa945044c68a6a6c849af2cea6a249e6c5c7632954b305d541bdc4f4918a519d"
        },
        "vignetting": {
            "name": "晕影",
            "wikiURL": "https://danbooru.donmai.us/wiki_pages/vignetting.html"
        }
    }
}

let csvLines = ["text,lang_zh,subType,dir"]
Object.entries(data.content).forEach(function ([key, item]) {
    csvLines.push(`${key},${item.name},风格,构图/画面效果`)
})

import fs from "fs"

fs.writeFileSync("./构图-画面效果.csv", csvLines.join("\n"))
