/* MCU specific Definition Implementation */

// Project Headers (engine utilities)
#include "engine/include/arch/mcudef.h"

#ifdef ATMEGA328P

    const char *vmcu_sreg_str[SREG_SIZE] = { "CF", "ZF", "NF", "VF", "SF", "HF", "TF", "IF" };

    const char *vmcu_sfr_str[SFR_SIZE]  = {

        "reserved",
        "reserved",
        "reserved",
        "PINB",
        "DDRB",
        "PORTB",
        "PINC",
        "DDRC",
        "PORTC",
        "PIND",
        "DDRD",
        "PORTD",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "TIFR0",
        "TIFR1",
        "TIFR2",
        "reserved",
        "reserved",
        "reserved",
        "PCIFR",
        "EIFR",
        "EIMSK",
        "GPIOR0",
        "EECR",
        "EEDR",
        "EEARL",
        "EEARH",
        "GTCCR",
        "TCCR0A",
        "TCCR0B",
        "TCNT0",
        "OCR0A",
        "OCR0B",
        "reserved",
        "GPIOR1",
        "GPIOR2",
        "SPCR0",
        "SPSR0",
        "SPDR0",
        "reserved",
        "ACSR",
        "DWDR",
        "reserved",
        "SMCR",
        "MCUSR",
        "MCUCR",
        "reserved",
        "SPMCSR",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "SPL",
        "SPH",
        "SREG",
        "WDTCSR",
        "CLKPR",
        "reserved",
        "reserved",
        "PRR",
        "reserved",
        "OSCCAL",
        "reserved",
        "PCICR",
        "EICRA",
        "reserved",
        "PCMSK0",
        "PCMSK1",
        "PCMSK2",
        "TIMSK0",
        "TIMSK1",
        "TIMSK2",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "ADCL",
        "ADCH",
        "ADCSRA",
        "ADCSRB",
        "ADMUX",
        "reserved",
        "DIDR0",
        "DIDR1",
        "TCCR1A",
        "TCCR1B",
        "TCCR1C",
        "reserved",
        "TCNT1L",
        "TCNT1H",
        "ICR1L",
        "ICR1H",
        "OCR1AL",
        "OCR1AH",
        "OCR1BL",
        "OCR1BH",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved", 
        "reserved", 
        "reserved", 
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "reserved",
        "TCCR2A",
        "TCCR2B",
        "TCNT2",
        "OCR2A",
        "OCR2B",
        "reserved",
        "ASSR",
        "reserved",
        "TWBR",
        "TWSR",
        "TWAR",
        "TWDR",
        "TWCR",
        "TWAMR",
        "reserved",
        "reserved",
        "UCSR0A",
        "UCSR0B",
        "UCSR0C",
        "reserved",
        "UBRR0L",
        "UBRR0H",
        "UDR0"
    };

#endif

