
# O que é o Guia Desenvolvedora Web <a name="id1"></a>
>*"Comece de onde você está. Use o que você tiver. Faça o que você puder" – Arthur Ashe*


Fala Devs, tudo bem? :vulcan_salute:

Vim compartilhar com vocês como estou me tornando uma desenvolvedora front-end. :dart:

Decidi criar esse guia porque na internet existe muito conteúdo ao nosso dispor, essa quantidade de material, quando somos iniciantes, muitas vezes pode nos confundir e até atrapalhar ao invés de ajudar. 

- [ ] [Você é um colecionador de cursos?](https://www.youtube.com/watch?v=mUqo8a1FDSM&list=PLHz_AreHm4dk_kkE0WS7010x8_AsU7twX&index=1)

>"*O grande segredo para se tornar um bom programador é deixar o imediatismo de lado e entender que seu cérebro vai precisar de tempo para absorver e entender as coisas. Se você estiver fazendo algo e parecer que isso é muito difícil, apenas pare, reflita no pouco que conseguiu aprender sobre isso e volte mais tarde ou no outro dia. Você verá que tudo é questão de ter paciência com o seu tempo natural de aprendizado e perceverança nos estudos.*"

## O que você vai encontrar nesse guia: <a name="id2"></a>

* Cursos 
* Artigos
* Vídeos 
* Desafios 
* Idéias de projetos

Todo o material utilizado neste guia é gratuito.:money_with_wings:

Não pule etapas, o intuito desse guia é justamente fornecer a ordem e um cronograma para seus estudos.

Realize os exercícios e desafios propostos :rocket:


## Índice

* [O que é o Guia Desenvolvedora Web](#id1)
* [O que você vai encontrar nesse guia](#id2)
* [Como usar o Guia](#id3)
* [Não sinta que você não é inteligente o suficiente](#id4)
* [Por que ser um programador?](#id5)
* [O que faz um programador Front end](#id6)
* **[Git e Github](#id7)**
   * [Material de estudo](#git1)
   * [Exercicios](#git2)
   * [Desafios](#git3)
* **[HTML5](#id8)**
   * [Material de estudo](#html1)
   * [Exercicios](#html2)
   * [Desafios](#html3)
* **[CSS3](#id9)**
   * [Material de estudo](#CSS1)
   * [Exercicios](#CSS2)
   * [Desafios](#CSS3)
* **[Design responsivo](#id10)**
   * Material de estudo 
   * Exercicios 
   * Desafios
* **[Logica de programação](#id11)**
   * Material de estudo 
   * Exercicios 
   * Desafios
* **[JavaScript](#id)**
   * Material de estudo 
   * Exercicios 
   * Desafios


## Como usar esse guia ? :books:<a name="id3"></a>

## Não sinta que você não é inteligente o suficiente :brain: <a name="id4"></a>

>*"O melhor momento para ter começado algo era há uns dez anos atrás, o segundo melhor momento é agora."*

Muitas vezes, principalmente quando somos iniciantes, ao pensar em entrar para o mundo da programação, nos vem a sensação de que não somos inteligentes o suficiente, ou não temos capacidade para isso. 

Eu particularmente sofri (e as vezes ainda sofro) com isso, uma eterna sensação de que não nasci pra isso, como se pra programar fosse necessario um certo dom, o que claramente não é verdade. 

Como esse é um pensamento sabotador e que esta presente em quase todos nós, montei esse topico com alguns videos e artigos que me ajuda a não cair no mito do programador Genio. 

É importante deixar claro que programação não é facil, mas tambem não é dificil, não desista. 


* Videos (Pt-Br)
- [ ] [Aprender programação sem ter dom da programação](https://www.youtube.com/watch?v=ZtMzB5CoekE)
- [ ] [Programação é dificil](https://www.youtube.com/watch?v=wvPAODEdQNI)



* Videos (Inglês)
- [ ] [It's Dangerous to Go Alone: Battling the Invisible Monsters in Tech](https://www.youtube.com/watch?v=1i8ylq4j_EY)
- [ ] [The Myth of the Genius Programmer](https://www.youtube.com/watch?v=0SARbwvhupQ)

* Artigos 
- [ ] [Ninguém simplesmente aprende a programar](https://www.programaria.org/ninguem-simplesmente-aprende-como-programar/)
- [ ] [Programar não requer talento ou paixão.](http://kwan.pt/pt/blog/programar-nao-requer-talento#:~:text=%22O%20mito%20do%20%22programador%20g%C3%A9nio%22%20%C3%A9%20extremamente%20perigoso.&text=Como%20resultado%2C%20os%20programadores%20t%C3%AAm,enorme%20na%20qualidade%20de%20vida.)
- [ ] [Programar é muito fácil](https://medium.com/@julia.maschion/programar-%C3%A9-muito-f%C3%A1cil-ddf610ca6f18)

## Por que ser um programador?:desktop_computer: <a name="id5"></a>

>*"Programação é uma linguagem, assim como português ou inglês. É o “idioma” do computador. Mesmo que você não queira seguir uma carreira em tecnologia, aprender a programar estimula o desenvolvimento de diversas habilidades."*

Abaixo listei alguns vídeos e leituras que da aquele UP pra começar :rocket:

* Vídeos 
- [ ] [Por que todos deveriam aprender a programar?](https://www.youtube.com/watch?v=mHW1Hsqlp6A)
- [ ] [Seja um Programador](https://www.youtube.com/watch?v=S9uPNppGsGo)
- [ ] [Como Virar Programador](https://www.youtube.com/watch?v=R6NCG9gqcX0)

* Artigos 
- [ ] [Por que aprender a programar?](https://recode.org.br/por-que-aprender-a-programar/)
- [ ] [Por que deveríamos saber programar ?Mesmo se não for trabalhar com isso!](https://medium.com/codando/por-que-deveriamos-saber-programar-mesmo-se-n%C3%A3o-for-trabalhar-com-isso-d9ac0e900f7b)

## O que faz um programador Front end? :hippopotamus: <a name="id6"></a>

>*Desenvolvimento web front-end é a prática de converter dados em uma interface gráfica, através do uso de HTML, CSS e JavaScript, para que os usuários possam visualizar e interagir com esses dados. - Wikipedia*

Abaixo listei dois vídeos para ajudar a entender o que faz um desenvolvedor front-end

- [ ] [O QUE É UM DESENVOLVEDOR FRONT-END? ](https://www.youtube.com/watch?v=v0cN26_1d3I)
- [ ] [O que faz uma desenvolvedora front-end?](https://www.youtube.com/watch?v=ZY3-MFxVdEw)

## Git e Github :trident: <a name="id7"></a>

Bom, finalmente depois de uma boa introdução ao mundo da programação, chegamos ao primeiro curso, espero que você não tenha pulado o contéudo acima :triumph:

O primeiro curso deste guia é o de Git e Github. Mas por quê? 
Antes de começar de fato a criar projetos e aprender o conteúdo, é importante você saber utilizar o git e como se comportar no github para tirar o maior proveito dessa rede e já começar a demontrar suas habilidades para o mundo :wink:

## Material de estudo <a name="git1"></a>
   #### Video
   - [ ]  [Curso de Git e GitHub: Grátis, pratico e sem usar comandos no terminal](https://www.youtube.com/playlist?list=PLHz_AreHm4dm7ZULPAmadvNhH6vk9oNZA)

   #### Leitura
   - [ ]  [Slides](https://github.com/gustavoguanabara/git-github/tree/master/slides-aulas)
   - [ ]  [Guia markdown](https://github.com/gustavoguanabara/git-github/blob/master/manuais-PDF/guia-markdown.pdf)
   - [ ]  [A importância do Github para Desenvolvedores](https://willianjusten.com.br/a-importancia-do-github-para-desenvolvedores/)
   - [ ]  [Git e a importância de versionar um projeto](https://www.hostgator.com.br/blog/git-o-sistema-de-controle/)
   - [ ]  [Como fazer um README.md BONITÃO](https://medium.com/@raullesteves/github-como-fazer-um-readme-md-bonit%C3%A3o-c85c8f154f8)

## Exercicios <a name="git2"></a>
   - [ ]  Crie sua conta no [Github](https://github.com/)
   - [ ]  Siga o meu [perfil](https://github.com/MilenaCarecho) 
   - [ ]  Dê uma estrela no [Guia](https://github.com/MilenaCarecho/GuiaDesenvolvedoraWeb)
   - [ ]  [Divulgue seu perfil](https://github.com/gustavoguanabara/git-github/issues/3)

## Desafios <a name="git3"></a>
   - [ ]  Clone esse repositorio e utilize ele como cronograma <a name="id3"></a>

## HTML5 :bone: <a name="id8"></a>

Bom, o que falar sobre nosso querido HTML5 ? 

HTML5 é uma linguagem de marcação hipertexto utilizada para criar sites.

Eu acho importante seguir a seguinte ordem para o estudo de html5: 
1. Conhecer a internet e o funcionamento dela, pra isso separei 3 videos do curso de HTML5 do *Curso em vídeo*, e é por lá que você começa.
2. Fazer o curso de HTML5 para iniciantes da NodeStudio (curso gratuido com certificado :heart_eyes:)
3. realizar os exercícios e desafios 
4. Em paralelo realizar o curso de [Lógica de programação](#id11)

   Caso você tenha alguma dificuldade na realização dos exercícios, consulte os documentos anexos no tópico *Leitura* :mag_right:

Tem muito conteúdo na internet de HTML5, muitos cursos gratuitos. 

Mas não se prenda a eles, a melhor forma de aprender é colocando a mão na massa, o curso linkado ja fornece a base necessária para que você aprenda a realizar suas buscas na documentação da W3School ou na apostila de HTML :relaxed:


## Material de estudo <a name="html1"></a>

   #### Video
   - [ ] [História da internet](https://www.youtube.com/watch?v=rsFCVjr5yxc&t=2s)
   - [ ] [História do HTML](https://www.youtube.com/watch?v=NSmapCNcSyI)
   - [ ] [Como funciona a internet](https://www.youtube.com/watch?v=LMfeZ6XD0No&t=3s)
   - [ ] [Curso de HTML5 para iniciantes](https://www.nodestudio.com.br/curso/curso-de-html5)
   - [ ] [SEO E META TAGS SOCIAIS COM HTML](https://www.youtube.com/watch?v=YRGLRFJh4fM)
   - [ ] [HTML - Basics and Good Practices PT-Br](https://www.youtube.com/watch?v=wi9jZJZYSIY)


   #### Leitura
   - [ ] [Entenda o que é HTTP](https://rockcontent.com/blog/http/)
   - [ ] [Como os navegadores funcionam](https://www.html5rocks.com/pt/tutorials/internals/howbrowserswork/#:~:text=A%20funcionalidade%20principal%20de%20um,ou%20outro%20tipo%20de%20arquivo.)
   - [ ] [DNS: o que é, como funciona](https://rockcontent.com/blog/dns/)
   - [ ] [O que é nome de domínio](https://pt.wikipedia.org/wiki/Nome_de_dom%C3%ADnio)
   - [ ] [O QUE É SERVIÇO DE HOSTING](https://blog.intnet.com.br/o-que-e-servico-de-hosting/)
   - [ ] [SEO básico](https://rockcontent.com/blog/seo-basico/)
   - [ ] [7 Tags HTML Que Diferenciam um Profissional SEO de um Amador](https://neilpatel.com/br/blog/tags-htm/)
   - [ ] [HTML: Boas práticas em acessibilidade](https://developer.mozilla.org/pt-BR/docs/Learn/Accessibility/HTML)
   - [ ] [Como escrever HTML com acessibilidade](https://medium.com/reprogramabr/como-escrever-html-com-acessibilidade-eb5fb1a6af5a)
   - [ ] [W3Schools](https://www.w3schools.com/html/default.asp)
   - [ ] [Apostila de HTML](https://github.com/MilenaCarecho/GuiaDesenvolvedoraWeb/blob/HTML5/Cursos/HTML5/Apostila%20HTML.pdf)


#### Após estudar o material acima, veja se consegue responder com facilidade as perguntas abaixo, caso alguma das perguntas seja um desafio pra você, recomendo que reveja e procure mais sobre o tema para fixação :nerd_face:

   * Como funciona a internet?
   * O que é HTTP? 
   * O que são os navegadores e como eles funcionam?
   * O que é DNS e como ele funciona? 
   * O que é um nome de dominio?
   * O que é hosting? 
   * O que é SEO e como utilizar com HTML?
   * Como ter acessibilidade com HTML? 
   

## Exercicios <a name="html2"></a>

   - [ ] **[Exercício 01](https://codepen.io/milenacarecho/full/PoZRdME)<br>**
   *Clique [aqui](https://github.com/gustavoguanabara/html-css/blob/master/desafios/d001/desafio-mensagens.pdf) para mais informações sobre o exercício 01*
   - [ ] **[Exercício 02](https://github.com/MilenaCarecho/GuiaDesenvolvedoraWeb/blob/master/Cursos/HTML5/Exercicios/Exercicio2.PNG)**<br>
   *Clique [aqui](https://github.com/gustavoguanabara/html-css/blob/master/desafios/d002/desafio-imagens.pdf) para mais informações sobre o exercício 02*
   - [ ] **[Exercício 03](https://github.com/MilenaCarecho/GuiaDesenvolvedoraWeb/blob/master/Cursos/HTML5/Exercicios/Exercicio3.PNG)**<br>
   *Clique [aqui](https://github.com/gustavoguanabara/html-css/blob/master/desafios/d003/desafio-mapa-mundi.pdf) para mais informações sobre o exercício 03*
   - [ ] **[Exercício 04](https://codepen.io/milenacarecho/full/oNbyEpL)**<br>
   *Clique [aqui](https://github.com/gustavoguanabara/html-css/blob/master/desafios/d004/desafio-emoji.pdf) para mais informações sobre o exercício 04*
   - [ ] **[Exercício 05]()**<br>
   *Clique [aqui](https://github.com/gustavoguanabara/html-css/blob/master/desafios/d005/desafio-social.pdf) para mais informações sobre o exercício 05*
   - [ ] **[Exercício 06]()**<br>
   *Clique [aqui](https://github.com/gustavoguanabara/html-css/blob/master/desafios/d006/desafio-tags.pdf) para mais informações sobre o exercício 05*
   - [ ] **[Exercício 07](https://codepen.io/milenacarecho/full/VweQdpQ)**<br>
   *Clique [aqui](https://github.com/MilenaCarecho/GuiaDesenvolvedoraWeb/blob/master/Cursos/HTML5/Exercicios/Exercicio7.pdf) para mais informações sobre o exercício 07*
   
#### Tente resolver o exercicio sozinha (o), não vá direto ao exercicio resolvido :frowning_face:

   * [*Exercicio 01 resolvido*](https://github.com/MilenaCarecho/GuiaDesenvolvedoraWeb/tree/master/Cursos/HTML5/ExerciciosResolvidos/Exercicio1)
   * [*Exercicio 02 resolvido*](https://github.com/MilenaCarecho/GuiaDesenvolvedoraWeb/tree/master/Cursos/HTML5/ExerciciosResolvidos/Exercicio2)
   * [*Exercicio 03 resolvido*](https://github.com/MilenaCarecho/GuiaDesenvolvedoraWeb/tree/master/Cursos/HTML5/ExerciciosResolvidos/Exercicio3)
   * [*Exercicio 04 resolvido*](https://github.com/MilenaCarecho/GuiaDesenvolvedoraWeb/tree/master/Cursos/HTML5/ExerciciosResolvidos/Exercicio4)
   * [*Exercicio 05 resolvido*](https://github.com/MilenaCarecho/GuiaDesenvolvedoraWeb/tree/master/Cursos/HTML5/ExerciciosResolvidos/Exercicio5)
   * [*Exercicio 06 resolvido*](https://github.com/MilenaCarecho/GuiaDesenvolvedoraWeb/tree/master/Cursos/HTML5/ExerciciosResolvidos/Exercicio6)
   * [*Exercicio 07 resolvido*](https://github.com/MilenaCarecho/GuiaDesenvolvedoraWeb/tree/HTML5/Cursos/HTML5/ExerciciosResolvidos/Exercicio7)
   

## Desafios <a name="html3"></a>

   * Não vai ter desafios no módulo HTML5, eu quis fazer o módulo HTML mais curtinho porque é melhor treinar ele com o complemento de CSS. Mas vou compensar isso colocando bastante desafios no módulo CSS3 :nerd_face:

## CSS3 :nail_care: <a name="id"></a>

## Material de estudo <a name="css1"></a> 

   #### Video 
   - [ ] [Curso de CSS3 para iniciantes](https://www.nodestudio.com.br/curso/curso-de-css3)

   #### Leitura

## Desafios <a name="css3"></a>

- [ ] [Desafio 30 dias de CSS](https://github.com/MilenaCarecho/30diasDeCSS)

## Desing responsivo<a name="id"></a>

## Material de estudo

   #### Video

- [ ] [Curso de Design Responsivo](https://www.nodestudio.com.br/curso/curso-de-design-responsivo)

   #### Leitura

   
## Logica de programação <a name="id11"></a> 

## Material de estudo

   #### Video 

   #### Leitura

## Desafios 



## Javascript<a name="id"></a> 

## Material de estudo  

   #### Video 

   #### Leitura

## Desafios 


## Contribuição 

Você tem alguma sugestão de como podemos melhorar esse projeto em geral? Me informe! Gostaria muito de ouvir seus comentários!
Quaisquer contribuições são muito apreciadas.:smile:

## Espalhe a palavra

Se as informações deste repositório foram úteis para você de alguma forma, certifique-se de dar uma estrela 🌟, dessa forma, outras pessoas podem encontrá-lo e se beneficiar também! Juntos, podemos crescer e melhorar nossa comunidade!








 
