# Removing Unused Dependencies

Before deploying your app, you might want to remove unused dependencies from your [pyproject.toml](/pyproject.toml) file to reduce the size of your app and improve its performance. Depending on the vector database provider you choose, you can remove the packages that are not needed for your specific provider.

Here are the packages you can remove for each vector database provider:

- **Pinecone:** Remove `weaviate-client`, `pymilvus`, `qdrant-client`, `redis`, and `llama-index`.
- **Weaviate:** Remove `pinecone-client`, `pymilvus`, `qdrant-client`, `redis`, and `llama-index`.
- **Zilliz:** Remove `pinecone-client`, `weaviate-client`, `qdrant-client`, `redis`, and `llama-index`.
- **Milvus:** Remove `pinecone-client`, `weaviate-client`, `qdrant-client`, `redis`, and `llama-index`.
- **Qdrant:** Remove `pinecone-client`, `weaviate-client`, `pymilvus`, `redis`, and `llama-index`.
- **Redis:** Remove `pinecone-client`, `weaviate-client`, `pymilvus`, `qdrant-client`, and `llama-index`.
- **LlamaIndex:** Remove `pinecone-client`, `weaviate-client`, `pymilvus`, `qdrant-client`, and `redis`.

After removing the unnecessary packages from the `pyproject.toml` file, you don't need to run `poetry lock` and `poetry install` manually. The provided Dockerfile takes care of installing the required dependencies using the `requirements.txt` file generated by the `poetry export` command.
