# Deploying to Heroku

## Removing Unused Dependencies

Before deploying your app, you might want to remove unused dependencies from your [pyproject.toml](/pyproject.toml) file to reduce the size of your app and improve its performance. Depending on the vector database provider you choose, you can remove the packages that are not needed for your specific provider.

Find the packages you can remove for each vector database provider [here](removing-unused-dependencies.md).

After removing the unnecessary packages from the `pyproject.toml` file, you don't need to run `poetry lock` and `poetry install` manually. The provided Dockerfile takes care of installing the required dependencies using the `requirements.txt` file generated by the `poetry export` command.

## Deployment

To deploy the Docker container from this repository to Heroku and set the required environment variables, follow these steps:

[Install Docker](https://docs.docker.com/engine/install/) on your local machine if it is not already installed.

Install the [Heroku CLI](https://devcenter.heroku.com/articles/heroku-cli) on your local machine.

Clone the repository from GitHub:

```
git clone https://github.com/openai/chatgpt-retrieval-plugin.git
```

Navigate to the cloned repository directory:

```
cd path/to/chatgpt-retrieval-plugin
```

Log in to the Heroku CLI:

```
heroku login
```

Create a Heroku app:

```
heroku create [app-name]
```

Log in to the Heroku Container Registry:

```
heroku container:login
```

Alternatively, you can use a command from the Makefile to log in to the Heroku Container Registry by running:

```
make heroku-login
```

Build the Docker image using the Dockerfile:

```
docker buildx build --platform linux/amd64 -t [image-name] .
```

(Replace `[image-name]` with the name you want to give your Docker image)

Push the Docker image to the Heroku Container Registry, and release the newly pushed image to your Heroku app.

```
docker tag [image-name] registry.heroku.com/[app-name]/web
docker push registry.heroku.com/[app-name]/web
heroku container:release web -a [app-name]
```

Alternatively, you can use a command from the to push the Docker image to the Heroku Container Registry by running:

```
make heroku-push
```

**Note:** You will need to edit the Makefile and replace `<your app name>` with your actual app name.

Set the required environment variables for your Heroku app:

```
heroku config:set DATASTORE=your_datastore \
OPENAI_API_KEY=your_openai_api_key \
BEARER_TOKEN=your_bearer_token \
<Add the environment variables for your chosen vector DB here> \
-a [app-name]
```

You could also set environment variables in the [Heroku Console](https://dashboard.heroku.com/apps).

After completing these steps, your Docker container should be deployed to Heroku and running with the necessary environment variables set. You can view your app by running:

```
heroku open -a [app-name]
```

which will open your app url. You should be able to find the OpenAPI schema at `<your_app_url>/.well-known/openapi.yaml` and the manifest at `<your_app_url>/.well-known/ai-plugin.json`.

To view your app logs:

```
heroku logs --tail -a [app-name]
```

Now make sure to change the plugin url in your plugin manifest file [here](/.well-known/ai-plugin.json), and in your OpenAPI schema [here](/.well-known/openapi.yaml), and redeploy with `make heroku-push`. This url will be `https://your-app-name.herokuapp.com`.
