PRAGMA foreign_keys = ON;
BEGIN TRANSACTION;
CREATE TABLE targetCIDs (CID INTEGER PRIMARY KEY NOT NULL);
-- LIST OF TARGET CID
CREATE TABLE CIDwidthCode (widthType INTEGER PRIMARY KEY NOT NULL, description TEXT NOT NULL);
INSERT INTO CIDwidthCode VALUES(0, 'Fullwidth');
INSERT INTO CIDwidthCode VALUES(1, 'Halfwidth');
INSERT INTO CIDwidthCode VALUES(2, 'Proportional');
INSERT INTO CIDwidthCode VALUES(3, 'Quarterwidth');
INSERT INTO CIDwidthCode VALUES(4, 'Thirdwidth');
INSERT INTO CIDwidthCode VALUES(9, 'Pre-rotated');
CREATE TABLE CIDwidth (CID INTEGER PRIMARY KEY NOT NULL, widthType INTEGER NOT NULL, FOREIGN KEY(widthType) REFERENCES CIDwidthCode(widthType)); -- From Adobe Technical Note #5078
-- WIDTH 1: 0 0
-- WIDTH 2: 1 230
-- WIDTH 1: 231 632
-- WIDTH 1: 8718 8719
-- WIDTH 9: 8720 9353
-- WIDTH 2: 9354 9737
-- WIDTH 3: 9738 9757
-- WIDTH 4: 9758 9778
-- WIDTH 1: 12063 12087
-- WIDTH 1: 12123 12128
-- WIDTH 1: 12169 12172
-- WIDTH 9: 12870 13319
-- WIDTH 2: 15449 15975
-- WIDTH 9: 16469 16778
-- WIDTH 2: 20317 20426
-- WIDTH 9: 20961 21070
CREATE VIEW widthData AS
SELECT CID, widthType FROM CIDwidth
UNION SELECT targetCIDs.CID AS CID, 0 AS widthType FROM targetCIDs NATURAL LEFT JOIN CIDwidth
WHERE CIDwidth.widthType IS NULL
ORDER BY CID;
CREATE TABLE lgcGlyphs (glyphName TEXT PRIMARY KEY NOT NULL, pwid INTEGER, hwid INTEGER, qwid INTEGER, twid INTEGER, fwid INTEGER, ital INTEGER,
rotPwid INTEGER, rotHwid INTEGER, rotQwid INTEGER, rotTwid INTEGER, rotItal INTEGER);
INSERT INTO lgcGlyphs VALUES('a', 66, 296, NULL, NULL, 816, 9509, 8785, 9015, NULL, NULL, 13025);
INSERT INTO lgcGlyphs VALUES('A', 34, 264, NULL, NULL, 790, 9477, 8753, 8983, NULL, NULL, 12993);
INSERT INTO lgcGlyphs VALUES('a.cyr', 1092, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('A.cyr', 1059, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('aacute', 194, 630, NULL, NULL, NULL, 9637, 8913, 9079, NULL, NULL, 13153);
INSERT INTO lgcGlyphs VALUES('Aacute', 165, NULL, NULL, NULL, NULL, 9608, 8884, NULL, NULL, NULL, 13124);
INSERT INTO lgcGlyphs VALUES('abreve', 15769, NULL, NULL, NULL, NULL, 15951, 16572, NULL, NULL, NULL, 16754);
INSERT INTO lgcGlyphs VALUES('Abreve', 15756, NULL, NULL, NULL, NULL, 15938, 16559, NULL, NULL, NULL, 16741);
INSERT INTO lgcGlyphs VALUES('acaron', 9406, NULL, NULL, NULL, NULL, 9726, 12922, NULL, NULL, NULL, 13242);
INSERT INTO lgcGlyphs VALUES('Acaron', 9394, NULL, NULL, NULL, NULL, 9714, 12910, NULL, NULL, NULL, 13230);
INSERT INTO lgcGlyphs VALUES('acircumflex', 195, 622, NULL, NULL, NULL, 9638, 8914, 9072, NULL, NULL, 13154);
INSERT INTO lgcGlyphs VALUES('Acircumflex', 166, NULL, NULL, NULL, NULL, 9609, 8885, NULL, NULL, NULL, 13125);
INSERT INTO lgcGlyphs VALUES('acute', 127, 501, NULL, NULL, 645, 9570, 8846, 9046, NULL, NULL, 13086);
INSERT INTO lgcGlyphs VALUES('adieresis', 197, 617, NULL, NULL, NULL, 9640, 8916, 9067, NULL, NULL, 13156);
INSERT INTO lgcGlyphs VALUES('Adieresis', 168, 599, NULL, NULL, NULL, 9611, 8887, 9049, NULL, NULL, 13127);
INSERT INTO lgcGlyphs VALUES('ae', 145, NULL, NULL, NULL, NULL, 9588, 8864, NULL, NULL, NULL, 13104);
INSERT INTO lgcGlyphs VALUES('AE', 139, NULL, NULL, NULL, NULL, 9582, 8858, NULL, NULL, NULL, 13098);
INSERT INTO lgcGlyphs VALUES('aeacute', 9421, NULL, NULL, NULL, NULL, NULL, 12937, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('aegrave', 9422, NULL, NULL, NULL, NULL, NULL, 12938, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('agrave', 193, 627, NULL, NULL, NULL, 9636, 8912, 9077, NULL, NULL, 13152);
INSERT INTO lgcGlyphs VALUES('Agrave', 164, NULL, NULL, NULL, NULL, 9607, 8883, NULL, NULL, NULL, 13123);
INSERT INTO lgcGlyphs VALUES('alpha', 1035, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Alpha', 1011, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('alphatonos', 20436, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Alphatonos', 20427, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('amacron', 9361, NULL, NULL, NULL, NULL, 9681, 12877, NULL, NULL, NULL, 13197);
INSERT INTO lgcGlyphs VALUES('Amacron', 9366, NULL, NULL, NULL, NULL, 9686, 12882, NULL, NULL, NULL, 13202);
INSERT INTO lgcGlyphs VALUES('ampersand', 7, 237, NULL, NULL, 717, 9450, 8726, 8956, NULL, NULL, 12966);
INSERT INTO lgcGlyphs VALUES('angstrom', NULL, NULL, NULL, NULL, 771, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('aogonek', 15745, NULL, NULL, NULL, NULL, 15930, 16548, NULL, NULL, NULL, 16733);
INSERT INTO lgcGlyphs VALUES('Aogonek', 15737, NULL, NULL, NULL, NULL, 15923, 16540, NULL, NULL, NULL, 16726);
INSERT INTO lgcGlyphs VALUES('apostrophemod', 96, NULL, NULL, NULL, NULL, 9539, 8815, NULL, NULL, NULL, 13055);
INSERT INTO lgcGlyphs VALUES('approxequalorimage', 15496, NULL, NULL, NULL, 762, NULL, 16507, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('aring', 198, NULL, NULL, NULL, NULL, 9641, 8917, NULL, NULL, NULL, 13157);
INSERT INTO lgcGlyphs VALUES('Aring', 169, NULL, NULL, NULL, NULL, 9612, 8888, NULL, NULL, NULL, 13128);
INSERT INTO lgcGlyphs VALUES('asciicircum', 63, 293, NULL, NULL, 648, 9506, 8782, 9012, NULL, NULL, 13022);
INSERT INTO lgcGlyphs VALUES('asciitilde', 100, 631, NULL, NULL, NULL, 9543, 8819, 9080, NULL, NULL, 13059);
INSERT INTO lgcGlyphs VALUES('ascript', 9418, NULL, NULL, NULL, NULL, NULL, 12934, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ascriptacute', 9419, NULL, NULL, NULL, NULL, NULL, 12935, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ascriptgrave', 9420, NULL, NULL, NULL, NULL, NULL, 12936, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ascriptturn', 15836, NULL, NULL, NULL, NULL, NULL, 16639, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('asterisk', 11, 241, NULL, NULL, 718, 9454, 8730, 8960, NULL, NULL, 12970);
INSERT INTO lgcGlyphs VALUES('asteriskdbl', NULL, NULL, NULL, NULL, 16281, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('asterism', NULL, NULL, NULL, NULL, 16282, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('at', 33, 263, NULL, NULL, 719, 9476, 8752, 8982, NULL, NULL, 12992);
INSERT INTO lgcGlyphs VALUES('atilde', 196, NULL, NULL, NULL, NULL, 9639, 8915, NULL, NULL, NULL, 13155);
INSERT INTO lgcGlyphs VALUES('Atilde', 167, NULL, NULL, NULL, NULL, 9610, 8886, NULL, NULL, NULL, 13126);
INSERT INTO lgcGlyphs VALUES('aturn', 15832, NULL, NULL, NULL, NULL, NULL, 16635, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('b', 67, 297, NULL, NULL, 817, 9510, 8786, 9016, NULL, NULL, 13026);
INSERT INTO lgcGlyphs VALUES('B', 35, 265, NULL, NULL, 791, 9478, 8754, 8984, NULL, NULL, 12994);
INSERT INTO lgcGlyphs VALUES('backslash', 97, 8719, NULL, NULL, 664, 9540, 8816, 9083, NULL, NULL, 13056);
INSERT INTO lgcGlyphs VALUES('bar', 99, 323, NULL, NULL, NULL, 9542, 8818, 9042, NULL, NULL, 13058);
INSERT INTO lgcGlyphs VALUES('be', 1093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Be', 1060, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('beta', 1036, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Beta', 1012, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('beta.ipa', 15909, NULL, NULL, NULL, NULL, NULL, 16712, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('bhook', 15822, NULL, NULL, NULL, NULL, NULL, 16625, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('bilabialclick', 15820, NULL, NULL, NULL, NULL, NULL, 16623, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('braceleft', 92, 322, NULL, NULL, 680, 9535, 8811, 9041, NULL, NULL, 13051);
INSERT INTO lgcGlyphs VALUES('braceright', 94, 324, NULL, NULL, 681, 9537, 8813, 9043, NULL, NULL, 13053);
INSERT INTO lgcGlyphs VALUES('bracketleft', 60, 290, NULL, NULL, 678, 9503, 8779, 9009, NULL, NULL, 13019);
INSERT INTO lgcGlyphs VALUES('bracketright', 62, 292, NULL, NULL, 679, 9505, 8781, 9011, NULL, NULL, 13021);
INSERT INTO lgcGlyphs VALUES('breve', 15738, NULL, NULL, NULL, NULL, NULL, 16541, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('brevecmb', 130, NULL, NULL, NULL, NULL, 9573, 8849, NULL, NULL, NULL, 13089);
INSERT INTO lgcGlyphs VALUES('breveinvertedbelowcmb', 15866, NULL, NULL, NULL, NULL, NULL, 16669, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('breveinverteddoublecmb', 15845, NULL, NULL, NULL, NULL, NULL, 16648, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('bridgebelowcmb', 15876, NULL, NULL, NULL, NULL, NULL, 16679, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('bridgeinvertedbelowcmb', 15877, NULL, NULL, NULL, NULL, NULL, 16680, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('brokenbar', 93, NULL, NULL, NULL, 8005, 9536, 8812, NULL, NULL, NULL, 13052);
INSERT INTO lgcGlyphs VALUES('Bsmallcap', 15891, NULL, NULL, NULL, NULL, NULL, 16694, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('bullet', 119, NULL, NULL, NULL, NULL, 9562, 8838, NULL, NULL, NULL, 13078);
INSERT INTO lgcGlyphs VALUES('c', 68, 298, NULL, NULL, 818, 9511, 8787, 9017, NULL, NULL, 13027);
INSERT INTO lgcGlyphs VALUES('C', 36, 266, NULL, NULL, 792, 9479, 8755, 8985, NULL, NULL, 12995);
INSERT INTO lgcGlyphs VALUES('cacute', 15771, NULL, NULL, NULL, NULL, 15953, 16574, NULL, NULL, NULL, 16756);
INSERT INTO lgcGlyphs VALUES('Cacute', 15758, NULL, NULL, NULL, NULL, 15940, 16561, NULL, NULL, NULL, 16743);
INSERT INTO lgcGlyphs VALUES('caron', 15749, NULL, NULL, NULL, NULL, NULL, 16552, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('caronbelowcmb', 15859, NULL, NULL, NULL, NULL, NULL, 16662, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('caroncmb', 137, NULL, NULL, NULL, NULL, 9580, 8856, NULL, NULL, NULL, 13096);
INSERT INTO lgcGlyphs VALUES('ccaron', 15772, NULL, NULL, NULL, NULL, 15954, 16575, NULL, NULL, NULL, 16757);
INSERT INTO lgcGlyphs VALUES('Ccaron', 15759, NULL, NULL, NULL, NULL, 15941, 16562, NULL, NULL, NULL, 16744);
INSERT INTO lgcGlyphs VALUES('ccedilla', 199, 604, NULL, NULL, NULL, 9642, 8918, 9054, NULL, NULL, 13158);
INSERT INTO lgcGlyphs VALUES('Ccedilla', 170, 605, NULL, NULL, NULL, 9613, 8889, 9055, NULL, NULL, 13129);
INSERT INTO lgcGlyphs VALUES('ccircumflex', 15789, NULL, NULL, NULL, NULL, 15970, 16592, NULL, NULL, NULL, 16773);
INSERT INTO lgcGlyphs VALUES('Ccircumflex', 15783, NULL, NULL, NULL, NULL, 15964, 16586, NULL, NULL, NULL, 16767);
INSERT INTO lgcGlyphs VALUES('ccurl', 15841, NULL, NULL, NULL, NULL, NULL, 16644, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('cdotaccent', 20352, NULL, NULL, NULL, NULL, 20407, 20996, NULL, NULL, NULL, 21051);
INSERT INTO lgcGlyphs VALUES('Cdotaccent', 20333, NULL, NULL, NULL, NULL, 20388, 20977, NULL, NULL, NULL, 21032);
INSERT INTO lgcGlyphs VALUES('cedilla', 134, NULL, NULL, NULL, NULL, 9577, 8853, NULL, NULL, NULL, 13093);
INSERT INTO lgcGlyphs VALUES('celsius', 15461, 12065, NULL, NULL, 710, NULL, 16474, 13297, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('cent', 102, 608, NULL, NULL, 713, 9545, 8821, 9058, NULL, NULL, 13061);
INSERT INTO lgcGlyphs VALUES('che', 1116, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Che', 1083, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('chi', 1056, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Chi', 1032, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('chi.ipa', 15911, NULL, NULL, NULL, NULL, NULL, 16714, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('circumflex', 128, NULL, NULL, NULL, NULL, 9571, 8847, NULL, NULL, NULL, 13087);
INSERT INTO lgcGlyphs VALUES('clickalveolar', 15821, NULL, NULL, NULL, NULL, NULL, 16624, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('colon', 27, 257, 9756, 9776, 639, 9470, 8746, 8976, 13272, 13292, 12986);
INSERT INTO lgcGlyphs VALUES('comma', 13, 243, 9751, 9771, 636, 9456, 8732, 8962, 13267, 13287, 12972);
INSERT INTO lgcGlyphs VALUES('commaturnedmod', 98, NULL, NULL, NULL, NULL, 9541, 8817, NULL, NULL, NULL, 13057);
INSERT INTO lgcGlyphs VALUES('copyright', 152, NULL, NULL, NULL, NULL, 9595, 8871, NULL, NULL, NULL, 13111);
INSERT INTO lgcGlyphs VALUES('copyright.sups', 8059, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('currency', 107, NULL, NULL, NULL, 16280, 9550, 8826, NULL, NULL, NULL, 13066);
INSERT INTO lgcGlyphs VALUES('d', 69, 299, NULL, NULL, 819, 9512, 8788, 9018, NULL, NULL, 13028);
INSERT INTO lgcGlyphs VALUES('D', 37, 267, NULL, NULL, 793, 9480, 8756, 8986, NULL, NULL, 12996);
INSERT INTO lgcGlyphs VALUES('dagger', 115, NULL, NULL, NULL, 776, 9558, 8834, NULL, NULL, NULL, 13074);
INSERT INTO lgcGlyphs VALUES('daggerdbl', 116, NULL, NULL, NULL, 777, 9559, 8835, NULL, NULL, NULL, 13075);
INSERT INTO lgcGlyphs VALUES('dblgravecmb', 15850, NULL, NULL, NULL, NULL, NULL, 16653, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dcaron', 15774, NULL, NULL, NULL, NULL, 15956, 16577, NULL, NULL, NULL, 16759);
INSERT INTO lgcGlyphs VALUES('Dcaron', 15761, NULL, NULL, NULL, NULL, 15943, 16564, NULL, NULL, NULL, 16746);
INSERT INTO lgcGlyphs VALUES('dcroat', 15775, NULL, NULL, NULL, NULL, 15957, 16578, NULL, NULL, NULL, 16760);
INSERT INTO lgcGlyphs VALUES('Dcroat', 20322, NULL, NULL, NULL, NULL, 20377, 20966, NULL, NULL, NULL, 21021);
INSERT INTO lgcGlyphs VALUES('de', 1096, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('De', 1063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('degree', 155, NULL, NULL, NULL, 707, 9598, 8874, NULL, NULL, NULL, 13114);
INSERT INTO lgcGlyphs VALUES('delta', 1038, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Delta', 1014, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Delta.math', 20367, NULL, NULL, NULL, NULL, 20422, 21011, NULL, NULL, NULL, 21066);
INSERT INTO lgcGlyphs VALUES('dhook', 15823, NULL, NULL, NULL, NULL, NULL, 16626, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dieresis', 132, 502, NULL, NULL, 647, 9575, 8851, 9047, NULL, NULL, 13091);
INSERT INTO lgcGlyphs VALUES('dieresisbelowcmb', 15868, NULL, NULL, NULL, NULL, NULL, 16671, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dieresistonos', 20318, NULL, NULL, NULL, NULL, 20373, 20962, NULL, NULL, NULL, 21017);
INSERT INTO lgcGlyphs VALUES('divide', 215, NULL, NULL, NULL, 696, 9658, 8934, NULL, NULL, NULL, 13174);
INSERT INTO lgcGlyphs VALUES('dje', 20460, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Dje', 20447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dollar', 5, 235, NULL, NULL, 712, 9448, 8724, 8954, NULL, NULL, 12964);
INSERT INTO lgcGlyphs VALUES('dotaccent', 15782, NULL, NULL, NULL, NULL, NULL, 16585, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dotaccentcmb', 131, NULL, NULL, NULL, NULL, 9574, 8850, NULL, NULL, NULL, 13090);
INSERT INTO lgcGlyphs VALUES('dotlessi', 146, NULL, NULL, NULL, NULL, 9589, 8865, NULL, NULL, NULL, 13105);
INSERT INTO lgcGlyphs VALUES('dotlessj', 9435, NULL, NULL, NULL, NULL, NULL, 12951, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dotlessjstrokehook', 15824, NULL, NULL, NULL, NULL, NULL, 16627, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('downtackbelowcmb', 15873, NULL, NULL, NULL, NULL, NULL, 16676, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('drthook', 15802, NULL, NULL, NULL, NULL, NULL, 16605, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dze', 20463, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Dze', 20450, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dzhe', 20472, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Dzhe', 20459, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('e', 70, 300, NULL, NULL, 820, 9513, 8789, 9019, NULL, NULL, 13029);
INSERT INTO lgcGlyphs VALUES('E', 38, 268, NULL, NULL, 794, 9481, 8757, 8987, NULL, NULL, 12997);
INSERT INTO lgcGlyphs VALUES('e.cyr', 1122, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('E.cyr', 1089, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('eacute', 201, 601, NULL, NULL, NULL, 9644, 8920, 9051, NULL, NULL, 13160);
INSERT INTO lgcGlyphs VALUES('Eacute', 172, NULL, NULL, NULL, NULL, 9615, 8891, NULL, NULL, NULL, 13131);
INSERT INTO lgcGlyphs VALUES('ecaron', 9407, NULL, NULL, NULL, NULL, 9727, 12923, NULL, NULL, NULL, 13243);
INSERT INTO lgcGlyphs VALUES('Ecaron', 9395, NULL, NULL, NULL, NULL, 9715, 12911, NULL, NULL, NULL, 13231);
INSERT INTO lgcGlyphs VALUES('ecircumflex', 202, 623, NULL, NULL, NULL, 9645, 8921, 9073, NULL, NULL, 13161);
INSERT INTO lgcGlyphs VALUES('Ecircumflex', 173, NULL, NULL, NULL, NULL, 9616, 8892, NULL, NULL, NULL, 13132);
INSERT INTO lgcGlyphs VALUES('edieresis', 203, 618, NULL, NULL, NULL, 9646, 8922, 9068, NULL, NULL, 13162);
INSERT INTO lgcGlyphs VALUES('Edieresis', 174, NULL, NULL, NULL, NULL, 9617, 8893, NULL, NULL, NULL, 13133);
INSERT INTO lgcGlyphs VALUES('edotaccent', 20353, NULL, NULL, NULL, NULL, 20408, 20997, NULL, NULL, NULL, 21052);
INSERT INTO lgcGlyphs VALUES('Edotaccent', 20334, NULL, NULL, NULL, NULL, 20389, 20978, NULL, NULL, NULL, 21033);
INSERT INTO lgcGlyphs VALUES('ef', 1113, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Ef', 1080, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('egrave', 200, 628, NULL, NULL, NULL, 9643, 8919, 9078, NULL, NULL, 13159);
INSERT INTO lgcGlyphs VALUES('Egrave', 171, NULL, NULL, NULL, NULL, 9614, 8890, NULL, NULL, NULL, 13130);
INSERT INTO lgcGlyphs VALUES('eight', 25, 255, 9746, 9766, 788, 9468, 8744, 8974, 13262, 13282, 12984);
INSERT INTO lgcGlyphs VALUES('eight.inferior', 9392, NULL, NULL, NULL, NULL, 9712, 12908, NULL, NULL, NULL, 13228);
INSERT INTO lgcGlyphs VALUES('eight.superior', 9382, NULL, NULL, NULL, NULL, 9702, 12898, NULL, NULL, NULL, 13218);
INSERT INTO lgcGlyphs VALUES('el', 1104, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('El', 1071, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ellipsis', 124, NULL, NULL, NULL, NULL, 9567, 8843, NULL, NULL, NULL, 13083);
INSERT INTO lgcGlyphs VALUES('em', 1105, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Em', 1072, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('emacron', 9364, NULL, NULL, NULL, NULL, 9684, 12880, NULL, NULL, NULL, 13200);
INSERT INTO lgcGlyphs VALUES('Emacron', 9369, NULL, NULL, NULL, NULL, 9689, 12885, NULL, NULL, NULL, 13205);
INSERT INTO lgcGlyphs VALUES('emdash', 138, NULL, NULL, NULL, NULL, 9581, 8857, NULL, NULL, NULL, 13097);
INSERT INTO lgcGlyphs VALUES('en', 1106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('En', 1073, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('eng', 9436, NULL, NULL, NULL, NULL, NULL, 12952, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Eng', 20326, NULL, NULL, NULL, NULL, 20381, 20970, NULL, NULL, NULL, 21025);
INSERT INTO lgcGlyphs VALUES('eogonek', 15773, NULL, NULL, NULL, NULL, 15955, 16576, NULL, NULL, NULL, 16758);
INSERT INTO lgcGlyphs VALUES('Eogonek', 15760, NULL, NULL, NULL, NULL, 15942, 16563, NULL, NULL, NULL, 16745);
INSERT INTO lgcGlyphs VALUES('eopen', 9432, NULL, NULL, NULL, NULL, NULL, 12948, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('eopenacute', 9433, NULL, NULL, NULL, NULL, NULL, 12949, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('eopengrave', 9434, NULL, NULL, NULL, NULL, NULL, 12950, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('eopenreversed', 15830, NULL, NULL, NULL, NULL, NULL, 16633, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('eopenreversedclosed', 15831, NULL, NULL, NULL, NULL, NULL, 16634, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('epsilon', 1039, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Epsilon', 1015, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('epsilon.alt', 15900, NULL, NULL, NULL, NULL, NULL, 16703, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('epsilontonos', 20437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Epsilontonos', 20428, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('equal', 30, 260, 9750, 9770, 697, 9473, 8749, 8979, 13266, 13286, 12989);
INSERT INTO lgcGlyphs VALUES('equivalence', 15495, NULL, NULL, NULL, 761, NULL, 16506, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('er', 1109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Er', 1076, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ereversed', 15829, NULL, NULL, NULL, NULL, NULL, 16632, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ering', 9408, NULL, NULL, NULL, NULL, 9728, 12924, NULL, NULL, NULL, 13244);
INSERT INTO lgcGlyphs VALUES('Ering', 9396, NULL, NULL, NULL, NULL, 9716, 12912, NULL, NULL, NULL, 13232);
INSERT INTO lgcGlyphs VALUES('es', 1110, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Es', 1077, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('esh', 9442, NULL, NULL, NULL, NULL, NULL, 12958, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('estimated', 20366, NULL, NULL, NULL, NULL, 20421, 21010, NULL, NULL, NULL, 21065);
INSERT INTO lgcGlyphs VALUES('eta', 1041, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Eta', 1017, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('etatonos', 20438, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Etatonos', 20429, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('eth', 208, NULL, NULL, NULL, NULL, 9651, 8927, NULL, NULL, NULL, 13167);
INSERT INTO lgcGlyphs VALUES('Eth', 179, NULL, NULL, NULL, NULL, 9622, 8898, NULL, NULL, NULL, 13138);
INSERT INTO lgcGlyphs VALUES('etilde', 9409, NULL, NULL, NULL, NULL, 9729, 12925, NULL, NULL, NULL, 13245);
INSERT INTO lgcGlyphs VALUES('Etilde', 9397, NULL, NULL, NULL, NULL, 9717, 12913, NULL, NULL, NULL, 13233);
INSERT INTO lgcGlyphs VALUES('euro', 9354, NULL, NULL, NULL, 9779, 9674, 12870, NULL, NULL, NULL, 13190);
INSERT INTO lgcGlyphs VALUES('exclam', 2, 232, NULL, NULL, 642, 9445, 8721, 8951, NULL, NULL, 12961);
INSERT INTO lgcGlyphs VALUES('exclamdown', 101, 612, NULL, NULL, NULL, 9544, 8820, 9062, NULL, NULL, 13060);
INSERT INTO lgcGlyphs VALUES('ezh', 9441, NULL, NULL, NULL, NULL, NULL, 12957, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('f', 71, 301, NULL, NULL, 821, 9514, 8790, 9020, NULL, NULL, 13030);
INSERT INTO lgcGlyphs VALUES('F', 39, 269, NULL, NULL, 795, 9482, 8758, 8988, NULL, NULL, 12998);
INSERT INTO lgcGlyphs VALUES('f_f', 9358, NULL, NULL, NULL, NULL, 9678, 12874, NULL, NULL, NULL, 13194);
INSERT INTO lgcGlyphs VALUES('f_f_i', 9359, NULL, NULL, NULL, NULL, 9679, 12875, NULL, NULL, NULL, 13195);
INSERT INTO lgcGlyphs VALUES('f_f_l', 9360, NULL, NULL, NULL, NULL, 9680, 12876, NULL, NULL, NULL, 13196);
INSERT INTO lgcGlyphs VALUES('f_i', 112, NULL, NULL, NULL, NULL, 9555, 8831, NULL, NULL, NULL, 13071);
INSERT INTO lgcGlyphs VALUES('f_l', 113, NULL, NULL, NULL, NULL, 9556, 8832, NULL, NULL, NULL, 13072);
INSERT INTO lgcGlyphs VALUES('figuredash', 114, NULL, NULL, NULL, NULL, 9557, 8833, NULL, NULL, NULL, 13073);
INSERT INTO lgcGlyphs VALUES('five', 22, 252, 9743, 9763, 785, 9465, 8741, 8971, 13259, 13279, 12981);
INSERT INTO lgcGlyphs VALUES('five.inferior', 9389, NULL, NULL, NULL, NULL, 9709, 12905, NULL, NULL, NULL, 13225);
INSERT INTO lgcGlyphs VALUES('five.superior', 9379, NULL, NULL, NULL, NULL, 9699, 12895, NULL, NULL, NULL, 13215);
INSERT INTO lgcGlyphs VALUES('fiveeighths', 9373, NULL, NULL, NULL, NULL, 9693, 12889, NULL, NULL, NULL, 13209);
INSERT INTO lgcGlyphs VALUES('florin', 105, NULL, NULL, NULL, NULL, 9548, 8824, NULL, NULL, NULL, 13064);
INSERT INTO lgcGlyphs VALUES('four', 21, 251, 9742, 9762, 784, 9464, 8740, 8970, 13258, 13278, 12980);
INSERT INTO lgcGlyphs VALUES('four.inferior', 9388, NULL, NULL, NULL, NULL, 9708, 12904, NULL, NULL, NULL, 13224);
INSERT INTO lgcGlyphs VALUES('four.superior', 9378, NULL, NULL, NULL, NULL, 9698, 12894, NULL, NULL, NULL, 13214);
INSERT INTO lgcGlyphs VALUES('fraction', 104, NULL, NULL, NULL, NULL, 9547, 8823, NULL, NULL, NULL, 13063);
INSERT INTO lgcGlyphs VALUES('g', 72, 302, NULL, NULL, 822, 9515, 8791, 9021, NULL, NULL, 13031);
INSERT INTO lgcGlyphs VALUES('G', 40, 270, NULL, NULL, 796, 9483, 8759, 8989, NULL, NULL, 12999);
INSERT INTO lgcGlyphs VALUES('gacute', 20354, NULL, NULL, NULL, NULL, 20409, 20998, NULL, NULL, NULL, 21053);
INSERT INTO lgcGlyphs VALUES('gamma', 1037, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Gamma', 1013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('gammalatin', 15884, NULL, NULL, NULL, NULL, NULL, 16687, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('gammasuper', 15898, NULL, NULL, NULL, NULL, NULL, 16701, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('gbreve', 20355, NULL, NULL, NULL, NULL, 20410, 20999, NULL, NULL, NULL, 21054);
INSERT INTO lgcGlyphs VALUES('Gbreve', 20335, NULL, NULL, NULL, NULL, 20390, 20979, NULL, NULL, NULL, 21034);
INSERT INTO lgcGlyphs VALUES('gcircumflex', 15790, NULL, NULL, NULL, NULL, 15971, 16593, NULL, NULL, NULL, 16774);
INSERT INTO lgcGlyphs VALUES('Gcircumflex', 15784, NULL, NULL, NULL, NULL, 15965, 16587, NULL, NULL, NULL, 16768);
INSERT INTO lgcGlyphs VALUES('Gcommaaccent', 20336, NULL, NULL, NULL, NULL, 20391, 20980, NULL, NULL, NULL, 21035);
INSERT INTO lgcGlyphs VALUES('gdotaccent', 20356, NULL, NULL, NULL, NULL, 20411, 21000, NULL, NULL, NULL, 21055);
INSERT INTO lgcGlyphs VALUES('Gdotaccent', 20337, NULL, NULL, NULL, NULL, 20392, 20981, NULL, NULL, NULL, 21036);
INSERT INTO lgcGlyphs VALUES('ge', 1095, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Ge', 1062, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('germandbls', 150, 603, NULL, NULL, NULL, 9593, 8869, 9053, NULL, NULL, 13109);
INSERT INTO lgcGlyphs VALUES('ghook', 15825, NULL, NULL, NULL, NULL, NULL, 16628, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Ghook', 15826, NULL, NULL, NULL, NULL, NULL, 16629, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('gje', 20461, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Gje', 20448, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('glottalstop', 15818, NULL, NULL, NULL, NULL, NULL, 16621, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('glottalstopreversed', 15817, NULL, NULL, NULL, NULL, NULL, 16620, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('glottalstopreversedmod', 15897, NULL, NULL, NULL, NULL, NULL, 16700, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('glottalstopstroke', 15840, NULL, NULL, NULL, NULL, NULL, 16643, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('glottalstopstrokereversed', 15839, NULL, NULL, NULL, NULL, NULL, 16642, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('grave', 65, 390, NULL, NULL, 646, 9508, 8784, 9045, NULL, NULL, 13024);
INSERT INTO lgcGlyphs VALUES('greater', 31, 261, NULL, NULL, 700, 9474, 8750, 8980, NULL, NULL, 12990);
INSERT INTO lgcGlyphs VALUES('greaterequal', 20370, NULL, NULL, NULL, NULL, 20425, 21014, NULL, NULL, NULL, 21069);
INSERT INTO lgcGlyphs VALUES('greateroverequal', 15458, NULL, NULL, NULL, 702, NULL, 16471, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('gscript', 15813, NULL, NULL, NULL, NULL, NULL, 16616, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Gsmallcap', 15883, NULL, NULL, NULL, NULL, NULL, 16686, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('guillemotleft', 109, NULL, NULL, NULL, NULL, 9552, 8828, NULL, NULL, NULL, 13068);
INSERT INTO lgcGlyphs VALUES('guillemotright', 123, NULL, NULL, NULL, NULL, 9566, 8842, NULL, NULL, NULL, 13082);
INSERT INTO lgcGlyphs VALUES('guilsinglleft', 110, NULL, NULL, NULL, NULL, 9553, 8829, NULL, NULL, NULL, 13069);
INSERT INTO lgcGlyphs VALUES('guilsinglright', 111, NULL, NULL, NULL, NULL, 9554, 8830, NULL, NULL, NULL, 13070);
INSERT INTO lgcGlyphs VALUES('h', 73, 303, NULL, NULL, 823, 9516, 8792, 9022, NULL, NULL, 13032);
INSERT INTO lgcGlyphs VALUES('H', 41, 271, NULL, NULL, 797, 9484, 8760, 8990, NULL, NULL, 13000);
INSERT INTO lgcGlyphs VALUES('halflength', 15848, NULL, NULL, NULL, NULL, NULL, 16651, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hard', 1119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Hard', 1086, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hbar', 15816, NULL, NULL, NULL, NULL, 15514, 16619, NULL, NULL, NULL, 16525);
INSERT INTO lgcGlyphs VALUES('Hbar', 20323, NULL, NULL, NULL, NULL, 20378, 20967, NULL, NULL, NULL, 21022);
INSERT INTO lgcGlyphs VALUES('hcircumflex', 15791, NULL, NULL, NULL, NULL, 15972, 16594, NULL, NULL, NULL, 16775);
INSERT INTO lgcGlyphs VALUES('Hcircumflex', 15785, NULL, NULL, NULL, NULL, 15966, 16588, NULL, NULL, NULL, 16769);
INSERT INTO lgcGlyphs VALUES('henghook', 15844, NULL, NULL, NULL, NULL, NULL, 16647, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hhook', 15819, NULL, NULL, NULL, NULL, NULL, 16622, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Hsmallcap', 15892, NULL, NULL, NULL, NULL, NULL, 16695, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hsuper', 15894, NULL, NULL, NULL, NULL, NULL, 16697, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hturn', 15838, NULL, NULL, NULL, NULL, NULL, 16641, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hungarumlaut', 15753, NULL, NULL, NULL, NULL, NULL, 16556, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hungarumlautcmb', 135, NULL, NULL, NULL, NULL, 9578, 8854, NULL, NULL, NULL, 13094);
INSERT INTO lgcGlyphs VALUES('hyphen', 14, 244, 9749, 9769, 662, 9457, 8733, 8963, 13265, 13285, 12973);
INSERT INTO lgcGlyphs VALUES('i', 74, 304, NULL, NULL, 824, 9517, 8793, 9023, NULL, NULL, 13033);
INSERT INTO lgcGlyphs VALUES('I', 42, 272, NULL, NULL, 798, 9485, 8761, 8991, NULL, NULL, 13001);
INSERT INTO lgcGlyphs VALUES('i.cyr', 1101, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('I.cyr', 1068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('i.short', 1102, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('I.short', 1069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('i.ukran', 20464, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('I.ukran', 20451, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ia', 1124, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Ia', 1091, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('iacute', 205, 602, NULL, NULL, NULL, 9648, 8924, 9052, NULL, NULL, 13164);
INSERT INTO lgcGlyphs VALUES('Iacute', 176, NULL, NULL, NULL, NULL, 9619, 8895, NULL, NULL, NULL, 13135);
INSERT INTO lgcGlyphs VALUES('ibar', 15827, NULL, NULL, NULL, NULL, NULL, 16630, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('icaron', 9410, NULL, NULL, NULL, NULL, 9730, 12926, NULL, NULL, NULL, 13246);
INSERT INTO lgcGlyphs VALUES('Icaron', 9398, NULL, NULL, NULL, NULL, 9718, 12914, NULL, NULL, NULL, 13234);
INSERT INTO lgcGlyphs VALUES('icircumflex', 206, 624, NULL, NULL, NULL, 9649, 8925, 9074, NULL, NULL, 13165);
INSERT INTO lgcGlyphs VALUES('Icircumflex', 177, NULL, NULL, NULL, NULL, 9620, 8896, NULL, NULL, NULL, 13136);
INSERT INTO lgcGlyphs VALUES('idieresis', 207, 619, NULL, NULL, NULL, 9650, 8926, 9069, NULL, NULL, 13166);
INSERT INTO lgcGlyphs VALUES('Idieresis', 178, NULL, NULL, NULL, NULL, 9621, 8897, NULL, NULL, NULL, 13137);
INSERT INTO lgcGlyphs VALUES('Idotaccent', 20338, NULL, NULL, NULL, NULL, 20393, 20982, NULL, NULL, NULL, 21037);
INSERT INTO lgcGlyphs VALUES('ie', 1097, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Ie', 1064, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ie.ukran', 20462, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Ie.ukran', 20449, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('igrave', 204, NULL, NULL, NULL, NULL, 9647, 8923, NULL, NULL, NULL, 13163);
INSERT INTO lgcGlyphs VALUES('Igrave', 175, NULL, NULL, NULL, NULL, 9618, 8894, NULL, NULL, NULL, 13134);
INSERT INTO lgcGlyphs VALUES('ij', 20328, NULL, NULL, NULL, NULL, 20383, 20972, NULL, NULL, NULL, 21027);
INSERT INTO lgcGlyphs VALUES('IJ', 20324, NULL, NULL, NULL, NULL, 20379, 20968, NULL, NULL, NULL, 21023);
INSERT INTO lgcGlyphs VALUES('imacron', 9362, NULL, NULL, NULL, NULL, 9682, 12878, NULL, NULL, NULL, 13198);
INSERT INTO lgcGlyphs VALUES('Imacron', 9367, NULL, NULL, NULL, NULL, 9687, 12883, NULL, NULL, NULL, 13203);
INSERT INTO lgcGlyphs VALUES('io', 1098, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Io', 1065, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('iogonek', 20357, NULL, NULL, NULL, NULL, 20412, 21001, NULL, NULL, NULL, 21056);
INSERT INTO lgcGlyphs VALUES('Iogonek', 20339, NULL, NULL, NULL, NULL, 20394, 20983, NULL, NULL, NULL, 21038);
INSERT INTO lgcGlyphs VALUES('iota', 1043, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Iota', 1019, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('iotadieresis', 20440, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Iotadieresis', 20431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('iotadieresistonos', 20441, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('iotatonos', 20439, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Iotatonos', 20430, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('iring', 9411, NULL, NULL, NULL, NULL, 9731, 12927, NULL, NULL, NULL, 13247);
INSERT INTO lgcGlyphs VALUES('Iring', 9399, NULL, NULL, NULL, NULL, 9719, 12915, NULL, NULL, NULL, 13235);
INSERT INTO lgcGlyphs VALUES('Ismallcap', 15885, NULL, NULL, NULL, NULL, NULL, 16688, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('itilde', 9412, NULL, NULL, NULL, NULL, 9732, 12928, NULL, NULL, NULL, 13248);
INSERT INTO lgcGlyphs VALUES('Itilde', 9400, NULL, NULL, NULL, NULL, 9720, 12916, NULL, NULL, NULL, 13236);
INSERT INTO lgcGlyphs VALUES('iu', 1123, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Iu', 1090, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('j', 75, 305, NULL, NULL, 825, 9518, 8794, 9024, NULL, NULL, 13034);
INSERT INTO lgcGlyphs VALUES('J', 43, 273, NULL, NULL, 799, 9486, 8762, 8992, NULL, NULL, 13002);
INSERT INTO lgcGlyphs VALUES('jcircumflex', 15792, NULL, NULL, NULL, NULL, 15973, 16595, NULL, NULL, NULL, 16776);
INSERT INTO lgcGlyphs VALUES('Jcircumflex', 15786, NULL, NULL, NULL, NULL, 15967, 16589, NULL, NULL, NULL, 16770);
INSERT INTO lgcGlyphs VALUES('jcrossedtail', 15811, NULL, NULL, NULL, NULL, NULL, 16614, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('jdotlessbar', 15809, NULL, NULL, NULL, NULL, NULL, 16612, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('je', 20466, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Je', 20453, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('jsuper', 15895, NULL, NULL, NULL, NULL, NULL, 16698, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('k', 76, 306, NULL, NULL, 826, 9519, 8795, 9025, NULL, NULL, 13035);
INSERT INTO lgcGlyphs VALUES('K', 44, 274, NULL, NULL, 800, 9487, 8763, 8993, NULL, NULL, 13003);
INSERT INTO lgcGlyphs VALUES('ka', 1103, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Ka', 1070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('kappa', 1044, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Kappa', 1020, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('kcommaaccent', 20358, NULL, NULL, NULL, NULL, 20413, 21002, NULL, NULL, NULL, 21057);
INSERT INTO lgcGlyphs VALUES('Kcommaaccent', 20340, NULL, NULL, NULL, NULL, 20395, 20984, NULL, NULL, NULL, 21039);
INSERT INTO lgcGlyphs VALUES('kha', 1114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Kha', 1081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('kje', 20470, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Kje', 20457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('kra', 20329, NULL, NULL, NULL, NULL, 20384, 20973, NULL, NULL, NULL, 21028);
INSERT INTO lgcGlyphs VALUES('l', 77, 307, NULL, NULL, 827, 9520, 8796, 9026, NULL, NULL, 13036);
INSERT INTO lgcGlyphs VALUES('L', 45, 275, NULL, NULL, 801, 9488, 8764, 8994, NULL, NULL, 13004);
INSERT INTO lgcGlyphs VALUES('lacute', 15770, NULL, NULL, NULL, NULL, 15952, 16573, NULL, NULL, NULL, 16755);
INSERT INTO lgcGlyphs VALUES('Lacute', 15757, NULL, NULL, NULL, NULL, 15939, 16560, NULL, NULL, NULL, 16742);
INSERT INTO lgcGlyphs VALUES('lambda', 1045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Lambda', 1021, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('lbelt', 15798, NULL, NULL, NULL, NULL, NULL, 16601, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('lcaron', 15747, NULL, NULL, NULL, NULL, 15931, 16550, NULL, NULL, NULL, 16734);
INSERT INTO lgcGlyphs VALUES('Lcaron', 15739, NULL, NULL, NULL, NULL, 15924, 16542, NULL, NULL, NULL, 16727);
INSERT INTO lgcGlyphs VALUES('lcaron.alt', 20359, NULL, NULL, NULL, NULL, 20414, 21003, NULL, NULL, NULL, 21058);
INSERT INTO lgcGlyphs VALUES('Lcaron.alt', 20341, NULL, NULL, NULL, NULL, 20396, 20985, NULL, NULL, NULL, 21040);
INSERT INTO lgcGlyphs VALUES('lcommaaccent', 20360, NULL, NULL, NULL, NULL, 20415, 21004, NULL, NULL, NULL, 21059);
INSERT INTO lgcGlyphs VALUES('Lcommaaccent', 20342, NULL, NULL, NULL, NULL, 20397, 20986, NULL, NULL, NULL, 21041);
INSERT INTO lgcGlyphs VALUES('ldot', 20330, NULL, NULL, NULL, NULL, 20385, 20974, NULL, NULL, NULL, 21029);
INSERT INTO lgcGlyphs VALUES('Ldot', 20325, NULL, NULL, NULL, NULL, 20380, 20969, NULL, NULL, NULL, 21024);
INSERT INTO lgcGlyphs VALUES('leftangleabovecmb', 15879, NULL, NULL, NULL, NULL, NULL, 16682, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('lefttackbelowcmb', 15874, NULL, NULL, NULL, NULL, NULL, 16677, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('length', 9443, NULL, NULL, NULL, NULL, NULL, 12959, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('less', 29, 259, NULL, NULL, 699, 9472, 8748, 8978, NULL, NULL, 12988);
INSERT INTO lgcGlyphs VALUES('lessequal', 20369, NULL, NULL, NULL, NULL, 20424, 21013, NULL, NULL, NULL, 21068);
INSERT INTO lgcGlyphs VALUES('lessoverequal', 15457, NULL, NULL, NULL, 701, NULL, 16470, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('lezh', 15799, NULL, NULL, NULL, NULL, NULL, 16602, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('lje', 20467, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Lje', 20454, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('logicalnot', 153, 8718, NULL, NULL, 751, 9596, 8872, 9082, NULL, NULL, 13112);
INSERT INTO lgcGlyphs VALUES('lozenge', 20371, NULL, NULL, NULL, NULL, 20426, 21015, NULL, NULL, NULL, 21070);
INSERT INTO lgcGlyphs VALUES('lrthook', 15808, NULL, NULL, NULL, NULL, NULL, 16611, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('lslash', 147, NULL, NULL, NULL, NULL, 9590, 8866, NULL, NULL, NULL, 13106);
INSERT INTO lgcGlyphs VALUES('Lslash', 141, NULL, NULL, NULL, NULL, 9584, 8860, NULL, NULL, NULL, 13100);
INSERT INTO lgcGlyphs VALUES('Lsmallcap', 15893, NULL, NULL, NULL, NULL, NULL, 16696, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('lsuper', 15899, NULL, NULL, NULL, NULL, NULL, 16702, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('m', 78, 308, NULL, NULL, 828, 9521, 8797, 9027, NULL, NULL, 13037);
INSERT INTO lgcGlyphs VALUES('M', 46, 276, NULL, NULL, 802, 9489, 8765, 8995, NULL, NULL, 13005);
INSERT INTO lgcGlyphs VALUES('macron', 129, NULL, NULL, NULL, NULL, 9572, 8848, NULL, NULL, NULL, 13088);
INSERT INTO lgcGlyphs VALUES('macronbelowcmb', 15863, NULL, NULL, NULL, NULL, NULL, 16666, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('macute', 15730, NULL, NULL, NULL, NULL, 15916, 16533, NULL, NULL, NULL, 16719);
INSERT INTO lgcGlyphs VALUES('Macute', 15729, NULL, NULL, NULL, NULL, 15915, 16532, NULL, NULL, NULL, 16718);
INSERT INTO lgcGlyphs VALUES('mho', 15515, NULL, NULL, NULL, 16204, 15912, 16526, NULL, NULL, NULL, 16715);
INSERT INTO lgcGlyphs VALUES('mhook', 15795, NULL, NULL, NULL, NULL, NULL, 16598, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('micro', 159, NULL, NULL, NULL, NULL, 9602, 8878, NULL, NULL, NULL, 13118);
INSERT INTO lgcGlyphs VALUES('minus', NULL, 514, 9748, 9768, 693, NULL, NULL, 9275, 13264, 13284, NULL);
INSERT INTO lgcGlyphs VALUES('minute', 9356, NULL, NULL, NULL, 708, 9676, 12872, NULL, NULL, NULL, 13192);
INSERT INTO lgcGlyphs VALUES('mturn', 15833, NULL, NULL, NULL, NULL, NULL, 16636, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('mturndescend', 15814, NULL, NULL, NULL, NULL, NULL, 16617, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('mu', 1046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Mu', 1022, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('multiply', 186, NULL, NULL, NULL, 695, 9629, 8905, NULL, NULL, NULL, 13145);
INSERT INTO lgcGlyphs VALUES('n', 79, 309, NULL, NULL, 829, 9522, 8798, 9028, NULL, NULL, 13038);
INSERT INTO lgcGlyphs VALUES('N', 47, 277, NULL, NULL, 803, 9490, 8766, 8996, NULL, NULL, 13006);
INSERT INTO lgcGlyphs VALUES('n.superior', 15908, NULL, NULL, NULL, NULL, NULL, 16711, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('nacute', 15776, NULL, NULL, NULL, NULL, 15958, 16579, NULL, NULL, NULL, 16761);
INSERT INTO lgcGlyphs VALUES('Nacute', 15762, NULL, NULL, NULL, NULL, 15944, 16565, NULL, NULL, NULL, 16747);
INSERT INTO lgcGlyphs VALUES('napostrophe', 20331, NULL, NULL, NULL, NULL, 20386, 20975, NULL, NULL, NULL, 21030);
INSERT INTO lgcGlyphs VALUES('ncaron', 15777, NULL, NULL, NULL, NULL, 15959, 16580, NULL, NULL, NULL, 16762);
INSERT INTO lgcGlyphs VALUES('Ncaron', 15763, NULL, NULL, NULL, NULL, 15945, 16566, NULL, NULL, NULL, 16748);
INSERT INTO lgcGlyphs VALUES('ncommaaccent', 20361, NULL, NULL, NULL, NULL, 20416, 21005, NULL, NULL, NULL, 21060);
INSERT INTO lgcGlyphs VALUES('Ncommaaccent', 20343, NULL, NULL, NULL, NULL, 20398, 20987, NULL, NULL, NULL, 21042);
INSERT INTO lgcGlyphs VALUES('ngrave', 15732, NULL, NULL, NULL, NULL, 15918, 16535, NULL, NULL, NULL, 16721);
INSERT INTO lgcGlyphs VALUES('Ngrave', 15731, NULL, NULL, NULL, NULL, 15917, 16534, NULL, NULL, NULL, 16720);
INSERT INTO lgcGlyphs VALUES('nhookleft', 15810, NULL, NULL, NULL, NULL, NULL, 16613, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('nine', 26, 256, 9747, 9767, 789, 9469, 8745, 8975, 13263, 13283, 12985);
INSERT INTO lgcGlyphs VALUES('nine.inferior', 9393, NULL, NULL, NULL, NULL, 9713, 12909, NULL, NULL, NULL, 13229);
INSERT INTO lgcGlyphs VALUES('nine.superior', 9383, NULL, NULL, NULL, NULL, 9703, 12899, NULL, NULL, NULL, 13219);
INSERT INTO lgcGlyphs VALUES('nje', 20468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Nje', 20455, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('notequal', 15456, NULL, NULL, NULL, 698, NULL, 16469, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('nrthook', 15803, NULL, NULL, NULL, NULL, NULL, 16606, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Nsmallcap', 15886, NULL, NULL, NULL, NULL, NULL, 16689, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ntilde', 209, 607, NULL, NULL, NULL, 9652, 8928, 9057, NULL, NULL, 13168);
INSERT INTO lgcGlyphs VALUES('Ntilde', 180, 606, NULL, NULL, NULL, 9623, 8899, 9056, NULL, NULL, 13139);
INSERT INTO lgcGlyphs VALUES('nu', 1047, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Nu', 1023, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('numbersign', 4, 234, NULL, NULL, 716, 9447, 8723, 8953, NULL, NULL, 12963);
INSERT INTO lgcGlyphs VALUES('numero', 20321, NULL, NULL, NULL, NULL, 20376, 20965, NULL, NULL, NULL, 21020);
INSERT INTO lgcGlyphs VALUES('o', 80, 310, NULL, NULL, 830, 9523, 8799, 9029, NULL, NULL, 13039);
INSERT INTO lgcGlyphs VALUES('O', 48, 278, NULL, NULL, 804, 9491, 8767, 8997, NULL, NULL, 13007);
INSERT INTO lgcGlyphs VALUES('o.cyr', 1107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('O.cyr', 1074, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('oacute', 211, 610, NULL, NULL, NULL, 9654, 8930, 9060, NULL, NULL, 13170);
INSERT INTO lgcGlyphs VALUES('Oacute', 182, NULL, NULL, NULL, NULL, 9625, 8901, NULL, NULL, NULL, 13141);
INSERT INTO lgcGlyphs VALUES('obar', 9437, NULL, NULL, NULL, NULL, NULL, 12953, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ocaron', 9413, NULL, NULL, NULL, NULL, 9733, 12929, NULL, NULL, NULL, 13249);
INSERT INTO lgcGlyphs VALUES('Ocaron', 9401, NULL, NULL, NULL, NULL, 9721, 12917, NULL, NULL, NULL, 13237);
INSERT INTO lgcGlyphs VALUES('ocircumflex', 212, 625, NULL, NULL, NULL, 9655, 8931, 9075, NULL, NULL, 13171);
INSERT INTO lgcGlyphs VALUES('Ocircumflex', 183, NULL, NULL, NULL, NULL, 9626, 8902, NULL, NULL, NULL, 13142);
INSERT INTO lgcGlyphs VALUES('odieresis', 214, 620, NULL, NULL, NULL, 9657, 8933, 9070, NULL, NULL, 13173);
INSERT INTO lgcGlyphs VALUES('Odieresis', 185, 615, NULL, NULL, NULL, 9628, 8904, 9065, NULL, NULL, 13144);
INSERT INTO lgcGlyphs VALUES('oe', 149, NULL, NULL, NULL, NULL, 9592, 8868, NULL, NULL, NULL, 13108);
INSERT INTO lgcGlyphs VALUES('OE', 143, NULL, NULL, NULL, NULL, 9586, 8862, NULL, NULL, NULL, 13102);
INSERT INTO lgcGlyphs VALUES('OEsmallcap', 15887, NULL, NULL, NULL, NULL, NULL, 16690, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ogonek', 15746, NULL, NULL, NULL, NULL, NULL, 16549, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ogonekcmb', 136, NULL, NULL, NULL, NULL, 9579, 8855, NULL, NULL, NULL, 13095);
INSERT INTO lgcGlyphs VALUES('ograve', 210, NULL, NULL, NULL, NULL, 9653, 8929, NULL, NULL, NULL, 13169);
INSERT INTO lgcGlyphs VALUES('Ograve', 181, NULL, NULL, NULL, NULL, 9624, 8900, NULL, NULL, NULL, 13140);
INSERT INTO lgcGlyphs VALUES('ohungarumlaut', 15778, NULL, NULL, NULL, NULL, 15960, 16581, NULL, NULL, NULL, 16763);
INSERT INTO lgcGlyphs VALUES('Ohungarumlaut', 15764, NULL, NULL, NULL, NULL, 15946, 16567, NULL, NULL, NULL, 16749);
INSERT INTO lgcGlyphs VALUES('omacron', 9365, NULL, NULL, NULL, NULL, 9685, 12881, NULL, NULL, NULL, 13201);
INSERT INTO lgcGlyphs VALUES('Omacron', 9370, NULL, NULL, NULL, NULL, 9690, 12886, NULL, NULL, NULL, 13206);
INSERT INTO lgcGlyphs VALUES('omega', 1058, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Omega', 1034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Omega.math', 9355, NULL, NULL, NULL, NULL, 9675, 12871, NULL, NULL, NULL, 13191);
INSERT INTO lgcGlyphs VALUES('omegatonos', 20446, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Omegatonos', 20435, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('omicron', 1049, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Omicron', 1025, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('omicrontonos', 20442, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Omicrontonos', 20432, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('one', 18, 248, 9739, 9759, 781, 9461, 8737, 8967, 13255, 13275, 12977);
INSERT INTO lgcGlyphs VALUES('one.inferior', 9385, NULL, NULL, NULL, NULL, 9705, 12901, NULL, NULL, NULL, 13221);
INSERT INTO lgcGlyphs VALUES('one.superior', 160, NULL, NULL, NULL, NULL, 9603, 8879, NULL, NULL, NULL, 13119);
INSERT INTO lgcGlyphs VALUES('oneeighth', 9371, NULL, NULL, NULL, NULL, 9691, 12887, NULL, NULL, NULL, 13207);
INSERT INTO lgcGlyphs VALUES('onefifth', 15727, NULL, NULL, NULL, NULL, 15914, 16530, NULL, NULL, NULL, 16717);
INSERT INTO lgcGlyphs VALUES('onehalf', 162, 614, NULL, NULL, NULL, 9605, 8881, 9064, NULL, NULL, 13121);
INSERT INTO lgcGlyphs VALUES('onequarter', 161, NULL, NULL, NULL, NULL, 9604, 8880, NULL, NULL, NULL, 13120);
INSERT INTO lgcGlyphs VALUES('onethird', 9375, NULL, NULL, NULL, NULL, 9695, 12891, NULL, NULL, NULL, 13211);
INSERT INTO lgcGlyphs VALUES('oopen', 9423, NULL, NULL, NULL, NULL, NULL, 12939, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('oopenacute', 9424, NULL, NULL, NULL, NULL, NULL, 12940, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('oopengrave', 9425, NULL, NULL, NULL, NULL, NULL, 12941, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ordfeminine', 140, NULL, NULL, NULL, NULL, 9583, 8859, NULL, NULL, NULL, 13099);
INSERT INTO lgcGlyphs VALUES('ordfeminine.alt', 20320, NULL, NULL, NULL, NULL, 20375, 20964, NULL, NULL, NULL, 21019);
INSERT INTO lgcGlyphs VALUES('ordmasculine', 144, NULL, NULL, NULL, NULL, 9587, 8863, NULL, NULL, NULL, 13103);
INSERT INTO lgcGlyphs VALUES('ordmasculine.alt', 20319, NULL, NULL, NULL, NULL, 20374, 20963, NULL, NULL, NULL, 21018);
INSERT INTO lgcGlyphs VALUES('oring', 9414, NULL, NULL, NULL, NULL, 9734, 12930, NULL, NULL, NULL, 13250);
INSERT INTO lgcGlyphs VALUES('Oring', 9402, NULL, NULL, NULL, NULL, 9722, 12918, NULL, NULL, NULL, 13238);
INSERT INTO lgcGlyphs VALUES('oslash', 148, NULL, NULL, NULL, NULL, 9591, 8867, NULL, NULL, NULL, 13107);
INSERT INTO lgcGlyphs VALUES('Oslash', 142, NULL, NULL, NULL, NULL, 9585, 8861, NULL, NULL, NULL, 13101);
INSERT INTO lgcGlyphs VALUES('otilde', 213, NULL, NULL, NULL, NULL, 9656, 8932, NULL, NULL, NULL, 13172);
INSERT INTO lgcGlyphs VALUES('Otilde', 184, NULL, NULL, NULL, NULL, 9627, 8903, NULL, NULL, NULL, 13143);
INSERT INTO lgcGlyphs VALUES('overline', 226, 325, NULL, NULL, 649, 9669, 8945, 9044, NULL, NULL, 13185);
INSERT INTO lgcGlyphs VALUES('p', 81, 311, NULL, NULL, 831, 9524, 8800, 9030, NULL, NULL, 13040);
INSERT INTO lgcGlyphs VALUES('P', 49, 279, NULL, NULL, 805, 9492, 8768, 8998, NULL, NULL, 13008);
INSERT INTO lgcGlyphs VALUES('paragraph', 118, NULL, NULL, NULL, 778, 9561, 8837, NULL, NULL, NULL, 13077);
INSERT INTO lgcGlyphs VALUES('parenleft', 9, 239, 9752, 9772, 674, 9452, 8728, 8958, 13268, 13288, 12968);
INSERT INTO lgcGlyphs VALUES('parenright', 10, 240, 9753, 9773, 675, 9453, 8729, 8959, 13269, 13289, 12969);
INSERT INTO lgcGlyphs VALUES('pe', 1108, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Pe', 1075, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('percent', 6, 236, NULL, NULL, 715, 9449, 8725, 8955, NULL, NULL, 12965);
INSERT INTO lgcGlyphs VALUES('period', 15, 245, 9754, 9774, 637, 9458, 8734, 8964, 13270, 13290, 12974);
INSERT INTO lgcGlyphs VALUES('periodcentered', 117, NULL, NULL, 9778, NULL, 9560, 8836, NULL, NULL, 13294, 13076);
INSERT INTO lgcGlyphs VALUES('perthousand', 125, NULL, NULL, NULL, 772, 9568, 8844, NULL, NULL, NULL, 13084);
INSERT INTO lgcGlyphs VALUES('phi', 1055, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Phi', 1031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('phi.alt', 12094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('philatin', 15888, NULL, NULL, NULL, NULL, NULL, 16691, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('pi', 1050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Pi', 1026, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('plus', 12, 242, NULL, NULL, 692, 9455, 8731, 8961, NULL, NULL, 12971);
INSERT INTO lgcGlyphs VALUES('plusbelowcmb', 15862, NULL, NULL, NULL, NULL, NULL, 16665, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('plusminus', 156, NULL, NULL, NULL, 694, 9599, 8875, NULL, NULL, NULL, 13115);
INSERT INTO lgcGlyphs VALUES('product', 20368, NULL, NULL, NULL, NULL, 20423, 21012, NULL, NULL, NULL, 21067);
INSERT INTO lgcGlyphs VALUES('psi', 1057, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Psi', 1033, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('q', 82, 312, NULL, NULL, 832, 9525, 8801, 9031, NULL, NULL, 13041);
INSERT INTO lgcGlyphs VALUES('Q', 50, 280, NULL, NULL, 806, 9493, 8769, 8999, NULL, NULL, 13009);
INSERT INTO lgcGlyphs VALUES('question', 32, 262, NULL, NULL, 641, 9475, 8751, 8981, NULL, NULL, 12991);
INSERT INTO lgcGlyphs VALUES('questiondown', 126, 613, NULL, NULL, NULL, 9569, 8845, 9063, NULL, NULL, 13085);
INSERT INTO lgcGlyphs VALUES('questiondbl', NULL, NULL, NULL, NULL, 16278, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('questionexclam', NULL, NULL, NULL, NULL, 16279, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('quotedbl', 3, 233, NULL, NULL, 8007, 9446, 8722, 8952, NULL, NULL, 12962);
INSERT INTO lgcGlyphs VALUES('quotedblbase', 121, NULL, NULL, NULL, NULL, 9564, 8840, NULL, NULL, NULL, 13080);
INSERT INTO lgcGlyphs VALUES('quotedblleft', 108, 503, NULL, NULL, 672, 9551, 8827, 9048, NULL, NULL, 13067);
INSERT INTO lgcGlyphs VALUES('quotedblright', 122, NULL, NULL, NULL, 673, 9565, 8841, NULL, NULL, NULL, 13081);
INSERT INTO lgcGlyphs VALUES('quoteleft', NULL, 295, NULL, NULL, 670, NULL, NULL, 9014, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('quoteright', NULL, NULL, NULL, NULL, 671, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('quotesinglbase', 120, NULL, NULL, NULL, NULL, 9563, 8839, NULL, NULL, NULL, 13079);
INSERT INTO lgcGlyphs VALUES('quotesingle', 8, 238, NULL, NULL, 8006, 9451, 8727, 8957, NULL, NULL, 12967);
INSERT INTO lgcGlyphs VALUES('r', 83, 313, NULL, NULL, 833, 9526, 8802, 9032, NULL, NULL, 13042);
INSERT INTO lgcGlyphs VALUES('R', 51, 281, NULL, NULL, 807, 9494, 8770, 9000, NULL, NULL, 13010);
INSERT INTO lgcGlyphs VALUES('racute', 15768, NULL, NULL, NULL, NULL, 15950, 16571, NULL, NULL, NULL, 16753);
INSERT INTO lgcGlyphs VALUES('Racute', 15755, NULL, NULL, NULL, NULL, 15937, 16558, NULL, NULL, NULL, 16740);
INSERT INTO lgcGlyphs VALUES('ramshorn', 15835, NULL, NULL, NULL, NULL, NULL, 16638, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('rcaron', 15779, NULL, NULL, NULL, NULL, 15961, 16582, NULL, NULL, NULL, 16764);
INSERT INTO lgcGlyphs VALUES('Rcaron', 15765, NULL, NULL, NULL, NULL, 15947, 16568, NULL, NULL, NULL, 16750);
INSERT INTO lgcGlyphs VALUES('rcommaaccent', 20362, NULL, NULL, NULL, NULL, 20417, 21006, NULL, NULL, NULL, 21061);
INSERT INTO lgcGlyphs VALUES('Rcommaaccent', 20344, NULL, NULL, NULL, NULL, 20399, 20988, NULL, NULL, NULL, 21043);
INSERT INTO lgcGlyphs VALUES('registered', 154, NULL, NULL, NULL, NULL, 9597, 8873, NULL, NULL, NULL, 13113);
INSERT INTO lgcGlyphs VALUES('registered.sups', 8060, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('rfishhook', 15797, NULL, NULL, NULL, NULL, NULL, 16600, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('rho', 1051, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Rho', 1027, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('rhotichook', 15867, NULL, NULL, NULL, NULL, NULL, 16670, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('righttackbelowcmb', 15875, NULL, NULL, NULL, NULL, NULL, 16678, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ring', 133, NULL, NULL, NULL, NULL, 9576, 8852, NULL, NULL, NULL, 13092);
INSERT INTO lgcGlyphs VALUES('ringbelowcmb', 15858, NULL, NULL, NULL, NULL, NULL, 16661, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ringhalfleftbelowcmb', 15861, NULL, NULL, NULL, NULL, NULL, 16664, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ringhalfrightbelowcmb', 15860, NULL, NULL, NULL, NULL, NULL, 16663, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('rrthook', 15804, NULL, NULL, NULL, NULL, NULL, 16607, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Rsmallcap', 15889, NULL, NULL, NULL, NULL, NULL, 16692, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Rsmallcapinv', 15815, NULL, NULL, NULL, NULL, NULL, 16618, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('rturn', 15800, NULL, NULL, NULL, NULL, NULL, 16603, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('rturnascend', 15843, NULL, NULL, NULL, NULL, NULL, 16646, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('rturnrthook', 15807, NULL, NULL, NULL, NULL, NULL, 16610, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('s', 84, 314, NULL, NULL, 834, 9527, 8803, 9033, NULL, NULL, 13043);
INSERT INTO lgcGlyphs VALUES('S', 52, 282, NULL, NULL, 808, 9495, 8771, 9001, NULL, NULL, 13011);
INSERT INTO lgcGlyphs VALUES('sacute', 15748, NULL, NULL, NULL, NULL, 15932, 16551, NULL, NULL, NULL, 16735);
INSERT INTO lgcGlyphs VALUES('Sacute', 15740, NULL, NULL, NULL, NULL, 15925, 16543, NULL, NULL, NULL, 16728);
INSERT INTO lgcGlyphs VALUES('scaron', 227, NULL, NULL, NULL, NULL, 9670, 8946, NULL, NULL, NULL, 13186);
INSERT INTO lgcGlyphs VALUES('Scaron', 223, NULL, NULL, NULL, NULL, 9666, 8942, NULL, NULL, NULL, 13182);
INSERT INTO lgcGlyphs VALUES('scedilla', 15750, NULL, NULL, NULL, NULL, 15933, 16553, NULL, NULL, NULL, 16736);
INSERT INTO lgcGlyphs VALUES('Scedilla', 15741, NULL, NULL, NULL, NULL, 15926, 16544, NULL, NULL, NULL, 16729);
INSERT INTO lgcGlyphs VALUES('schwa', 9426, NULL, NULL, NULL, NULL, NULL, 12942, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('schwaacute', 9427, NULL, NULL, NULL, NULL, NULL, 12943, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('schwagrave', 9428, NULL, NULL, NULL, NULL, NULL, 12944, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('schwahook', 9429, NULL, NULL, NULL, NULL, NULL, 12945, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('schwahookacute', 9430, NULL, NULL, NULL, NULL, NULL, 12946, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('schwahookgrave', 9431, NULL, NULL, NULL, NULL, NULL, 12947, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('scircumflex', 15793, NULL, NULL, NULL, NULL, 15974, 16596, NULL, NULL, NULL, 16777);
INSERT INTO lgcGlyphs VALUES('Scircumflex', 15787, NULL, NULL, NULL, NULL, 15968, 16590, NULL, NULL, NULL, 16771);
INSERT INTO lgcGlyphs VALUES('seagullbelowcmb', 15870, NULL, NULL, NULL, NULL, NULL, 16673, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('second', 9357, NULL, NULL, NULL, 709, 9677, 12873, NULL, NULL, NULL, 13193);
INSERT INTO lgcGlyphs VALUES('section', 106, NULL, NULL, NULL, 720, 9549, 8825, NULL, NULL, NULL, 13065);
INSERT INTO lgcGlyphs VALUES('semicolon', 28, 258, 9757, 9777, 640, 9471, 8747, 8977, 13273, 13293, 12987);
INSERT INTO lgcGlyphs VALUES('seven', 24, 254, 9745, 9765, 787, 9467, 8743, 8973, 13261, 13281, 12983);
INSERT INTO lgcGlyphs VALUES('seven.inferior', 9391, NULL, NULL, NULL, NULL, 9711, 12907, NULL, NULL, NULL, 13227);
INSERT INTO lgcGlyphs VALUES('seven.superior', 9381, NULL, NULL, NULL, NULL, 9701, 12897, NULL, NULL, NULL, 13217);
INSERT INTO lgcGlyphs VALUES('seveneighths', 9374, NULL, NULL, NULL, NULL, 9694, 12890, NULL, NULL, NULL, 13210);
INSERT INTO lgcGlyphs VALUES('sha', 1117, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Sha', 1084, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('shcha', 1118, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Shcha', 1085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('sigma', 1052, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Sigma', 1028, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('sigma.end', 16222, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('six', 23, 253, 9744, 9764, 786, 9466, 8742, 8972, 13260, 13280, 12982);
INSERT INTO lgcGlyphs VALUES('six.inferior', 9390, NULL, NULL, NULL, NULL, 9710, 12906, NULL, NULL, NULL, 13226);
INSERT INTO lgcGlyphs VALUES('six.superior', 9380, NULL, NULL, NULL, NULL, 9700, 12896, NULL, NULL, NULL, 13216);
INSERT INTO lgcGlyphs VALUES('slash', 16, 246, 9755, 9775, 663, 9459, 8735, 8965, 13271, 13291, 12975);
INSERT INTO lgcGlyphs VALUES('soft', 1121, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Soft', 1088, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('softhyphen', 151, NULL, NULL, NULL, NULL, 9594, 8870, NULL, NULL, NULL, 13110);
INSERT INTO lgcGlyphs VALUES('space', 1, 231, NULL, NULL, 633, 9444, 8720, 8950, NULL, NULL, 12960);
INSERT INTO lgcGlyphs VALUES('squarebelowcmb', 15878, NULL, NULL, NULL, NULL, NULL, 16681, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('srthook', 15805, NULL, NULL, NULL, NULL, NULL, 16608, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('sterling', 103, 609, NULL, NULL, 714, 9546, 8822, 9059, NULL, NULL, 13062);
INSERT INTO lgcGlyphs VALUES('stigma', 12095, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('t', 85, 315, NULL, NULL, 835, 9528, 8804, 9034, NULL, NULL, 13044);
INSERT INTO lgcGlyphs VALUES('T', 53, 283, NULL, NULL, 809, 9496, 8772, 9002, NULL, NULL, 13012);
INSERT INTO lgcGlyphs VALUES('tau', 1053, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Tau', 1029, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('tbar', 20332, NULL, NULL, NULL, NULL, 20387, 20976, NULL, NULL, NULL, 21031);
INSERT INTO lgcGlyphs VALUES('Tbar', 20327, NULL, NULL, NULL, NULL, 20382, 20971, NULL, NULL, NULL, 21026);
INSERT INTO lgcGlyphs VALUES('tcaron', 15751, NULL, NULL, NULL, NULL, 15934, 16554, NULL, NULL, NULL, 16737);
INSERT INTO lgcGlyphs VALUES('Tcaron', 15742, NULL, NULL, NULL, NULL, 15927, 16545, NULL, NULL, NULL, 16730);
INSERT INTO lgcGlyphs VALUES('tcedilla', 15781, NULL, NULL, NULL, NULL, 15963, 16584, NULL, NULL, NULL, 16766);
INSERT INTO lgcGlyphs VALUES('Tcedilla', 15767, NULL, NULL, NULL, NULL, 15949, 16570, NULL, NULL, NULL, 16752);
INSERT INTO lgcGlyphs VALUES('te', 1111, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Te', 1078, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('theta', 1042, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Theta', 1018, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('theta.alt', 12096, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('theta.ipa', 15910, NULL, NULL, NULL, NULL, NULL, 16713, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('thorn', 221, NULL, NULL, NULL, NULL, 9664, 8940, NULL, NULL, NULL, 13180);
INSERT INTO lgcGlyphs VALUES('Thorn', 192, NULL, NULL, NULL, NULL, 9635, 8911, NULL, NULL, NULL, 13151);
INSERT INTO lgcGlyphs VALUES('three', 20, 250, 9741, 9761, 783, 9463, 8739, 8969, 13257, 13277, 12979);
INSERT INTO lgcGlyphs VALUES('three.inferior', 9387, NULL, NULL, NULL, NULL, 9707, 12903, NULL, NULL, NULL, 13223);
INSERT INTO lgcGlyphs VALUES('three.superior', 158, NULL, NULL, NULL, NULL, 9601, 8877, NULL, NULL, NULL, 13117);
INSERT INTO lgcGlyphs VALUES('threeeighths', 9372, NULL, NULL, NULL, NULL, 9692, 12888, NULL, NULL, NULL, 13208);
INSERT INTO lgcGlyphs VALUES('threequarters', 163, NULL, NULL, NULL, NULL, 9606, 8882, NULL, NULL, NULL, 13122);
INSERT INTO lgcGlyphs VALUES('tilde', 95, NULL, NULL, NULL, NULL, 9538, 8814, NULL, NULL, NULL, 13054);
INSERT INTO lgcGlyphs VALUES('tildebelowcmb', 15869, NULL, NULL, NULL, NULL, NULL, 16672, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('tildeoverlaycmb', 15871, NULL, NULL, NULL, NULL, NULL, 16674, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('toneextrahigh', 15851, NULL, NULL, NULL, NULL, NULL, 16654, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('toneextralow', 15855, NULL, NULL, NULL, NULL, NULL, 16658, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('tonefalling', 15857, NULL, NULL, NULL, NULL, NULL, 16660, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('tonehigh', 15852, NULL, NULL, NULL, NULL, NULL, 16655, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('tonelow', 15854, NULL, NULL, NULL, NULL, NULL, 16657, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('tonemid', 15853, NULL, NULL, NULL, NULL, NULL, 16656, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('tonerising', 15856, NULL, NULL, NULL, NULL, NULL, 16659, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('tonos', 20317, NULL, NULL, NULL, NULL, 20372, 20961, NULL, NULL, NULL, 21016);
INSERT INTO lgcGlyphs VALUES('trademark', 228, NULL, NULL, NULL, NULL, 9671, 8947, NULL, NULL, NULL, 13187);
INSERT INTO lgcGlyphs VALUES('triagup', NULL, 629, NULL, NULL, NULL, NULL, NULL, 9353, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('trthook', 15801, NULL, NULL, NULL, NULL, NULL, 16604, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('tse', 1115, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Tse', 1082, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('tshe', 20469, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Tshe', 20456, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('two', 19, 249, 9740, 9760, 782, 9462, 8738, 8968, 13256, 13276, 12978);
INSERT INTO lgcGlyphs VALUES('two.inferior', 9386, NULL, NULL, NULL, NULL, 9706, 12902, NULL, NULL, NULL, 13222);
INSERT INTO lgcGlyphs VALUES('two.superior', 157, NULL, NULL, NULL, NULL, 9600, 8876, NULL, NULL, NULL, 13116);
INSERT INTO lgcGlyphs VALUES('twothirds', 9376, NULL, NULL, NULL, NULL, 9696, 12892, NULL, NULL, NULL, 13212);
INSERT INTO lgcGlyphs VALUES('u', 86, 316, NULL, NULL, 836, 9529, 8805, 9035, NULL, NULL, 13045);
INSERT INTO lgcGlyphs VALUES('U', 54, 284, NULL, NULL, 810, 9497, 8773, 9003, NULL, NULL, 13013);
INSERT INTO lgcGlyphs VALUES('u.cyr', 1112, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('U.cyr', 1079, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('u.short', 20471, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('U.short', 20458, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('uacute', 217, 611, NULL, NULL, NULL, 9660, 8936, 9061, NULL, NULL, 13176);
INSERT INTO lgcGlyphs VALUES('Uacute', 188, NULL, NULL, NULL, NULL, 9631, 8907, NULL, NULL, NULL, 13147);
INSERT INTO lgcGlyphs VALUES('ubar', 15828, NULL, NULL, NULL, NULL, NULL, 16631, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ubreve', 15794, NULL, NULL, NULL, NULL, 15975, 16597, NULL, NULL, NULL, 16778);
INSERT INTO lgcGlyphs VALUES('Ubreve', 15788, NULL, NULL, NULL, NULL, 15969, 16591, NULL, NULL, NULL, 16772);
INSERT INTO lgcGlyphs VALUES('ucaron', 9415, NULL, NULL, NULL, NULL, 9735, 12931, NULL, NULL, NULL, 13251);
INSERT INTO lgcGlyphs VALUES('Ucaron', 9403, NULL, NULL, NULL, NULL, 9723, 12919, NULL, NULL, NULL, 13239);
INSERT INTO lgcGlyphs VALUES('ucircumflex', 218, 626, NULL, NULL, NULL, 9661, 8937, 9076, NULL, NULL, 13177);
INSERT INTO lgcGlyphs VALUES('Ucircumflex', 189, NULL, NULL, NULL, NULL, 9632, 8908, NULL, NULL, NULL, 13148);
INSERT INTO lgcGlyphs VALUES('udieresis', 219, 621, NULL, NULL, NULL, 9662, 8938, 9071, NULL, NULL, 13178);
INSERT INTO lgcGlyphs VALUES('Udieresis', 190, 616, NULL, NULL, NULL, 9633, 8909, 9066, NULL, NULL, 13149);
INSERT INTO lgcGlyphs VALUES('udieresisacute', 15734, NULL, NULL, NULL, NULL, 15920, 16537, NULL, NULL, NULL, 16723);
INSERT INTO lgcGlyphs VALUES('Udieresisacute', 20346, NULL, NULL, NULL, NULL, 20401, 20990, NULL, NULL, NULL, 21045);
INSERT INTO lgcGlyphs VALUES('udieresiscaron', 15735, NULL, NULL, NULL, NULL, 15921, 16538, NULL, NULL, NULL, 16724);
INSERT INTO lgcGlyphs VALUES('Udieresiscaron', 20348, NULL, NULL, NULL, NULL, 20403, 20992, NULL, NULL, NULL, 21047);
INSERT INTO lgcGlyphs VALUES('udieresisgrave', 15736, NULL, NULL, NULL, NULL, 15922, 16539, NULL, NULL, NULL, 16725);
INSERT INTO lgcGlyphs VALUES('Udieresisgrave', 20347, NULL, NULL, NULL, NULL, 20402, 20991, NULL, NULL, NULL, 21046);
INSERT INTO lgcGlyphs VALUES('udieresismacron', 15733, NULL, NULL, NULL, NULL, 15919, 16536, NULL, NULL, NULL, 16722);
INSERT INTO lgcGlyphs VALUES('Udieresismacron', 20349, NULL, NULL, NULL, NULL, 20404, 20993, NULL, NULL, NULL, 21048);
INSERT INTO lgcGlyphs VALUES('ugrave', 216, 600, NULL, NULL, NULL, 9659, 8935, 9050, NULL, NULL, 13175);
INSERT INTO lgcGlyphs VALUES('Ugrave', 187, NULL, NULL, NULL, NULL, 9630, 8906, NULL, NULL, NULL, 13146);
INSERT INTO lgcGlyphs VALUES('uhungarumlaut', 15780, NULL, NULL, NULL, NULL, 15962, 16583, NULL, NULL, NULL, 16765);
INSERT INTO lgcGlyphs VALUES('Uhungarumlaut', 15766, NULL, NULL, NULL, NULL, 15948, 16569, NULL, NULL, NULL, 16751);
INSERT INTO lgcGlyphs VALUES('umacron', 9363, NULL, NULL, NULL, NULL, 9683, 12879, NULL, NULL, NULL, 13199);
INSERT INTO lgcGlyphs VALUES('Umacron', 9368, NULL, NULL, NULL, NULL, 9688, 12884, NULL, NULL, NULL, 13204);
INSERT INTO lgcGlyphs VALUES('underscore', 64, 294, NULL, NULL, 650, 9507, 8783, 9013, NULL, NULL, 13023);
INSERT INTO lgcGlyphs VALUES('uogonek', 20363, NULL, NULL, NULL, NULL, 20418, 21007, NULL, NULL, NULL, 21062);
INSERT INTO lgcGlyphs VALUES('Uogonek', 20345, NULL, NULL, NULL, NULL, 20400, 20989, NULL, NULL, NULL, 21044);
INSERT INTO lgcGlyphs VALUES('upsilon', 1054, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Upsilon', 1030, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('upsilondieresis', 20444, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Upsilondieresis', 20434, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('upsilondieresistonos', 20445, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('upsilonlatin', 15834, NULL, NULL, NULL, NULL, NULL, 16637, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('upsilontonos', 20443, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Upsilontonos', 20433, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('uptackbelowcmb', 15872, NULL, NULL, NULL, NULL, NULL, 16675, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('uring', 9416, NULL, NULL, NULL, NULL, 9736, 12932, NULL, NULL, NULL, 13252);
INSERT INTO lgcGlyphs VALUES('Uring', 9404, NULL, NULL, NULL, NULL, 9724, 12920, NULL, NULL, NULL, 13240);
INSERT INTO lgcGlyphs VALUES('utilde', 9417, NULL, NULL, NULL, NULL, 9737, 12933, NULL, NULL, NULL, 13253);
INSERT INTO lgcGlyphs VALUES('Utilde', 9405, NULL, NULL, NULL, NULL, 9725, 12921, NULL, NULL, NULL, 13241);
INSERT INTO lgcGlyphs VALUES('v', 87, 317, NULL, NULL, 837, 9530, 8806, 9036, NULL, NULL, 13046);
INSERT INTO lgcGlyphs VALUES('V', 55, 285, NULL, NULL, 811, 9498, 8774, 9004, NULL, NULL, 13014);
INSERT INTO lgcGlyphs VALUES('ve', 1094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Ve', 1061, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('verticallinebelowcmb', 15865, NULL, NULL, NULL, NULL, NULL, 16668, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('verticallinelowmod', 15847, NULL, NULL, NULL, NULL, NULL, 16650, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('verticallinemod', 15846, NULL, NULL, NULL, NULL, NULL, 16649, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('vhook', 15796, NULL, NULL, NULL, NULL, NULL, 16599, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('vturn', 9438, NULL, NULL, NULL, NULL, NULL, 12954, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('vturnacute', 9439, NULL, NULL, NULL, NULL, NULL, 12955, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('vturngrave', 9440, NULL, NULL, NULL, NULL, NULL, 12956, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('w', 88, 318, NULL, NULL, 838, 9531, 8807, 9037, NULL, NULL, 13047);
INSERT INTO lgcGlyphs VALUES('W', 56, 286, NULL, NULL, 812, 9499, 8775, 9005, NULL, NULL, 13015);
INSERT INTO lgcGlyphs VALUES('wcircumflex', 20364, NULL, NULL, NULL, NULL, 20419, 21008, NULL, NULL, NULL, 21063);
INSERT INTO lgcGlyphs VALUES('Wcircumflex', 20350, NULL, NULL, NULL, NULL, 20405, 20994, NULL, NULL, NULL, 21049);
INSERT INTO lgcGlyphs VALUES('wsuper', 15896, NULL, NULL, NULL, NULL, NULL, 16699, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('wturn', 15837, NULL, NULL, NULL, NULL, NULL, 16640, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('x', 89, 319, NULL, NULL, 839, 9532, 8808, 9038, NULL, NULL, 13048);
INSERT INTO lgcGlyphs VALUES('X', 57, 287, NULL, NULL, 813, 9500, 8776, 9006, NULL, NULL, 13016);
INSERT INTO lgcGlyphs VALUES('xabovecmb', 15864, NULL, NULL, NULL, NULL, NULL, 16667, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('xi', 1048, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Xi', 1024, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('y', 90, 320, NULL, NULL, 840, 9533, 8809, 9039, NULL, NULL, 13049);
INSERT INTO lgcGlyphs VALUES('Y', 58, 288, NULL, NULL, 814, 9501, 8777, 9007, NULL, NULL, 13017);
INSERT INTO lgcGlyphs VALUES('yacute', 220, NULL, NULL, NULL, NULL, 9663, 8939, NULL, NULL, NULL, 13179);
INSERT INTO lgcGlyphs VALUES('Yacute', 191, NULL, NULL, NULL, NULL, 9634, 8910, NULL, NULL, NULL, 13150);
INSERT INTO lgcGlyphs VALUES('ycircumflex', 20365, NULL, NULL, NULL, NULL, 20420, 21009, NULL, NULL, NULL, 21064);
INSERT INTO lgcGlyphs VALUES('Ycircumflex', 20351, NULL, NULL, NULL, NULL, 20406, 20995, NULL, NULL, NULL, 21050);
INSERT INTO lgcGlyphs VALUES('ydieresis', 222, NULL, NULL, NULL, NULL, 9665, 8941, NULL, NULL, NULL, 13181);
INSERT INTO lgcGlyphs VALUES('Ydieresis', 224, NULL, NULL, NULL, NULL, 9667, 8943, NULL, NULL, NULL, 13183);
INSERT INTO lgcGlyphs VALUES('yen', 61, 291, NULL, NULL, 711, 9504, 8780, 9010, NULL, NULL, 13020);
INSERT INTO lgcGlyphs VALUES('yeri', 1120, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Yeri', 1087, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('yi', 20465, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Yi', 20452, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Ysmallcap', 15890, NULL, NULL, NULL, NULL, NULL, 16693, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('yturn', 15812, NULL, NULL, NULL, NULL, NULL, 16615, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('z', 91, 321, NULL, NULL, 841, 9534, 8810, 9040, NULL, NULL, 13050);
INSERT INTO lgcGlyphs VALUES('Z', 59, 289, NULL, NULL, 815, 9502, 8778, 9008, NULL, NULL, 13018);
INSERT INTO lgcGlyphs VALUES('zacute', 15752, NULL, NULL, NULL, NULL, 15935, 16555, NULL, NULL, NULL, 16738);
INSERT INTO lgcGlyphs VALUES('Zacute', 15743, NULL, NULL, NULL, NULL, 15928, 16546, NULL, NULL, NULL, 16731);
INSERT INTO lgcGlyphs VALUES('zcaron', 229, NULL, NULL, NULL, NULL, 9672, 8948, NULL, NULL, NULL, 13188);
INSERT INTO lgcGlyphs VALUES('Zcaron', 225, NULL, NULL, NULL, NULL, 9668, 8944, NULL, NULL, NULL, 13184);
INSERT INTO lgcGlyphs VALUES('zcurl', 15842, NULL, NULL, NULL, NULL, NULL, 16645, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('zdotaccent', 15754, NULL, NULL, NULL, NULL, 15936, 16557, NULL, NULL, NULL, 16739);
INSERT INTO lgcGlyphs VALUES('Zdotaccent', 15744, NULL, NULL, NULL, NULL, 15929, 16547, NULL, NULL, NULL, 16732);
INSERT INTO lgcGlyphs VALUES('ze', 1100, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Ze', 1067, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('zero', 17, 247, 9738, 9758, 780, 9460, 8736, 8966, 13254, 13274, 12976);
INSERT INTO lgcGlyphs VALUES('zero.inferior', 9384, NULL, NULL, NULL, NULL, 9704, 12900, NULL, NULL, NULL, 13220);
INSERT INTO lgcGlyphs VALUES('zero.slash', 230, 632, NULL, NULL, 8228, 9673, 8949, 9081, NULL, NULL, 13189);
INSERT INTO lgcGlyphs VALUES('zero.superior', 9377, NULL, NULL, NULL, NULL, 9697, 12893, NULL, NULL, NULL, 13213);
INSERT INTO lgcGlyphs VALUES('zeta', 1040, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Zeta', 1016, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('zhe', 1099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('Zhe', 1066, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('zrthook', 15806, NULL, NULL, NULL, NULL, NULL, 16609, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('lthorizform', NULL, 425, NULL, NULL, 7479, NULL, NULL, 9277, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hvhorizform', NULL, 426, NULL, NULL, 7480, NULL, NULL, 9278, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ltvertform', NULL, 427, NULL, NULL, 7481, NULL, NULL, 9279, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hvvertform', NULL, 428, NULL, NULL, 7482, NULL, NULL, 9280, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ltdashtriphorizform', NULL, 429, NULL, NULL, 7483, NULL, NULL, 9281, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hvdashtriphorizform', NULL, 430, NULL, NULL, 7484, NULL, NULL, 9282, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ltdashtripvertform', NULL, 431, NULL, NULL, 7485, NULL, NULL, 9283, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hvdashtripvertform', NULL, 432, NULL, NULL, 7486, NULL, NULL, 9284, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ltdashquadhorizform', NULL, 433, NULL, NULL, 7487, NULL, NULL, 9285, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hvdashquadhorizform', NULL, 434, NULL, NULL, 7488, NULL, NULL, 9286, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ltdashquadvertform', NULL, 435, NULL, NULL, 7489, NULL, NULL, 9287, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hvdashquadvertform', NULL, 436, NULL, NULL, 7490, NULL, NULL, 9288, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ltdnrtform', NULL, 437, NULL, NULL, 7491, NULL, NULL, 9289, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dnltrthvform', NULL, 438, NULL, NULL, 7492, NULL, NULL, 9290, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dnhvrtltform', NULL, 439, NULL, NULL, 7493, NULL, NULL, 9291, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hvdnrtform', NULL, 440, NULL, NULL, 7494, NULL, NULL, 9292, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ltdnleftform', NULL, 441, NULL, NULL, 7495, NULL, NULL, 9293, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dnltlefthvform', NULL, 442, NULL, NULL, 7496, NULL, NULL, 9294, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dnhvleftltform', NULL, 443, NULL, NULL, 7497, NULL, NULL, 9295, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hvdnleftform', NULL, 444, NULL, NULL, 7498, NULL, NULL, 9296, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ltuprtform', NULL, 445, NULL, NULL, 7499, NULL, NULL, 9297, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('upltrthvform', NULL, 446, NULL, NULL, 7500, NULL, NULL, 9298, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('uphvrtltform', NULL, 447, NULL, NULL, 7501, NULL, NULL, 9299, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hvuprtform', NULL, 448, NULL, NULL, 7502, NULL, NULL, 9300, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ltupleftform', NULL, 449, NULL, NULL, 7503, NULL, NULL, 9301, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('upltlefthvform', NULL, 450, NULL, NULL, 7504, NULL, NULL, 9302, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('uphvleftltform', NULL, 451, NULL, NULL, 7505, NULL, NULL, 9303, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hvupleftform', NULL, 452, NULL, NULL, 7506, NULL, NULL, 9304, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ltvertrightform', NULL, 453, NULL, NULL, 7507, NULL, NULL, 9305, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('vertltrthvform', NULL, 454, NULL, NULL, 7508, NULL, NULL, 9306, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('uphvrtdnltform', NULL, 455, NULL, NULL, 7509, NULL, NULL, 9307, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dnhvrtupltform', NULL, 456, NULL, NULL, 7510, NULL, NULL, 9308, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('verthvrtltform', NULL, 457, NULL, NULL, 7511, NULL, NULL, 9309, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dnltrtuphvform', NULL, 458, NULL, NULL, 7512, NULL, NULL, 9310, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('upltrtdnhvform', NULL, 459, NULL, NULL, 7513, NULL, NULL, 9311, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hvvertrtform', NULL, 460, NULL, NULL, 7514, NULL, NULL, 9312, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ltvertleftform', NULL, 461, NULL, NULL, 7515, NULL, NULL, 9313, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('vtltlefthvform', NULL, 462, NULL, NULL, 7516, NULL, NULL, 9314, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('uphvleftdnltform', NULL, 463, NULL, NULL, 7517, NULL, NULL, 9315, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dnhvleftupltform', NULL, 464, NULL, NULL, 7518, NULL, NULL, 9316, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('verthvleftltform', NULL, 465, NULL, NULL, 7519, NULL, NULL, 9317, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dnltleftuphvform', NULL, 466, NULL, NULL, 7520, NULL, NULL, 9318, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('upltleftdnhvform', NULL, 467, NULL, NULL, 7521, NULL, NULL, 9319, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hvvertleftform', NULL, 468, NULL, NULL, 7522, NULL, NULL, 9320, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ltdnhorizform', NULL, 469, NULL, NULL, 7523, NULL, NULL, 9321, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('lefthvrtdnltform', NULL, 470, NULL, NULL, 7524, NULL, NULL, 9322, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('rthvleftdnltform', NULL, 471, NULL, NULL, 7525, NULL, NULL, 9323, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dnlthorizhvform', NULL, 472, NULL, NULL, 7526, NULL, NULL, 9324, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dnhvhorizltform', NULL, 473, NULL, NULL, 7527, NULL, NULL, 9325, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('rtltrtdnhvform', NULL, 474, NULL, NULL, 7528, NULL, NULL, 9326, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('leftltrtdnhvform', NULL, 475, NULL, NULL, 7529, NULL, NULL, 9327, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hvdnhorizform', NULL, 476, NULL, NULL, 7530, NULL, NULL, 9328, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ltuphorizform', NULL, 477, NULL, NULL, 7531, NULL, NULL, 9329, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('lefthvrtupltform', NULL, 478, NULL, NULL, 7532, NULL, NULL, 9330, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('rthvleftupltform', NULL, 479, NULL, NULL, 7533, NULL, NULL, 9331, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('uplthorizhvform', NULL, 480, NULL, NULL, 7534, NULL, NULL, 9332, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('uphvhorizltform', NULL, 481, NULL, NULL, 7535, NULL, NULL, 9333, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('rtltleftuphvform', NULL, 482, NULL, NULL, 7536, NULL, NULL, 9334, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('leftltrtuphvform', NULL, 483, NULL, NULL, 7537, NULL, NULL, 9335, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hvuphorizform', NULL, 484, NULL, NULL, 7538, NULL, NULL, 9336, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('ltverthorizform', NULL, 485, NULL, NULL, 7539, NULL, NULL, 9337, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('lefthvrtvertltform', NULL, 486, NULL, NULL, 7540, NULL, NULL, 9338, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('rthvleftvertltform', NULL, 487, NULL, NULL, 7541, NULL, NULL, 9339, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('vertlthorizhvform', NULL, 488, NULL, NULL, 7542, NULL, NULL, 9340, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('uphvdnhorizltform', NULL, 489, NULL, NULL, 7543, NULL, NULL, 9341, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dnhvuphorizltform', NULL, 490, NULL, NULL, 7544, NULL, NULL, 9342, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('verthvhorizltform', NULL, 491, NULL, NULL, 7545, NULL, NULL, 9343, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('leftuphvrtdnltform', NULL, 492, NULL, NULL, 7546, NULL, NULL, 9344, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('rtuphvleftdnltform', NULL, 493, NULL, NULL, 7547, NULL, NULL, 9345, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('leftdnhvrtupltform', NULL, 494, NULL, NULL, 7548, NULL, NULL, 9346, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('rtdnhvleftupltform', NULL, 495, NULL, NULL, 7549, NULL, NULL, 9347, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dnltuphorizhvform', NULL, 496, NULL, NULL, 7550, NULL, NULL, 9348, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('upltdnhorizhvform', NULL, 497, NULL, NULL, 7551, NULL, NULL, 9349, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('rtltleftverthvform', NULL, 498, NULL, NULL, 7552, NULL, NULL, 9350, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('leftltrtverthvform', NULL, 499, NULL, NULL, 7553, NULL, NULL, 9351, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('hvverthorizform', NULL, 500, NULL, NULL, 7554, NULL, NULL, 9352, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('infinity', 15459, NULL, NULL, NULL, 703, NULL, 16472, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('therefore', 15460, NULL, NULL, NULL, 704, NULL, 16473, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('element', 15464, NULL, NULL, NULL, 741, NULL, 16475, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('suchthat', 15465, NULL, NULL, NULL, 742, NULL, 16476, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('subsetorequal', 15466, NULL, NULL, NULL, 743, NULL, 16477, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('supersetorequal', 15467, NULL, NULL, NULL, 744, NULL, 16478, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('subset', 15468, NULL, NULL, NULL, 745, NULL, 16479, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('superset', 15469, NULL, NULL, NULL, 746, NULL, 16480, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('union', 15470, NULL, NULL, NULL, 747, NULL, 16481, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('intersection', 15471, NULL, NULL, NULL, 748, NULL, 16482, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('notsubset', 15472, NULL, NULL, NULL, 16306, NULL, 16483, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('notsuperset', 15473, NULL, NULL, NULL, 16307, NULL, 16484, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('subsetnotequal', 15474, NULL, NULL, NULL, 16308, NULL, 16485, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('supersetnotequal', 15475, NULL, NULL, NULL, 16309, NULL, 16486, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('notelement', 15476, NULL, NULL, NULL, 16299, NULL, 16487, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('emptyset', 15477, NULL, NULL, NULL, 12184, NULL, 16488, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('projective', 15478, NULL, NULL, NULL, NULL, NULL, 16489, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('perspcorrespond', 15479, NULL, NULL, NULL, NULL, NULL, 16490, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('logicaland', 15480, NULL, NULL, NULL, 749, NULL, 16491, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('logicalor', 15481, NULL, NULL, NULL, 750, NULL, 16492, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('arrowdblright', 15482, NULL, NULL, NULL, 752, NULL, 16493, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('arrowdblboth', 15483, NULL, NULL, NULL, 753, NULL, 16494, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('universal', 15484, NULL, NULL, NULL, 754, NULL, 16495, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('existential', 15485, NULL, NULL, NULL, 755, NULL, 16496, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('circleplus', 15486, NULL, NULL, NULL, 12188, NULL, 16497, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('circleminus', 15487, NULL, NULL, NULL, 12186, NULL, 16498, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('circlemultiply', 15488, NULL, NULL, NULL, 12189, NULL, 16499, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('parallel', 15489, NULL, NULL, NULL, 16196, NULL, 16500, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('notparallel', 15490, NULL, NULL, NULL, 16300, NULL, 16501, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('angle', 15491, NULL, NULL, NULL, 756, NULL, 16502, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('perpendicular', 15492, NULL, NULL, NULL, 757, NULL, 16503, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('partialdiff', 15493, NULL, NULL, NULL, 759, NULL, 16504, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('nabla', 15494, NULL, NULL, NULL, 760, NULL, 16505, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('muchless', 15497, NULL, NULL, NULL, 763, NULL, 16508, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('muchgreater', 15498, NULL, NULL, NULL, 764, NULL, 16509, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('radical', 15499, NULL, NULL, NULL, 765, NULL, 16510, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('reversedtilde', 15500, NULL, NULL, NULL, 766, NULL, 16511, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('proportional', 15501, NULL, NULL, NULL, 767, NULL, 16512, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('because', 15502, NULL, NULL, NULL, 768, NULL, 16513, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('integral', 15503, NULL, NULL, NULL, 769, NULL, 16514, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('integraldbl', 15504, NULL, NULL, NULL, 770, NULL, 16515, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('notequivalence', 15505, NULL, NULL, NULL, 16303, NULL, 16516, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('asymptequal', 15506, NULL, NULL, NULL, 12120, NULL, 16517, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('congruent', 15507, NULL, NULL, NULL, 16301, NULL, 16518, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('approxequal', 15508, NULL, NULL, NULL, 16302, NULL, 16519, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('lessorgreater', 15509, NULL, NULL, NULL, 16304, NULL, 16520, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('greaterorless', 15510, NULL, NULL, NULL, 16305, NULL, 16521, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('arrowboth', 15511, NULL, NULL, NULL, 12201, NULL, 16522, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('minusplus', 15512, NULL, NULL, NULL, 12118, NULL, 16523, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('aleph', 15513, NULL, NULL, NULL, 12089, NULL, 16524, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('lessequalgreater', 15725, NULL, NULL, NULL, 16310, NULL, 16528, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('greaterequalless', 15726, NULL, NULL, NULL, 16311, NULL, 16529, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('propellor', 15728, NULL, NULL, NULL, 16271, NULL, 16531, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('undertie', 15849, NULL, NULL, NULL, NULL, NULL, 16652, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('contourintegral', 15880, NULL, NULL, NULL, 7624, NULL, 16683, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('orthogonal', 15881, NULL, NULL, NULL, 7629, NULL, 16684, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('righttriangle', 15882, NULL, NULL, NULL, 7630, NULL, 16685, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('summation', 15901, NULL, NULL, NULL, 7625, NULL, 16704, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('integraltrpl', 15902, NULL, NULL, NULL, 8195, NULL, 16705, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('lessorequivalent', 15903, NULL, NULL, NULL, 12121, NULL, 16706, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('greaterorequivalent', 15904, NULL, NULL, NULL, 12122, NULL, 16707, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('circledivide', 15905, NULL, NULL, NULL, 12187, NULL, 16708, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('squareplus', 15906, NULL, NULL, NULL, 12190, NULL, 16709, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('squaremultiply', 15907, NULL, NULL, NULL, 12185, NULL, 16710, NULL, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('female', NULL, 12066, NULL, NULL, 706, NULL, NULL, 13298, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('male', NULL, 12067, NULL, NULL, 705, NULL, NULL, 13299, NULL, NULL, NULL);
INSERT INTO lgcGlyphs VALUES('dblhyphenkana', 15516, NULL, NULL, NULL, NULL, 15913, 16527, NULL, NULL, NULL, 16716);
CREATE TABLE lgcFont (fontTag TEXT PRIMARY KEY NOT NULL, srcPrefix TEXT NOT NULL, srcSuffix TEXT NOT NULL, tSuffix TEXT, rotated TEXT);
INSERT INTO lgcFont VALUES('SRCFONT', '', '.sfdir', '', 'ROTATED');
INSERT INTO lgcFont VALUES('FIXEDFONT', 'Fixed-', '.sfdir', 'f', 'ROTATEDFIXED');
INSERT INTO lgcFont VALUES('THIRDWIDTH', 'Third-', '.sfd', 't', 'ROTATEDQUARTER');
INSERT INTO lgcFont VALUES('QUARTERWIDTH', 'Quarter-', '.sfd', 'q', 'ROTATEDTHIRD');
INSERT INTO lgcFont VALUES('WIDEFONT', 'Wide-', '.sfdir', 'w', NULL);
INSERT INTO lgcFont VALUES('ITALICFONT', '', '-Italic.sfdir', 'i', 'ROTATEDITALIC');
INSERT INTO lgcFont VALUES('ENCLFONT', 'Enclosed-', '.sfdir', 'encl', NULL);
INSERT INTO lgcFont VALUES('KUMIMOJI', 'Kumimoji-', '.sfdir', 'kumi', NULL);
INSERT INTO lgcFont VALUES('ROTATED', 'Rotated-', '.sfd', 'r', NULL);
INSERT INTO lgcFont VALUES('ROTATEDFIXED', 'Rotated-Fixed-', '.sfd', 'rf', NULL);
INSERT INTO lgcFont VALUES('ROTATEDQUARTER', 'Rotated-Third-', '.sfd', 'rq', NULL);
INSERT INTO lgcFont VALUES('ROTATEDTHIRD', 'Rotated-Quarter-', '.sfd', 'rt', NULL);
INSERT INTO lgcFont VALUES('ROTATEDITALIC', 'Rotated-', '-Italic.sfd', 'ri', NULL);
INSERT INTO lgcFont VALUES('RUBYFONT', 'Ruby-', '.sfdir', 'ruby', NULL);
INSERT INTO lgcFont VALUES('PROPORTIONALKANA', 'KanaP-', '.sfdir', 'pkna', NULL);
INSERT INTO lgcFont VALUES('SYMBOLFONT', 'Symbols-', '.sfdir', 'syms', NULL);
INSERT INTO lgcFont VALUES('PROPORTIONALVERTKANA', 'KanaVertP-', '.sfdir', 'pvkn', NULL);
INSERT INTO lgcFont VALUES('ENCLALNUM', 'EnclosedAlnum-', '.sfdir', 'ecan', NULL);
CREATE TABLE subFont (FontID INTEGER PRIMARY KEY NOT NULL, mapFile TEXT NOT NULL, fontName TEXT NOT NULL, fontFile TEXT NOT NULL, procBaseFont TEXT, lgcFontTag TEXT, FOREIGN KEY(lgcFontTag) REFERENCES lgcFont(fontTag));
INSERT INTO subFont VALUES(0,'cidpua.map','Japanese','work.otf', NULL, NULL);
INSERT INTO subFont VALUES(1,'cidpua-kana.map','Kana','kana.otf', NULL, NULL);
INSERT INTO subFont VALUES(2,'cidpua-rkana.map','RotKana','rotkana.otf', NULL, NULL);
INSERT INTO subFont VALUES(4,'cidpua-kumimoji.map','Kumimoji','kumimoji.otf', NULL, 'KUMIMOJI');
INSERT INTO subFont VALUES(5,'cidpua-rot.map','RotCJK','rotcjk.otf', NULL, NULL);
INSERT INTO subFont VALUES(6,'cidpua-ruby.map','Ruby','ruby.otf', 'ruby-base.otf', 'RUBYFONT');
INSERT INTO subFont VALUES(7,'cidpua-kanap.map','KanaP','kanap.otf', 'kanap-base.otf', 'PROPORTIONALKANA');
INSERT INTO subFont VALUES(9,'cidpua-kanavertp.map','KanaVertP','kanavp.otf', 'kanavp-base.otf', 'PROPORTIONALVERTKANA');
INSERT INTO subFont VALUES(10,'cidpua-symbols.map','Symbols','symbols.otf', NULL, 'SYMBOLFONT');
INSERT INTO subFont VALUES(12,'cidpua-enclalnum.map','EnclosedAlnum','encl-alnum.otf', NULL, 'ENCLALNUM');
INSERT INTO subFont VALUES(13,'cidpua-enclosed.map','Enclosed','enclosed.otf', 'enclosed-base.otf', 'ENCLFONT');
INSERT INTO subFont VALUES(14,'cidpua-uprightsym.map','UprightSym','upright.otf', NULL, NULL);
INSERT INTO subFont VALUES(19,'cidpua-uprightruby.map','UprightRuby','uprightruby.otf', NULL, NULL);
INSERT INTO subFont VALUES(30,'lgc.map','LGC','lgc.otf', NULL, 'SRCFONT');
INSERT INTO subFont VALUES(31,'lgc-fixed.map','Fixed','fixed.otf', NULL, 'FIXEDFONT');
INSERT INTO subFont VALUES(32,'lgc-third.map','ThirdWidth','third.otf', NULL, 'THIRDWIDTH');
INSERT INTO subFont VALUES(33,'lgc-quarter.map','QuarterWidth','quarter.otf', NULL, 'QUARTERWIDTH');
INSERT INTO subFont VALUES(34,'lgc-wide.map','Fullwidth','wide.otf', NULL, 'WIDEFONT');
INSERT INTO subFont VALUES(37,'lgc-italic.map','Italic','italic.otf', NULL, 'ITALICFONT');
INSERT INTO subFont VALUES(50,'lgc-rotated.map','Rotated','rotated.otf', NULL, 'ROTATED');
INSERT INTO subFont VALUES(51,'lgc-rotfixed.map','RotFixed','rotfixed.otf', NULL, 'ROTATEDFIXED');
INSERT INTO subFont VALUES(52,'lgc-rotquarter.map','RotQuarter','rotquart.otf', NULL, 'ROTATEDQUARTER');
INSERT INTO subFont VALUES(53,'lgc-rotthird.map','RotThird','rotthird.otf', NULL, 'ROTATEDTHIRD');
INSERT INTO subFont VALUES(57,'lgc-rotitalic.map','RotItalic','rotital.otf', NULL, 'ROTATEDITALIC');
CREATE TABLE cjkCID (CID INTEGER NOT NULL, fontID INTEGER NOT NULL, FOREIGN KEY(fontID) REFERENCES subFont(FontID));
-- CJKCID 332 389 1
-- CJKCID 391 421 1
-- CJKCID 516 598 1
-- CJKCID 643 644 1
-- CJKCID 651 654 1
-- CJKCID 657 658 1
-- CJKCID 660 660 1
-- CJKCID 842 1010 1
-- CJKCID 7585 7600 1
-- CJKCID 7891 7891 1
-- CJKCID 7918 7955 1
-- CJKCID 7958 7960 1
-- CJKCID 8038 8052 1
-- CJKCID 8183 8183 1
-- CJKCID 8264 8265 1
-- CJKCID 8313 8316 1
-- CJKCID 8327 8358 1
-- CJKCID 11871 12040 1
-- CJKCID 12269 12638 1
-- CJKCID 16193 16193 1
-- CJKCID 16195 16195 1
-- CJKCID 16209 16221 1
-- CJKCID 16236 16252 1
-- CJKCID 16333 16349 1
-- CJKCID 16352 16411 1
-- CJKCID 20929 20956 1
-- CJKCID 9090 9178 2
-- CJKCID 9180 9262 2
-- CJKCID 7575 7584 4
-- CJKCID 7601 7607 4
-- CJKCID 7610 7612 4
-- CJKCID 8020 8037 4
-- CJKCID 8053 8053 4
-- CJKCID 8055 8055 4
-- CJKCID 8061 8070 4
-- CJKCID 8092 8101 4
-- CJKCID 8182 8182 4
-- CJKCID 8186 8190 4
-- CJKCID 8192 8194 4
-- CJKCID 8225 8226 4
-- CJKCID 8295 8307 4
-- CJKCID 9872 9883 4
-- CJKCID 11846 11870 4
-- CJKCID 20523 20552 4
-- CJKCID 20587 20928 4
-- CJKCID 9084 9089 5
-- CJKCID 9179 9179 5
-- CJKCID 9263 9274 5
-- CJKCID 9276 9276 5
-- CJKCID 12137 12138 5
-- CJKCID 13295 13296 5
-- CJKCID 13300 13319 5
-- CJKCID 12649 12654 6
-- CJKCID 12661 12869 6
-- CJKCID 16414 16468 6
-- CJKCID 15449 15455 7
-- CJKCID 15462 15463 7
-- CJKCID 15517 15724 7
-- CJKCID 15976 16192 9
-- CJKCID 690 691 10
-- CJKCID 721 734 10
-- CJKCID 736 740 10
-- CJKCID 752 753 10
-- CJKCID 758 758 10
-- CJKCID 773 775 10
-- CJKCID 779 779 10
-- CJKCID 7478 7478 10
-- CJKCID 7626 7628 10
-- CJKCID 7631 7632 10
-- CJKCID 7915 7917 10
-- CJKCID 8008 8014 10
-- CJKCID 8016 8019 10
-- CJKCID 8056 8056 10
-- CJKCID 8058 8058 10
-- CJKCID 8166 8181 10
-- CJKCID 8184 8185 10
-- CJKCID 8206 8222 10
-- CJKCID 8230 8258 10
-- CJKCID 8261 8263 10
-- CJKCID 8308 8312 10
-- CJKCID 9780 9871 10
-- CJKCID 12088 12088 10
-- CJKCID 12090 12093 10
-- CJKCID 12097 12100 10
-- CJKCID 12102 12105 10
-- CJKCID 12111 12117 10
-- CJKCID 12119 12119 10
-- CJKCID 12143 12168 10
-- CJKCID 12175 12178 10
-- CJKCID 12183 12183 10
-- CJKCID 12191 12191 10
-- CJKCID 12194 12215 10
-- CJKCID 12220 12260 10
-- CJKCID 15444 15448 10
-- CJKCID 16199 16200 10
-- CJKCID 16203 16203 10
-- CJKCID 16233 16234 10
-- CJKCID 16274 16277 10
-- CJKCID 16312 16325 10
-- CJKCID 16350 16351 10
-- CJKCID 20473 20496 10
-- CJKCID 20513 20522 10
-- CJKCID 20957 20958 10
-- CJKCID 7555 7574 12
-- CJKCID 8015 8015 12
-- CJKCID 8071 8091 12
-- CJKCID 8102 8137 12
-- CJKCID 8224 8224 12
-- CJKCID 8227 8227 12
-- CJKCID 8286 8294 12
-- CJKCID 9884 10029 12
-- CJKCID 10152 10171 12
-- CJKCID 10233 10364 12
-- CJKCID 10502 10656 12
-- CJKCID 10763 10926 12
-- CJKCID 11035 11199 12
-- CJKCID 11306 11469 12
-- CJKCID 11576 11738 12
-- CJKCID 11845 11845 12
-- CJKCID 16223 16232 12
-- CJKCID 16328 16328 12
-- CJKCID 20497 20502 12
-- CJKCID 20504 20509 12
-- CJKCID 20554 20554 12
-- CJKCID 20575 20576 12
-- CJKCID 20578 20581 12
-- CJKCID 20583 20586 12
-- CJKCID 7613 7620 13
-- CJKCID 8138 8165 13
-- CJKCID 8191 8191 13
-- CJKCID 8196 8205 13
-- CJKCID 8223 8223 13
-- CJKCID 8317 8320 13
-- CJKCID 10030 10151 13
-- CJKCID 10172 10232 13
-- CJKCID 10365 10501 13
-- CJKCID 10657 10762 13
-- CJKCID 10927 11034 13
-- CJKCID 11200 11305 13
-- CJKCID 11470 11575 13
-- CJKCID 11739 11844 13
-- CJKCID 20503 20503 13
-- CJKCID 20510 20512 13
-- CJKCID 20553 20553 13
-- CJKCID 20555 20574 13
-- CJKCID 20577 20577 13
-- CJKCID 20582 20582 13
-- CJKCID 327 331 14
-- CJKCID 423 424 14
-- CJKCID 504 513 14
-- CJKCID 634 635 14
-- CJKCID 638 638 14
-- CJKCID 661 661 14
-- CJKCID 665 669 14
-- CJKCID 676 677 14
-- CJKCID 682 689 14
-- CJKCID 735 735 14
-- CJKCID 7608 7609 14
-- CJKCID 7887 7890 14
-- CJKCID 7892 7914 14
-- CJKCID 8057 8057 14
-- CJKCID 8259 8260 14
-- CJKCID 8268 8283 14
-- CJKCID 12063 12064 14
-- CJKCID 12068 12087 14
-- CJKCID 12101 12101 14
-- CJKCID 12123 12136 14
-- CJKCID 12139 12142 14
-- CJKCID 12169 12174 14
-- CJKCID 12179 12180 14
-- CJKCID 12182 12182 14
-- CJKCID 12192 12193 14
-- CJKCID 12216 12219 14
-- CJKCID 12261 12268 14
-- CJKCID 12639 12640 14
-- CJKCID 16194 16194 14
-- CJKCID 16197 16198 14
-- CJKCID 16201 16202 14
-- CJKCID 16205 16208 14
-- CJKCID 16235 16235 14
-- CJKCID 16253 16270 14
-- CJKCID 16272 16273 14
-- CJKCID 16315 16322 14
-- CJKCID 16329 16332 14
-- CJKCID 20959 20960 14
-- CJKCID 12641 12648 19
-- CJKCID 12655 12660 19
-- CJKCID 16412 16413 19
CREATE VIEW lgcCID AS
SELECT pwid AS CID, 30 AS fontID, glyphName FROM lgcGlyphs WHERE pwid IS NOT NULL
UNION SELECT hwid AS CID, 31 AS fontID, glyphName FROM lgcGlyphs WHERE hwid IS NOT NULL
UNION SELECT twid AS CID, 32 AS fontID, glyphName FROM lgcGlyphs WHERE twid IS NOT NULL
UNION SELECT qwid AS CID, 33 AS fontID, glyphName FROM lgcGlyphs WHERE qwid IS NOT NULL
UNION SELECT fwid AS CID, 34 AS fontID, glyphName FROM lgcGlyphs WHERE fwid IS NOT NULL
UNION SELECT ital AS CID, 37 AS fontID, glyphName FROM lgcGlyphs WHERE ital IS NOT NULL
UNION SELECT rotPwid AS CID, 50 AS fontID, glyphName FROM lgcGlyphs WHERE rotPwid IS NOT NULL
UNION SELECT rotHwid AS CID, 51 AS fontID, glyphName FROM lgcGlyphs WHERE rotHwid IS NOT NULL
UNION SELECT rotQwid AS CID, 52 AS fontID, glyphName FROM lgcGlyphs WHERE rotQwid IS NOT NULL
UNION SELECT rotTwid AS CID, 53 AS fontID, glyphName FROM lgcGlyphs WHERE rotTwid IS NOT NULL
UNION SELECT rotItal AS CID, 57 AS fontID, glyphName FROM lgcGlyphs WHERE rotItal IS NOT NULL
ORDER BY CID;
CREATE VIEW symbolCID AS
SELECT CID, fontID, 'uF'
|| SUBSTR('0123456789ABCDEF', CID / 4096 % 16 + 1, 1)
|| SUBSTR('0123456789ABCDEF', CID / 256  % 16 + 1, 1)
|| SUBSTR('0123456789ABCDEF', CID / 16   % 16 + 1, 1)
|| SUBSTR('0123456789ABCDEF', CID        % 16 + 1, 1)
AS glyphName FROM cjkCID ORDER BY CID;
CREATE VIEW normalCIDs AS SELECT CID FROM targetCIDs EXCEPT SELECT CID FROM symbolCID EXCEPT SELECT CID FROM lgcCID ORDER BY CID;
CREATE VIEW normalCID AS
SELECT CID, 0 AS fontID, 'uF'
|| SUBSTR('0123456789ABCDEF', CID / 4096 % 16 + 1, 1)
|| SUBSTR('0123456789ABCDEF', CID / 256  % 16 + 1, 1)
|| SUBSTR('0123456789ABCDEF', CID / 16   % 16 + 1, 1)
|| SUBSTR('0123456789ABCDEF', CID        % 16 + 1, 1)
AS glyphName FROM normalCIDs ORDER BY CID;
CREATE VIEW cidKeys AS
SELECT CID, fontID, glyphName FROM normalCID
UNION SELECT CID, fontID, glyphName FROM symbolCID
UNION SELECT CID, fontID, glyphName FROM lgcCID
ORDER BY CID;
CREATE TABLE featureCode (featID INTEGER PRIMARY KEY NOT NULL, featTag TEXT NOT NULL, isLarge BOOLEAN NOT NULL, aalt BOOLEAN NOT NULL);
INSERT INTO featureCode VALUES(10, 'vert', 0, 1);
INSERT INTO featureCode VALUES(11, 'vrt2', 0, 1);
INSERT INTO featureCode VALUES(12, 'hkna', 0, 1);
INSERT INTO featureCode VALUES(13, 'vkna', 0, 1);
INSERT INTO featureCode VALUES(14, 'ruby', 0, 1);
INSERT INTO featureCode VALUES(15, 'pkna', 0, 1);
INSERT INTO featureCode VALUES(20, 'pwid', 0, 1);
INSERT INTO featureCode VALUES(21, 'hwid', 0, 1);
INSERT INTO featureCode VALUES(22, 'qwid', 0, 1);
INSERT INTO featureCode VALUES(23, 'twid', 0, 1);
INSERT INTO featureCode VALUES(24, 'fwid', 0, 1);
INSERT INTO featureCode VALUES(30, 'ital', 0, 1);
INSERT INTO featureCode VALUES(35, 'zero', 0, 1);
INSERT INTO featureCode VALUES(36, 'salt', 0, 1);
INSERT INTO featureCode VALUES(40, 'ccmp', 1, 0);
INSERT INTO featureCode VALUES(41, 'liga', 0, 0);
INSERT INTO featureCode VALUES(42, 'dlig', 1, 0);
INSERT INTO featureCode VALUES(46, 'frac', 0, 0);
INSERT INTO featureCode VALUES(47, 'afrc', 0, 0);
INSERT INTO featureCode VALUES(50, 'jp83', 0, 1);
INSERT INTO featureCode VALUES(51, 'jp04', 0, 1);
INSERT INTO featureCode VALUES(52, 'jp90', 0, 1);
INSERT INTO featureCode VALUES(53, 'nlck', 0, 1);
INSERT INTO featureCode VALUES(60, 'sups', 0, 1);
INSERT INTO featureCode VALUES(61, 'subs', 0, 1);
CREATE TABLE jVars (j90 INTEGER PRIMARY KEY, j83 INTEGER, j04 INTEGER);
INSERT INTO jVars VALUES(1133, 13408, NULL);
INSERT INTO jVars VALUES(1142, NULL, 7961);
INSERT INTO jVars VALUES(1151, NULL, 7634);
INSERT INTO jVars VALUES(1170, 13409, NULL);
INSERT INTO jVars VALUES(1186, 13410, NULL);
INSERT INTO jVars VALUES(1191, 13411, NULL);
INSERT INTO jVars VALUES(1202, NULL, 7635);
INSERT INTO jVars VALUES(1205, NULL, 7962);
INSERT INTO jVars VALUES(1207, NULL, 7636);
INSERT INTO jVars VALUES(1216, NULL, 7637);
INSERT INTO jVars VALUES(1228, NULL, 7638);
INSERT INTO jVars VALUES(1243, 13412, 20271);
INSERT INTO jVars VALUES(1247, NULL, 7642);
INSERT INTO jVars VALUES(1252, 13413, 13650);
INSERT INTO jVars VALUES(1268, 13414, NULL);
INSERT INTO jVars VALUES(1286, 13415, NULL);
INSERT INTO jVars VALUES(1290, 13416, NULL);
INSERT INTO jVars VALUES(1302, 13417, NULL);
INSERT INTO jVars VALUES(1319, 13418, NULL);
INSERT INTO jVars VALUES(1320, NULL, 7645);
INSERT INTO jVars VALUES(1376, NULL, 7647);
INSERT INTO jVars VALUES(1383, NULL, 7965);
INSERT INTO jVars VALUES(1386, 13419, NULL);
INSERT INTO jVars VALUES(1389, 13420, NULL);
INSERT INTO jVars VALUES(1398, NULL, 13673);
INSERT INTO jVars VALUES(1402, NULL, 20269);
INSERT INTO jVars VALUES(1408, NULL, 7650);
INSERT INTO jVars VALUES(1424, 13421, NULL);
INSERT INTO jVars VALUES(1426, 13422, NULL);
INSERT INTO jVars VALUES(1427, 13423, NULL);
INSERT INTO jVars VALUES(1450, 13424, NULL);
INSERT INTO jVars VALUES(1481, NULL, 7652);
INSERT INTO jVars VALUES(1489, NULL, 7653);
INSERT INTO jVars VALUES(1494, NULL, 20290);
INSERT INTO jVars VALUES(1526, 13425, NULL);
INSERT INTO jVars VALUES(1545, NULL, 7656);
INSERT INTO jVars VALUES(1551, 13426, NULL);
INSERT INTO jVars VALUES(1564, 13427, NULL);
INSERT INTO jVars VALUES(1569, NULL, 7657);
INSERT INTO jVars VALUES(1572, 13428, NULL);
INSERT INTO jVars VALUES(1596, 13429, NULL);
INSERT INTO jVars VALUES(1605, NULL, 7658);
INSERT INTO jVars VALUES(1610, 13430, NULL);
INSERT INTO jVars VALUES(1626, NULL, 7659);
INSERT INTO jVars VALUES(1660, NULL, 7966);
INSERT INTO jVars VALUES(1662, NULL, 20270);
INSERT INTO jVars VALUES(1665, 13431, NULL);
INSERT INTO jVars VALUES(1666, NULL, 20263);
INSERT INTO jVars VALUES(1698, NULL, 7661);
INSERT INTO jVars VALUES(1722, NULL, 7968);
INSERT INTO jVars VALUES(1735, NULL, 7662);
INSERT INTO jVars VALUES(1737, 13432, NULL);
INSERT INTO jVars VALUES(1772, NULL, 7664);
INSERT INTO jVars VALUES(1779, NULL, 7665);
INSERT INTO jVars VALUES(1781, NULL, 7666);
INSERT INTO jVars VALUES(1791, NULL, 20272);
INSERT INTO jVars VALUES(1805, NULL, 7668);
INSERT INTO jVars VALUES(1850, NULL, 20273);
INSERT INTO jVars VALUES(1852, 13433, NULL);
INSERT INTO jVars VALUES(1856, 13434, NULL);
INSERT INTO jVars VALUES(1863, NULL, 7674);
INSERT INTO jVars VALUES(1864, 13435, NULL);
INSERT INTO jVars VALUES(1872, 13436, NULL);
INSERT INTO jVars VALUES(1876, NULL, 7676);
INSERT INTO jVars VALUES(1892, NULL, 20276);
INSERT INTO jVars VALUES(1909, NULL, 7678);
INSERT INTO jVars VALUES(1934, 13437, NULL);
INSERT INTO jVars VALUES(1949, 13438, NULL);
INSERT INTO jVars VALUES(1958, 13439, NULL);
INSERT INTO jVars VALUES(1964, 13440, NULL);
INSERT INTO jVars VALUES(1981, NULL, 7679);
INSERT INTO jVars VALUES(1995, 13441, NULL);
INSERT INTO jVars VALUES(1997, 13442, NULL);
INSERT INTO jVars VALUES(1998, NULL, 20279);
INSERT INTO jVars VALUES(2007, 13443, NULL);
INSERT INTO jVars VALUES(2012, 13444, NULL);
INSERT INTO jVars VALUES(2015, 13445, NULL);
INSERT INTO jVars VALUES(2026, 13446, NULL);
INSERT INTO jVars VALUES(2033, 13447, NULL);
INSERT INTO jVars VALUES(2043, 13448, NULL);
INSERT INTO jVars VALUES(2054, NULL, 7683);
INSERT INTO jVars VALUES(2059, NULL, 20284);
INSERT INTO jVars VALUES(2085, NULL, 20281);
INSERT INTO jVars VALUES(2129, 13449, NULL);
INSERT INTO jVars VALUES(2135, NULL, 7686);
INSERT INTO jVars VALUES(2165, NULL, 7688);
INSERT INTO jVars VALUES(2168, NULL, 7689);
INSERT INTO jVars VALUES(2170, NULL, 7690);
INSERT INTO jVars VALUES(2171, NULL, 20280);
INSERT INTO jVars VALUES(2191, NULL, 7970);
INSERT INTO jVars VALUES(2198, 13450, NULL);
INSERT INTO jVars VALUES(2201, 13451, NULL);
INSERT INTO jVars VALUES(2206, 13452, NULL);
INSERT INTO jVars VALUES(2305, 13453, NULL);
INSERT INTO jVars VALUES(2309, 13454, NULL);
INSERT INTO jVars VALUES(2313, NULL, 7695);
INSERT INTO jVars VALUES(2314, NULL, 7696);
INSERT INTO jVars VALUES(2345, 13455, NULL);
INSERT INTO jVars VALUES(2366, 13456, NULL);
INSERT INTO jVars VALUES(2368, NULL, 7698);
INSERT INTO jVars VALUES(2378, 13457, NULL);
INSERT INTO jVars VALUES(2400, 13458, NULL);
INSERT INTO jVars VALUES(2402, 13459, NULL);
INSERT INTO jVars VALUES(2407, 13460, 13460);
INSERT INTO jVars VALUES(2428, NULL, 7701);
INSERT INTO jVars VALUES(2429, NULL, 7702);
INSERT INTO jVars VALUES(2445, NULL, 7703);
INSERT INTO jVars VALUES(2470, 13461, NULL);
INSERT INTO jVars VALUES(2497, 13462, NULL);
INSERT INTO jVars VALUES(2508, NULL, 7708);
INSERT INTO jVars VALUES(2510, 13463, NULL);
INSERT INTO jVars VALUES(2523, NULL, 20282);
INSERT INTO jVars VALUES(2533, 13464, NULL);
INSERT INTO jVars VALUES(2536, 13465, NULL);
INSERT INTO jVars VALUES(2540, 13466, NULL);
INSERT INTO jVars VALUES(2544, NULL, 7709);
INSERT INTO jVars VALUES(2572, 13467, NULL);
INSERT INTO jVars VALUES(2588, NULL, 13860);
INSERT INTO jVars VALUES(2598, NULL, 7711);
INSERT INTO jVars VALUES(2609, 13468, NULL);
INSERT INTO jVars VALUES(2622, 13469, NULL);
INSERT INTO jVars VALUES(2630, NULL, 7713);
INSERT INTO jVars VALUES(2689, 13470, NULL);
INSERT INTO jVars VALUES(2709, NULL, 7716);
INSERT INTO jVars VALUES(2717, NULL, 7718);
INSERT INTO jVars VALUES(2718, NULL, 7972);
INSERT INTO jVars VALUES(2720, NULL, 7973);
INSERT INTO jVars VALUES(2721, NULL, 7974);
INSERT INTO jVars VALUES(2727, 13471, NULL);
INSERT INTO jVars VALUES(2729, NULL, 7720);
INSERT INTO jVars VALUES(2747, NULL, 7721);
INSERT INTO jVars VALUES(2766, NULL, 7722);
INSERT INTO jVars VALUES(2799, 13472, NULL);
INSERT INTO jVars VALUES(2801, 13473, NULL);
INSERT INTO jVars VALUES(2814, 13474, NULL);
INSERT INTO jVars VALUES(2839, NULL, 7975);
INSERT INTO jVars VALUES(2845, NULL, 7726);
INSERT INTO jVars VALUES(2876, NULL, 7728);
INSERT INTO jVars VALUES(2909, NULL, 7733);
INSERT INTO jVars VALUES(2919, NULL, 7735);
INSERT INTO jVars VALUES(2924, NULL, 7738);
INSERT INTO jVars VALUES(2933, NULL, 13915);
INSERT INTO jVars VALUES(2944, 13475, NULL);
INSERT INTO jVars VALUES(2959, 13476, NULL);
INSERT INTO jVars VALUES(2990, NULL, 7740);
INSERT INTO jVars VALUES(2995, NULL, 7741);
INSERT INTO jVars VALUES(3001, 13477, NULL);
INSERT INTO jVars VALUES(3012, NULL, 21072);
INSERT INTO jVars VALUES(3019, 13478, NULL);
INSERT INTO jVars VALUES(3020, 13479, NULL);
INSERT INTO jVars VALUES(3027, 13480, NULL);
INSERT INTO jVars VALUES(3033, NULL, 7743);
INSERT INTO jVars VALUES(3044, NULL, 7744);
INSERT INTO jVars VALUES(3046, NULL, 7745);
INSERT INTO jVars VALUES(3081, 13481, NULL);
INSERT INTO jVars VALUES(3082, 13482, NULL);
INSERT INTO jVars VALUES(3086, NULL, 20286);
INSERT INTO jVars VALUES(3094, 13483, NULL);
INSERT INTO jVars VALUES(3100, NULL, 7748);
INSERT INTO jVars VALUES(3105, NULL, 7749);
INSERT INTO jVars VALUES(3112, NULL, 7750);
INSERT INTO jVars VALUES(3136, NULL, 13949);
INSERT INTO jVars VALUES(3138, NULL, 7753);
INSERT INTO jVars VALUES(3141, NULL, 7754);
INSERT INTO jVars VALUES(3148, NULL, 7756);
INSERT INTO jVars VALUES(3175, 13484, NULL);
INSERT INTO jVars VALUES(3200, 13485, NULL);
INSERT INTO jVars VALUES(3244, NULL, 7761);
INSERT INTO jVars VALUES(3251, NULL, 20287);
INSERT INTO jVars VALUES(3262, NULL, 7766);
INSERT INTO jVars VALUES(3263, NULL, 7767);
INSERT INTO jVars VALUES(3266, NULL, 7768);
INSERT INTO jVars VALUES(3295, NULL, 7769);
INSERT INTO jVars VALUES(3327, 13486, NULL);
INSERT INTO jVars VALUES(3337, 13487, NULL);
INSERT INTO jVars VALUES(3341, NULL, 7771);
INSERT INTO jVars VALUES(3344, 13488, NULL);
INSERT INTO jVars VALUES(3357, NULL, 7772);
INSERT INTO jVars VALUES(3359, NULL, 7773);
INSERT INTO jVars VALUES(3379, NULL, 20288);
INSERT INTO jVars VALUES(3384, NULL, 7775);
INSERT INTO jVars VALUES(3412, NULL, 7978);
INSERT INTO jVars VALUES(3421, 13489, NULL);
INSERT INTO jVars VALUES(3430, 13490, NULL);
INSERT INTO jVars VALUES(3432, NULL, 7778);
INSERT INTO jVars VALUES(3445, 13491, NULL);
INSERT INTO jVars VALUES(3446, 13492, NULL);
INSERT INTO jVars VALUES(3449, 13493, NULL);
INSERT INTO jVars VALUES(3456, 13494, NULL);
INSERT INTO jVars VALUES(3460, 13495, NULL);
INSERT INTO jVars VALUES(3465, NULL, 7780);
INSERT INTO jVars VALUES(3477, NULL, 7782);
INSERT INTO jVars VALUES(3489, NULL, 7783);
INSERT INTO jVars VALUES(3495, NULL, 7785);
INSERT INTO jVars VALUES(3505, NULL, 20222);
INSERT INTO jVars VALUES(3506, NULL, 7786);
INSERT INTO jVars VALUES(3520, NULL, 7787);
INSERT INTO jVars VALUES(3521, 13496, NULL);
INSERT INTO jVars VALUES(3538, NULL, 20289);
INSERT INTO jVars VALUES(3541, 13497, NULL);
INSERT INTO jVars VALUES(3562, 13498, NULL);
INSERT INTO jVars VALUES(3580, 13499, NULL);
INSERT INTO jVars VALUES(3582, 13500, NULL);
INSERT INTO jVars VALUES(3584, 13501, NULL);
INSERT INTO jVars VALUES(3588, 13502, NULL);
INSERT INTO jVars VALUES(3590, 13503, NULL);
INSERT INTO jVars VALUES(3591, 13504, NULL);
INSERT INTO jVars VALUES(3603, 13505, 7789);
INSERT INTO jVars VALUES(3613, NULL, 7790);
INSERT INTO jVars VALUES(3614, NULL, 14013);
INSERT INTO jVars VALUES(3619, NULL, 7979);
INSERT INTO jVars VALUES(3624, 13506, NULL);
INSERT INTO jVars VALUES(3626, NULL, 7791);
INSERT INTO jVars VALUES(3628, NULL, 20291);
INSERT INTO jVars VALUES(3657, NULL, 7792);
INSERT INTO jVars VALUES(3659, 13507, NULL);
INSERT INTO jVars VALUES(3671, NULL, 7794);
INSERT INTO jVars VALUES(3725, 13508, NULL);
INSERT INTO jVars VALUES(3742, NULL, 7796);
INSERT INTO jVars VALUES(3743, 13509, NULL);
INSERT INTO jVars VALUES(3750, NULL, 7980);
INSERT INTO jVars VALUES(3770, 13510, NULL);
INSERT INTO jVars VALUES(3813, NULL, 7798);
INSERT INTO jVars VALUES(3819, NULL, 7799);
INSERT INTO jVars VALUES(3822, NULL, 20293);
INSERT INTO jVars VALUES(3832, NULL, 20294);
INSERT INTO jVars VALUES(3833, 13511, NULL);
INSERT INTO jVars VALUES(3846, NULL, 7801);
INSERT INTO jVars VALUES(3848, NULL, 7802);
INSERT INTO jVars VALUES(3868, NULL, 14074);
INSERT INTO jVars VALUES(3917, 13512, NULL);
INSERT INTO jVars VALUES(3939, 13513, NULL);
INSERT INTO jVars VALUES(4001, 13514, NULL);
INSERT INTO jVars VALUES(4003, 13515, NULL);
INSERT INTO jVars VALUES(4023, 13516, NULL);
INSERT INTO jVars VALUES(4034, NULL, 7809);
INSERT INTO jVars VALUES(4035, NULL, 7810);
INSERT INTO jVars VALUES(4036, NULL, 20265);
INSERT INTO jVars VALUES(4038, 13517, NULL);
INSERT INTO jVars VALUES(4055, NULL, 7812);
INSERT INTO jVars VALUES(4062, 13518, NULL);
INSERT INTO jVars VALUES(4087, 13519, NULL);
INSERT INTO jVars VALUES(4181, 13520, NULL);
INSERT INTO jVars VALUES(4225, 13521, NULL);
INSERT INTO jVars VALUES(4228, NULL, 7817);
INSERT INTO jVars VALUES(4242, 13522, NULL);
INSERT INTO jVars VALUES(4301, 13523, NULL);
INSERT INTO jVars VALUES(4308, 13524, NULL);
INSERT INTO jVars VALUES(4331, 13525, NULL);
INSERT INTO jVars VALUES(4332, NULL, 14111);
INSERT INTO jVars VALUES(4368, NULL, 20277);
INSERT INTO jVars VALUES(4411, 13526, NULL);
INSERT INTO jVars VALUES(4433, NULL, 7821);
INSERT INTO jVars VALUES(4452, 13527, NULL);
INSERT INTO jVars VALUES(4454, NULL, 14116);
INSERT INTO jVars VALUES(4468, 13528, NULL);
INSERT INTO jVars VALUES(4516, 13529, NULL);
INSERT INTO jVars VALUES(4572, 13530, NULL);
INSERT INTO jVars VALUES(4583, 13531, NULL);
INSERT INTO jVars VALUES(4588, 13532, NULL);
INSERT INTO jVars VALUES(4695, 13533, NULL);
INSERT INTO jVars VALUES(4700, 13534, NULL);
INSERT INTO jVars VALUES(4711, 13535, NULL);
INSERT INTO jVars VALUES(4713, 13536, NULL);
INSERT INTO jVars VALUES(4772, 13537, NULL);
INSERT INTO jVars VALUES(4796, 13538, NULL);
INSERT INTO jVars VALUES(4858, 13539, NULL);
INSERT INTO jVars VALUES(4882, 13540, NULL);
INSERT INTO jVars VALUES(4928, 13541, NULL);
INSERT INTO jVars VALUES(4943, NULL, 7991);
INSERT INTO jVars VALUES(4949, 13542, NULL);
INSERT INTO jVars VALUES(4963, 13543, NULL);
INSERT INTO jVars VALUES(5015, 13544, NULL);
INSERT INTO jVars VALUES(5018, 13545, NULL);
INSERT INTO jVars VALUES(5020, NULL, 20264);
INSERT INTO jVars VALUES(5048, 13546, NULL);
INSERT INTO jVars VALUES(5070, 13547, NULL);
INSERT INTO jVars VALUES(5109, 13548, NULL);
INSERT INTO jVars VALUES(5155, 13549, NULL);
INSERT INTO jVars VALUES(5178, 13550, NULL);
INSERT INTO jVars VALUES(5240, 13551, NULL);
INSERT INTO jVars VALUES(5248, 13552, NULL);
INSERT INTO jVars VALUES(5267, 13553, NULL);
INSERT INTO jVars VALUES(5294, 13554, NULL);
INSERT INTO jVars VALUES(5306, 13555, NULL);
INSERT INTO jVars VALUES(5376, 13556, NULL);
INSERT INTO jVars VALUES(5377, 13557, NULL);
INSERT INTO jVars VALUES(5459, 13558, NULL);
INSERT INTO jVars VALUES(5489, 13559, NULL);
INSERT INTO jVars VALUES(5493, 13560, NULL);
INSERT INTO jVars VALUES(5500, 13561, NULL);
INSERT INTO jVars VALUES(5595, 13562, NULL);
INSERT INTO jVars VALUES(5629, NULL, 20278);
INSERT INTO jVars VALUES(5659, 13563, NULL);
INSERT INTO jVars VALUES(5667, 13564, NULL);
INSERT INTO jVars VALUES(5671, 13565, NULL);
INSERT INTO jVars VALUES(5688, 13566, NULL);
INSERT INTO jVars VALUES(5701, 13567, NULL);
INSERT INTO jVars VALUES(5704, NULL, 20267);
INSERT INTO jVars VALUES(5707, NULL, 20283);
INSERT INTO jVars VALUES(5741, NULL, 20175);
INSERT INTO jVars VALUES(5782, 13568, NULL);
INSERT INTO jVars VALUES(5855, 13569, NULL);
INSERT INTO jVars VALUES(5870, 13570, NULL);
INSERT INTO jVars VALUES(5903, 13571, NULL);
INSERT INTO jVars VALUES(5913, 13572, NULL);
INSERT INTO jVars VALUES(5933, 13573, NULL);
INSERT INTO jVars VALUES(5937, NULL, 20285);
INSERT INTO jVars VALUES(5976, NULL, 20266);
INSERT INTO jVars VALUES(6001, NULL, 7997);
INSERT INTO jVars VALUES(6059, 13574, NULL);
INSERT INTO jVars VALUES(6075, 13575, NULL);
INSERT INTO jVars VALUES(6104, 13576, NULL);
INSERT INTO jVars VALUES(6123, 13577, NULL);
INSERT INTO jVars VALUES(6187, 13578, NULL);
INSERT INTO jVars VALUES(6196, 13579, NULL);
INSERT INTO jVars VALUES(6217, 13580, NULL);
INSERT INTO jVars VALUES(6218, 13581, NULL);
INSERT INTO jVars VALUES(6221, 13582, NULL);
INSERT INTO jVars VALUES(6223, 13583, NULL);
INSERT INTO jVars VALUES(6224, 13584, NULL);
INSERT INTO jVars VALUES(6255, 13585, NULL);
INSERT INTO jVars VALUES(6258, NULL, 20275);
INSERT INTO jVars VALUES(6265, 13586, NULL);
INSERT INTO jVars VALUES(6276, 13587, NULL);
INSERT INTO jVars VALUES(6284, 13588, NULL);
INSERT INTO jVars VALUES(6310, NULL, 14196);
INSERT INTO jVars VALUES(6325, NULL, 20292);
INSERT INTO jVars VALUES(6388, 13589, NULL);
INSERT INTO jVars VALUES(6443, 13590, NULL);
INSERT INTO jVars VALUES(6464, 13591, NULL);
INSERT INTO jVars VALUES(6481, NULL, 20274);
INSERT INTO jVars VALUES(6510, NULL, 20296);
INSERT INTO jVars VALUES(6523, 13592, NULL);
INSERT INTO jVars VALUES(6537, NULL, 20295);
INSERT INTO jVars VALUES(6569, 13593, NULL);
INSERT INTO jVars VALUES(6582, 13594, NULL);
INSERT INTO jVars VALUES(6601, 13595, NULL);
INSERT INTO jVars VALUES(6607, 13596, NULL);
INSERT INTO jVars VALUES(6618, 13597, NULL);
INSERT INTO jVars VALUES(6621, 13598, NULL);
INSERT INTO jVars VALUES(6631, 13599, NULL);
INSERT INTO jVars VALUES(6632, 13600, NULL);
INSERT INTO jVars VALUES(6662, 13601, 20268);
INSERT INTO jVars VALUES(6773, 13602, NULL);
INSERT INTO jVars VALUES(6776, 13603, NULL);
INSERT INTO jVars VALUES(6779, 13604, NULL);
INSERT INTO jVars VALUES(6837, 13605, NULL);
INSERT INTO jVars VALUES(6841, 13606, NULL);
INSERT INTO jVars VALUES(6913, 13607, NULL);
INSERT INTO jVars VALUES(6914, 13608, NULL);
INSERT INTO jVars VALUES(6944, 13609, NULL);
INSERT INTO jVars VALUES(6946, 13610, NULL);
INSERT INTO jVars VALUES(6947, 13611, NULL);
INSERT INTO jVars VALUES(6949, 13612, NULL);
INSERT INTO jVars VALUES(6951, 13613, NULL);
INSERT INTO jVars VALUES(6952, 13614, NULL);
INSERT INTO jVars VALUES(6956, 13615, NULL);
INSERT INTO jVars VALUES(6958, 13616, NULL);
INSERT INTO jVars VALUES(6959, 13617, NULL);
INSERT INTO jVars VALUES(6961, 13618, NULL);
INSERT INTO jVars VALUES(6962, 13619, NULL);
INSERT INTO jVars VALUES(7053, 13620, NULL);
INSERT INTO jVars VALUES(7104, 13621, NULL);
INSERT INTO jVars VALUES(7138, 13622, NULL);
INSERT INTO jVars VALUES(7146, 13623, NULL);
INSERT INTO jVars VALUES(7152, 13624, NULL);
INSERT INTO jVars VALUES(7180, 13625, NULL);
INSERT INTO jVars VALUES(7194, 13626, NULL);
INSERT INTO jVars VALUES(7200, 13627, NULL);
INSERT INTO jVars VALUES(7248, NULL, 8003);
INSERT INTO jVars VALUES(7251, 13628, NULL);
INSERT INTO jVars VALUES(7304, 13629, NULL);
INSERT INTO jVars VALUES(7307, 13630, NULL);
INSERT INTO jVars VALUES(7321, 13631, NULL);
INSERT INTO jVars VALUES(7329, 13632, NULL);
INSERT INTO jVars VALUES(7332, 13633, NULL);
INSERT INTO jVars VALUES(7362, NULL, 14272);
INSERT INTO jVars VALUES(7379, 13634, NULL);
INSERT INTO jVars VALUES(7402, 13635, NULL);
INSERT INTO jVars VALUES(7451, 13636, NULL);
INSERT INTO jVars VALUES(8612, NULL, 21073);
INSERT INTO jVars VALUES(8625, NULL, 21074);
INSERT INTO jVars VALUES(14541, NULL, 21558);
INSERT INTO jVars VALUES(14762, NULL, 21933);
INSERT INTO jVars VALUES(15319, NULL, 22920);
INSERT INTO jVars VALUES(17469, NULL, 21371);
INSERT INTO jVars VALUES(17755, NULL, 21722);
CREATE TABLE fractions (src1 TEXT NOT NULL, src2 TEXT NOT NULL, src3 TEXT NOT NULL, src4 TEXT, src5 TEXT,
diagonal INTEGER NOT NULL, stacked INTEGER NOT NULL, pwid INTEGER, CHECK(src4 IS NOT NULL OR src5 IS NULL));
INSERT INTO fractions VALUES('zero', 'fraction', 'three', NULL, NULL, 9780, 9825, NULL);
INSERT INTO fractions VALUES('one', 'fraction', 'two', NULL, NULL, 8184, 9826, 162);
INSERT INTO fractions VALUES('one', 'fraction', 'three', NULL, NULL, 9781, 9827, 9375);
INSERT INTO fractions VALUES('two', 'fraction', 'three', NULL, NULL, 9782, 9828, 9376);
INSERT INTO fractions VALUES('one', 'fraction', 'four', NULL, NULL, 8185, 9829, 161);
INSERT INTO fractions VALUES('three', 'fraction', 'four', NULL, NULL, 9783, 9830, 163);
INSERT INTO fractions VALUES('one', 'fraction', 'five', NULL, NULL, 9784, 9831, 15727);
INSERT INTO fractions VALUES('two', 'fraction', 'five', NULL, NULL, 9785, 9832, NULL);
INSERT INTO fractions VALUES('three', 'fraction', 'five', NULL, NULL, 9786, 9833, NULL);
INSERT INTO fractions VALUES('four', 'fraction', 'five', NULL, NULL, 9787, 9834, NULL);
INSERT INTO fractions VALUES('one', 'fraction', 'six', NULL, NULL, 9788, 9835, NULL);
INSERT INTO fractions VALUES('five', 'fraction', 'six', NULL, NULL, 9789, 9836, NULL);
INSERT INTO fractions VALUES('one', 'fraction', 'seven', NULL, NULL, 9790, 9837, NULL);
INSERT INTO fractions VALUES('two', 'fraction', 'seven', NULL, NULL, 9791, 9838, NULL);
INSERT INTO fractions VALUES('three', 'fraction', 'seven', NULL, NULL, 9792, 9839, NULL);
INSERT INTO fractions VALUES('four', 'fraction', 'seven', NULL, NULL, 9793, 9840, NULL);
INSERT INTO fractions VALUES('five', 'fraction', 'seven', NULL, NULL, 9794, 9841, NULL);
INSERT INTO fractions VALUES('six', 'fraction', 'seven', NULL, NULL, 9795, 9842, NULL);
INSERT INTO fractions VALUES('one', 'fraction', 'eight', NULL, NULL, 9796, 9843, 9371);
INSERT INTO fractions VALUES('three', 'fraction', 'eight', NULL, NULL, 9797, 9844, 9372);
INSERT INTO fractions VALUES('five', 'fraction', 'eight', NULL, NULL, 9798, 9845, 9373);
INSERT INTO fractions VALUES('seven', 'fraction', 'eight', NULL, NULL, 9799, 9846, 9374);
INSERT INTO fractions VALUES('one', 'fraction', 'nine', NULL, NULL, 9800, 9847, NULL);
INSERT INTO fractions VALUES('two', 'fraction', 'nine', NULL, NULL, 9801, 9848, NULL);
INSERT INTO fractions VALUES('four', 'fraction', 'nine', NULL, NULL, 9802, 9849, NULL);
INSERT INTO fractions VALUES('five', 'fraction', 'nine', NULL, NULL, 9803, 9850, NULL);
INSERT INTO fractions VALUES('seven', 'fraction', 'nine', NULL, NULL, 9804, 9851, NULL);
INSERT INTO fractions VALUES('eight', 'fraction', 'nine', NULL, NULL, 9805, 9852, NULL);
INSERT INTO fractions VALUES('one', 'fraction', 'one', 'zero', NULL, 9806, 9853, NULL);
INSERT INTO fractions VALUES('three', 'fraction', 'one', 'zero', NULL, 9807, 9854, NULL);
INSERT INTO fractions VALUES('seven', 'fraction', 'one', 'zero', NULL, 9808, 9855, NULL);
INSERT INTO fractions VALUES('nine', 'fraction', 'one', 'zero', NULL, 9809, 9856, NULL);
INSERT INTO fractions VALUES('one', 'fraction', 'one', 'one', NULL, 9810, 9857, NULL);
INSERT INTO fractions VALUES('two', 'fraction', 'one', 'one', NULL, 9811, 9858, NULL);
INSERT INTO fractions VALUES('three', 'fraction', 'one', 'one', NULL, 9812, 9859, NULL);
INSERT INTO fractions VALUES('four', 'fraction', 'one', 'one', NULL, 9813, 9860, NULL);
INSERT INTO fractions VALUES('five', 'fraction', 'one', 'one', NULL, 9814, 9861, NULL);
INSERT INTO fractions VALUES('six', 'fraction', 'one', 'one', NULL, 9815, 9862, NULL);
INSERT INTO fractions VALUES('seven', 'fraction', 'one', 'one', NULL, 9816, 9863, NULL);
INSERT INTO fractions VALUES('eight', 'fraction', 'one', 'one', NULL, 9817, 9864, NULL);
INSERT INTO fractions VALUES('nine', 'fraction', 'one', 'one', NULL, 9818, 9865, NULL);
INSERT INTO fractions VALUES('one', 'zero', 'fraction', 'one', 'one', 9819, 9866, NULL);
INSERT INTO fractions VALUES('one', 'fraction', 'one', 'two', NULL, 9820, 9867, NULL);
INSERT INTO fractions VALUES('five', 'fraction', 'one', 'two', NULL, 9821, 9868, NULL);
INSERT INTO fractions VALUES('seven', 'fraction', 'one', 'two', NULL, 9822, 9869, NULL);
INSERT INTO fractions VALUES('one', 'one', 'fraction', 'one', 'two', 9823, 9870, NULL);
INSERT INTO fractions VALUES('one', 'fraction', 'one', 'zero', 'zero', 9824, 9871, NULL);
CREATE TABLE salt (fromCID INTEGER PRIMARY KEY NOT NULL, toCID INTEGER NOT NULL);
INSERT INTO salt VALUES(140, 20320);
INSERT INTO salt VALUES(144, 20319);
INSERT INTO salt VALUES(705, 7478);
INSERT INTO salt VALUES(1036, 15909);
INSERT INTO salt VALUES(1042, 15910);
INSERT INTO salt VALUES(1056, 15911);
INSERT INTO salt VALUES(8859, 20964);
INSERT INTO salt VALUES(8863, 20963);
INSERT INTO salt VALUES(9583, 20375);
INSERT INTO salt VALUES(9387, 20374);
INSERT INTO salt VALUES(13099, 21019);
INSERT INTO salt VALUES(13103, 21018);
INSERT INTO salt VALUES(15739, 20341);
INSERT INTO salt VALUES(15747, 20359);
CREATE TABLE supsLabel (fromGlyph TEXT PRIMARY KEY NOT NULL, toGlyph TEXT NOT NULL);
INSERT INTO supsLabel VALUES('zero', 'zero.superior');
INSERT INTO supsLabel VALUES('one', 'one.superior');
INSERT INTO supsLabel VALUES('two', 'two.superior');
INSERT INTO supsLabel VALUES('three', 'three.superior');
INSERT INTO supsLabel VALUES('four', 'four.superior');
INSERT INTO supsLabel VALUES('five', 'five.superior');
INSERT INTO supsLabel VALUES('six', 'six.superior');
INSERT INTO supsLabel VALUES('seven', 'seven.superior');
INSERT INTO supsLabel VALUES('eight', 'eight.superior');
INSERT INTO supsLabel VALUES('nine', 'nine.superior');
INSERT INTO supsLabel VALUES('copyright', 'copyright.sups');
INSERT INTO supsLabel VALUES('registered', 'registered.sups');
CREATE TABLE subsLabel (fromGlyph TEXT PRIMARY KEY NOT NULL, toGlyph TEXT NOT NULL);
INSERT INTO subsLabel VALUES('zero', 'zero.inferior');
INSERT INTO subsLabel VALUES('one', 'one.inferior');
INSERT INTO subsLabel VALUES('two', 'two.inferior');
INSERT INTO subsLabel VALUES('three', 'three.inferior');
INSERT INTO subsLabel VALUES('four', 'four.inferior');
INSERT INTO subsLabel VALUES('five', 'five.inferior');
INSERT INTO subsLabel VALUES('six', 'six.inferior');
INSERT INTO subsLabel VALUES('seven', 'seven.inferior');
INSERT INTO subsLabel VALUES('eight', 'eight.inferior');
INSERT INTO subsLabel VALUES('nine', 'nine.inferior');
CREATE VIEW sups AS
SELECT s1.pwid AS fromCID, s2.pwid AS toCID FROM supsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.hwid AS fromCID, s2.hwid AS toCID FROM supsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.qwid AS fromCID, s2.qwid AS toCID FROM supsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.twid AS fromCID, s2.twid AS toCID FROM supsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.fwid AS fromCID, s2.fwid AS toCID FROM supsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.ital AS fromCID, s2.ital AS toCID FROM supsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.rotPwid AS fromCID, s2.rotPwid AS toCID FROM supsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.rotHwid AS fromCID, s2.rotHwid AS toCID FROM supsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.rotQwid AS fromCID, s2.rotQwid AS toCID FROM supsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.rotTwid AS fromCID, s2.rotTwid AS toCID FROM supsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.rotItal AS fromCID, s2.rotItal AS toCID FROM supsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName;
CREATE VIEW subs AS
SELECT s1.pwid AS fromCID, s2.pwid AS toCID FROM subsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.hwid AS fromCID, s2.hwid AS toCID FROM subsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.qwid AS fromCID, s2.qwid AS toCID FROM subsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.twid AS fromCID, s2.twid AS toCID FROM subsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.fwid AS fromCID, s2.fwid AS toCID FROM subsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.ital AS fromCID, s2.ital AS toCID FROM subsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.rotPwid AS fromCID, s2.rotPwid AS toCID FROM subsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.rotHwid AS fromCID, s2.rotHwid AS toCID FROM subsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.rotQwid AS fromCID, s2.rotQwid AS toCID FROM subsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.rotTwid AS fromCID, s2.rotTwid AS toCID FROM subsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName
UNION SELECT s1.rotItal AS fromCID, s2.rotItal AS toCID FROM subsLabel INNER JOIN lgcGlyphs AS s1 ON fromGlyph=s1.glyphName INNER JOIN lgcGlyphs AS s2 ON toGlyph=s2.glyphName;
CREATE TABLE kana (label TEXT PRIMARY KEY NOT NULL, horizontalFull INTEGER UNIQUE, horizontalHalf INTEGER UNIQUE, verticalFull INTEGER UNIQUE, verticalHalf INTEGER UNIQUE, horizontalRuby INTEGER UNIQUE, verticalRuby INTEGER UNIQUE, horizontalTune INTEGER UNIQUE, verticalTune INTEGER UNIQUE, proportional INTEGER UNIQUE, verticalProp INTEGER UNIQUE);
INSERT INTO kana VALUES('ぁ', 842, 517, 7918, 9181, 12671, 12757, 12275, 12458, 15517, 15985);
INSERT INTO kana VALUES('あ', 843, 526, NULL, 9190, 12672, NULL, 12276, 12459, 15518, 15986);
INSERT INTO kana VALUES('ぃ', 844, 518, 7919, 9182, 12673, 12758, 12277, 12460, 15519, 15987);
INSERT INTO kana VALUES('い', 845, 527, NULL, 9191, 12674, NULL, 12278, 12461, 15520, 15988);
INSERT INTO kana VALUES('ぅ', 846, 519, 7920, 9183, 12675, 12759, 12279, 12462, 15521, 15989);
INSERT INTO kana VALUES('う', 847, 528, NULL, 9192, 12676, NULL, 12280, 12463, 15522, 15990);
INSERT INTO kana VALUES('ぇ', 848, 520, 7921, 9184, 12677, 12760, 12281, 12464, 15523, 15991);
INSERT INTO kana VALUES('え', 849, 529, NULL, 9193, 12678, NULL, 12282, 12465, 15524, 15992);
INSERT INTO kana VALUES('ぉ', 850, 521, 7922, 9185, 12679, 12761, 12283, 12466, 15525, 15993);
INSERT INTO kana VALUES('お', 851, 530, NULL, 9194, 12680, NULL, 12284, 12467, 15526, 15994);
INSERT INTO kana VALUES('か', 852, 531, NULL, 9195, 12681, NULL, 12286, 12469, 15527, 15995);
INSERT INTO kana VALUES('が', 853, 574, NULL, 9238, 12683, NULL, 12287, 12470, 15528, 15996);
INSERT INTO kana VALUES('き', 854, 532, NULL, 9196, 12684, NULL, 12288, 12471, 15529, 15997);
INSERT INTO kana VALUES('ぎ', 855, 575, NULL, 9239, 12685, NULL, 12289, 12472, 15530, 15998);
INSERT INTO kana VALUES('く', 856, 533, NULL, 9197, 12686, NULL, 12290, 12473, 15531, 15999);
INSERT INTO kana VALUES('ぐ', 857, 576, NULL, 9240, 12687, NULL, 12291, 12474, 15532, 16000);
INSERT INTO kana VALUES('け', 858, 534, NULL, 9198, 12688, NULL, 12293, 12476, 15533, 16001);
INSERT INTO kana VALUES('げ', 859, 577, NULL, 9241, 12690, NULL, 12294, 12477, 15534, 16002);
INSERT INTO kana VALUES('こ', 860, 535, NULL, 9199, 12691, NULL, 12296, 12479, 15535, 16003);
INSERT INTO kana VALUES('ご', 861, 578, NULL, 9242, 12692, NULL, 12297, 12480, 15536, 16004);
INSERT INTO kana VALUES('さ', 862, 536, NULL, 9200, 12693, NULL, 12298, 12481, 15537, 16005);
INSERT INTO kana VALUES('ざ', 863, 579, NULL, 9243, 12694, NULL, 12299, 12482, 15538, 16006);
INSERT INTO kana VALUES('し', 864, 537, NULL, 9201, 12695, NULL, 12300, 12483, 15539, 16007);
INSERT INTO kana VALUES('じ', 865, 580, NULL, 9244, 12696, NULL, 12301, 12484, 15540, 16008);
INSERT INTO kana VALUES('す', 866, 538, NULL, 9202, 12697, NULL, 12302, 12485, 15541, 16009);
INSERT INTO kana VALUES('ず', 867, 581, NULL, 9245, 12698, NULL, 12303, 12486, 15542, 16010);
INSERT INTO kana VALUES('せ', 868, 539, NULL, 9203, 12699, NULL, 12304, 12487, 15543, 16011);
INSERT INTO kana VALUES('ぜ', 869, 582, NULL, 9246, 12700, NULL, 12305, 12488, 15544, 16012);
INSERT INTO kana VALUES('そ', 870, 540, NULL, 9204, 12701, NULL, 12306, 12489, 15545, 16013);
INSERT INTO kana VALUES('ぞ', 871, 583, NULL, 9247, 12702, NULL, 12307, 12490, 15546, 16014);
INSERT INTO kana VALUES('た', 872, 541, NULL, 9205, 12703, NULL, 12308, 12491, 15547, 16015);
INSERT INTO kana VALUES('だ', 873, 584, NULL, 9248, 12704, NULL, 12309, 12492, 15548, 16016);
INSERT INTO kana VALUES('ち', 874, 542, NULL, 9206, 12705, NULL, 12310, 12493, 15549, 16017);
INSERT INTO kana VALUES('ぢ', 875, 585, NULL, 9249, 12706, NULL, 12311, 12494, 15550, 16018);
INSERT INTO kana VALUES('っ', 876, 525, 7923, 9189, 12707, 12764, 12312, 12495, 15551, 16019);
INSERT INTO kana VALUES('つ', 877, 543, NULL, 9207, 12708, NULL, 12313, 12496, 15552, 16020);
INSERT INTO kana VALUES('づ', 878, 586, NULL, 9250, 12709, NULL, 12314, 12497, 15553, 16021);
INSERT INTO kana VALUES('て', 879, 544, NULL, 9208, 12710, NULL, 12315, 12498, 15554, 16022);
INSERT INTO kana VALUES('で', 880, 587, NULL, 9251, 12711, NULL, 12316, 12499, 15555, 16023);
INSERT INTO kana VALUES('と', 881, 545, NULL, 9209, 12712, NULL, 12317, 12500, 15556, 16024);
INSERT INTO kana VALUES('ど', 882, 588, NULL, 9252, 12713, NULL, 12318, 12501, 15557, 16025);
INSERT INTO kana VALUES('な', 883, 546, NULL, 9210, 12714, NULL, 12319, 12502, 15558, 16026);
INSERT INTO kana VALUES('に', 884, 547, NULL, 9211, 12715, NULL, 12320, 12503, 15559, 16027);
INSERT INTO kana VALUES('ぬ', 885, 548, NULL, 9212, 12716, NULL, 12321, 12504, 15560, 16028);
INSERT INTO kana VALUES('ね', 886, 549, NULL, 9213, 12717, NULL, 12322, 12505, 15561, 16029);
INSERT INTO kana VALUES('の', 887, 550, NULL, 9214, 12718, NULL, 12323, 12506, 15562, 16030);
INSERT INTO kana VALUES('は', 888, 551, NULL, 9215, 12719, NULL, 12324, 12507, 15563, 16031);
INSERT INTO kana VALUES('ば', 889, 589, NULL, 9253, 12720, NULL, 12325, 12508, 15564, 16032);
INSERT INTO kana VALUES('ぱ', 890, 590, NULL, 9254, 12721, NULL, 12326, 12509, 15565, 16033);
INSERT INTO kana VALUES('ひ', 891, 552, NULL, 9216, 12722, NULL, 12327, 12510, 15566, 16034);
INSERT INTO kana VALUES('び', 892, 591, NULL, 9255, 12723, NULL, 12328, 12511, 15567, 16035);
INSERT INTO kana VALUES('ぴ', 893, 592, NULL, 9256, 12724, NULL, 12329, 12512, 15568, 16036);
INSERT INTO kana VALUES('ふ', 894, 553, NULL, 9217, 12725, NULL, 12330, 12513, 15569, 16037);
INSERT INTO kana VALUES('ぶ', 895, 593, NULL, 9257, 12726, NULL, 12331, 12514, 15570, 16038);
INSERT INTO kana VALUES('ぷ', 896, 594, NULL, 9258, 12727, NULL, 12332, 12515, 15571, 16039);
INSERT INTO kana VALUES('へ', 897, 554, NULL, 9218, 12728, NULL, 12333, 12516, 15572, 16040);
INSERT INTO kana VALUES('べ', 898, 595, NULL, 9259, 12729, NULL, 12334, 12517, 15573, 16041);
INSERT INTO kana VALUES('ぺ', 899, 596, NULL, 9260, 12730, NULL, 12335, 12518, 15574, 16042);
INSERT INTO kana VALUES('ほ', 900, 555, NULL, 9219, 12731, NULL, 12336, 12519, 15575, 16043);
INSERT INTO kana VALUES('ぼ', 901, 597, NULL, 9261, 12732, NULL, 12337, 12520, 15576, 16044);
INSERT INTO kana VALUES('ぽ', 902, 598, NULL, 9262, 12733, NULL, 12338, 12521, 15577, 16045);
INSERT INTO kana VALUES('ま', 903, 556, NULL, 9220, 12734, NULL, 12339, 12522, 15578, 16046);
INSERT INTO kana VALUES('み', 904, 557, NULL, 9221, 12735, NULL, 12340, 12523, 15579, 16047);
INSERT INTO kana VALUES('む', 905, 558, NULL, 9222, 12736, NULL, 12341, 12524, 15580, 16048);
INSERT INTO kana VALUES('め', 906, 559, NULL, 9223, 12737, NULL, 12342, 12525, 15581, 16049);
INSERT INTO kana VALUES('も', 907, 560, NULL, 9224, 12738, NULL, 12343, 12526, 15582, 16050);
INSERT INTO kana VALUES('ゃ', 908, 522, 7924, 9186, 12739, 12765, 12344, 12527, 15583, 16051);
INSERT INTO kana VALUES('や', 909, 561, NULL, 9225, 12740, NULL, 12345, 12528, 15584, 16052);
INSERT INTO kana VALUES('ゅ', 910, 523, 7925, 9187, 12741, 12766, 12346, 12529, 15585, 16053);
INSERT INTO kana VALUES('ゆ', 911, 562, NULL, 9226, 12742, NULL, 12347, 12530, 15586, 16054);
INSERT INTO kana VALUES('ょ', 912, 524, 7926, 9188, 12743, 12767, 12348, 12531, 15587, 16055);
INSERT INTO kana VALUES('よ', 913, 563, NULL, 9227, 12744, NULL, 12349, 12532, 15588, 16056);
INSERT INTO kana VALUES('ら', 914, 564, NULL, 9228, 12745, NULL, 12350, 12533, 15589, 16057);
INSERT INTO kana VALUES('り', 915, 565, NULL, 9229, 12746, NULL, 12351, 12534, 15590, 16058);
INSERT INTO kana VALUES('る', 916, 566, NULL, 9230, 12747, NULL, 12352, 12535, 15591, 16059);
INSERT INTO kana VALUES('れ', 917, 567, NULL, 9231, 12748, NULL, 12353, 12536, 15592, 16060);
INSERT INTO kana VALUES('ろ', 918, 568, NULL, 9232, 12749, NULL, 12354, 12537, 15593, 16061);
INSERT INTO kana VALUES('ゎ', 919, 573, 7927, 9237, 12750, 12768, 12355, 12538, 15594, 16062);
INSERT INTO kana VALUES('わ', 920, 569, NULL, 9233, 12751, NULL, 12356, 12539, 15595, 16063);
INSERT INTO kana VALUES('ゐ', 921, 571, NULL, 9235, 12752, NULL, 12357, 12540, 15596, 16064);
INSERT INTO kana VALUES('ゑ', 922, 572, NULL, 9236, 12753, NULL, 12358, 12541, 15597, 16065);
INSERT INTO kana VALUES('を', 923, 516, NULL, 9180, 12754, NULL, 12359, 12542, 15598, 16066);
INSERT INTO kana VALUES('ん', 924, 570, NULL, 9234, 12755, NULL, 12360, 12543, 15599, 16067);
INSERT INTO kana VALUES('ァ', 925, 333, 7928, 9091, 12769, 12855, 12365, 12548, 15608, 16076);
INSERT INTO kana VALUES('ア', 926, 343, NULL, 9101, 12770, NULL, 12366, 12549, 15609, 16077);
INSERT INTO kana VALUES('ィ', 927, 334, 7929, 9092, 12771, 12856, 12367, 12550, 15610, 16078);
INSERT INTO kana VALUES('イ', 928, 344, NULL, 9102, 12772, NULL, 12368, 12551, 15611, 16079);
INSERT INTO kana VALUES('ゥ', 929, 335, 7930, 9093, 12773, 12857, 12369, 12552, 15612, 16080);
INSERT INTO kana VALUES('ウ', 930, 345, NULL, 9103, 12774, NULL, 12370, 12553, 15613, 16081);
INSERT INTO kana VALUES('ェ', 931, 336, 7931, 9094, 12775, 12858, 12371, 12554, 15614, 16082);
INSERT INTO kana VALUES('エ', 932, 346, NULL, 9104, 12776, NULL, 12372, 12555, 15615, 16083);
INSERT INTO kana VALUES('ォ', 933, 337, 7932, 9095, 12777, 12859, 12373, 12556, 15616, 16084);
INSERT INTO kana VALUES('オ', 934, 347, NULL, 9105, 12778, NULL, 12374, 12557, 15617, 16085);
INSERT INTO kana VALUES('カ', 935, 348, NULL, 9106, 12779, NULL, 12376, 12559, 15618, 16086);
INSERT INTO kana VALUES('ガ', 936, 397, NULL, 9154, 12781, NULL, 12377, 12560, 15619, 16087);
INSERT INTO kana VALUES('キ', 937, 349, NULL, 9107, 12782, NULL, 12378, 12561, 15620, 16088);
INSERT INTO kana VALUES('ギ', 938, 398, NULL, 9155, 12783, NULL, 12379, 12562, 15621, 16089);
INSERT INTO kana VALUES('ク', 939, 350, NULL, 9108, 12784, NULL, 12380, 12563, 15622, 16090);
INSERT INTO kana VALUES('グ', 940, 399, NULL, 9156, 12785, NULL, 12381, 12564, 15623, 16091);
INSERT INTO kana VALUES('ケ', 941, 351, NULL, 9109, 12786, NULL, 12383, 12566, 15624, 16092);
INSERT INTO kana VALUES('ゲ', 942, 400, NULL, 9157, 12788, NULL, 12384, 12567, 15625, 16093);
INSERT INTO kana VALUES('コ', 943, 352, NULL, 9110, 12789, NULL, 12386, 12569, 15626, 16094);
INSERT INTO kana VALUES('ゴ', 944, 401, NULL, 9158, 12790, NULL, 12387, 12570, 15627, 16095);
INSERT INTO kana VALUES('サ', 945, 353, NULL, 9111, 12791, NULL, 12388, 12571, 15628, 16096);
INSERT INTO kana VALUES('ザ', 946, 402, NULL, 9159, 12792, NULL, 12389, 12572, 15629, 16097);
INSERT INTO kana VALUES('シ', 947, 354, NULL, 9112, 12793, NULL, 12390, 12573, 15630, 16098);
INSERT INTO kana VALUES('ジ', 948, 403, NULL, 9160, 12794, NULL, 12391, 12574, 15631, 16099);
INSERT INTO kana VALUES('ス', 949, 355, NULL, 9113, 12795, NULL, 12392, 12575, 15632, 16100);
INSERT INTO kana VALUES('ズ', 950, 404, NULL, 9161, 12796, NULL, 12393, 12576, 15633, 16101);
INSERT INTO kana VALUES('セ', 951, 356, NULL, 9114, 12797, NULL, 12394, 12577, 15634, 16102);
INSERT INTO kana VALUES('ゼ', 952, 405, NULL, 9162, 12798, NULL, 12395, 12578, 15635, 16103);
INSERT INTO kana VALUES('ソ', 953, 357, NULL, 9115, 12799, NULL, 12396, 12579, 15636, 16104);
INSERT INTO kana VALUES('ゾ', 954, 406, NULL, 9163, 12800, NULL, 12397, 12580, 15637, 16105);
INSERT INTO kana VALUES('タ', 955, 358, NULL, 9116, 12801, NULL, 12398, 12581, 15638, 16106);
INSERT INTO kana VALUES('ダ', 956, 407, NULL, 9164, 12802, NULL, 12399, 12582, 15639, 16107);
INSERT INTO kana VALUES('チ', 957, 359, NULL, 9117, 12803, NULL, 12400, 12583, 15640, 16108);
INSERT INTO kana VALUES('ヂ', 958, 408, NULL, 9165, 12804, NULL, 12401, 12584, 15641, 16109);
INSERT INTO kana VALUES('ッ', 959, 341, 7933, 9099, 12805, 12862, 12402, 12585, 15642, 16110);
INSERT INTO kana VALUES('ツ', 960, 360, NULL, 9118, 12806, NULL, 12403, 12586, 15643, 16111);
INSERT INTO kana VALUES('ヅ', 961, 409, NULL, 9166, 12807, NULL, 12404, 12587, 15644, 16112);
INSERT INTO kana VALUES('テ', 962, 361, NULL, 9119, 12808, NULL, 12405, 12588, 15645, 16113);
INSERT INTO kana VALUES('デ', 963, 410, NULL, 9167, 12809, NULL, 12406, 12589, 15646, 16114);
INSERT INTO kana VALUES('ト', 964, 362, NULL, 9120, 12810, NULL, 12407, 12590, 15647, 16115);
INSERT INTO kana VALUES('ド', 965, 411, NULL, 9168, 12811, NULL, 12408, 12591, 15648, 16116);
INSERT INTO kana VALUES('ナ', 966, 363, NULL, 9121, 12812, NULL, 12409, 12592, 15649, 16117);
INSERT INTO kana VALUES('ニ', 967, 364, NULL, 9122, 12813, NULL, 12410, 12593, 15650, 16118);
INSERT INTO kana VALUES('ヌ', 968, 365, NULL, 9123, 12814, NULL, 12411, 12594, 15651, 16119);
INSERT INTO kana VALUES('ネ', 969, 366, NULL, 9124, 12815, NULL, 12412, 12595, 15652, 16120);
INSERT INTO kana VALUES('ノ', 970, 367, NULL, 9125, 12816, NULL, 12413, 12596, 15653, 16121);
INSERT INTO kana VALUES('ハ', 971, 368, NULL, 9126, 12817, NULL, 12414, 12597, 15654, 16122);
INSERT INTO kana VALUES('バ', 972, 412, NULL, 9169, 12818, NULL, 12415, 12598, 15655, 16123);
INSERT INTO kana VALUES('パ', 973, 413, NULL, 9170, 12819, NULL, 12416, 12599, 15656, 16124);
INSERT INTO kana VALUES('ヒ', 974, 369, NULL, 9127, 12820, NULL, 12417, 12600, 15657, 16125);
INSERT INTO kana VALUES('ビ', 975, 414, NULL, 9171, 12821, NULL, 12418, 12601, 15658, 16126);
INSERT INTO kana VALUES('ピ', 976, 415, NULL, 9172, 12822, NULL, 12419, 12602, 15659, 16127);
INSERT INTO kana VALUES('フ', 977, 370, NULL, 9128, 12823, NULL, 12420, 12603, 15660, 16128);
INSERT INTO kana VALUES('ブ', 978, 416, NULL, 9173, 12824, NULL, 12421, 12604, 15661, 16129);
INSERT INTO kana VALUES('プ', 979, 417, NULL, 9174, 12825, NULL, 12422, 12605, 15662, 16130);
INSERT INTO kana VALUES('ヘ', 980, 371, NULL, 9129, 12826, NULL, 12423, 12606, 15663, 16131);
INSERT INTO kana VALUES('ベ', 981, 418, NULL, 9175, 12827, NULL, 12424, 12607, 15664, 16132);
INSERT INTO kana VALUES('ペ', 982, 419, NULL, 9176, 12828, NULL, 12425, 12608, 15665, 16133);
INSERT INTO kana VALUES('ホ', 983, 372, NULL, 9130, 12829, NULL, 12426, 12609, 15666, 16134);
INSERT INTO kana VALUES('ボ', 984, 420, NULL, 9177, 12830, NULL, 12427, 12610, 15667, 16135);
INSERT INTO kana VALUES('ポ', 985, 421, NULL, 9178, 12831, NULL, 12428, 12611, 15668, 16136);
INSERT INTO kana VALUES('マ', 986, 373, NULL, 9131, 12832, NULL, 12429, 12612, 15669, 16137);
INSERT INTO kana VALUES('ミ', 987, 374, NULL, 9132, 12833, NULL, 12430, 12613, 15670, 16138);
INSERT INTO kana VALUES('ム', 988, 375, NULL, 9133, 12834, NULL, 12431, 12614, 15671, 16139);
INSERT INTO kana VALUES('メ', 989, 376, NULL, 9134, 12835, NULL, 12432, 12615, 15672, 16140);
INSERT INTO kana VALUES('モ', 990, 377, NULL, 9135, 12836, NULL, 12433, 12616, 15673, 16141);
INSERT INTO kana VALUES('ャ', 991, 338, 7934, 9096, 12837, 12863, 12434, 12617, 15674, 16142);
INSERT INTO kana VALUES('ヤ', 992, 378, NULL, 9136, 12838, NULL, 12435, 12618, 15675, 16143);
INSERT INTO kana VALUES('ュ', 993, 339, 7935, 9097, 12839, 12864, 12436, 12619, 15676, 16144);
INSERT INTO kana VALUES('ユ', 994, 379, NULL, 9137, 12840, NULL, 12437, 12620, 15677, 16145);
INSERT INTO kana VALUES('ョ', 995, 340, 7936, 9098, 12841, 12865, 12438, 12621, 15678, 16146);
INSERT INTO kana VALUES('ヨ', 996, 380, NULL, 9138, 12842, NULL, 12439, 12622, 15679, 16147);
INSERT INTO kana VALUES('ラ', 997, 381, NULL, 9139, 12843, NULL, 12440, 12623, 15680, 16148);
INSERT INTO kana VALUES('リ', 998, 382, NULL, 9140, 12844, NULL, 12441, 12624, 15681, 16149);
INSERT INTO kana VALUES('ル', 999, 383, NULL, 9141, 12845, NULL, 12442, 12625, 15682, 16150);
INSERT INTO kana VALUES('レ', 1000, 384, NULL, 9142, 12846, NULL, 12443, 12626, 15683, 16151);
INSERT INTO kana VALUES('ロ', 1001, 385, NULL, 9143, 12847, NULL, 12444, 12627, 15684, 16152);
INSERT INTO kana VALUES('ヮ', 1002, 393, 7937, 9150, 12848, 12866, 12445, 12628, 15685, 16153);
INSERT INTO kana VALUES('ワ', 1003, 386, NULL, 9144, 12849, NULL, 12446, 12629, 15686, 16154);
INSERT INTO kana VALUES('ヰ', 1004, 391, NULL, 9148, 12850, NULL, 12447, 12630, 15687, 16155);
INSERT INTO kana VALUES('ヱ', 1005, 392, NULL, 9149, 12851, NULL, 12448, 12631, 15688, 16156);
INSERT INTO kana VALUES('ヲ', 1006, 332, NULL, 9090, 12852, NULL, 12449, 12632, 15689, 16157);
INSERT INTO kana VALUES('ン', 1007, 387, NULL, 9145, 12853, NULL, 12450, 12633, 15690, 16158);
INSERT INTO kana VALUES('ヴ', 1008, 396, NULL, 9153, 12854, NULL, 12451, 12634, 15691, 16159);
INSERT INTO kana VALUES('ヵ', 1009, 394, 7938, 9151, 12780, 12860, 12375, 12558, 15692, 16160);
INSERT INTO kana VALUES('ヶ', 1010, 395, 7939, 9152, 12787, 12861, 12382, 12565, 15693, 16161);
INSERT INTO kana VALUES('ー', 660, 342, 7891, 9100, 12867, 12868, 12364, 12547, 15455, 15982);
INSERT INTO kana VALUES('voicedmark', 643, 388, 8271, 9146, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('semivoicedmark', 644, 389, 8272, 9147, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('triangle', 731, 629, NULL, 9353, 12648, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('ideographicperiod', 635, 327, 7888, 9085, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('cornerbracketleft', 686, 328, 7911, 9086, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('cornerbracketright', 687, 329, 7912, 9087, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('ideographiccomma', 634, 330, 7887, 9088, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('dotkatakana', 638, 331, NULL, 9089, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('u301D', 7608, 423, 7956, 9263, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('u301F', 7609, 424, 7957, 9264, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('tortoiseshellbracketleft', 676, 504, 7901, 9265, 12655, 12659, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('tortoiseshellbracketright', 677, 505, 7902, 9266, 12656, 12660, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('anglebracketleft', 682, 506, 7907, 9267, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('anglebracketright', 683, 507, 7908, 9268, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('dblanglebracketleft', 684, 508, 7909, 9269, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('dblanglebracketright', 685, 509, 7910, 9270, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('whitecornerbracketleft', 688, 510, 7913, 9271, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('whitecornerbracketright', 689, 511, 7914, 9272, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('blacklenticularbracketleft', 690, 512, 7915, 9273, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('blacklenticularbracketright', 691, 513, 7916, 9274, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('vuhiragana', 7958, NULL, NULL, NULL, 12756, NULL, 12361, 12544, 15600, 16068);
INSERT INTO kana VALUES('kasmallhiragana', 7959, NULL, 8264, NULL, 12682, 12762, 12285, 12468, 15601, 16069);
INSERT INTO kana VALUES('kesmallhiragana', 7960, NULL, 8265, NULL, 12689, 12763, 12292, 12475, 15602, 16070);
INSERT INTO kana VALUES('kosmallhiragana', 12269, NULL, 12270, NULL, 16448, 16467, 12295, 12478, 15723, 16191);
INSERT INTO kana VALUES('kosmallkatakana', 12271, NULL, 12272, NULL, 16449, 16468, 12385, 12568, 15724, 16192);
INSERT INTO kana VALUES('kusmallkatakana', 16236, NULL, 16333, NULL, 16427, 16450, 16365, 16395, 15702, 16170);
INSERT INTO kana VALUES('sismallkatakana', 16237, NULL, 16334, NULL, 16428, 16451, 16366, 16396, 15703, 16171);
INSERT INTO kana VALUES('susmallkatakana', 16238, NULL, 16335, NULL, 16429, 16452, 16367, 16397, 15704, 16172);
INSERT INTO kana VALUES('tosmallkatakana', 16239, NULL, 16336, NULL, 16430, 16453, 16368, 16398, 15705, 16173);
INSERT INTO kana VALUES('nusmallkatakana', 16240, NULL, 16337, NULL, 16431, 16454, 16369, 16399, 15706, 16174);
INSERT INTO kana VALUES('hasmallkatakana', 16241, NULL, 16338, NULL, 16432, 16455, 16370, 16400, 15707, 16175);
INSERT INTO kana VALUES('hismallkatakana', 16242, NULL, 16339, NULL, 16433, 16456, 16371, 16401, 15708, 16176);
INSERT INTO kana VALUES('husmallkatakana', 16243, NULL, 16340, NULL, 16434, 16457, 16372, 16402, 15709, 16177);
INSERT INTO kana VALUES('hesmallkatakana', 16244, NULL, 16341, NULL, 16435, 16458, 16373, 16403, 15710, 16178);
INSERT INTO kana VALUES('hosmallkatakana', 16245, NULL, 16342, NULL, 16436, 16459, 16374, 16404, 15711, 16179);
INSERT INTO kana VALUES('pusmallkatakana', 16246, NULL, 16343, NULL, 16437, 16460, 16375, 16405, 15712, 16180);
INSERT INTO kana VALUES('musmallkatakana', 16247, NULL, 16344, NULL, 16438, 16461, 16376, 16406, 15713, 16181);
INSERT INTO kana VALUES('rasmallkatakana', 16248, NULL, 16345, NULL, 16439, 16462, 16377, 16407, 15714, 16182);
INSERT INTO kana VALUES('rismallkatakana', 16249, NULL, 16346, NULL, 16440, 16463, 16378, 16408, 15715, 16183);
INSERT INTO kana VALUES('rusmallkatakana', 16250, NULL, 16347, NULL, 16441, 16464, 16379, 16409, 15716, 16184);
INSERT INTO kana VALUES('resmallkatakana', 16251, NULL, 16348, NULL, 16442, 16465, 16380, 16410, 15717, 16185);
INSERT INTO kana VALUES('rosmallkatakana', 16252, NULL, 16349, NULL, 16443, 16466, 16381, 16411, 15718, 16186);
INSERT INTO kana VALUES('dittosignkana', 12106, NULL, 12107, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('blackcircle', 724, NULL, NULL, NULL, 12641, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('asteriskmonospace', 718, NULL, NULL, NULL, 12642, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('referencemark', 734, NULL, NULL, NULL, 12643, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('whitecircle', 723, NULL, NULL, NULL, 12644, 16413, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('bullseye', 725, NULL, NULL, NULL, 12645, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('fisheye', 8210, NULL, NULL, NULL, 12646, 16412, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('whitetriangle', 730, NULL, NULL, NULL, 12647, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('iterationkatakana', 651, NULL, NULL, NULL, 12649, NULL, 12362, 12545, 15451, 15978);
INSERT INTO kana VALUES('voicediterationkatakana', 652, NULL, NULL, NULL, 12650, NULL, 12363, 12546, 15452, 15979);
INSERT INTO kana VALUES('iterationhiragana', 653, NULL, NULL, NULL, 12651, NULL, 12273, 12456, 15449, 15976);
INSERT INTO kana VALUES('voicediterationhiragana', 654, NULL, NULL, NULL, 12652, NULL, 12274, 12457, 15450, 15977);
INSERT INTO kana VALUES('parenleftmonospace', 674, 239, 7899, 8958, 12653, 12657, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('parenrightmonospace', 675, 240, 7900, 8959, 12654, 12658, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('zero', 780, 247, NULL, 8966, 12661, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('one', 781, 248, NULL, 8967, 12662, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('two', 782, 249, NULL, 8968, 12663, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('three', 783, 250, NULL, 8969, 12664, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('four', 784, 251, NULL, 8970, 12665, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('five', 785, 252, NULL, 8971, 12666, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('six', 786, 253, NULL, 8972, 12667, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('seven', 787, 254, NULL, 8973, 12668, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('eight', 788, 255, NULL, 8974, 12669, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('nine', 789, 256, NULL, 8975, 12670, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('overline', 649, 325, 7889, 9044, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('underscore', 650, 294, 7890, 9013, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('horizontalbar', 661, NULL, 7892, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('hyphentwo', 662, 244, 7893, 8963, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('slashmonospace', 663, 246, 7894, 8965, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('dblverticalbar', 666, NULL, 7895, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('barmonospace', 667, 323, 7896, 9042, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('ellipsis', 668, NULL, 7897, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('twodotenleader', 669, NULL, 7898, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('bracketleftmonospace', 678, NULL, 7903, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('bracketrightmonospace', 679, NULL, 7904, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('braceleftmonospace', 680, NULL, 7905, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('bracerightmonospace', 681, NULL, 7906, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('minus', 693, 514, NULL, 9275, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('whitetortoiseshellbracketleft', 12129, 12076, 12139, 13308, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('whitetortoiseshellbracketright', 12130, 12077, 12140, 13309, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('doubleparenthesisleft', 12131, 12078, 12141, 13310, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('doubleparenthesisright', 12132, 12079, 12142, 13311, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('spacekatakana', NULL, 326, NULL, 9084, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('spacehiragana', NULL, 515, NULL, 9179, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('spaceboxdrawing', NULL, 422, NULL, 9276, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('vakatakana', 8313, NULL, NULL, NULL, 16444, NULL, 12452, 12635, 15719, 16187);
INSERT INTO kana VALUES('vikatakana', 8314, NULL, NULL, NULL, 16445, NULL, 12453, 12636, 15720, 16188);
INSERT INTO kana VALUES('vekatakana', 8315, NULL, NULL, NULL, 16446, NULL, 12454, 12637, 15721, 16189);
INSERT INTO kana VALUES('vokatakana', 8316, NULL, NULL, NULL, 16447, NULL, 12455, 12638, 15722, 16190);
INSERT INTO kana VALUES('ngakatakana', 16214, NULL, NULL, NULL, 16419, NULL, 16357, 16387, 15694, 16162);
INSERT INTO kana VALUES('ngikatakana', 16215, NULL, NULL, NULL, 16420, NULL, 16358, 16388, 15695, 16163);
INSERT INTO kana VALUES('ngukatakana', 16216, NULL, NULL, NULL, 16421, NULL, 16359, 16389, 15696, 16164);
INSERT INTO kana VALUES('ngekatakana', 16217, NULL, NULL, NULL, 16422, NULL, 16360, 16390, 15697, 16165);
INSERT INTO kana VALUES('ngokatakana', 16218, NULL, NULL, NULL, 16423, NULL, 16361, 16391, 15698, 16166);
INSERT INTO kana VALUES('cekatakana', 16219, NULL, NULL, NULL, 16424, NULL, 16362, 16392, 15699, 16167);
INSERT INTO kana VALUES('tukatakanahalfvoiced', 16220, NULL, NULL, NULL, 16425, NULL, 16363, 16393, 15700, 16168);
INSERT INTO kana VALUES('tokatakanahalfvoiced', 16221, NULL, NULL, NULL, 16426, NULL, 16364, 16394, 15701, 16169);
INSERT INTO kana VALUES('ngahiragana', 16209, NULL, NULL, NULL, 16414, NULL, 16352, 16382, 15603, 16071);
INSERT INTO kana VALUES('ngihiragana', 16210, NULL, NULL, NULL, 16415, NULL, 16353, 16383, 15604, 16072);
INSERT INTO kana VALUES('nguhiragana', 16211, NULL, NULL, NULL, 16416, NULL, 16354, 16384, 15605, 16073);
INSERT INTO kana VALUES('ngehiragana', 16212, NULL, NULL, NULL, 16417, NULL, 16355, 16385, 15606, 16074);
INSERT INTO kana VALUES('ngohiragana', 16213, NULL, NULL, NULL, 16418, NULL, 16356, 16386, 15607, 16075);
INSERT INTO kana VALUES('equal', 697, NULL, 7917, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('degree', 707, NULL, 8269, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('geta', 740, 12068, 8270, 13300, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('minute', 708, NULL, 8273, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('period', 637, 245, 8274, 8964, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('quotedblleft', 672, 503, 8279, 9048, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('quotedblright', 673, NULL, 8280, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('quoteleft', 670, 295, 8281, 9014, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('quoteright', 671, NULL, 8282, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('braceleftupper', 8178, NULL, 8168, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('braceleftmiddle', 8179, NULL, 8167, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('braceleftlower', 8180, NULL, 8166, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('braceleftjoint', 8181, NULL, 8169, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('bracerightupper', 8174, NULL, 8172, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('bracerightmiddle', 8175, NULL, 8171, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('bracerightlower', 8176, NULL, 8170, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('bracerightjoint', 8177, NULL, 8173, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('post', 735, 12069, NULL, 13301, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('u239B', 12143, NULL, 12148, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('u239D', 12144, NULL, 12147, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('u239E', 12145, NULL, 12150, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('u23A0', 12146, NULL, 12149, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('u23A1', 12151, NULL, 12156, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('u23A3', 12152, NULL, 12155, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('u23A4', 12153, NULL, 12158, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('u23A6', 12154, NULL, 12157, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('glyph12159', 12159, NULL, 12164, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('glyph12160', 12160, NULL, 12163, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('glyph12161', 12161, NULL, 12166, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('glyph12162', 12162, NULL, 12165, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('glyph12167', 12167, NULL, 12168, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('cornerbracketleft.dup2', 12123, 12070, 12133, 13302, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('cornerbracketright.dup2', 12124, 12071, 12134, 13303, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('whitecornerbracketleft.dup2', 12125, 12072, 12135, 13304, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('whitecornerbracketright.dup2', 12126, 12073, 12136, 13305, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('whitebracketleft', 12127, 12074, 12137, 13306, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('whitebracketright', 12128, 12075, 12138, 13307, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('glyph12063', NULL, 12063, NULL, 13295, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('glyph12064', NULL, 12064, NULL, 13296, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('glyph12080', NULL, 12080, NULL, 13312, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('glyph12081', NULL, 12081, NULL, 13313, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('glyph12082', NULL, 12082, NULL, 13314, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('glyph12083', NULL, 12083, NULL, 13315, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('glyph12084', NULL, 12084, NULL, 13316, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('glyph12085', NULL, 12085, NULL, 13317, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('glyph12086', NULL, 12086, NULL, 13318, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('glyph12087', NULL, 12087, NULL, 13319, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('u3003', 655, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15453, 15980);
INSERT INTO kana VALUES('u3006', 658, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15454, 15981);
INSERT INTO kana VALUES('u30FF', 16195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15462, 15983);
INSERT INTO kana VALUES('u309F', 12181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15463, 15984);
INSERT INTO kana VALUES('u210F', 12092, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15514, 16525);
INSERT INTO kana VALUES('u30A0', 16205, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15516, 16527);
INSERT INTO kana VALUES('bracepart1', 16312, NULL, 16350, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('bracepart2', 16313, NULL, 16351, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kana VALUES('glyph15906', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15906, 16709);
INSERT INTO kana VALUES('glyph15907', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15907, 16710);
INSERT INTO kana VALUES('u30A0.ital', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15913, 16716);
CREATE TABLE cjkLabel (label TEXT PRIMARY KEY NOT NULL, CID INTEGER NOT NULL);
INSERT INTO cjkLabel VALUES('Unus', 7575);
INSERT INTO cjkLabel VALUES('Duo', 7576);
INSERT INTO cjkLabel VALUES('Tres', 7577);
INSERT INTO cjkLabel VALUES('Quattuor', 7578);
INSERT INTO cjkLabel VALUES('Quinque', 7579);
INSERT INTO cjkLabel VALUES('Sex', 7580);
INSERT INTO cjkLabel VALUES('Septem', 7581);
INSERT INTO cjkLabel VALUES('Octo', 7582);
INSERT INTO cjkLabel VALUES('Novem', 7583);
INSERT INTO cjkLabel VALUES('Decem', 7584);
INSERT INTO cjkLabel VALUES('Undecim', 8225);
INSERT INTO cjkLabel VALUES('Duodecim', 8226);
INSERT INTO cjkLabel VALUES('Tredecim', 8295);
INSERT INTO cjkLabel VALUES('Quattuordecim', 8296);
INSERT INTO cjkLabel VALUES('Quindecim', 8297);
INSERT INTO cjkLabel VALUES('unus', 8092);
INSERT INTO cjkLabel VALUES('duo', 8093);
INSERT INTO cjkLabel VALUES('tres', 8094);
INSERT INTO cjkLabel VALUES('quattuor', 8095);
INSERT INTO cjkLabel VALUES('quinque', 8096);
INSERT INTO cjkLabel VALUES('sex', 8097);
INSERT INTO cjkLabel VALUES('septem', 8098);
INSERT INTO cjkLabel VALUES('octo', 8099);
INSERT INTO cjkLabel VALUES('novem', 8100);
INSERT INTO cjkLabel VALUES('decem', 8101);
INSERT INTO cjkLabel VALUES('undecim', 8298);
INSERT INTO cjkLabel VALUES('duodecim', 8299);
INSERT INTO cjkLabel VALUES('tredecim', 8300);
INSERT INTO cjkLabel VALUES('quattuordecim', 8301);
INSERT INTO cjkLabel VALUES('quindecim', 8302);
INSERT INTO cjkLabel VALUES('liter', 8025);
INSERT INTO cjkLabel VALUES('上', 2509);
INSERT INTO cjkLabel VALUES('中', 2980);
INSERT INTO cjkLabel VALUES('下', 1340);
INSERT INTO cjkLabel VALUES('左', 2088);
INSERT INTO cjkLabel VALUES('右', 1224);
INSERT INTO cjkLabel VALUES('夜', 3831);
INSERT INTO cjkLabel VALUES('至', 2232);
INSERT INTO cjkLabel VALUES('企', 1575);
INSERT INTO cjkLabel VALUES('医', 1193);
INSERT INTO cjkLabel VALUES('協', 1696);
INSERT INTO cjkLabel VALUES('名', 3786);
INSERT INTO cjkLabel VALUES('宗', 2347);
INSERT INTO cjkLabel VALUES('労', 4049);
INSERT INTO cjkLabel VALUES('学', 1462);
INSERT INTO cjkLabel VALUES('祭', 2119);
INSERT INTO cjkLabel VALUES('呼', 1914);
INSERT INTO cjkLabel VALUES('有', 3863);
INSERT INTO cjkLabel VALUES('株', 1490);
INSERT INTO cjkLabel VALUES('社', 2302);
INSERT INTO cjkLabel VALUES('監', 1538);
INSERT INTO cjkLabel VALUES('自', 2263);
INSERT INTO cjkLabel VALUES('資', 2239);
INSERT INTO cjkLabel VALUES('財', 2130);
INSERT INTO cjkLabel VALUES('印', 1209);
INSERT INTO cjkLabel VALUES('秘', 3455);
INSERT INTO cjkLabel VALUES('大', 2887);
INSERT INTO cjkLabel VALUES('小', 2454);
INSERT INTO cjkLabel VALUES('優', 3855);
INSERT INTO cjkLabel VALUES('控', 1991);
INSERT INTO cjkLabel VALUES('一', 1200);
INSERT INTO cjkLabel VALUES('二', 3275);
INSERT INTO cjkLabel VALUES('三', 2174);
INSERT INTO cjkLabel VALUES('四', 2203);
INSERT INTO cjkLabel VALUES('五', 1938);
INSERT INTO cjkLabel VALUES('六', 4065);
INSERT INTO cjkLabel VALUES('七', 2275);
INSERT INTO cjkLabel VALUES('八', 3392);
INSERT INTO cjkLabel VALUES('九', 1757);
INSERT INTO cjkLabel VALUES('十', 2375);
INSERT INTO cjkLabel VALUES('日', 3284);
INSERT INTO cjkLabel VALUES('月', 1860);
INSERT INTO cjkLabel VALUES('火', 1360);
INSERT INTO cjkLabel VALUES('水', 2603);
INSERT INTO cjkLabel VALUES('木', 3814);
INSERT INTO cjkLabel VALUES('金', 1754);
INSERT INTO cjkLabel VALUES('土', 3156);
INSERT INTO cjkLabel VALUES('営', 1254);
INSERT INTO cjkLabel VALUES('合', 2041);
INSERT INTO cjkLabel VALUES('調', 3024);
INSERT INTO cjkLabel VALUES('注', 2987);
INSERT INTO cjkLabel VALUES('副', 3565);
INSERT INTO cjkLabel VALUES('減', 1902);
INSERT INTO cjkLabel VALUES('標', 3498);
INSERT INTO cjkLabel VALUES('欠', 1853);
INSERT INTO cjkLabel VALUES('基', 1580);
INSERT INTO cjkLabel VALUES('禁', 1744);
INSERT INTO cjkLabel VALUES('項', 2034);
INSERT INTO cjkLabel VALUES('休', 1651);
INSERT INTO cjkLabel VALUES('女', 2433);
INSERT INTO cjkLabel VALUES('男', 2953);
INSERT INTO cjkLabel VALUES('正', 2649);
INSERT INTO cjkLabel VALUES('写', 2296);
INSERT INTO cjkLabel VALUES('祝', 2389);
INSERT INTO cjkLabel VALUES('出', 2394);
INSERT INTO cjkLabel VALUES('適', 3110);
INSERT INTO cjkLabel VALUES('特', 3227);
INSERT INTO cjkLabel VALUES('済', 2113);
INSERT INTO cjkLabel VALUES('増', 2815);
INSERT INTO cjkLabel VALUES('問', 3824);
INSERT INTO cjkLabel VALUES('答', 3188);
INSERT INTO cjkLabel VALUES('例', 4011);
INSERT INTO cjkLabel VALUES('電', 3135);
INSERT INTO cjkLabel VALUES('年', 3301);
INSERT INTO cjkLabel VALUES('天', 3121);
INSERT INTO cjkLabel VALUES('再', 2102);
INSERT INTO cjkLabel VALUES('新', 2557);
INSERT INTO cjkLabel VALUES('映', 1257);
INSERT INTO cjkLabel VALUES('声', 2656);
INSERT INTO cjkLabel VALUES('前', 2738);
INSERT INTO cjkLabel VALUES('後', 1945);
INSERT INTO cjkLabel VALUES('終', 2356);
INSERT INTO cjkLabel VALUES('立', 3953);
INSERT INTO cjkLabel VALUES('交', 1958);
INSERT INTO cjkLabel VALUES('劇', 1846);
INSERT INTO cjkLabel VALUES('司', 2200);
INSERT INTO cjkLabel VALUES('解', 1394);
INSERT INTO cjkLabel VALUES('気', 1598);
INSERT INTO cjkLabel VALUES('多', 2847);
INSERT INTO cjkLabel VALUES('文', 3592);
INSERT INTO cjkLabel VALUES('手', 2326);
INSERT INTO cjkLabel VALUES('双', 2770);
INSERT INTO cjkLabel VALUES('段', 2952);
INSERT INTO cjkLabel VALUES('明', 3788);
INSERT INTO cjkLabel VALUES('治', 2255);
INSERT INTO cjkLabel VALUES('昭', 2468);
INSERT INTO cjkLabel VALUES('和', 4072);
INSERT INTO cjkLabel VALUES('式', 2268);
INSERT INTO cjkLabel VALUES('会', 1393);
INSERT INTO cjkLabel VALUES('限', 1910);
INSERT INTO cjkLabel VALUES('団', 2946);
INSERT INTO cjkLabel VALUES('法', 3663);
INSERT INTO cjkLabel VALUES('人', 2579);
INSERT INTO cjkLabel VALUES('平', 3599);
INSERT INTO cjkLabel VALUES('成', 2642);
INSERT INTO cjkLabel VALUES('療', 3981);
INSERT INTO cjkLabel VALUES('校', 1997);
INSERT INTO cjkLabel VALUES('共', 1694);
INSERT INTO cjkLabel VALUES('同', 3209);
INSERT INTO cjkLabel VALUES('組', 2762);
INSERT INTO cjkLabel VALUES('教', 1709);
INSERT INTO cjkLabel VALUES('郵', 3875);
INSERT INTO cjkLabel VALUES('便', 3624);
INSERT INTO cjkLabel VALUES('番', 3434);
INSERT INTO cjkLabel VALUES('号', 2040);
CREATE TABLE cjkKumimoji (label TEXT PRIMARY KEY NOT NULL, horizontal INTEGER UNIQUE NOT NULL, vertical INTEGER UNIQUE NOT NULL, horizontalAlt INTEGER, verticalAlt INTEGER,
src1 TEXT NOT NULL, src2 TEXT NOT NULL, src3 TEXT, src4 TEXT, src5 TEXT, src6 TEXT, src7 TEXT, src8 TEXT);
INSERT INTO cjkKumimoji VALUES('ミリ', 7585, 7940, NULL, NULL, 'ミ', 'リ', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('キロ', 7586, 7941, NULL, NULL, 'キ', 'ロ', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('センチ', 8038, 8329, 7587, 7942, 'セ', 'ン', 'チ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('メートル', 7588, 7943, NULL, NULL, 'メ', 'ー', 'ト', 'ル', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('グラム', 8040, 8339, 7589, 7944, 'グ', 'ラ', 'ム', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('トン', 7590, 7945, NULL, NULL, 'ト', 'ン', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('アール', 8042, 8338, 7591, 7946, 'ア', 'ー', 'ル', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ヘクタール', 7592, 7947, NULL, NULL, 'ヘ', 'ク', 'タ', 'ー', 'ル', NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('リットル', 7593, 7948, NULL, NULL, 'リ', 'ッ', 'ト', 'ル', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ワット', 8044, 8344, 7594, 7949, 'ワ', 'ッ', 'ト', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('カロリー', 7595, 7950, NULL, NULL, 'カ', 'ロ', 'リ', 'ー', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ドル', 7596, 7951, NULL, NULL, 'ド', 'ル', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('セント', 8043, 8348, 7597, 7952, 'セ', 'ン', 'ト', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('パーセント', 7598, 7953, NULL, NULL, 'パ', 'ー', 'セ', 'ン', 'ト', NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ミリバール', 7599, 7954, NULL, NULL, 'ミ', 'リ', 'バ', 'ー', 'ル', NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ページ', 8047, 8349, 7600, 7955, 'ペ', 'ー', 'ジ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('明治', 7621, 12041, NULL, NULL, '明', '治', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('大正', 7622, 12042, NULL, NULL, '大', '正', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('昭和', 7623, 12043, NULL, NULL, '昭', '和', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('キロメートル', 8039, 8330, NULL, NULL, 'キ', 'ロ', 'メ', 'ー', 'ト', 'ル', NULL, NULL);
INSERT INTO cjkKumimoji VALUES('キログラム', 8041, 8340, NULL, NULL, 'キ', 'ロ', 'グ', 'ラ', 'ム', NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ホーン', 8045, 8347, 8345, 8346, 'ホ', 'ー', 'ン', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ヘルツ', 8046, 8343, 8341, 8342, 'ヘ', 'ル', 'ツ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('アパート', 8048, 8350, NULL, NULL, 'ア', 'パ', 'ー', 'ト', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ビル', 8049, 8358, NULL, NULL, 'ビ', 'ル', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('マンション', 8050, 8357, NULL, NULL, 'マ', 'ン', 'シ', 'ョ', 'ン', NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('コーポ', 8051, 8353, 8351, 8352, 'コ', 'ー', 'ポ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ハイツ', 8052, 8356, 8354, 8355, 'ハ', 'イ', 'ツ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('株式会社', 8054, 8324, NULL, NULL, '株', '式', '会', '社', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('インチ', 8183, 8333, 8331, 8332, 'イ', 'ン', 'チ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('有限会社', 8321, 8325, NULL, NULL, '有', '限', '会', '社', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('財団法人', 8322, 8326, NULL, NULL, '財', '団', '法', '人', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('平成', 8323, 12044, NULL, NULL, '平', '成', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('フィート', 8327, 8334, NULL, NULL, 'フ', 'ィ', 'ー', 'ト', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ヤード', 8328, 8337, 8335, 8336, 'ヤ', 'ー', 'ド', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('さじ', 11871, 11872, NULL, NULL, 'さ', 'じ', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('アト', 11873, 11957, NULL, NULL, 'ア', 'ト', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('アルファ', 11874, 11958, NULL, NULL, 'ア', 'ル', 'フ', 'ァ', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('アンペア', 11875, 11959, NULL, NULL, 'ア', 'ン', 'ペ', 'ア', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('イニング', 11876, 11960, NULL, NULL, 'イ', 'ニ', 'ン', 'グ', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ウォン', 11877, 11961, NULL, NULL, 'ウ', 'ォ', 'ン', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ウルシ', 11878, 11962, NULL, NULL, 'ウ', 'ル', 'シ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('エーカー', 11879, 11963, NULL, NULL, 'エ', 'ー', 'カ', 'ー', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('エクサ', 11880, 11964, NULL, NULL, 'エ', 'ク', 'サ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('エスクード', 11881, 11965, NULL, NULL, 'エ', 'ス', 'ク', 'ー', 'ド', NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('オーム', 11882, 11966, NULL, NULL, 'オ', 'ー', 'ム', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('オングストローム', 11883, 11967, NULL, NULL, 'オ', 'ン', 'グ', 'ス', 'ト', 'ロ', 'ー', 'ム');
INSERT INTO cjkKumimoji VALUES('オンス', 11884, 11968, NULL, NULL, 'オ', 'ン', 'ス', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('オントロ', 11885, 11969, NULL, NULL, 'オ', 'ン', 'ト', 'ロ', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('カイリ', 11886, 11970, NULL, NULL, 'カ', 'イ', 'リ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('カップ', 11887, 11971, NULL, NULL, 'カ', 'ッ', 'プ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('カラット', 11888, 11972, NULL, NULL, 'カ', 'ラ', 'ッ', 'ト', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ガロン', 11889, 11973, NULL, NULL, 'ガ', 'ロ', 'ン', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ガンマ', 11890, 11974, NULL, NULL, 'ガ', 'ン', 'マ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ギガ', 11891, 11975, NULL, NULL, 'ギ', 'ガ', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ギニー', 11892, 11976, NULL, NULL, 'ギ', 'ニ', 'ー', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('キュリー', 11893, 11977, NULL, NULL, 'キ', 'ュ', 'リ', 'ー', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ギルダー', 11894, 11978, NULL, NULL, 'ギ', 'ル', 'ダ', 'ー', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('キロリットル', 11895, 11979, NULL, NULL, 'キ', 'ロ', 'リ', 'ッ', 'ト', 'ル', NULL, NULL);
INSERT INTO cjkKumimoji VALUES('キロワット', 11896, 11980, NULL, NULL, 'キ', 'ロ', 'ワ', 'ッ', 'ト', NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('グスーム', 11897, 11981, NULL, NULL, 'グ', 'ス', 'ー', 'ム', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('グラムトン', 11898, 11982, NULL, NULL, 'グ', 'ラ', 'ム', 'ト', 'ン', NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('クルザード', 11899, 11983, NULL, NULL, 'ク', 'ル', 'ザ', 'ー', 'ド', NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('クルゼイロ', 11900, 11984, NULL, NULL, 'ク', 'ル', 'ゼ', 'イ', 'ロ', NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('クローネ', 11901, 11985, NULL, NULL, 'ク', 'ロ', 'ー', 'ネ', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ケース', 11902, 11986, NULL, NULL, 'ケ', 'ー', 'ス', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('コルナ', 11903, 11987, NULL, NULL, 'コ', 'ル', 'ナ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('サイクル', 11904, 11988, NULL, NULL, 'サ', 'イ', 'ク', 'ル', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('サンチーム', 11905, 11989, NULL, NULL, 'サ', 'ン', 'チ', 'ー', 'ム', NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('シリング', 11906, 11990, NULL, NULL, 'シ', 'リ', 'ン', 'グ', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ダース', 11907, 11991, NULL, NULL, 'ダ', 'ー', 'ス', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('デカ', 11908, 11992, NULL, NULL, 'デ', 'カ', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('デシ', 11909, 11993, NULL, NULL, 'デ', 'シ', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('テラ', 11910, 11994, NULL, NULL, 'テ', 'ラ', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ドラクマ', 11911, 11995, NULL, NULL, 'ド', 'ラ', 'ク', 'マ', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ナノ', 11912, 11996, NULL, NULL, 'ナ', 'ノ', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ノット', 11913, 11997, NULL, NULL, 'ノ', 'ッ', 'ト', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('バーツ', 11914, 11998, NULL, NULL, 'バ', 'ー', 'ツ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('バーレル', 11915, 11999, NULL, NULL, 'バ', 'ー', 'レ', 'ル', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('パスカル', 11916, 12000, NULL, NULL, 'パ', 'ス', 'カ', 'ル', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('バレル', 11917, 12001, NULL, NULL, 'バ', 'レ', 'ル', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ピアストル', 11918, 12002, NULL, NULL, 'ピ', 'ア', 'ス', 'ト', 'ル', NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ピクル', 11919, 12003, NULL, NULL, 'ピ', 'ク', 'ル', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ピコ', 11920, 12004, NULL, NULL, 'ピ', 'コ', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ファラッド', 11921, 12005, NULL, NULL, 'フ', 'ァ', 'ラ', 'ッ', 'ド', NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ファラド', 11922, 12006, NULL, NULL, 'フ', 'ァ', 'ラ', 'ド', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('フェムト', 11923, 12007, NULL, NULL, 'フ', 'ェ', 'ム', 'ト', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ブッシェル', 11924, 12008, NULL, NULL, 'ブ', 'ッ', 'シ', 'ェ', 'ル', NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('フラン', 11925, 12009, NULL, NULL, 'フ', 'ラ', 'ン', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ベータ', 11926, 12010, NULL, NULL, 'ベ', 'ー', 'タ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ヘクト', 11927, 12011, NULL, NULL, 'ヘ', 'ク', 'ト', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ヘクトパスカル', 11928, 12012, NULL, NULL, 'ヘ', 'ク', 'ト', 'パ', 'ス', 'カ', 'ル', NULL);
INSERT INTO cjkKumimoji VALUES('ペセタ', 11929, 12013, NULL, NULL, 'ペ', 'セ', 'タ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ペソ', 11930, 12014, NULL, NULL, 'ペ', 'ソ', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ペタ', 11931, 12015, NULL, NULL, 'ペ', 'タ', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ペニヒ', 11932, 12016, NULL, NULL, 'ペ', 'ニ', 'ヒ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ペンス', 11933, 12017, NULL, NULL, 'ペ', 'ン', 'ス', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ポイント', 11934, 12018, NULL, NULL, 'ポ', 'イ', 'ン', 'ト', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ホール', 11935, 12019, NULL, NULL, 'ホ', 'ー', 'ル', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ボルト', 11936, 12020, NULL, NULL, 'ボ', 'ル', 'ト', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ホン', 11937, 12021, NULL, NULL, 'ホ', 'ン', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ポンド', 11938, 12022, NULL, NULL, 'ポ', 'ン', 'ド', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('マイクロ', 11939, 12023, NULL, NULL, 'マ', 'イ', 'ク', 'ロ', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('マイル', 11940, 12024, NULL, NULL, 'マ', 'イ', 'ル', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('マッハ', 11941, 12025, NULL, NULL, 'マ', 'ッ', 'ハ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('マルク', 11942, 12026, NULL, NULL, 'マ', 'ル', 'ク', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ミクロン', 11943, 12027, NULL, NULL, 'ミ', 'ク', 'ロ', 'ン', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('メガ', 11944, 12028, NULL, NULL, 'メ', 'ガ', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('メガトン', 11945, 12029, NULL, NULL, 'メ', 'ガ', 'ト', 'ン', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ヤール', 11946, 12030, NULL, NULL, 'ヤ', 'ー', 'ル', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ユアン', 11947, 12031, NULL, NULL, 'ユ', 'ア', 'ン', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ユーロ', 11948, 12032, NULL, NULL, 'ユ', 'ー', 'ロ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ラド', 11949, 12033, NULL, NULL, 'ラ', 'ド', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('リラ', 11950, 12034, NULL, NULL, 'リ', 'ラ', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ルーブル', 11951, 12035, NULL, NULL, 'ル', 'ー', 'ブ', 'ル', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ルクス', 11952, 12036, NULL, NULL, 'ル', 'ク', 'ス', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ルピア', 11953, 12037, NULL, NULL, 'ル', 'ピ', 'ア', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ルピー', 11954, 12038, NULL, NULL, 'ル', 'ピ', 'ー', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('レム', 11955, 12039, NULL, NULL, 'レ', 'ム', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('レントゲン', 11956, 12040, NULL, NULL, 'レ', 'ン', 'ト', 'ゲ', 'ン', NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('医療法人', 12045, 12054, NULL, NULL, '医', '療', '法', '人', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('学校法人', 12046, 12055, NULL, NULL, '学', '校', '法', '人', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('共同組合', 12047, 12056, NULL, NULL, '共', '同', '組', '合', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('協同組合', 12048, 12057, NULL, NULL, '協', '同', '組', '合', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('合資会社', 12049, 12058, NULL, NULL, '合', '資', '会', '社', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('合名会社', 12050, 12059, NULL, NULL, '合', '名', '会', '社', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('社団法人', 12051, 12060, NULL, NULL, '社', '団', '法', '人', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('宗教法人', 12052, 12061, NULL, NULL, '宗', '教', '法', '人', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('郵便番号', 12053, 12062, NULL, NULL, '郵', '便', '番', '号', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ガル', 20929, 20943, NULL, NULL, 'ガ', 'ル', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('グレイ', 20930, 20944, NULL, NULL, 'グ', 'レ', 'イ', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('クローナ', 20931, 20945, NULL, NULL, 'ク', 'ロ', 'ー', 'ナ', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('シーベルト', 20932, 20946, NULL, NULL, 'シ', 'ー', 'ベ', 'ル', 'ト', NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('シェケル', 20933, 20947, NULL, NULL, 'シ', 'ェ', 'ケ', 'ル', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ジュール', 20934, 20948, NULL, NULL, 'ジ', 'ュ', 'ー', 'ル', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('デシベル', 20935, 20949, NULL, NULL, 'デ', 'シ', 'ベ', 'ル', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ドット', 20936, 20950, NULL, NULL, 'ド', 'ッ', 'ト', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('バイト', 20937, 20951, NULL, NULL, 'バ', 'イ', 'ト', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ビット', 20938, 20952, NULL, NULL, 'ビ', 'ッ', 'ト', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ベクレル', 20939, 20953, NULL, NULL, 'ベ', 'ク', 'レ', 'ル', NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ボー', 20940, 20954, NULL, NULL, 'ボ', 'ー', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('ランド', 20941, 20955, NULL, NULL, 'ラ', 'ン', 'ド', NULL, NULL, NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('リンギット', 20942, 20956, NULL, NULL, 'リ', 'ン', 'ギ', 'ッ', 'ト', NULL, NULL, NULL);
INSERT INTO cjkKumimoji VALUES('令和', 23058, 23059, NULL, NULL, '令', '和', NULL, NULL, NULL, NULL, NULL, NULL);
CREATE VIEW zeroNoSlash AS SELECT * FROM lgcGlyphs WHERE glyphName = 'zero';
CREATE VIEW zeroWithSlash AS SELECT * FROM lgcGlyphs WHERE glyphName = 'zero.slash';
CREATE VIEW zero AS
SELECT zeroNoSlash.pwid AS fromCID, zeroWithSlash.pwid AS toCID FROM zeroNoSlash JOIN zeroWithSlash
UNION SELECT zeroNoSlash.hwid AS fromCID, zeroWithSlash.hwid AS toCID FROM zeroNoSlash JOIN zeroWithSlash
UNION SELECT zeroNoSlash.qwid AS fromCID, zeroWithSlash.qwid AS toCID FROM zeroNoSlash JOIN zeroWithSlash
UNION SELECT zeroNoSlash.twid AS fromCID, zeroWithSlash.twid AS toCID FROM zeroNoSlash JOIN zeroWithSlash
UNION SELECT zeroNoSlash.fwid AS fromCID, zeroWithSlash.fwid AS toCID FROM zeroNoSlash JOIN zeroWithSlash
UNION SELECT zeroNoSlash.ital AS fromCID, zeroWithSlash.ital AS toCID FROM zeroNoSlash JOIN zeroWithSlash
UNION SELECT zeroNoSlash.rotPwid AS fromCID, zeroWithSlash.rotPwid AS toCID FROM zeroNoSlash JOIN zeroWithSlash
UNION SELECT zeroNoSlash.rotHwid AS fromCID, zeroWithSlash.rotHwid AS toCID FROM zeroNoSlash JOIN zeroWithSlash
UNION SELECT zeroNoSlash.rotQwid AS fromCID, zeroWithSlash.rotQwid AS toCID FROM zeroNoSlash JOIN zeroWithSlash
UNION SELECT zeroNoSlash.rotTwid AS fromCID, zeroWithSlash.rotTwid AS toCID FROM zeroNoSlash JOIN zeroWithSlash
UNION SELECT zeroNoSlash.rotItal AS fromCID, zeroWithSlash.rotItal AS toCID FROM zeroNoSlash JOIN zeroWithSlash;
CREATE VIEW oneToOneFeat AS
SELECT 10 AS feat, horizontalFull AS fromCID, verticalFull AS toCID FROM kana WHERE horizontalFull IS NOT NULL AND verticalFull IS NOT NULL
UNION SELECT 10 AS feat, horizontalRuby AS fromCID, verticalRuby AS toCID FROM kana WHERE horizontalRuby IS NOT NULL AND verticalRuby IS NOT NULL
UNION SELECT 10 AS feat, horizontalTune AS fromCID, verticalTune AS toCID FROM kana WHERE horizontalTune IS NOT NULL AND verticalTune IS NOT NULL
UNION SELECT 10 AS feat, proportional AS fromCID, verticalProp AS toCID FROM kana WHERE proportional IS NOT NULL AND verticalProp IS NOT NULL
UNION SELECT 10 AS feat, horizontal AS fromCID, vertical AS toCID FROM cjkKumimoji WHERE horizontal IS NOT NULL AND vertical IS NOT NULL
UNION SELECT 11 AS feat, pwid AS fromCID, rotPwid AS toCID FROM lgcGlyphs WHERE pwid IS NOT NULL AND rotPwid IS NOT NULL
UNION SELECT 11 AS feat, hwid AS fromCID, rotHwid AS toCID FROM lgcGlyphs WHERE hwid IS NOT NULL AND rotHwid IS NOT NULL
UNION SELECT 11 AS feat, qwid AS fromCID, rotQwid AS toCID FROM lgcGlyphs WHERE qwid IS NOT NULL AND rotQwid IS NOT NULL
UNION SELECT 11 AS feat, twid AS fromCID, rotTwid AS toCID FROM lgcGlyphs WHERE twid IS NOT NULL AND rotTwid IS NOT NULL
UNION SELECT 11 AS feat, ital AS fromCID, rotItal AS toCID FROM lgcGlyphs WHERE ital IS NOT NULL AND rotItal IS NOT NULL
UNION SELECT 11 AS feat, horizontalFull AS fromCID, verticalFull AS toCID FROM kana WHERE horizontalFull IS NOT NULL AND verticalFull IS NOT NULL
UNION SELECT 11 AS feat, horizontalHalf AS fromCID, verticalHalf AS toCID FROM kana WHERE horizontalHalf IS NOT NULL AND verticalHalf IS NOT NULL
UNION SELECT 11 AS feat, horizontalRuby AS fromCID, verticalRuby AS toCID FROM kana WHERE horizontalRuby IS NOT NULL AND verticalRuby IS NOT NULL
UNION SELECT 11 AS feat, horizontalTune AS fromCID, verticalTune AS toCID FROM kana WHERE horizontalTune IS NOT NULL AND verticalTune IS NOT NULL
UNION SELECT 11 AS feat, proportional AS fromCID, verticalProp AS toCID FROM kana WHERE proportional IS NOT NULL AND verticalProp IS NOT NULL
UNION SELECT 11 AS feat, horizontal AS fromCID, vertical AS toCID FROM cjkKumimoji WHERE horizontal IS NOT NULL AND vertical IS NOT NULL
UNION SELECT 12 AS feat, horizontalFull AS fromCID, horizontalTune AS toCID FROM kana WHERE horizontalFull IS NOT NULL AND horizontalTune IS NOT NULL
UNION SELECT 13 AS feat, horizontalFull AS fromCID, verticalTune AS toCID FROM kana WHERE horizontalFull IS NOT NULL AND verticalTune IS NOT NULL
UNION SELECT 13 AS feat, verticalFull AS fromCID, verticalTune AS toCID FROM kana WHERE verticalFull IS NOT NULL AND verticalTune IS NOT NULL
UNION SELECT 14 AS feat, horizontalFull AS fromCID, horizontalRuby AS toCID FROM kana WHERE horizontalFull IS NOT NULL AND horizontalRuby IS NOT NULL
UNION SELECT 14 AS feat, verticalFull AS fromCID, verticalRuby AS toCID FROM kana WHERE verticalFull IS NOT NULL AND verticalRuby IS NOT NULL
UNION SELECT 15 AS feat, horizontalFull AS fromCID, proportional AS toCID FROM kana WHERE horizontalFull IS NOT NULL AND proportional IS NOT NULL
UNION SELECT 20 AS feat, hwid AS fromCID, pwid AS toCID FROM lgcGlyphs WHERE hwid IS NOT NULL AND pwid IS NOT NULL
UNION SELECT 20 AS feat, qwid AS fromCID, pwid AS toCID FROM lgcGlyphs WHERE qwid IS NOT NULL AND pwid IS NOT NULL
UNION SELECT 20 AS feat, twid AS fromCID, pwid AS toCID FROM lgcGlyphs WHERE twid IS NOT NULL AND pwid IS NOT NULL
UNION SELECT 20 AS feat, fwid AS fromCID, pwid AS toCID FROM lgcGlyphs WHERE fwid IS NOT NULL AND pwid IS NOT NULL
UNION SELECT 21 AS feat, pwid AS fromCID, hwid AS toCID FROM lgcGlyphs WHERE pwid IS NOT NULL AND hwid IS NOT NULL
UNION SELECT 21 AS feat, qwid AS fromCID, hwid AS toCID FROM lgcGlyphs WHERE qwid IS NOT NULL AND hwid IS NOT NULL
UNION SELECT 21 AS feat, twid AS fromCID, hwid AS toCID FROM lgcGlyphs WHERE twid IS NOT NULL AND hwid IS NOT NULL
UNION SELECT 21 AS feat, fwid AS fromCID, hwid AS toCID FROM lgcGlyphs WHERE fwid IS NOT NULL AND hwid IS NOT NULL
UNION SELECT 22 AS feat, pwid AS fromCID, qwid AS toCID FROM lgcGlyphs WHERE pwid IS NOT NULL AND qwid IS NOT NULL
UNION SELECT 22 AS feat, hwid AS fromCID, qwid AS toCID FROM lgcGlyphs WHERE hwid IS NOT NULL AND qwid IS NOT NULL
UNION SELECT 22 AS feat, twid AS fromCID, qwid AS toCID FROM lgcGlyphs WHERE twid IS NOT NULL AND qwid IS NOT NULL
UNION SELECT 22 AS feat, fwid AS fromCID, qwid AS toCID FROM lgcGlyphs WHERE fwid IS NOT NULL AND qwid IS NOT NULL
UNION SELECT 23 AS feat, pwid AS fromCID, twid AS toCID FROM lgcGlyphs WHERE pwid IS NOT NULL AND twid IS NOT NULL
UNION SELECT 23 AS feat, hwid AS fromCID, twid AS toCID FROM lgcGlyphs WHERE hwid IS NOT NULL AND twid IS NOT NULL
UNION SELECT 23 AS feat, qwid AS fromCID, twid AS toCID FROM lgcGlyphs WHERE qwid IS NOT NULL AND twid IS NOT NULL
UNION SELECT 23 AS feat, fwid AS fromCID, twid AS toCID FROM lgcGlyphs WHERE fwid IS NOT NULL AND twid IS NOT NULL
UNION SELECT 24 AS feat, pwid AS fromCID, fwid AS toCID FROM lgcGlyphs WHERE pwid IS NOT NULL AND fwid IS NOT NULL
UNION SELECT 24 AS feat, hwid AS fromCID, fwid AS toCID FROM lgcGlyphs WHERE hwid IS NOT NULL AND fwid IS NOT NULL
UNION SELECT 24 AS feat, qwid AS fromCID, fwid AS toCID FROM lgcGlyphs WHERE qwid IS NOT NULL AND fwid IS NOT NULL
UNION SELECT 24 AS feat, twid AS fromCID, fwid AS toCID FROM lgcGlyphs WHERE twid IS NOT NULL AND fwid IS NOT NULL
UNION SELECT 30 AS feat, pwid AS fromCID, ital AS toCID FROM lgcGlyphs WHERE pwid IS NOT NULL AND ital IS NOT NULL
UNION SELECT 20 AS feat, rotHwid AS fromCID, rotPwid AS toCID FROM lgcGlyphs WHERE rotHwid IS NOT NULL AND rotPwid IS NOT NULL
UNION SELECT 20 AS feat, rotQwid AS fromCID, rotPwid AS toCID FROM lgcGlyphs WHERE rotQwid IS NOT NULL AND rotPwid IS NOT NULL
UNION SELECT 20 AS feat, rotTwid AS fromCID, rotPwid AS toCID FROM lgcGlyphs WHERE rotTwid IS NOT NULL AND rotPwid IS NOT NULL
UNION SELECT 21 AS feat, rotPwid AS fromCID, rotHwid AS toCID FROM lgcGlyphs WHERE rotPwid IS NOT NULL AND rotHwid IS NOT NULL
UNION SELECT 21 AS feat, rotQwid AS fromCID, rotHwid AS toCID FROM lgcGlyphs WHERE rotQwid IS NOT NULL AND rotHwid IS NOT NULL
UNION SELECT 21 AS feat, rotTwid AS fromCID, rotHwid AS toCID FROM lgcGlyphs WHERE rotTwid IS NOT NULL AND rotHwid IS NOT NULL
UNION SELECT 22 AS feat, rotPwid AS fromCID, rotQwid AS toCID FROM lgcGlyphs WHERE rotPwid IS NOT NULL AND rotQwid IS NOT NULL
UNION SELECT 22 AS feat, rotHwid AS fromCID, rotQwid AS toCID FROM lgcGlyphs WHERE rotHwid IS NOT NULL AND rotQwid IS NOT NULL
UNION SELECT 22 AS feat, rotTwid AS fromCID, rotQwid AS toCID FROM lgcGlyphs WHERE rotTwid IS NOT NULL AND rotQwid IS NOT NULL
UNION SELECT 23 AS feat, rotPwid AS fromCID, rotTwid AS toCID FROM lgcGlyphs WHERE rotPwid IS NOT NULL AND rotTwid IS NOT NULL
UNION SELECT 23 AS feat, rotHwid AS fromCID, rotTwid AS toCID FROM lgcGlyphs WHERE rotHwid IS NOT NULL AND rotTwid IS NOT NULL
UNION SELECT 23 AS feat, rotQwid AS fromCID, rotTwid AS toCID FROM lgcGlyphs WHERE rotQwid IS NOT NULL AND rotTwid IS NOT NULL
UNION SELECT 30 AS feat, rotPwid AS fromCID, rotItal AS toCID FROM lgcGlyphs WHERE rotPwid IS NOT NULL AND rotItal IS NOT NULL
UNION SELECT 21 AS feat, horizontalFull AS fromCID, horizontalHalf AS toCID FROM kana WHERE horizontalFull IS NOT NULL AND horizontalHalf IS NOT NULL
UNION SELECT 21 AS feat, verticalFull AS fromCID, verticalHalf AS toCID FROM kana WHERE verticalFull IS NOT NULL AND verticalHalf IS NOT NULL
UNION SELECT 24 AS feat, horizontalHalf AS fromCID, horizontalFull AS toCID FROM kana WHERE horizontalHalf IS NOT NULL AND horizontalFull IS NOT NULL
UNION SELECT 24 AS feat, verticalHalf AS fromCID, verticalFull AS toCID FROM kana WHERE verticalHalf IS NOT NULL AND verticalFull IS NOT NULL
UNION SELECT 20 AS feat, diagonal AS fromCID, pwid AS toCID FROM fractions WHERE diagonal IS NOT NULL AND pwid IS NOT NULL
UNION SELECT 20 AS feat, stacked AS fromCID, pwid AS toCID FROM fractions WHERE stacked IS NOT NULL AND pwid IS NOT NULL
UNION SELECT 24 AS feat, pwid AS stacked, pwid AS toCID FROM fractions WHERE pwid IS NOT NULL AND stacked IS NOT NULL
UNION SELECT 35 AS feat, fromCID, toCID FROM zero WHERE fromCID IS NOT NULL AND toCID IS NOT NULL
UNION SELECT 36 AS feat, fromCID, toCID FROM salt WHERE fromCID IS NOT NULL AND toCID IS NOT NULL
UNION SELECT 50 AS feat, j90 AS fromCID, j83 AS toCID FROM jVars WHERE j90 IS NOT NULL AND j83 IS NOT NULL
UNION SELECT 50 AS feat, j04 AS fromCID, j83 AS toCID FROM jVars WHERE j04 IS NOT NULL AND j83 IS NOT NULL
UNION SELECT 51 AS feat, j90 AS fromCID, j04 AS toCID FROM jVars WHERE j90 IS NOT NULL AND j04 IS NOT NULL
UNION SELECT 51 AS feat, j83 AS fromCID, j04 AS toCID FROM jVars WHERE j83 IS NOT NULL AND j04 IS NOT NULL
UNION SELECT 52 AS feat, j83 AS fromCID, j90 AS toCID FROM jVars WHERE j83 IS NOT NULL AND j90 IS NOT NULL
UNION SELECT 52 AS feat, j04 AS fromCID, j90 AS toCID FROM jVars WHERE j04 IS NOT NULL AND j90 IS NOT NULL
UNION SELECT 53 AS feat, j90 AS fromCID, j04 AS toCID FROM jVars WHERE j90 IS NOT NULL AND j04 IS NOT NULL AND j04 >= 19132 AND j04 <= 20296
UNION SELECT 53 AS feat, j83 AS fromCID, j04 AS toCID FROM jVars WHERE j83 IS NOT NULL AND j04 IS NOT NULL AND j04 >= 19132 AND j04 <= 20296
UNION SELECT 60 AS feat, fromCID, toCID FROM sups WHERE fromCID IS NOT NULL AND toCID IS NOT NULL
UNION SELECT 61 AS feat, fromCID, toCID FROM subs WHERE fromCID IS NOT NULL AND toCID IS NOT NULL
ORDER BY feat, fromCID;
CREATE TABLE compositeCID (ligature INTEGER PRIMARY KEY NOT NULL, part1 INTEGER NOT NULL, part2 INTEGER NOT NULL, part3 INTEGER, part4 INTEGER CHECK(part3 IS NOT NULL OR part4 IS NULL));
INSERT INTO compositeCID VALUES(15856, 15855, 15851, NULL, NULL);
INSERT INTO compositeCID VALUES(15857, 15851, 15855, NULL, NULL);
INSERT INTO compositeCID VALUES(16209, 852, 16327, NULL, NULL);
INSERT INTO compositeCID VALUES(16210, 854, 16327, NULL, NULL);
INSERT INTO compositeCID VALUES(16211, 856, 16327, NULL, NULL);
INSERT INTO compositeCID VALUES(16212, 858, 16327, NULL, NULL);
INSERT INTO compositeCID VALUES(16213, 860, 16327, NULL, NULL);
INSERT INTO compositeCID VALUES(16214, 935, 16327, NULL, NULL);
INSERT INTO compositeCID VALUES(16215, 937, 16327, NULL, NULL);
INSERT INTO compositeCID VALUES(16216, 939, 16327, NULL, NULL);
INSERT INTO compositeCID VALUES(16217, 941, 16327, NULL, NULL);
INSERT INTO compositeCID VALUES(16218, 943, 16327, NULL, NULL);
INSERT INTO compositeCID VALUES(16219, 951, 16327, NULL, NULL);
INSERT INTO compositeCID VALUES(16220, 960, 16327, NULL, NULL);
INSERT INTO compositeCID VALUES(16221, 964, 16327, NULL, NULL);
INSERT INTO compositeCID VALUES(16246, 16243, 16327, NULL, NULL);
CREATE TABLE lig2 (glyphName TEXT PRIMARY KEY NOT NULL, src1 TEXT NOT NULL, src2 TEXT NOT NULL, CID INTEGER, ital INTEGER);
INSERT INTO lig2 VALUES('zerozero', 'zero', 'zero', 20749, 20589);
INSERT INTO lig2 VALUES('zeroone', 'zero', 'one', 20750, 20590);
INSERT INTO lig2 VALUES('zerotwo', 'zero', 'two', 20751, 20591);
INSERT INTO lig2 VALUES('zerothree', 'zero', 'three', 20752, 20592);
INSERT INTO lig2 VALUES('zerofour', 'zero', 'four', 20753, 20593);
INSERT INTO lig2 VALUES('zerofive', 'zero', 'five', 20754, 20594);
INSERT INTO lig2 VALUES('zerosix', 'zero', 'six', 20755, 20595);
INSERT INTO lig2 VALUES('zeroseven', 'zero', 'seven', 20756, 20596);
INSERT INTO lig2 VALUES('zeroeight', 'zero', 'eight', 20757, 20597);
INSERT INTO lig2 VALUES('zeronine', 'zero', 'nine', 20758, 20598);
INSERT INTO lig2 VALUES('ten', 'one', 'zero', 20759, 20599);
INSERT INTO lig2 VALUES('eleven', 'one', 'one', 20760, 20600);
INSERT INTO lig2 VALUES('twelve', 'one', 'two', 20761, 20601);
INSERT INTO lig2 VALUES('thirteen', 'one', 'three', 20762, 20602);
INSERT INTO lig2 VALUES('fourteen', 'one', 'four', 20763, 20603);
INSERT INTO lig2 VALUES('fifteen', 'one', 'five', 20764, 20604);
INSERT INTO lig2 VALUES('sixteen', 'one', 'six', 20765, 20605);
INSERT INTO lig2 VALUES('seventeen', 'one', 'seven', 20766, 20606);
INSERT INTO lig2 VALUES('eighteen', 'one', 'eight', 20767, 20607);
INSERT INTO lig2 VALUES('nineteen', 'one', 'nine', 20768, 20608);
INSERT INTO lig2 VALUES('twenty', 'two', 'zero', 20769, 20609);
INSERT INTO lig2 VALUES('twentyone', 'two', 'one', 20770, 20610);
INSERT INTO lig2 VALUES('twentytwo', 'two', 'two', 20771, 20611);
INSERT INTO lig2 VALUES('twentythree', 'two', 'three', 20772, 20612);
INSERT INTO lig2 VALUES('twentyfour', 'two', 'four', 20773, 20613);
INSERT INTO lig2 VALUES('twentyfive', 'two', 'five', 20774, 20614);
INSERT INTO lig2 VALUES('twentysix', 'two', 'six', 20775, 20615);
INSERT INTO lig2 VALUES('twentyseven', 'two', 'seven', 20776, 20616);
INSERT INTO lig2 VALUES('twentyeight', 'two', 'eight', 20777, 20617);
INSERT INTO lig2 VALUES('twentynine', 'two', 'nine', 20778, 20618);
INSERT INTO lig2 VALUES('thirty', 'three', 'zero', 20779, 20619);
INSERT INTO lig2 VALUES('thirtyone', 'three', 'one', 20780, 20620);
INSERT INTO lig2 VALUES('thirtytwo', 'three', 'two', 20781, 20621);
INSERT INTO lig2 VALUES('thirtythree', 'three', 'three', 20782, 20622);
INSERT INTO lig2 VALUES('thirtyfour', 'three', 'four', 20783, 20623);
INSERT INTO lig2 VALUES('thirtyfive', 'three', 'five', 20784, 20624);
INSERT INTO lig2 VALUES('thirtysix', 'three', 'six', 20785, 20625);
INSERT INTO lig2 VALUES('thirtyseven', 'three', 'seven', 20786, 20626);
INSERT INTO lig2 VALUES('thirtyeight', 'three', 'eight', 20787, 20627);
INSERT INTO lig2 VALUES('thirtynine', 'three', 'nine', 20788, 20628);
INSERT INTO lig2 VALUES('forty', 'four', 'zero', 20789, 20629);
INSERT INTO lig2 VALUES('fortyone', 'four', 'one', 20790, 20630);
INSERT INTO lig2 VALUES('fortytwo', 'four', 'two', 20791, 20631);
INSERT INTO lig2 VALUES('fortythree', 'four', 'three', 20792, 20632);
INSERT INTO lig2 VALUES('fortyfour', 'four', 'four', 20793, 20633);
INSERT INTO lig2 VALUES('fortyfive', 'four', 'five', 20794, 20634);
INSERT INTO lig2 VALUES('fortysix', 'four', 'six', 20795, 20635);
INSERT INTO lig2 VALUES('fortyseven', 'four', 'seven', 20796, 20636);
INSERT INTO lig2 VALUES('fortyeight', 'four', 'eight', 20797, 20637);
INSERT INTO lig2 VALUES('fortynine', 'four', 'nine', 20798, 20638);
INSERT INTO lig2 VALUES('fifty', 'five', 'zero', 20799, 20639);
INSERT INTO lig2 VALUES('fiftyone', 'five', 'one', 20800, 20640);
INSERT INTO lig2 VALUES('fiftytwo', 'five', 'two', 20801, 20641);
INSERT INTO lig2 VALUES('fiftythree', 'five', 'three', 20802, 20642);
INSERT INTO lig2 VALUES('fiftyfour', 'five', 'four', 20803, 20643);
INSERT INTO lig2 VALUES('fiftyfive', 'five', 'five', 20804, 20644);
INSERT INTO lig2 VALUES('fiftysix', 'five', 'six', 20805, 20645);
INSERT INTO lig2 VALUES('fiftyseven', 'five', 'seven', 20806, 20646);
INSERT INTO lig2 VALUES('fiftyeight', 'five', 'eight', 20807, 20647);
INSERT INTO lig2 VALUES('fiftynine', 'five', 'nine', 20808, 20648);
INSERT INTO lig2 VALUES('sixty', 'six', 'zero', 20809, NULL);
INSERT INTO lig2 VALUES('sixtyone', 'six', 'one', 20810, NULL);
INSERT INTO lig2 VALUES('sixtytwo', 'six', 'two', 20811, NULL);
INSERT INTO lig2 VALUES('sixtythree', 'six', 'three', 20812, NULL);
INSERT INTO lig2 VALUES('sixtyfour', 'six', 'four', 20813, NULL);
INSERT INTO lig2 VALUES('sixtyfive', 'six', 'five', 20814, NULL);
INSERT INTO lig2 VALUES('sixtysix', 'six', 'six', 20815, NULL);
INSERT INTO lig2 VALUES('sixtyseven', 'six', 'seven', 20816, NULL);
INSERT INTO lig2 VALUES('sixtyeight', 'six', 'eight', 20817, NULL);
INSERT INTO lig2 VALUES('sixtynine', 'six', 'nine', 20818, NULL);
INSERT INTO lig2 VALUES('seventy', 'seven', 'zero', 20819, NULL);
INSERT INTO lig2 VALUES('seventyone', 'seven', 'one', 20820, NULL);
INSERT INTO lig2 VALUES('seventytwo', 'seven', 'two', 20821, NULL);
INSERT INTO lig2 VALUES('seventythree', 'seven', 'three', 20822, NULL);
INSERT INTO lig2 VALUES('seventyfour', 'seven', 'four', 20823, NULL);
INSERT INTO lig2 VALUES('seventyfive', 'seven', 'five', 20824, NULL);
INSERT INTO lig2 VALUES('seventysix', 'seven', 'six', 20825, NULL);
INSERT INTO lig2 VALUES('seventyseven', 'seven', 'seven', 20826, NULL);
INSERT INTO lig2 VALUES('seventyeight', 'seven', 'eight', 20827, NULL);
INSERT INTO lig2 VALUES('seventynine', 'seven', 'nine', 20828, NULL);
INSERT INTO lig2 VALUES('eighty', 'eight', 'zero', 20829, NULL);
INSERT INTO lig2 VALUES('eightyone', 'eight', 'one', 20830, NULL);
INSERT INTO lig2 VALUES('eightytwo', 'eight', 'two', 20831, NULL);
INSERT INTO lig2 VALUES('eightythree', 'eight', 'three', 20832, NULL);
INSERT INTO lig2 VALUES('eightyfour', 'eight', 'four', 20833, NULL);
INSERT INTO lig2 VALUES('eightyfive', 'eight', 'five', 20834, NULL);
INSERT INTO lig2 VALUES('eightysix', 'eight', 'six', 20835, NULL);
INSERT INTO lig2 VALUES('eightyseven', 'eight', 'seven', 20836, NULL);
INSERT INTO lig2 VALUES('eightyeight', 'eight', 'eight', 20837, NULL);
INSERT INTO lig2 VALUES('eightynine', 'eight', 'nine', 20838, NULL);
INSERT INTO lig2 VALUES('ninety', 'nine', 'zero', 20839, NULL);
INSERT INTO lig2 VALUES('ninetyone', 'nine', 'one', 20840, NULL);
INSERT INTO lig2 VALUES('ninetytwo', 'nine', 'two', 20841, NULL);
INSERT INTO lig2 VALUES('ninetythree', 'nine', 'three', 20842, NULL);
INSERT INTO lig2 VALUES('ninetyfour', 'nine', 'four', 20843, NULL);
INSERT INTO lig2 VALUES('ninetyfive', 'nine', 'five', 20844, NULL);
INSERT INTO lig2 VALUES('ninetysix', 'nine', 'six', 20845, NULL);
INSERT INTO lig2 VALUES('ninetyseven', 'nine', 'seven', 20846, NULL);
INSERT INTO lig2 VALUES('ninetyeight', 'nine', 'eight', 20847, NULL);
INSERT INTO lig2 VALUES('ninetynine', 'nine', 'nine', 20848, NULL);
INSERT INTO lig2 VALUES('十一', '十', '一', NULL, NULL);
INSERT INTO lig2 VALUES('十二', '十', '二', NULL, NULL);
INSERT INTO lig2 VALUES('十三', '十', '三', NULL, NULL);
INSERT INTO lig2 VALUES('十四', '十', '四', NULL, NULL);
INSERT INTO lig2 VALUES('十五', '十', '五', NULL, NULL);
INSERT INTO lig2 VALUES('十六', '十', '六', NULL, NULL);
INSERT INTO lig2 VALUES('十七', '十', '七', NULL, NULL);
INSERT INTO lig2 VALUES('十八', '十', '八', NULL, NULL);
INSERT INTO lig2 VALUES('十九', '十', '九', NULL, NULL);
INSERT INTO lig2 VALUES('二十', '二', '十', NULL, NULL);
INSERT INTO lig2 VALUES('ほか', 'ほ', 'か', NULL, NULL);
INSERT INTO lig2 VALUES('PV', 'P', 'V', NULL, NULL);
INSERT INTO lig2 VALUES('MV', 'M', 'V', NULL, NULL);
INSERT INTO lig2 VALUES('SS', 'S', 'S', NULL, NULL);
INSERT INTO lig2 VALUES('S1', 'S', 'one', NULL, NULL);
INSERT INTO lig2 VALUES('S2', 'S', 'two', NULL, NULL);
INSERT INTO lig2 VALUES('S3', 'S', 'three', NULL, NULL);
INSERT INTO lig2 VALUES('HV', 'H', 'V', NULL, NULL);
INSERT INTO lig2 VALUES('CL', 'C', 'L', NULL, NULL);
INSERT INTO lig2 VALUES('AS', 'A', 'S', NULL, NULL);
INSERT INTO lig2 VALUES('AM', 'A', 'M', NULL, NULL);
CREATE TABLE lig3 (glyphName TEXT PRIMARY KEY NOT NULL, src1 TEXT NOT NULL, src2 TEXT NOT NULL, src3 TEXT NOT NULL, CID INTEGER);
INSERT INTO lig3 VALUES('hundred', 'one', 'zero', 'zero', 20849);
INSERT INTO lig3 VALUES('KCL', 'K', 'C', 'L', NULL);
INSERT INTO lig3 VALUES('BEL', 'B', 'E', 'L', NULL);
CREATE TABLE ligatureCID (CID INTEGER PRIMARY KEY NOT NULL, src1 INTEGER NOT NULL, src2 INTEGER NOT NULL, src3 INTEGER);
INSERT INTO ligatureCID VALUES(112, 71, 74, NULL); -- fi
INSERT INTO ligatureCID VALUES(113, 71, 77, NULL); -- fl
INSERT INTO ligatureCID VALUES(9358, 71, 71, NULL); -- ff
INSERT INTO ligatureCID VALUES(9359, 71, 71, 74); -- ffi
INSERT INTO ligatureCID VALUES(9360, 71, 71, 77); -- ffl
INSERT INTO ligatureCID VALUES(20959, 7888, 7912, NULL);
INSERT INTO ligatureCID VALUES(20960, 7888, 7914, NULL);
CREATE TABLE enclosed (glyphName TEXT PRIMARY KEY NOT NULL, parenthesis INTEGER, circle INTEGER, circleRev INTEGER, square INTEGER, squareRev INTEGER, roundSquare INTEGER, roundSquareRev INTEGER, squareDashed INTEGER, dotAfter INTEGER, circleDbl INTEGER);
INSERT INTO enclosed VALUES('zero', 8227, 8224, 10503, 10764, 11037, 11307, 11576, NULL, 8061, NULL);
INSERT INTO enclosed VALUES('one', 8071, 7555, 8286, 10766, 11039, 11309, 11578, NULL, 8062, 16223);
INSERT INTO enclosed VALUES('two', 8072, 7556, 8287, 10768, 11041, 11311, 11580, NULL, 8063, 16224);
INSERT INTO enclosed VALUES('three', 8073, 7557, 8288, 10770, 11043, 11313, 11582, NULL, 8064, 16225);
INSERT INTO enclosed VALUES('four', 8074, 7558, 8289, 10772, 11045, 11315, 11584, NULL, 8065, 16226);
INSERT INTO enclosed VALUES('five', 8075, 7559, 8290, 10774, 11047, 11317, 11586, NULL, 8066, 16227);
INSERT INTO enclosed VALUES('six', 8076, 7560, 8291, 10776, 11049, 11319, 11588, NULL, 8067, 16228);
INSERT INTO enclosed VALUES('seven', 8077, 7561, 8292, 10778, 11051, 11321, 11590, NULL, 8068, 16229);
INSERT INTO enclosed VALUES('eight', 8078, 7562, 8293, 10780, 11053, 11323, 11592, NULL, 8069, 16230);
INSERT INTO enclosed VALUES('nine', 8079, 7563, 8294, 10782, 11055, 11325, 11594, NULL, 8070, 16231);
INSERT INTO enclosed VALUES('zerozero', 9884, 10234, 10504, 10765, 11038, 11308, 11577, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('zeroone', 9885, 10235, 10505, 10767, 11040, 11310, 11579, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('zerotwo', 9886, 10236, 10506, 10769, 11042, 11312, 11581, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('zerothree', 9887, 10237, 10507, 10771, 11044, 11314, 11583, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('zerofour', 9888, 10238, 10508, 10773, 11046, 11316, 11585, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('zerofive', 9889, 10239, 10509, 10775, 11048, 11318, 11587, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('zerosix', 9890, 10240, 10510, 10777, 11050, 11320, 11589, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('zeroseven', 9891, 10241, 10511, 10779, 11052, 11322, 11591, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('zeroeight', 9892, 10242, 10512, 10781, 11054, 11324, 11593, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('zeronine', 9893, 10243, 10513, 10783, 11056, 11326, 11595, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ten', 8080, 7564, 10514, 10784, 11057, 11327, 11596, NULL, 20587, 16232);
INSERT INTO enclosed VALUES('eleven', 8081, 7565, 10515, 10785, 11058, 11328, 11597, NULL, 20588, NULL);
INSERT INTO enclosed VALUES('twelve', 8082, 7566, 10516, 10786, 11059, 11329, 11598, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('thirteen', 8083, 7567, 10517, 10787, 11060, 11330, 11599, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fourteen', 8084, 7568, 10518, 10788, 11061, 11331, 11600, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fifteen', 8085, 7569, 10519, 10789, 11062, 11332, 11601, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('sixteen', 8086, 7570, 10520, 10790, 11063, 11333, 11602, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('seventeen', 8087, 7571, 10521, 10791, 11064, 11334, 11603, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('eighteen', 8088, 7572, 10522, 10792, 11065, 11335, 11604, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('nineteen', 8089, 7573, 10523, 10793, 11066, 11336, 11605, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('twenty', 8090, 7574, 10524, 10794, 11067, 11337, 11606, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('twentyone', 9894, 8091, 10525, 10795, 11068, 11338, 11607, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('twentytwo', 9895, 8102, 10526, 10796, 11069, 11339, 11608, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('twentythree', 9896, 8103, 10527, 10797, 11070, 11340, 11609, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('twentyfour', 9897, 8104, 10528, 10798, 11071, 11341, 11610, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('twentyfive', 9898, 8105, 10529, 10799, 11072, 11342, 11611, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('twentysix', 9899, 8106, 10530, 10800, 11073, 11343, 11612, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('twentyseven', 9900, 8107, 10531, 10801, 11074, 11344, 11613, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('twentyeight', 9901, 8108, 10532, 10802, 11075, 11345, 11614, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('twentynine', 9902, 8109, 10533, 10803, 11076, 11346, 11615, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('thirty', 9903, 8110, 10534, 10804, 11077, 11347, 11616, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('thirtyone', 9904, 8111, 10535, 10805, 11078, 11348, 11617, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('thirtytwo', 9905, 10244, 10536, 10806, 11079, 11349, 11618, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('thirtythree', 9906, 10245, 10537, 10807, 11080, 11350, 11619, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('thirtyfour', 9907, 10246, 10538, 10808, 11081, 11351, 11620, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('thirtyfive', 9908, 10247, 10539, 10809, 11082, 11352, 11621, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('thirtysix', 9909, 10248, 10540, 10810, 11083, 11353, 11622, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('thirtyseven', 9910, 10249, 10541, 10811, 11084, 11354, 11623, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('thirtyeight', 9911, 10250, 10542, 10812, 11085, 11355, 11624, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('thirtynine', 9912, 10251, 10543, 10813, 11086, 11356, 11625, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('forty', 9913, 10252, 10544, 10814, 11087, 11357, 11626, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fortyone', 9914, 10253, 10545, 10815, 11088, 11358, 11627, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fortytwo', 9915, 10254, 10546, 10816, 11089, 11359, 11628, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fortythree', 9916, 10255, 10547, 10817, 11090, 11360, 11629, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fortyfour', 9917, 10256, 10548, 10818, 11091, 11361, 11630, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fortyfive', 9918, 10257, 10549, 10819, 11092, 11362, 11631, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fortysix', 9919, 10258, 10550, 10820, 11093, 11363, 11632, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fortyseven', 9920, 10259, 10551, 10821, 11094, 11364, 11633, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fortyeight', 9921, 10260, 10552, 10822, 11095, 11365, 11634, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fortynine', 9922, 10261, 10553, 10823, 11096, 11366, 11635, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fifty', 9923, 10262, 10554, 10824, 11097, 11367, 11636, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fiftyone', 9924, 10263, 10555, 10825, 11098, 11368, 11637, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fiftytwo', 9925, 10264, 10556, 10826, 11099, 11369, 11638, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fiftythree', 9926, 10265, 10557, 10827, 11100, 11370, 11639, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fiftyfour', 9927, 10266, 10558, 10828, 11101, 11371, 11640, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fiftyfive', 9928, 10267, 10559, 10829, 11102, 11372, 11641, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fiftysix', 9929, 10268, 10560, 10830, 11103, 11373, 11642, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fiftyseven', 9930, 10269, 10561, 10831, 11104, 11374, 11643, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fiftyeight', 9931, 10270, 10562, 10832, 11105, 11375, 11644, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('fiftynine', 9932, 10271, 10563, 10833, 11106, 11376, 11645, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('sixty', 9933, 10272, 10564, 10834, 11107, 11377, 11646, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('sixtyone', 9934, 10273, 10565, 10835, 11108, 11378, 11647, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('sixtytwo', 9935, 10274, 10566, 10836, 11109, 11379, 11648, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('sixtythree', 9936, 10275, 10567, 10837, 11110, 11380, 11649, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('sixtyfour', 9937, 10276, 10568, 10838, 11111, 11381, 11650, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('sixtyfive', 9938, 10277, 10569, 10839, 11112, 11382, 11651, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('sixtysix', 9939, 10278, 10570, 10840, 11113, 11383, 11652, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('sixtyseven', 9940, 10279, 10571, 10841, 11114, 11384, 11653, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('sixtyeight', 9941, 10280, 10572, 10842, 11115, 11385, 11654, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('sixtynine', 9942, 10281, 10573, 10843, 11116, 11386, 11655, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('seventy', 9943, 10282, 10574, 10844, 11117, 11387, 11656, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('seventyone', 9944, 10283, 10575, 10845, 11118, 11388, 11657, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('seventytwo', 9945, 10284, 10576, 10846, 11119, 11389, 11658, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('seventythree', 9946, 10285, 10577, 10847, 11120, 11390, 11659, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('seventyfour', 9947, 10286, 10578, 10848, 11121, 11391, 11660, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('seventyfive', 9948, 10287, 10579, 10849, 11122, 11392, 11661, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('seventysix', 9949, 10288, 10580, 10850, 11123, 11393, 11662, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('seventyseven', 9950, 10289, 10581, 10851, 11124, 11394, 11663, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('seventyeight', 9951, 10290, 10582, 10852, 11125, 11395, 11664, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('seventynine', 9952, 10291, 10583, 10853, 11126, 11396, 11665, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('eighty', 9953, 10292, 10584, 10854, 11127, 11397, 11666, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('eightyone', 9954, 10293, 10585, 10855, 11128, 11398, 11667, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('eightytwo', 9955, 10294, 10586, 10856, 11129, 11399, 11668, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('eightythree', 9956, 10295, 10587, 10857, 11130, 11400, 11669, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('eightyfour', 9957, 10296, 10588, 10858, 11131, 11401, 11670, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('eightyfive', 9958, 10297, 10589, 10859, 11132, 11402, 11671, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('eightysix', 9959, 10298, 10590, 10860, 11133, 11403, 11672, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('eightyseven', 9960, 10299, 10591, 10861, 11134, 11404, 11673, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('eightyeight', 9961, 10300, 10592, 10862, 11135, 11405, 11674, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('eightynine', 9962, 10301, 10593, 10863, 11136, 11406, 11675, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ninety', 9963, 10302, 10594, 10864, 11137, 11407, 11676, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ninetyone', 9964, 10303, 10595, 10865, 11138, 11408, 11677, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ninetytwo', 9965, 10304, 10596, 10866, 11139, 11409, 11678, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ninetythree', 9966, 10305, 10597, 10867, 11140, 11410, 11679, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ninetyfour', 9967, 10306, 10598, 10868, 11141, 11411, 11680, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ninetyfive', 9968, 10307, 10599, 10869, 11142, 11412, 11681, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ninetysix', 9969, 10308, 10600, 10870, 11143, 11413, 11682, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ninetyseven', 9970, 10309, 10601, 10871, 11144, 11414, 11683, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ninetyeight', 9971, 10310, 10602, 10872, 11145, 11415, 11684, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ninetynine', 9972, 10311, 10603, 10873, 11146, 11416, 11685, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('hundred', 9973, 10312, 10604, 10874, 11147, 11417, 11686, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('unus', 9974, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('duo', 9975, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('tres', 9976, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('quattuor', 9977, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('quinque', 9978, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('sex', 9979, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('septem', 9980, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('octo', 9981, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('novem', 9982, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('decem', 9983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('undecim', 9984, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('duodecim', 9985, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('tredecim', 9986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('quattuordecim', 9987, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('quindecim', 9988, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Unus', 9989, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Duo', 9990, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Tres', 9991, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Quattuor', 9992, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Quinque', 9993, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Sex', 9994, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Septem', 9995, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Octo', 9996, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Novem', 9997, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Decem', 9998, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Undecim', 9999, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Duodecim', 10000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Tredecim', 10001, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Quattuordecim', 10002, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Quindecim', 10003, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('a', 8112, 10313, 10605, 10875, 11148, 11418, 11687, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('b', 8113, 10314, 10606, 10876, 11149, 11419, 11688, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('c', 8114, 10315, 10607, 10877, 11150, 11420, 11689, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('d', 8115, 10316, 10608, 10878, 11151, 11421, 11690, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('e', 8116, 10317, 10609, 10879, 11152, 11422, 11691, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('f', 8117, 10318, 10610, 10880, 11153, 11423, 11692, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('g', 8118, 10319, 10611, 10881, 11154, 11424, 11693, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('h', 8119, 10320, 10612, 10882, 11155, 11425, 11694, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('i', 8120, 10321, 10613, 10883, 11156, 11426, 11695, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('j', 8121, 10322, 10614, 10884, 11157, 11427, 11696, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('k', 8122, 10323, 10615, 10885, 11158, 11428, 11697, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('l', 8123, 10324, 10616, 10886, 11159, 11429, 11698, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('m', 8124, 10325, 10617, 10887, 11160, 11430, 11699, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('n', 8125, 10326, 10618, 10888, 11161, 11431, 11700, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('o', 8126, 10327, 10619, 10889, 11162, 11432, 11701, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('p', 8127, 10328, 10620, 10890, 11163, 11433, 11702, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('q', 8128, 10329, 10621, 10891, 11164, 11434, 11703, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('r', 8129, 10330, 10622, 10892, 11165, 11435, 11704, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('s', 8130, 10331, 10623, 10893, 11166, 11436, 11705, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('t', 8131, 10332, 10624, 10894, 11167, 11437, 11706, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('u', 8132, 10333, 10625, 10895, 11168, 11438, 11707, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('v', 8133, 10334, 10626, 10896, 11169, 11439, 11708, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('w', 8134, 10335, 10627, 10897, 11170, 11440, 11709, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('x', 8135, 10336, 10628, 10898, 11171, 11441, 11710, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('y', 8136, 10337, 10629, 10899, 11172, 11442, 11711, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('z', 8137, 10338, 10630, 10900, 11173, 11443, 11712, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('A', 10004, 10339, 10631, 10901, 11174, 11444, 11713, 20497, NULL, NULL);
INSERT INTO enclosed VALUES('B', 10005, 10340, 10632, 10902, 11175, 11445, 11714, 20498, NULL, NULL);
INSERT INTO enclosed VALUES('C', 10006, 10341, 10633, 10903, 11176, 11446, 11715, 20499, NULL, NULL);
INSERT INTO enclosed VALUES('D', 10007, 10342, 10634, 10904, 11177, 11447, 11716, 20500, NULL, NULL);
INSERT INTO enclosed VALUES('E', 10008, 10343, 10635, 10905, 11178, 11448, 11717, 20501, NULL, NULL);
INSERT INTO enclosed VALUES('F', 10009, 10344, 10636, 10906, 11179, 11449, 11718, 20502, NULL, NULL);
INSERT INTO enclosed VALUES('G', 10010, 10345, 10637, 10907, 11180, 11450, 11719, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('H', 10011, 10346, 10638, 10908, 11181, 11451, 11720, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('I', 10012, 10347, 10639, 10909, 11182, 11452, 11721, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('J', 10013, 10348, 10640, 10910, 11183, 11453, 11722, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('K', 10014, 10349, 10641, 10911, 11184, 11454, 11723, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('L', 10015, 10350, 10642, 10912, 11185, 11455, 11724, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('M', 10016, 10351, 10643, 10913, 11186, 11456, 11725, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('N', 10017, 10352, 10644, 10914, 11187, 11457, 11726, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('O', 10018, 10353, 10645, 10915, 11188, 11458, 11727, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('P', 10019, 10354, 10646, 10916, 11189, 11459, 11728, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Q', 10020, 10355, 10647, 10917, 11190, 11460, 11729, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('R', 10021, 10356, 10648, 10918, 11191, 11461, 11730, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('S', 10022, 10357, 10649, 10919, 11192, 11462, 11731, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('T', 10023, 10358, 10650, 10920, 11193, 11463, 11732, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('U', 10024, 10359, 10651, 10921, 11194, 11464, 11733, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('V', 10025, 10360, 10652, 10922, 11195, 11465, 11734, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('W', 10026, 10361, 10653, 10923, 11196, 11466, 11735, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('X', 10027, 10362, 10654, 10924, 11197, 11467, 11736, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Y', 10028, 10363, 10655, 10925, 11198, 11468, 11737, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('Z', 10029, 10364, 10656, 10926, 11199, 11469, 11738, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('あ', 10030, 10365, 10657, 10927, 11200, 11470, 11739, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('い', 10031, 10366, 10658, 10928, 11201, 11471, 11740, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('う', 10032, 10367, 10659, 10929, 11202, 11472, 11741, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('え', 10033, 10368, 10660, 10930, 11203, 11473, 11742, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('お', 10034, 10369, 10661, 10931, 11204, 11474, 11743, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('か', 10035, 10370, 10662, 10932, 11205, 11475, 11744, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('き', 10036, 10371, 10663, 10933, 11206, 11476, 11745, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('く', 10037, 10372, 10664, 10934, 11207, 11477, 11746, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('け', 10038, 10373, 10665, 10935, 11208, 11478, 11747, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('こ', 10039, 10374, 10666, 10936, 11209, 11479, 11748, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('さ', 10040, 10375, 10667, 10937, 11210, 11480, 11749, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('し', 10041, 10376, 10668, 10938, 11211, 11481, 11750, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('す', 10042, 10377, 10669, 10939, 11212, 11482, 11751, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('せ', 10043, 10378, 10670, 10940, 11213, 11483, 11752, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('そ', 10044, 10379, 10671, 10941, 11214, 11484, 11753, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('た', 10045, 10380, 10672, 10942, 11215, 11485, 11754, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ち', 10046, 10381, 10673, 10943, 11216, 11486, 11755, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('つ', 10047, 10382, 10674, 10944, 11217, 11487, 11756, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('て', 10048, 10383, 10675, 10945, 11218, 11488, 11757, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('と', 10049, 10384, 10676, 10946, 11219, 11489, 11758, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('な', 10050, 10385, 10677, 10947, 11220, 11490, 11759, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('に', 10051, 10386, 10678, 10948, 11221, 11491, 11760, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ぬ', 10052, 10387, 10679, 10949, 11222, 11492, 11761, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ね', 10053, 10388, 10680, 10950, 11223, 11493, 11762, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('の', 10054, 10389, 10681, 10951, 11224, 11494, 11763, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('は', 10055, 10390, 10682, 10952, 11225, 11495, 11764, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ひ', 10056, 10391, 10683, 10953, 11226, 11496, 11765, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ふ', 10057, 10392, 10684, 10954, 11227, 11497, 11766, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('へ', 10058, 10393, 10685, 10955, 11228, 11498, 11767, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ほ', 10059, 10394, 10686, 10956, 11229, 11499, 11768, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ま', 10060, 10395, 10687, 10957, 11230, 11500, 11769, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('み', 10061, 10396, 10688, 10958, 11231, 11501, 11770, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('む', 10062, 10397, 10689, 10959, 11232, 11502, 11771, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('め', 10063, 10398, 10690, 10960, 11233, 11503, 11772, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('も', 10064, 10399, 10691, 10961, 11234, 11504, 11773, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('や', 10065, 10400, 10692, 10962, 11235, 11505, 11774, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ゆ', 10066, 10401, 10693, 10963, 11236, 11506, 11775, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('よ', 10067, 10402, 10694, 10964, 11237, 11507, 11776, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ら', 10068, 10403, 10695, 10965, 11238, 11508, 11777, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('り', 10069, 10404, 10696, 10966, 11239, 11509, 11778, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('る', 10070, 10405, 10697, 10967, 11240, 11510, 11779, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('れ', 10071, 10406, 10698, 10968, 11241, 11511, 11780, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ろ', 10072, 10407, 10699, 10969, 11242, 11512, 11781, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('わ', 10073, 10408, 10700, 10970, 11243, 11513, 11782, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ゐ', 10074, 10409, 10701, 10971, 11244, 11514, 11783, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ゑ', 10075, 10410, 10702, 10972, 11245, 11515, 11784, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('を', 10076, 10411, 10703, 10973, 11246, 11516, 11785, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ん', 10077, 10412, 10704, 10974, 11247, 11517, 11786, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ア', 10078, 10413, 10705, 10975, 11248, 11518, 11787, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('イ', 10079, 10414, 10706, 10976, 11249, 11519, 11788, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ウ', 10080, 10415, 10707, 10977, 11250, 11520, 11789, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('エ', 10081, 10416, 10708, 10978, 11251, 11521, 11790, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('オ', 10082, 10417, 10709, 10979, 11252, 11522, 11791, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('カ', 10083, 10418, 10710, 10980, 11253, 11523, 11792, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('キ', 10084, 10419, 10711, 10981, 11254, 11524, 11793, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ク', 10085, 10420, 10712, 10982, 11255, 11525, 11794, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ケ', 10086, 10421, 10713, 10983, 11256, 11526, 11795, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('コ', 10087, 10422, 10714, 10984, 11257, 11527, 11796, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('サ', 10088, 10423, 10715, 10985, 11258, 11528, 11797, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('シ', 10089, 10424, 10716, 10986, 11259, 11529, 11798, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ス', 10090, 10425, 10717, 10987, 11260, 11530, 11799, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('セ', 10091, 10426, 10718, 10988, 11261, 11531, 11800, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ソ', 10092, 10427, 10719, 10989, 11262, 11532, 11801, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('タ', 10093, 10428, 10720, 10990, 11263, 11533, 11802, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('チ', 10094, 10429, 10721, 10991, 11264, 11534, 11803, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ツ', 10095, 10430, 10722, 10992, 11265, 11535, 11804, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('テ', 10096, 10431, 10723, 10993, 11266, 11536, 11805, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ト', 10097, 10432, 10724, 10994, 11267, 11537, 11806, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ナ', 10098, 10433, 10725, 10995, 11268, 11538, 11807, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ニ', 10099, 10434, 10726, 10996, 11269, 11539, 11808, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ヌ', 10100, 10435, 10727, 10997, 11270, 11540, 11809, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ネ', 10101, 10436, 10728, 10998, 11271, 11541, 11810, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ノ', 10102, 10437, 10729, 10999, 11272, 11542, 11811, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ハ', 10103, 10438, 10730, 11000, 11273, 11543, 11812, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ヒ', 10104, 10439, 10731, 11001, 11274, 11544, 11813, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('フ', 10105, 10440, 10732, 11002, 11275, 11545, 11814, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ヘ', 10106, 10441, 10733, 11003, 11276, 11546, 11815, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ホ', 10107, 10442, 10734, 11004, 11277, 11547, 11816, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('マ', 10108, 10443, 10735, 11005, 11278, 11548, 11817, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ミ', 10109, 10444, 10736, 11006, 11279, 11549, 11818, 20512, NULL, NULL);
INSERT INTO enclosed VALUES('ム', 10110, 10445, 10737, 11007, 11280, 11550, 11819, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('メ', 10111, 10446, 10738, 11008, 11281, 11551, 11820, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('モ', 10112, 10447, 10739, 11009, 11282, 11552, 11821, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ヤ', 10113, 10448, 10740, 11010, 11283, 11553, 11822, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ユ', 10114, 10449, 10741, 11011, 11284, 11554, 11823, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ヨ', 10115, 10450, 10742, 11012, 11285, 11555, 11824, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ラ', 10116, 10451, 10743, 11013, 11286, 11556, 11825, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('リ', 10117, 10452, 10744, 11014, 11287, 11557, 11826, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ル', 10118, 10453, 10745, 11015, 11288, 11558, 11827, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('レ', 10119, 10454, 10746, 11016, 11289, 11559, 11828, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ロ', 10120, 10455, 10747, 11017, 11290, 11560, 11829, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ワ', 10121, 10456, 10748, 11018, 11291, 11561, 11830, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ヰ', 10122, 10457, 10749, 11019, 11292, 11562, 11831, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ヱ', 10123, 10458, 10750, 11020, 11293, 11563, 11832, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ヲ', 10124, 10459, 10751, 11021, 11294, 11564, 11833, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ン', 10125, 10460, 10752, 11022, 11295, 11565, 11834, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('上', NULL, 7613, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('中', NULL, 7614, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('下', NULL, 7615, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('左', NULL, 7616, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('右', NULL, 7617, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('夜', NULL, 8152, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('至', 8138, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('企', 8139, 8153, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('医', NULL, 8154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('協', 8140, 8155, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('名', 8141, 8156, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('宗', NULL, 8157, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('労', 8142, 8158, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('学', 8149, 8159, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('祭', 8150, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('呼', 8151, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('有', NULL, 8160, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('株', NULL, 8161, NULL, NULL, NULL, 20569, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('社', 8143, 8162, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('監', 8144, 8163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('自', 8145, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('資', 8146, 8164, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('財', 8147, 8165, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('印', NULL, 8191, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('秘', NULL, 8223, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('大', NULL, 8317, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('小', NULL, 8318, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('優', NULL, 8319, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('控', NULL, 8320, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('一', 10126, 10461, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('二', 10127, 10462, NULL, NULL, NULL, 20571, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('三', 10128, 10463, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('四', 10129, 10464, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('五', 10130, 10465, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('六', 10131, 10466, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('七', 10132, 10467, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('八', 10133, 10468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('九', 10134, 10469, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('十', 10135, 10470, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('十一', 10136, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('十二', 10137, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('十三', 10138, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('十四', 10139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('十五', 10140, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('十六', 10141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('十七', 10142, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('十八', 10143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('十九', 10144, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('二十', 10145, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('日', 8197, 10471, 10753, 11023, 11296, 11566, 11835, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('月', 8198, 10472, 10754, 11024, 11297, 11567, 11836, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('火', 8199, 10473, 10755, 11025, 11298, 11568, 11837, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('水', 8200, 10474, 10756, 11026, 11299, 11569, 11838, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('木', 8201, 10475, 10757, 11027, 11300, 11570, 11839, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('金', 8202, 10476, 10758, 11028, 11301, 11571, 11840, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('土', 8203, 10477, 10759, 11029, 11302, 11572, 11841, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('営', 10146, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('合', 10147, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('調', NULL, 10478, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('注', 10148, 10479, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('副', NULL, 10480, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('減', NULL, 10481, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('標', NULL, 10482, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('欠', NULL, 10483, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('基', NULL, 10484, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('禁', NULL, 10485, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('項', NULL, 10486, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('休', 8205, 10487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('女', NULL, 10488, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('男', NULL, 10489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('正', NULL, 10490, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('写', NULL, 10491, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('祝', 8204, 10492, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('出', NULL, 10493, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('適', NULL, 10494, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('特', 8148, 10495, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('済', NULL, 10496, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('増', NULL, 10497, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('問', 10149, 10498, 10760, 11032, 11303, 11573, 11842, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('答', 10150, 10499, 10761, 11033, 11304, 11574, 11843, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('例', 10151, 10500, 10762, 11034, 11305, 11575, 11844, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('電', NULL, 10501, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('年', NULL, 20553, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('負', NULL, NULL, NULL, 11030, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('勝', NULL, NULL, NULL, 11031, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('天', NULL, NULL, NULL, NULL, NULL, 20555, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('再', NULL, NULL, NULL, NULL, NULL, 20556, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('新', NULL, NULL, NULL, NULL, NULL, 20557, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('映', NULL, NULL, NULL, NULL, NULL, 20558, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('声', NULL, NULL, NULL, NULL, NULL, 20559, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('前', NULL, NULL, NULL, NULL, NULL, 20560, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('後', NULL, NULL, NULL, NULL, NULL, 20561, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('終', NULL, NULL, NULL, NULL, NULL, 20562, NULL, 20503, NULL, NULL);
INSERT INTO enclosed VALUES('立', NULL, NULL, NULL, NULL, NULL, 20563, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('交', NULL, NULL, NULL, NULL, NULL, 20564, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('ほか', NULL, NULL, NULL, NULL, NULL, 20565, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('劇', NULL, NULL, NULL, NULL, NULL, 20566, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('司', NULL, NULL, NULL, NULL, NULL, 20567, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('解', NULL, NULL, NULL, NULL, NULL, 20568, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('気', NULL, NULL, NULL, NULL, NULL, 20570, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('多', NULL, NULL, NULL, NULL, NULL, 20572, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('文', NULL, NULL, NULL, NULL, NULL, 20573, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('手', NULL, NULL, NULL, NULL, NULL, 20574, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('PV', NULL, NULL, NULL, NULL, NULL, 20575, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('MV', NULL, NULL, NULL, NULL, NULL, 20576, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('双', NULL, NULL, NULL, NULL, NULL, 20577, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('SS', NULL, NULL, NULL, NULL, NULL, 20578, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('S1', NULL, NULL, NULL, NULL, NULL, 20579, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('S2', NULL, NULL, NULL, NULL, NULL, 20580, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('S3', NULL, NULL, NULL, NULL, NULL, 20581, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('デ', NULL, NULL, NULL, NULL, NULL, 20582, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('HV', NULL, NULL, NULL, NULL, NULL, 20583, NULL, NULL, NULL, NULL);
INSERT INTO enclosed VALUES('CL', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20505, NULL, NULL);
INSERT INTO enclosed VALUES('KCL', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20506, NULL, NULL);
INSERT INTO enclosed VALUES('BEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20507, NULL, NULL);
INSERT INTO enclosed VALUES('AS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20508, NULL, NULL);
INSERT INTO enclosed VALUES('AM', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20509, NULL, NULL);
INSERT INTO enclosed VALUES('段', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20510, NULL, NULL);
INSERT INTO enclosed VALUES('ゴ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20511, NULL, NULL);
CREATE TABLE kumimoji (CID INTEGER PRIMARY KEY NOT NULL, src1 TEXT NOT NULL, src2 TEXT, src3 TEXT, src4 TEXT, src5 TEXT, src6 TEXT, src7 TEXT, src8 TEXT);
INSERT INTO kumimoji VALUES(7601, 'm', 'm', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(7602, 'c', 'm', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(7603, 'k', 'm', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(7604, 'm', 'g', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(7605, 'k', 'g', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(7606, 'c', 'c', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(7607, 'm', 'two.superior', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(7611, 'K', 'period', 'K', 'period', NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(7612, 'T', 'E', 'L', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8020, 'c', 'm', 'two.superior', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8021, 'k', 'm', 'two.superior', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8022, 'c', 'm', 'three.superior', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8023, 'm', 'three.superior', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8024, 'd', 'liter', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8026, 'k', 'liter', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8027, 'm', 's', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8028, 'micro', 's', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8029, 'n', 's', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8030, 'p', 's', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8031, 'K', 'B', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8032, 'M', 'B', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8033, 'G', 'B', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8035, 'H', 'z', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8036, 'm', 'b', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8037, 'm', 'liter', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8053, 'K', 'K', 'period', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8061, 'zero', 'period', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8062, 'one', 'period', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8063, 'two', 'period', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8064, 'three', 'period', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8065, 'four', 'period', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8066, 'five', 'period', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8067, 'six', 'period', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8068, 'seven', 'period', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8069, 'eight', 'period', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8070, 'nine', 'period', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8177, 'bracerightlower', 'bracerightupper', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8181, 'braceleftlower', 'braceleftupper', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8182, 'i', 'n', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8186, 'm', 'm', 'two.superior', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8187, 'm', 'm', 'three.superior', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8188, 'k', 'm', 'three.superior', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8189, 's', 'e', 'c', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8190, 'm', 'i', 'n', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8192, 'c', 'a', 'l', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8193, 'k', 'c', 'a', 'l', NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8194, 'd', 'B', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8306, 'T', 'B', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(8307, 'F', 'A', 'X', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(9883, 'Unus', 'Unus', 'Unus', 'Unus', NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11846, 'A', 'M', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11847, 'K', 'K', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11848, 'N', 'o', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11849, 'P', 'H', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11850, 'P', 'M', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11851, 'P', 'R', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11854, 'V', 'S', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11855, 'a', 'slash', 'c', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11856, 'a', 'period', 'm', 'period', NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11857, 'c', 'slash', 'c', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11858, 'c', 'period', 'c', 'period', NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11859, 'c', 'slash', 'o', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11860, 'd', 'l', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11861, 'h', 'P', 'a', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11862, 'k', 'l', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11864, 'micro', 'g', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11865, 'micro', 'm', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11866, 'm', 'l', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11867, 'm', 'slash', 'm', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11868, 'n', 'slash', 'm', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11869, 'p', 'H', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(11870, 'p', 'period', 'm', 'period', NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20523, 'zero', 'multiply', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20524, 'one', 'multiply', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20525, 'two', 'multiply', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20526, 'three', 'multiply', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20527, 'four', 'multiply', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20528, 'five', 'multiply', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20529, 'six', 'multiply', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20530, 'seven', 'multiply', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20531, 'eight', 'multiply', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20532, 'nine', 'multiply', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20533, 'space', 'zero', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20534, 'space', 'one', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20535, 'space', 'two', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20536, 'space', 'three', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20537, 'space', 'four', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20538, 'space', 'five', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20539, 'space', 'six', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20540, 'space', 'seven', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20541, 'space', 'eight', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20542, 'space', 'nine', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20543, 'zero', 'space', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20544, 'one', 'space', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20545, 'two', 'space', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20546, 'three', 'space', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20547, 'four', 'space', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20548, 'five', 'space', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20549, 'six', 'space', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20550, 'seven', 'space', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20551, 'eight', 'space', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20552, 'nine', 'space', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20587, 'one', 'zero', 'period', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20588, 'one', 'one', 'period', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20749, 'zero', 'zero', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20750, 'zero', 'one', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20751, 'zero', 'two', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20752, 'zero', 'three', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20753, 'zero', 'four', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20754, 'zero', 'five', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20755, 'zero', 'six', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20756, 'zero', 'seven', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20757, 'zero', 'eight', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20758, 'zero', 'nine', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20759, 'one', 'zero', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20760, 'one', 'one', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20761, 'one', 'two', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20762, 'one', 'three', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20763, 'one', 'four', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20764, 'one', 'five', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20765, 'one', 'six', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20766, 'one', 'seven', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20767, 'one', 'eight', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20768, 'one', 'nine', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20769, 'two', 'zero', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20770, 'two', 'one', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20771, 'two', 'two', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20772, 'two', 'three', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20773, 'two', 'four', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20774, 'two', 'five', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20775, 'two', 'six', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20776, 'two', 'seven', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20777, 'two', 'eight', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20778, 'two', 'nine', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20779, 'three', 'zero', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20780, 'three', 'one', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20781, 'three', 'two', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20782, 'three', 'three', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20783, 'three', 'four', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20784, 'three', 'five', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20785, 'three', 'six', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20786, 'three', 'seven', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20787, 'three', 'eight', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20788, 'three', 'nine', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20789, 'four', 'zero', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20790, 'four', 'one', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20791, 'four', 'two', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20792, 'four', 'three', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20793, 'four', 'four', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20794, 'four', 'five', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20795, 'four', 'six', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20796, 'four', 'seven', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20797, 'four', 'eight', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20798, 'four', 'nine', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20799, 'five', 'zero', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20800, 'five', 'one', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20801, 'five', 'two', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20802, 'five', 'three', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20803, 'five', 'four', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20804, 'five', 'five', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20805, 'five', 'six', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20806, 'five', 'seven', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20807, 'five', 'eight', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20808, 'five', 'nine', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20809, 'six', 'zero', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20810, 'six', 'one', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20811, 'six', 'two', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20812, 'six', 'three', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20813, 'six', 'four', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20814, 'six', 'five', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20815, 'six', 'six', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20816, 'six', 'seven', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20817, 'six', 'eight', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20818, 'six', 'nine', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20819, 'seven', 'zero', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20820, 'seven', 'one', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20821, 'seven', 'two', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20822, 'seven', 'three', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20823, 'seven', 'four', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20824, 'seven', 'five', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20825, 'seven', 'six', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20826, 'seven', 'seven', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20827, 'seven', 'eight', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20828, 'seven', 'nine', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20829, 'eight', 'zero', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20830, 'eight', 'one', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20831, 'eight', 'two', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20832, 'eight', 'three', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20833, 'eight', 'four', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20834, 'eight', 'five', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20835, 'eight', 'six', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20836, 'eight', 'seven', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20837, 'eight', 'eight', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20838, 'eight', 'nine', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20839, 'nine', 'zero', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20840, 'nine', 'one', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20841, 'nine', 'two', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20842, 'nine', 'three', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20843, 'nine', 'four', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20844, 'nine', 'five', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20845, 'nine', 'six', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20846, 'nine', 'seven', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20847, 'nine', 'eight', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20848, 'nine', 'nine', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20849, 'one', 'zero', 'zero', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20850, 'one', 'zero', 'one', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20851, 'one', 'zero', 'two', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20852, 'one', 'zero', 'three', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20853, 'one', 'zero', 'four', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20854, 'one', 'zero', 'five', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20855, 'one', 'zero', 'six', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20856, 'one', 'zero', 'seven', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20857, 'one', 'zero', 'eight', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20858, 'one', 'zero', 'nine', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20859, 'one', 'one', 'zero', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20860, 'one', 'one', 'one', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20861, 'one', 'one', 'two', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20862, 'one', 'one', 'three', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20863, 'one', 'one', 'four', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20864, 'one', 'one', 'five', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20865, 'one', 'one', 'six', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20866, 'one', 'one', 'seven', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20867, 'one', 'one', 'eight', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20868, 'one', 'one', 'nine', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20869, 'one', 'two', 'zero', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20870, 'one', 'two', 'one', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20871, 'one', 'two', 'two', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20872, 'one', 'two', 'three', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20873, 'one', 'two', 'four', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20874, 'one', 'two', 'five', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20875, 'one', 'two', 'six', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20876, 'one', 'two', 'seven', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20877, 'one', 'two', 'eight', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20878, 'one', 'two', 'nine', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20879, 'one', 'three', 'zero', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20880, 'one', 'three', 'one', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20881, 'one', 'three', 'two', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20882, 'one', 'three', 'three', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20883, 'one', 'three', 'four', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20884, 'one', 'three', 'five', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20885, 'one', 'three', 'six', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20886, 'one', 'three', 'seven', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20887, 'one', 'three', 'eight', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20888, 'one', 'three', 'nine', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20889, 'one', 'four', 'zero', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20890, 'one', 'four', 'one', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20891, 'one', 'four', 'two', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20892, 'one', 'four', 'three', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20893, 'one', 'four', 'four', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20894, 'one', 'four', 'five', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20895, 'one', 'four', 'six', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20896, 'one', 'four', 'seven', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20897, 'one', 'four', 'eight', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20898, 'one', 'four', 'nine', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20899, 'period', 'zero', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20900, 'period', 'one', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20901, 'period', 'two', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20902, 'period', 'three', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20903, 'period', 'four', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20904, 'period', 'five', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20905, 'period', 'six', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20906, 'period', 'seven', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20907, 'period', 'eight', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20908, 'period', 'nine', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20909, 'comma', 'zero', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20910, 'comma', 'one', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20911, 'comma', 'two', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20912, 'comma', 'three', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20913, 'comma', 'four', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20914, 'comma', 'five', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20915, 'comma', 'six', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20916, 'comma', 'seven', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20917, 'comma', 'eight', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20918, 'comma', 'nine', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20919, 'p', 'p', 'b', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20920, 'p', 'p', 'm', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20921, 'quotesingle', 'S', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20922, 'H', 'two.inferior', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20923, 'O', 'two.inferior', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20924, 'O', 'x', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20925, 'N', 'x', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20926, 'Q', 'two.superior', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20927, 'J', 'r', 'period', NULL, NULL, NULL, NULL, NULL);
INSERT INTO kumimoji VALUES(20928, 'D', 'r', 'period', NULL, NULL, NULL, NULL, NULL);
CREATE VIEW glyphLabels AS
SELECT glyphName, pwid AS CID FROM lgcGlyphs WHERE pwid IS NOT NULL
UNION SELECT glyphName, fwid AS CID FROM lgcGlyphs WHERE fwid IS NOT NULL
UNION SELECT label AS glyphName, CID FROM cjkLabel
UNION SELECT label AS glyphName, horizontalFull AS CID FROM kana WHERE horizontalFull IS NOT NULL
UNION SELECT glyphName, CID FROM lig2 WHERE CID IS NOT NULL
UNION SELECT glyphName, CID FROM lig3 WHERE CID IS NOT NULL
ORDER BY glyphName;
CREATE TABLE macCompat (CID INTEGER PRIMARY KEY NOT NULL, src1 INTEGER NOT NULL, src2 INTEGER NOT NULL, src3 INTEGER, src4 INTEGER, src5 INTEGER);
INSERT INTO macCompat VALUES(8061, 15444, 17, 15, NULL, NULL); -- 0.
INSERT INTO macCompat VALUES(8297, 15444, 57, 55, NULL, NULL); -- XV
INSERT INTO macCompat VALUES(8302, 15444, 89, 87, NULL, NULL); -- xv
INSERT INTO macCompat VALUES(8306, 15444, 53, 35, NULL, NULL); -- TB
INSERT INTO macCompat VALUES(8312, 15444, 739, 738, NULL, NULL); -- down up
INSERT INTO macCompat VALUES(8296, 15445, 57, 42, 55, NULL); -- XIV
INSERT INTO macCompat VALUES(8301, 15445, 89, 74, 87, NULL); -- xiv
INSERT INTO macCompat VALUES(8307, 15445, 39, 34, 57, NULL); -- FAX
INSERT INTO macCompat VALUES(8295, 15446, 57, 42, 42, 42); -- XIII
INSERT INTO macCompat VALUES(8300, 15446, 89, 74, 74, 74); -- xiii
INSERT INTO macCompat VALUES(8321, 15446, 3863, 1910, 1393, 2302); -- Yuugen Kaisha
INSERT INTO macCompat VALUES(8322, 15446, 2130, 2946, 3663, 2579); -- Zaidan Hohjin
INSERT INTO macCompat VALUES(8206, 8014, 15447, NULL, NULL, NULL); -- right filled arrow
INSERT INTO macCompat VALUES(8207, 8013, 15447, NULL, NULL, NULL); -- left filled arrow
INSERT INTO macCompat VALUES(8208, 8012, 15447, NULL, NULL, NULL); -- up filled arrow
INSERT INTO macCompat VALUES(8209, 8011, 15447, NULL, NULL, NULL); -- down filled arrow
INSERT INTO macCompat VALUES(124, 668, 15448, NULL, NULL, NULL); -- ellipsis
INSERT INTO macCompat VALUES(8303, 828, 15448, NULL, NULL, NULL); -- metre
INSERT INTO macCompat VALUES(8304, 822, 15448, NULL, NULL, NULL); -- gramme
CREATE VIEW compositeFeat AS
SELECT 40 AS feat, part1 AS base1, part2 AS base2, part3 AS base3, part4 AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, ligature AS target FROM compositeCID
UNION SELECT 40 AS feat, CID AS base1, 10233 AS base2, NULL AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, parenthesis    AS target FROM glyphLabels NATURAL INNER JOIN enclosed WHERE parenthesis    IS NOT NULL
UNION SELECT 40 AS feat, CID AS base1, 16328 AS base2, NULL AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, circle         AS target FROM glyphLabels NATURAL INNER JOIN enclosed WHERE circle         IS NOT NULL
UNION SELECT 40 AS feat, CID AS base1, 10763 AS base2, NULL AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, circleRev      AS target FROM glyphLabels NATURAL INNER JOIN enclosed WHERE circleRev      IS NOT NULL
UNION SELECT 40 AS feat, CID AS base1, 11035 AS base2, NULL AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, square         AS target FROM glyphLabels NATURAL INNER JOIN enclosed WHERE square         IS NOT NULL
UNION SELECT 40 AS feat, CID AS base1, 11306 AS base2, NULL AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, squareRev      AS target FROM glyphLabels NATURAL INNER JOIN enclosed WHERE squareRev      IS NOT NULL
UNION SELECT 40 AS feat, CID AS base1,  8015 AS base2, NULL AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, roundSquare    AS target FROM glyphLabels NATURAL INNER JOIN enclosed WHERE roundSquare    IS NOT NULL
UNION SELECT 40 AS feat, CID AS base1, 11845 AS base2, NULL AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, roundSquareRev AS target FROM glyphLabels NATURAL INNER JOIN enclosed WHERE roundSquareRev IS NOT NULL
UNION SELECT 40 AS feat, s1.CID AS base1, s2.CID AS base2, 10233 AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, parenthesis    AS target FROM lig2 NATURAL INNER JOIN enclosed INNER JOIN glyphLabels AS s1 ON src1 = s1.glyphName INNER JOIN glyphLabels AS s2 ON src2 = s2.glyphName WHERE parenthesis    IS NOT NULL
UNION SELECT 40 AS feat, s1.CID AS base1, s2.CID AS base2, 16328 AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, circle         AS target FROM lig2 NATURAL INNER JOIN enclosed INNER JOIN glyphLabels AS s1 ON src1 = s1.glyphName INNER JOIN glyphLabels AS s2 ON src2 = s2.glyphName WHERE circle         IS NOT NULL
UNION SELECT 40 AS feat, s1.CID AS base1, s2.CID AS base2, 10763 AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, circleRev      AS target FROM lig2 NATURAL INNER JOIN enclosed INNER JOIN glyphLabels AS s1 ON src1 = s1.glyphName INNER JOIN glyphLabels AS s2 ON src2 = s2.glyphName WHERE circleRev      IS NOT NULL
UNION SELECT 40 AS feat, s1.CID AS base1, s2.CID AS base2, 11035 AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, square         AS target FROM lig2 NATURAL INNER JOIN enclosed INNER JOIN glyphLabels AS s1 ON src1 = s1.glyphName INNER JOIN glyphLabels AS s2 ON src2 = s2.glyphName WHERE square         IS NOT NULL
UNION SELECT 40 AS feat, s1.CID AS base1, s2.CID AS base2, 11306 AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, squareRev      AS target FROM lig2 NATURAL INNER JOIN enclosed INNER JOIN glyphLabels AS s1 ON src1 = s1.glyphName INNER JOIN glyphLabels AS s2 ON src2 = s2.glyphName WHERE squareRev      IS NOT NULL
UNION SELECT 40 AS feat, s1.CID AS base1, s2.CID AS base2,  8015 AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, roundSquare    AS target FROM lig2 NATURAL INNER JOIN enclosed INNER JOIN glyphLabels AS s1 ON src1 = s1.glyphName INNER JOIN glyphLabels AS s2 ON src2 = s2.glyphName WHERE roundSquare    IS NOT NULL
UNION SELECT 40 AS feat, s1.CID AS base1, s2.CID AS base2, 11845 AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, roundSquareRev AS target FROM lig2 NATURAL INNER JOIN enclosed INNER JOIN glyphLabels AS s1 ON src1 = s1.glyphName INNER JOIN glyphLabels AS s2 ON src2 = s2.glyphName WHERE roundSquareRev IS NOT NULL
UNION SELECT 40 AS feat, s1.CID AS base1, s2.CID AS base2, s3.CID AS base3, 10233 AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, parenthesis    AS target FROM lig3 NATURAL INNER JOIN enclosed INNER JOIN glyphLabels AS s1 ON src1 = s1.glyphName INNER JOIN glyphLabels AS s2 ON src2 = s2.glyphName INNER JOIN glyphLabels AS s3 ON src3 = s3.glyphName WHERE parenthesis    IS NOT NULL
UNION SELECT 40 AS feat, s1.CID AS base1, s2.CID AS base2, s3.CID AS base3, 16328 AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, circle         AS target FROM lig3 NATURAL INNER JOIN enclosed INNER JOIN glyphLabels AS s1 ON src1 = s1.glyphName INNER JOIN glyphLabels AS s2 ON src2 = s2.glyphName INNER JOIN glyphLabels AS s3 ON src3 = s3.glyphName WHERE circle         IS NOT NULL
UNION SELECT 40 AS feat, s1.CID AS base1, s2.CID AS base2, s3.CID AS base3, 10763 AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, circleRev      AS target FROM lig3 NATURAL INNER JOIN enclosed INNER JOIN glyphLabels AS s1 ON src1 = s1.glyphName INNER JOIN glyphLabels AS s2 ON src2 = s2.glyphName INNER JOIN glyphLabels AS s3 ON src3 = s3.glyphName WHERE circleRev      IS NOT NULL
UNION SELECT 40 AS feat, s1.CID AS base1, s2.CID AS base2, s3.CID AS base3, 11035 AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, square         AS target FROM lig3 NATURAL INNER JOIN enclosed INNER JOIN glyphLabels AS s1 ON src1 = s1.glyphName INNER JOIN glyphLabels AS s2 ON src2 = s2.glyphName INNER JOIN glyphLabels AS s3 ON src3 = s3.glyphName WHERE square         IS NOT NULL
UNION SELECT 40 AS feat, s1.CID AS base1, s2.CID AS base2, s3.CID AS base3, 11306 AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, squareRev      AS target FROM lig3 NATURAL INNER JOIN enclosed INNER JOIN glyphLabels AS s1 ON src1 = s1.glyphName INNER JOIN glyphLabels AS s2 ON src2 = s2.glyphName INNER JOIN glyphLabels AS s3 ON src3 = s3.glyphName WHERE squareRev      IS NOT NULL
UNION SELECT 40 AS feat, s1.CID AS base1, s2.CID AS base2, s3.CID AS base3,  8015 AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, roundSquare    AS target FROM lig3 NATURAL INNER JOIN enclosed INNER JOIN glyphLabels AS s1 ON src1 = s1.glyphName INNER JOIN glyphLabels AS s2 ON src2 = s2.glyphName INNER JOIN glyphLabels AS s3 ON src3 = s3.glyphName WHERE roundSquare    IS NOT NULL
UNION SELECT 40 AS feat, s1.CID AS base1, s2.CID AS base2, s3.CID AS base3, 11845 AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, roundSquareRev AS target FROM lig3 NATURAL INNER JOIN enclosed INNER JOIN glyphLabels AS s1 ON src1 = s1.glyphName INNER JOIN glyphLabels AS s2 ON src2 = s2.glyphName INNER JOIN glyphLabels AS s3 ON src3 = s3.glyphName WHERE roundSquareRev IS NOT NULL
UNION SELECT 40 AS feat, src1 AS base1, src2 AS base2, src3 AS base3, src4 AS base4, src5 AS base5, NULL AS base6, NULL AS base7, NULL AS base8, CID AS target FROM macCompat
UNION SELECT 41 AS feat, src1 AS base1, src2 AS base2, src3 AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, CID AS target FROM ligatureCID
UNION SELECT 42 AS feat, s1.CID AS base1, s2.CID AS base2, s3.CID AS base3, s4.CID AS base4, s5.CID AS base5, s6.CID AS base6, s7.CID AS base7, s8.CID AS base8, kumimoji.CID AS target FROM kumimoji
LEFT JOIN glyphLabels AS s1 ON src1 = s1.glyphName LEFT JOIN glyphLabels AS s2 ON src2 = s2.glyphName LEFT JOIN glyphLabels AS s3 ON src3 = s3.glyphName LEFT JOIN glyphLabels AS s4 ON src4 = s4.glyphName
LEFT JOIN glyphLabels AS s5 ON src5 = s5.glyphName LEFT JOIN glyphLabels AS s6 ON src6 = s6.glyphName LEFT JOIN glyphLabels AS s7 ON src7 = s7.glyphName LEFT JOIN glyphLabels AS s8 ON src8 = s8.glyphName
UNION SELECT 46 AS feat, s1.CID AS base1, s2.CID AS base2, s3.CID AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, diagonal AS target FROM fractions
LEFT JOIN glyphLabels AS s1 ON src1 = s1.glyphName LEFT JOIN glyphLabels AS s2 ON src2 = s2.glyphName LEFT JOIN glyphLabels AS s3 ON src3 = s3.glyphName
WHERE src4 IS NULL AND src5 IS NULL
UNION SELECT 46 AS feat, s1.CID AS base1, s2.CID AS base2, s3.CID AS base3, s4.CID AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, diagonal AS target FROM fractions
LEFT JOIN glyphLabels AS s1 ON src1 = s1.glyphName LEFT JOIN glyphLabels AS s2 ON src2 = s2.glyphName LEFT JOIN glyphLabels AS s3 ON src3 = s3.glyphName LEFT JOIN glyphLabels AS s4 ON src4 = s4.glyphName
WHERE src4 IS NOT NULL AND src5 IS NULL
UNION SELECT 46 AS feat, s1.CID AS base1, s2.CID AS base2, s3.CID AS base3, s4.CID AS base4, s5.CID AS base5, NULL AS base6, NULL AS base7, NULL AS base8, diagonal AS target FROM fractions
LEFT JOIN glyphLabels AS s1 ON src1 = s1.glyphName LEFT JOIN glyphLabels AS s2 ON src2 = s2.glyphName LEFT JOIN glyphLabels AS s3 ON src3 = s3.glyphName LEFT JOIN glyphLabels AS s4 ON src4 = s4.glyphName LEFT JOIN glyphLabels AS s5 ON src5 = s5.glyphName
WHERE src4 IS NOT NULL AND src5 IS NOT NULL
UNION SELECT 47 AS feat, s1.CID AS base1, s2.CID AS base2, s3.CID AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, stacked AS target FROM fractions
LEFT JOIN glyphLabels AS s1 ON src1 = s1.glyphName LEFT JOIN glyphLabels AS s2 ON src2 = s2.glyphName LEFT JOIN glyphLabels AS s3 ON src3 = s3.glyphName
WHERE src4 IS NULL AND src5 IS NULL
UNION SELECT 47 AS feat, s1.CID AS base1, s2.CID AS base2, s3.CID AS base3, s4.CID AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, stacked AS target FROM fractions
LEFT JOIN glyphLabels AS s1 ON src1 = s1.glyphName LEFT JOIN glyphLabels AS s2 ON src2 = s2.glyphName LEFT JOIN glyphLabels AS s3 ON src3 = s3.glyphName LEFT JOIN glyphLabels AS s4 ON src4 = s4.glyphName
WHERE src4 IS NOT NULL AND src5 IS NULL
UNION SELECT 47 AS feat, s1.CID AS base1, s2.CID AS base2, s3.CID AS base3, s4.CID AS base4, s5.CID AS base5, NULL AS base6, NULL AS base7, NULL AS base8, stacked AS target FROM fractions
LEFT JOIN glyphLabels AS s1 ON src1 = s1.glyphName LEFT JOIN glyphLabels AS s2 ON src2 = s2.glyphName LEFT JOIN glyphLabels AS s3 ON src3 = s3.glyphName LEFT JOIN glyphLabels AS s4 ON src4 = s4.glyphName LEFT JOIN glyphLabels AS s5 ON src5 = s5.glyphName
WHERE src4 IS NOT NULL AND src5 IS NOT NULL
ORDER BY feat, target;
CREATE VIEW featureList AS
SELECT feat, fromCID AS base1, NULL AS base2, NULL AS base3, NULL AS base4, NULL AS base5, NULL AS base6, NULL AS base7, NULL AS base8, toCID AS target FROM oneToOneFeat
UNION SELECT feat, base1, base2, base3, base4, base5, base6, base7, base8, target FROM compositeFeat
ORDER BY feat;
CREATE VIEW features AS
SELECT featTag, base1, base2, base3, base4, base5, base6, base7, base8, target FROM featureCode INNER JOIN featureList ON featID = feat;
COMMIT;
