/* eslint-disable @metamask/design-tokens/color-no-hex*/
export const storiesMetadata = {
  totle: {
    color: '#283B4C',
    icon: 'data:image/png;base64,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',
  },
  dexag: {
    color: '#13171F',
    icon: 'data:image/png;base64,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',
  },
  airswap: {
    color: '#2B71FF',
    icon: 'data:image/png;base64,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',
  },
  paraswap: {
    color: '#0058D4',
    icon: 'data:image/png;base64,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',
  },
  zeroExV1: {
    color: '#000',
    icon: 'data:image/png;base64,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',
  },
  oneInch: {
    color: '#323232',
    icon: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAASkAAAB5CAYAAABlYNfBAAAACXBIWXMAACxLAAAsSwGlPZapAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAACQQSURBVHgB7Z0JfFTl1f/PnSwzk3VCAoFAYEjYDRAUSHCBoOBSFwK2wlurgNrW/pVCrcv/Uzdc2tpqy6J2UStY6/ZWIYhWrCgBPwIJCmGRLZAMS1hDMknInsx9z++ZucMkTCBAAmQ4Xz/jzNx7596ZkPnlnN9znvMQCYIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgCIIgnFc0ukSwZWTaaqpMM3WNUk2k23Uip+7Ss2rXZc0jQRAuWgJWpMJGZma6XOSs+TYr25w2aU60OXjWlJRkGpXYmb4/4qSXVm92kKaPtVjIWVlJ9iCdbI0aOevXZeWRIAgXDQEpUkqgNG0xufTpusk0dHBn26w3b0ijhKNOOtizC414/WN88DyOpmxR5hB7tDlUvW5feaVximxq1J+BwJEgCBeUgBQpS9rEwoevHGx/afWWhYlRYdM+HD+Suvzrv2R+YBKlffgVpZtM9KOYKErpEkMsUkRWM1WEWWhbaBB9sKWQPtu1j8pr64l0bXZN7qJnSBCEC0YQdXAs6Zn24B4DbA37tzs9zzNu7JM464pucSw2++3PpqdYrli0ioISOtO/GxvpwdXf0+2HnZSw9wgFb9tDpVsdtKGmjlZZQ6iWNfuyeBv1jI6gfWWVVF5XlxHcbcDKhgPbHca5g7sPXBCcyNs81xMEoX0xUQenZm2Wg1zabIiV2uCiDERIPRpdCBNt4w4cI72kgig2kq74+Bu13SA4JYmO/uR6umpoH5p2tJwmbi6g67Y4aFZkOC2aPI4So8JZxrWnvS9oJDtvy9B1bYP3eoIgtCsBke4hwuHUbAGMcBap2X/u13PqDVYLjdqxhzY6K5VIaZzS6dW13tfgudY9jly7ivyeM2hwEh3+QTpN/28OG+2lDp20PNL1jC+n3mR7ac1mWpa/P7smZ/FYEgShXQkYT8o8cmJpJ1uks7SswvF0eFjGtOIyur9HHP11UyGdLRAx8z030+clTpX+IUJLNwXRWlcjTfrgS7JY9RhndpakfYLQjnT4dM9AM+nz7r1tnM0WGZ6x5Wipip6mHS0jp0k7SUTKTRrNi7TSLV2iT3nO42ym1775KV23bgfdc7yWLv94NTUsy6UrE+PV/qpqbUzz15jTbp8pqaAgtB3BFCDU1NDcDTt2z/z7Ew/SI8/Op63HayjtYAl22YxjtoYE0XPRYUTDU2hbwT4ysVjRkbIWzxlRVUNL0gbQ1ys2UPoWd0RW1DmaDi5bqx4HkT7WMjxTnUDXaKhm0jKjzEEZFbWNvXnTLBIE4ZwJqBIEc1rm3P/+5bmZZRVVdN8jv6d3i8tpUH2j2geBun9wMj3xsym05Ks1NOvOCfSj+5+kvIOlpzxn0MgBdOQHo2jL0RIqr6mnKEsIoa4KNVWreYRw9b7D3voqRFjPjr2crvvnZ06NtCy1UXft4XA1LzSMsiU1FIQzJ6BECgb66GEpKx6/bzJx2sci9AS94jjkTKlrtI3uaqN33nqJFn+1mu6//UZatf57enTumzTiSCm9WFpJUbpO+4Pd2W+PBleT82qdIpWRrlnYfK+p9RjxoRQ8OpVM7FsZwJhHKtn/5Q9beovZbL4vrMnNeosEQWgVAZPugZq1WdmrdC37caKMnl270JiMdLp7Va5tBHtUaTdcQz3i42igvQe5WJB++8YHtPaff6K3P11BP3/1X/RecQWrDBHEbGZ5NU3ndBHCBSBKDSs3nnS9htztSsC0TlFKoIIS4mjZkCTqn9STFr3yO3XM9t176cCRo/Tlmm8pd/O2jAOHizMsaRNnYyRSlU90AAoLC5EyT9V5dJNvdk3TnHzvcLlcb/Xt2zebBKEd6fDFnM0J7jFw9t6DR2xdY21038QbqKyiko7FRNEj035IURFhNGpIf5r54us09orBNGbkEH4+gL4rLaOwLbsoyqXTR11jnZ3HX2l58dBh9dxIF32BMAWnJFNV+kBaWVdP2fuPUmeTiXZelUJPr91CkckpVGLuRAcrasgWHUVDkhPphqtHUOb4a8gSGkobdhbYXA2Ns4K7D6KGom0rfc+NaLBhv7t49GKABcrOYrSGRWkKPx3At658s/MtlcVq2syZM6Pnz5//OQlCOxFQIqXqpUibVXa8im4dk0afrMqlz1Z/R3/41b0qigJ19Q20ZtN2mnXXRPUYN1tUJH3w+SqV5u2+fKDlb0/OoOs58lqq6fTGviJKr2tQgqXSQQ6uzBw1uQ4UU8jhUup/5WDqftvV9FG4mZ5igXLFxNPga2+m0up62uespk0Hy2llwTFyVteRPS6SRl+eQj36DaLV6/Kovq4mw1eo1Kigri1uKNp+UXRm8AjUCnKLUkuMEqES2pOA8qSsaZMW33lzRmavbl1oeU4epXOUNG3CeIoKD2t+KAxs76jf9sJ99OxPf6PSu7QZd9P0zOvV9pCgIFqd9z39ds4C+v3mXapa/eedIlRqCO8JwgUQWWFeYFGQiSZ9sJxCeg+i6M7xZI2MVvchZov3wlfZO9G4Pp3ps+/30x//PJ/Kiw+jfmJazdqP3mKRms0i9fTFUn+1e/dujFDOacWhenl5eadhw4bJwEALFBUVUXV1dSZHpKkmk6kXb7JxJKp+B5E687Zsfriyd+/eDhKaEDAi5YlCCte+/Sea987H9PyMqad9TRiP0lXV1tGCrC9oa+FeSh88gG4fd1WTY6x8THnFcTUS+OqmfLqfBQl+FUQK9wYQKsvDU2g/R10QKp+OChQdF09JqSMoceAQ9TzGGkI/TetFC9bsovf+/ipVVpQ5rVa9d021toF329m2z6zLWbyEzoH8/PwM/hJk8i//UN/tHBltDAoKmtuaL8OuXbs28DlS6fTofN6H2J+aS8JJsAiRw+HozT+jgtMcWsrH3tOnT58sErwETDGnwdC+vWn8qGHe5/wlo9CQYFrLKd68d5ZQeWWVdx8EKNJq4chpPL3IKWFzgQLVLGJd4zrRS0/PoAXhFop0ueiL+Bjaz1FTDjooeIC5Xvfel5QYHU4LJo52z/vzUMbR0obln9Dyt16lqnKnSgVfz9lDY/olUOr4W9QcQ0Og1HsmvTedBTC4+fZ0QUHBChanFfzZZ3rMbu8N2/jLsoGPO62KG3/pWwH+2LX2WKFlYvhn/uaGDRvkZ+lDwIgURsr4D5Zz1fotdFlyL7UNAhVhMdNLCz+iP7z6okr7YiIjmryupKxciVVzgkwnfjSVNbXKS/qWDfAhLILVKf2onM89N9KdxhmlC42bC6j+81xK6RyjJij/7IoBNDkliW7s20Ptryovo9WL36H62holVOuLnNTD3pviuvfEbnuI2ex+39Q0+jkVHmGaCWFi8Snl22yI0WleZuPj5sJzIuFiwxYREdGa6PWSIaAiKY5Alny9/nvqk9hNPY8Ot9Lb/1lBBd9/TDmPB9Guwp0UGXbCHwoNDqKlq3LUcb6iBBCiR3m21ze4R/hs3ePJzFHabWNG0Ld9EqnvpOvdEVVoiDeqql+WyxHVcup+vJqeSb+M5t2YTjcl9/CeF0KFqAoUlFSRld9Dv7Rr1POuSf09R7nsdBqMqInFphCC0wphao6tsbHxdFXxre1SCnMum4Q2gf+42knwEmjpnmPjzkLlNcVGRZCJo51F/1lMtw7V6JF/N1Ifex+a//ZH6kCkgBgFXLpynTrOFnHCXMdzfOsqeRSvE6dtOBaMvvwyTgunU6+u8fTg5FtoaD+7EqcPw0K9URVo3FxIdYu/VingvrLjaFXc5E0eKthJxUV71GNEVHHde6loqv/IaygsEvMJNfupPiSLUypSNkRNdG5p1phT7eTzt3aU0SH1UkJ7EViRlGYa2qube/Lvd9t20WPzFtCwQYOJev6Cel32E6qtrqRrRw1X+yFkX2/YouqogJmFKNziTrdQ7BnFXhXunRVVFOMRsCfum6zubx0zkh6ccgtFR0QogTKPSqUdcTaVAhqE3DhSVaPPXJbTxEQ3OLR7Z5PnI27+IYVFRTcZCfSHpyxgMZ26LKBVnM5zgvDwtU7XmbSU/a9rSRDaiYASKRYV+62citU3NpK9e1caPqgfPXTP3TSCR+3GXT2S7v/xJOrRtbMSKNw27nSQ8/gJAUEqqHmEBqN+ECeca+/hYr/X69WtMx2yd6fXnpxBD3BktSDCJ5rK3UauomKad1O615Py5VDhCZFCrZZuckdrhi/VEpyiZVAbCFRrYaGCxzWdHzqa7+PtMOgvl2FzoT0JGJFCCQLrSyoM7kZP983MselubykiXN0gQPCYDF/qX5+uYCPc7j0H0rwwj4kOcXJ5fKng4GD6R9YXJ10T18LUGtRlzfARKUyR0VnrtoYG0aT3l6NB3kmvhTcFIFCOA8XelPJ08GeYQOcZHhJfmJSU1JsFaRhHVmNx48cxvP1aESihvQmcSKqRMuAZgVr+4m/YvosaXCcmCkN8MNIXFx2hhOr5Nz6gPQePqInGzooT0ZQl9ERZQUVVjXoNtg3u15tefm/pSZfFRGYQzfdDhw/2Guil3+6gAVv3qkiqJSqcpbR73xEljkb1e31tLZ0KFt0yugBA4FmQ8pAC4saPpXBTOC8EzARjzWSa8JOb3d18N+UXUomznGrq6tVziAxG8PBFgyD9/PmXacW3W+i++39BCxe8Sa9+8Ak97vGb4E3hOERgjSxySPtgqidymrho+TeEEgdEUP6Akb71q1xKq61XI37Xf55L6Q9PUS1c0NLFHxCm+NgoKmXfKi4mSpUnsBQ5WvqcqE7WtPNfg+spSFQeVlsKFM6bn5+fGhISMoZTWURrvTCJmZoOCDgxqdlTiFpYX1+/sl+/fu22PqLns9r54QS+JuYo2lAp7u/98Pasth40wL8vRm/5c6IYFxXqQz0/E2O/g5+r6/PT7EAftAiUHueq2nz74r+pFA6dDTZ/+CqVwLDmX7gdjn0c6UQosbnh/z1F9Sw+E6b8hIpcYZT76YdUfaSIDi1/23u+Yh6Rq2toUI8RdcWzeByvqaX9R47R3b95iXL/9We/7wPXXfPYi2pSss7//bCqjoJHD6UvB9tpetbXJx0/buoDlH+wjAYmJaiUr1+vrvTxy+ieoGfX5GT57Z/uMc5R+OnX9OZf3my+28O/yKcvuWefKTk5ucXC0V27dmV6zoMvqL35a/mWzV+gZ8405ePPQA0NDRn8Wpw7k85uhNJxttf3h48Io9h1Gp2Z71foeR9vneLcrak4N3Cc4fUxrQazCAJyNe6ASPd03TQTURRStx5sZqOxHVKoysoqJVBIySY/+gINmHg/Wa1Weu7J/68ECnRL6kdlbJ5vzD/RCz046MSPBdEU0kekfSgEvXbkUFq6Klf5VYiymqNaE0dZvWnfZ+u20f6yKr/vG+eOiQ5XURTEtKz4kNrOfzk2tvRZ8YXkX/pfNf38Or6sszw+0Vh+vpDaAE/0ABGx+9mNbdPwxcMUHGoFECcc6zHcMXF5Gp19CYXduD7qxegsgYAgamERMWrOZtOZD0xAgBbu3r37z9Q22OnMwB+uuXz9gp07dwZcIWiHFyl0PrB36zzrdR5hy997gL/wFfSjcVcrkXp32UrVNyqaTXMjnXvm4Qdo1d4K9RhTVHbkuCOcr7/7XgmP7ukh5UtFtXuOHnytSeOuolfeX6rOX1VT500pAdJMiFPsgCT6KMys+qhHson/2nfb/b53LdSq6rBKyirJYgml8qNH1PZG0lbQKYCRzV/y3r7ChL+iF8gn0jgFe+pUB3iEIMYQp7MoPD3l9SEs/AVddKbTSXwinLaoOQOzPJOyLxS9+d9ifWumPHUkOn4k5aIMjNAhHevbK4HGDh+ifKW9h44qY3wIG95LV+ZyqhdOsZ060X8claqAEgK1etE7VFXh9qERSRnC09hMqFSJAG8Lt5pVy5eCokPK27KwIDmPV6mKdDzHdTJ/PIGW/eU5uosjO0RUz9vC/dZJYdIxRvRKWaBw/gg+t1Hgqbv0Paf72IioLqAwNaGZX9N8nyEE69tYnJozMTo6elFrD/a8L4xWrqe2K+mAffIUXVgg2gsCKaIKiHSvmE3y8spqGpHSX00wBoigMNqHynDUQu05dJhCbHFKoACmphgCBTbnO9Q9UriGhpMb3UEEIWJo35KWMoDPd0Q9RvRVwgIVycY8yhFQkY708sVZ96h79Fb3hzXKvVJNiUfAIsIsdGz/Xjx01K/LyrNlZNo60KozLUYgBw4c0NgQRzpmp3aGhWcsRzKzW3GcIZxfUdtPjLZdBHMieRzJ9CYFCB1fpEyUjSZ22wr2UpwtSm1C2oVYCNXnEKvbxozkFO1T6sr+E0CKd6xob5PTGGUILs+oXnMQYYGQ4CDqztHUXo7SDO8Kx0Nson2m1qAk4Tf33kEtEZuYpMoPgJUjsuqyYo9oatkQJ3RFsFioQw/zQwzq6ursrTTx24pfnirt8whUTDsJlMLJ0AUGLXZYLM97TV17EAjLrGeTpj9z//Ov0Ls8uvbInDfVCN5eVQO1RXlRECikfpgjV7x/D+3IPXmkDfsBBMffED+2GxEWuinA5/IFxZ/lVTVNts2Ycitd00K5QgWFqTQPxERHUEHeOvVYJx7WdqFti+64kI3vYHKfKywGGMWz0/klJioqqkVfCO+JBWomtVNkxyKYd5E0/9P4vcykACAg6qRYqGbvHZmZ99i8BegiaUc7lT/+6l76ZGUOpd/9a6rTgunKSXeqKSd5ng4EvsBn2n+4WI3iAXhFtT6GuAH2w68azB4YaqWaj+6hpQtqssw+1eOvP/mgeg++BaOhETGkmX2irggrbeRUT0f9DWlz4Gzw43NqeteBwSIPb7GQqDqokJCQaE4Xh51JNMbHjva33Ujz+OHZjAZCeLI4jcqrr68v87wvnGsoXy/DuAQb121VBnDSz4EfZ5B7tLVVnMor7EgETDFnXW5WFqVmZnOKlLlxZ+Gc9Lseso0YPJCuvekWaohPVsdsWfVFEx/K4J3fP0p3P/6SEh34TC1R29Cgoqmrhw1SzyFKzYGR3sUW6Y3GMGXmtScepDse+4P3mMheA7yPYcYf3rVVvS/NJ/3gwC2bLi34O6VP8teV0iMu81qborVk0Hsiu6km0xklEOjR9WxLXUeNwk/MqeTHtuTk5LZYrmwOn+eh5hs5up3H7x9TkjBA0JpU1QYDvT0LX88HgdWqJU+lRw50Xrkr8waaM/sRirS7BQGjeQUb1530EnTjRCTVNS5GdeEMs4RidM3v6VFugLTPHByspszU+zHYsf94M/HCohBGCQSwdIr3Pu4aF037tm1Sj91tWhTKPKdLDI5C/H5mCH5wcHAeIgtqJf7Ma45GNE8BaatPgwnUp2qL7Jku5EBZSBu1T4ZYb/K3g6+Dn8OKM2ihg8/cizo4Adc+GAsZJLDo3DXhRvrGUeIdzUO5gT/uuP4aMnOKNiipp6ouR6pnVJu3BETIqJ0ywMif0eoFfaia11vd5ZmyE56QRMFWd3fQUB75qyk5rNoLp4weT/09ze900gOycvhcMJvNumcayFmBfw9O0/xVzrf4Er7ePRfpBOqVrT2QI7wY6uAElEi5l7SijOvSr1C9mSBSAJGKvzQPEdS4tFQK5RQPq8qgqtxfdNQcf6N/Lo8oRXr6UDWPpjDKCCISkr3bErvGYlkrNT2m1+Dh3sJS1rssEtqUAwcO4AtrP4OXLLwY58TZ7XZEUw66hAisSMqlTcPdXZk30vL8o97Nxpe/OePThymTG9FT74R45Q9VNBuhOxPgUSFdhFAhmjLAyCHm9Vli4lWqh+tgnh5qo7rY+1It6+KBHZuNEoSFHWVl445EXV0doqnW9o7XOc27VAcuLjoCqp8UO89TM8ddo6Ko9UXuyKmlKArcdPVwleJBqNDCBca5vygJZnrulh30xZr1p30fpWyco18VFncwRguNKCpx2FWUnNiF+vSMJyuL2XEWREfRUSWSXiHVTtsJsy3R6RIhNDRUO5Pe4U6ns9UpldC+BFIkNQ3/yxw3ukkUZZjS/hjs0/AOKRoiIURBKNiEIYrH+Y599Ni8N5WnceNVw1WJwalapaD2CeKE1jDAiKKw5t7AywYocTpaUkG79x1WxZxxMZHe0T2Joi4eZKHTi4eAKUFgw3wqDPM+fZNpUfYutQldBYqbVZYbwCiPjYpUjxE9IQLqFBnujn7qSJUR/PXfn9KCJcvpnRceo26xMUq8UGLgCyKx5tEXTHVzSISK0NB9AZi7D6BtBQe8BZwgPjaaQlx1FyqKEoQOQUBEUuFXZqpRm+tGXdEkijKquP0R6VmuCgKD/lHocIDniKjQmeDdz1bSvHeX0l+fmEHdO3dSkZE/vwoeVPPIyoimXvlgKW3Md5AteQjVm0KbCBR8KZQfoPpdRVG6/oxEUYJwMgEhUjwgl4H7MVeO8npRwDNh9yRQG4X5d8CY4Gv0Nsc9qs/hI/3yxxOoX88ElfZBzHwjJq8wsauzNHvNSdfYWriPz/G/FGwJp+jkIU32ofSgZ7dYlYru27YZRZx5NblZs0loN1zuf7tWp3CB2JepoxIQIqWRNiEyPIz2u6zebZij11LZAcRnUO+eKi3DnDtEQwaod8KCofCS0gb39y7aoGqogt3ZMQTKWLQBkVddfT3lbD7RMwpLud/xyO/UVJj4EeObXD/IpLF5Hk8N1ceNNM+ha/pEEtqVsLAwnf/dTtsCxwN6ZLV6+onQvgRIZ05KxRSYwpITfhEW4PQHBApCNX7UMCU8WEQUkRJAZ8+fPfcyPTJngYq2knp0bbKyMUYAcTz8KoARPIjVNcNSeORvg/e45197j6OxYyrNMwo3DRI5gtJcDSd6WWn6dEnz2p/y8nIy5sG1kl+eaRM9oX3o8MY5/CgOhmwR8T281eWgvLjpwgeIimbeOYHvB6iIaCiP7MHYRrTz+qJltHRljhIpdDjAcQ/ffbtXvHzBa+A3qd5SbKSjXQv6RuVs3qH2z39nCX20/BtVWd48zYNRjnYu6Kvu9aFyslRrFr2RJmg6baz5NiubhDYHRZAOhyOPhQopX2vEJyYyMvIrFqprZaTvwtLhRYr1ws4ZFFWaowjNU5DmuZcxd/tRzcUJ6duh4hJ6f1m2V5iM41586F6aOHYUJcTFeD0nlB74GuPwpTDCB7GCUKE8HKkhUjyI07x3lygfqlP/4U3eJwQKRjma7bmjPG0hwihL2sQV7GtlcMCWV52zeBgJ7QL+DXft2oVVXrKplZ0E+NhhUVFR6/Pz8+9pqfrcZwEHNScwUBdDuJB0eJHi3z077ht49AxdDjCJ2IiGJl3nnjwM7wji9E3eNjaz328iTE/9/Md05w8y3A3zdHQj1slZWa26HWDdPvwSopgzKMg98odpMxAnw6sCWJgBIM2DQMGHMoWc8LlieLTQEKgTdVv6NJ+1esSXOg+wz6Q3NDTMN5lMZ+I3oZf8ioKCguzGxsaVWFLM2IH2KYWFhZmeligQKh2LOrBQSSlJGxIIdVJ2/A/iBAGYnjle+U4QKkOc4Cu9/elX7De9QoOSEumJn/4P3T7+KnWMscaeUf+E54iSUHQJcTJxmIbSA2NVZLXIqNXs9aqM3uYYETQFh1C3UTc38aGslhD2sKxNBCos0kYsSlRdXgY/zamZ9LFt7EsFxFJlbQ26CLCIQGyyfXpAtQq0f2GxavIa18mzE9Bf/GmOvFYG+lp455OOH0np/BdMc1eWP/mz/1EThZHWoZGc0RsK6RgECnP1/vn8r1XNUwmLElqyIEJS3hKLTrDnvjmdIsNbvP5v/+FeCRkChQjKV6BQamBP6MwjeZWUOHAw9R95NYWYLap1MXwpwH/cp1etaTuB8qxpR4J/2JvSOT17yLMAQ3uByCqbhDYhcCrOGSVQmIcX5RYKRDlYnfjjle507Olf3KkWCEXahs6bCbHnNniDpdpfef8Tr0CFRnZqsr+xUff2MefkgOLCTKQdPcxRlWe5dk0JlHQ8OI8gUj527NgGp9OJpnJttU5ek0tQO/VOv1QJKJGCeW1MdUF0g17nRu9yTIPpl5igHmMicainxS+ExpgAjFE6LI+F9sMPTrlFddX0hzsye1l5W/CgOg8bc5JAAaMAFLVRCV060fEDu0+0L3aXHiykNsYziuXwk4qcEeHh4Zhk29q6onansrJSLS9ObUBsbCwizjkccUZzCnfWC4u2ACZt+xsNbMsRwktqtDEQRMphPFiQ9YUyzOExbdrp8AoUgGeE9fJSknsqjwkpXnMQeUF4cHuFIzAsiYWFFIZ4lsnae+hIkxFBwyRvXgvlC6a/oLq8cP0aNQXG40FNVAtItB/n/EvcFqLgM+xP50pbia+Bx5+ajdS4jYXKGRwc3CQ6RvS2f/9+Z21trYPOcQEInGv37t34921tKUWHp+MXc+onRGrhki9UNIWGcxAYX7B95h//7l1x2GgR3Pw4XyBGiLImP/aCumElGkOg0BuquUnuizt6iqEEm5nWLX3fWKHGwQI1rD0FylMugSb+2XQO4EtstVqzyeePwIV6Lz7ncrTFuQzwGfv06TObRSqJn7ZFu2a0/n3IXzfP+vp6dPpsi/7nEFX9TFoId3Q6vEgFhZz45XqCjXOAkTise9c8XUPB5fz3lpI1NMQ7Dw+rvrS07FRLoJK8eZmBL2i/MjC5O5Xv2U4r3/+HMsp5DHGexaoEykHtDMxhHm6/51y/0N27d0fzt2vpHISqrd6L77mobQRF4elRjl7mWM0YPZ7PyiPE5+PXX4te5/72ezpqzjuTPu0t0Zbn6ggExFC1eeTEUiy+8O4Lj6qizfiYKFUicD17Ul+v39LkWJQdrP7nn8hqMaspLig3wGKiD89ZoI6FsJUdr6SeXbuo9M53KSqkd7EpVzZZSMEXpHbdOXqqLD6oIifPAqQOj/+UTecZT6FhKtrm+i5vhFofpHJY3KA1y7R7RgyxGordt3EczsNfbicLR/bpznOq9+I5R15r+4m35blaOLfNs/pLKp9rKD43uVMrI70yPmuep+96dmtLDnxWl0n1fe/8b1HqWSor+wx/Dn7Pxdv2nMvP4WIiIETKMjJzIf9JnAqRGjVkIHXt5F515Y5HX/AWWvqCOip4VzDPUV6AHwL+on7MftNtY9LUoqJfc1p3DaeCMN8xehfZayBF9RxwUvSEtA6Le3bm6Kn8cJFXnDze0zysCUiCIJw1gdGZ00QLfZ8aK7U88dPJasSuOYZ3hf5OWMYKFeaYjzd25FA6XFpOA5N60frtu1UqiNdj5A4pnq9AIWpK6GyjPj1iyVRxRPlOqxe/Q8X79zqxorI1TO8tAiUI505AiFRNDeUhctm6e5+qgTKWO1crGc+aftLxEKhtBe65fRjpg1gdKz/urixnrwrtW46VVaj9D0y+hWpKD5Or3r1aMebgpfTtQTZTDR3ekkMr3v4rrfvPRyeJ04VcIl0QAonAiKTyslRqNf/dJarUoNJnXTx4TP6McXc7lWJysv/kW6pgUOl5/QwWKYWziCOsBKo/uof++8YcFTVhKk59bU22TvosESdBaB8CZ45XaqbNHKqtSB/SP/XdFx5Tm0qc5fTrP71Orz05Q3lL5VE9OXWLUZFR2e6mCzQYPhXYylHWg7/7C21f/Df1HAb8pr1HKdhs9prhLExzrVZ6S0RJENqXwKk4RzSVnvmrnM07Vqi2KV98Q0tWrKY3nv6liqYQLcV3H6pG5tQtxt0dE3VOVUf3EaKwRV9+Q9NuG88RU6Ia1cMNntTQfnY18meY4RYLzYU41ZIgCO1NwM2WRzkCR1O2Q8Wl9PlfnlUCtXFnIaXf/Wuyj5tMuinE7+saK8uoZNOqJi2HIVDREeFK4NiKd1qtem+JnATh/BJQc/eARvoSjqamIlUzijk35TtU94GEyGCKiI0jXQv2FnOqFWIa66m6VCdb6kjanruKGmrdMVJpeaXTWXHcqeumPM3kmicCJQjnn4ATKVWOoNNUREAGmNrCBrcyu0EIe0shoe6mdfV1NbzvROKGlM6k6W/pGmXV5kgrX0G40ARkczS05J0x5ZaMP866R619h4UVSNPHsgAN5eHM3i7d1EvTdJuua05NY5+JXGW6i/IoiLJlUQRBuLgITJHCwgYubcOYKy6zuScEawtrchZNJ0EQOhwB22bWLVS0GJGSxUoTxU8SBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQLin+Dz5IwjUsPBVBAAAAAElFTkSuQmCC',
  },
};
