import { AggregatorNetwork } from './types';

export const defaultBuyableChains: AggregatorNetwork[] = [
  {
    active: true,
    chainId: 1,
    chainName: 'Ethereum Mainnet',
    shortName: 'Ethereum',
    nativeTokenSupported: true,
  },
  {
    active: true,
    chainId: 10,
    chainName: 'Optimism Mainnet',
    shortName: 'Optimism',
    nativeTokenSupported: true,
  },
  {
    active: true,
    chainId: 25,
    chainName: 'Cronos Mainnet',
    shortName: 'Cronos',
    nativeTokenSupported: true,
  },
  {
    active: true,
    chainId: 56,
    chainName: 'BNB Chain Mainnet',
    shortName: 'BNB Chain',
    nativeTokenSupported: true,
  },
  {
    active: true,
    chainId: 100,
    chainName: 'Gnosis Mainnet',
    shortName: 'Gnosis',
    nativeTokenSupported: true,
  },
  {
    active: true,
    chainId: 137,
    chainName: 'Polygon Mainnet',
    shortName: 'Polygon',
    nativeTokenSupported: true,
  },
  {
    active: true,
    chainId: 250,
    chainName: 'Fantom Mainnet',
    shortName: 'Fantom',
    nativeTokenSupported: true,
  },
  {
    active: true,
    chainId: 324,
    chainName: 'zkSync Era Mainnet',
    shortName: 'zkSync Era',
    nativeTokenSupported: true,
  },
  {
    active: true,
    chainId: 1101,
    chainName: 'Polygon zkEVM',
    shortName: 'Polygon zkEVM',
    nativeTokenSupported: true,
  },
  {
    active: true,
    chainId: 1284,
    chainName: 'Moonbeam Mainnet',
    shortName: 'Moonbeam',
    nativeTokenSupported: true,
  },
  {
    active: true,
    chainId: 1285,
    chainName: 'Moonriver Mainnet',
    shortName: 'Moonriver',
    nativeTokenSupported: true,
  },
  {
    active: true,
    chainId: 8453,
    chainName: 'Base Mainnet',
    shortName: 'Base',
    nativeTokenSupported: true,
  },
  {
    active: true,
    chainId: 42161,
    chainName: 'Arbitrum Mainnet',
    shortName: 'Arbitrum',
    nativeTokenSupported: true,
  },
  {
    active: true,
    chainId: 42220,
    chainName: 'Celo Mainnet',
    shortName: 'Celo',
    nativeTokenSupported: false,
  },
  {
    active: true,
    chainId: 43114,
    chainName: 'Avalanche C-Chain Mainnet',
    shortName: 'Avalanche C-Chain',
    nativeTokenSupported: true,
  },
  {
    active: true,
    chainId: 59144,
    chainName: 'Linea',
    shortName: 'Linea',
    nativeTokenSupported: true,
  },
  {
    active: true,
    chainId: 1313161554,
    chainName: 'Aurora Mainnet',
    shortName: 'Aurora',
    nativeTokenSupported: false,
  },
  {
    active: true,
    chainId: 1666600000,
    chainName: 'Harmony Mainnet (Shard 0)',
    shortName: 'Harmony (Shard 0)',
    nativeTokenSupported: true,
  },
  {
    active: true,
    chainId: 11297108109,
    chainName: 'Palm Mainnet',
    shortName: 'Palm',
    nativeTokenSupported: false,
  },
];
