/* eslint-disable @metamask/design-tokens/color-no-hex*/
import React, { useState, useEffect } from 'react';
import PropTypes from 'prop-types';
import { ThemeType } from '../../../../shared/constants/preferences';

const LOGO_WIDTH = 162;
const LOGO_HEIGHT = 30;
const TEXT_COLOR = 'var(--color-text-default)';
const FLASK_PILL_BACKGROUND = 'var(--color-overlay-alternative)';
const FLASK_PILL_TEXT = 'var(--color-overlay-inverse)';
const BETA_PILL_BACKGROUND = 'var(--color-primary-default)';
const BETA_PIL_TEXT = 'var(--color-primary-inverse)';

export default function MetaFoxHorizontalLogo({
  theme: themeProps,
  className,
}) {
  const [theme, setTheme] = useState(() =>
    themeProps === undefined
      ? document.documentElement.getAttribute('data-theme')
      : themeProps,
  );

  useEffect(() => {
    if (themeProps !== undefined) {
      setTheme(themeProps);
    }
  }, [themeProps]);

  const fill = theme === 'dark' ? 'rgb(255,255,255)' : 'rgb(22,22,22)';

  switch (process.env.METAMASK_BUILD_TYPE) {
    case 'beta':
      return (
        <svg
          width={LOGO_WIDTH}
          height={LOGO_HEIGHT}
          viewBox="0 0 723 115"
          fill="none"
          xmlns="http://www.w3.org/2000/svg"
          className={className}
        >
          <g clipPath="url(#clip0_3375_9161)">
            <path
              d="M546.118 57.394C542.911 55.2721 539.373 53.7633 536.024 51.8772C533.854 50.6512 531.542 49.5668 529.655 48.0107C526.447 45.3702 527.108 40.1835 530.457 37.9202C535.269 34.7139 543.241 36.5057 544.09 43.0598C544.09 43.2012 544.232 43.2955 544.373 43.2955H551.638C551.826 43.2955 551.968 43.1541 551.921 42.9655C551.543 38.4389 549.798 34.6667 546.59 32.262C543.524 29.9515 540.033 28.7256 536.307 28.7256C517.107 28.7256 515.362 49.0481 525.693 55.4607C526.872 56.2152 537.014 61.3076 540.599 63.5237C544.184 65.7399 545.317 69.7949 543.76 73.0013C542.345 75.9247 538.665 77.9522 534.986 77.7165C530.976 77.4807 527.863 75.3117 526.778 71.9168C526.589 71.3038 526.495 70.125 526.495 69.6063C526.495 69.4649 526.353 69.3234 526.212 69.3234H518.334C518.192 69.3234 518.051 69.4649 518.051 69.6063C518.051 75.3117 519.466 78.4709 523.334 81.3472C526.966 84.082 530.929 85.2136 535.033 85.2136C545.788 85.2136 551.355 79.131 552.487 72.8127C553.477 66.6358 551.638 61.0718 546.118 57.394Z"
              fill={TEXT_COLOR}
            />
            <path
              d="M204.069 29.7638H200.578H196.757C196.616 29.7638 196.521 29.8581 196.474 29.9524L190.011 51.2648C189.917 51.5477 189.54 51.5477 189.445 51.2648L182.983 29.9524C182.935 29.8109 182.841 29.7638 182.7 29.7638H178.879H175.388H170.671C170.529 29.7638 170.388 29.9052 170.388 30.0467V84.4594C170.388 84.6008 170.529 84.7423 170.671 84.7423H178.548C178.69 84.7423 178.831 84.6008 178.831 84.4594V43.1076C178.831 42.7776 179.303 42.7304 179.398 43.0133L185.907 64.4672L186.379 65.9761C186.426 66.1175 186.521 66.1647 186.662 66.1647H192.7C192.842 66.1647 192.936 66.0704 192.983 65.9761L193.455 64.4672L199.965 43.0133C200.059 42.6833 200.531 42.7776 200.531 43.1076V84.4594C200.531 84.6008 200.672 84.7423 200.814 84.7423H208.692C208.833 84.7423 208.975 84.6008 208.975 84.4594V30.0467C208.975 29.9052 208.833 29.7638 208.692 29.7638H204.069Z"
              fill={TEXT_COLOR}
            />
            <path
              d="M425.498 29.7638C425.356 29.7638 425.262 29.8581 425.215 29.9524L418.752 51.2648C418.658 51.5477 418.28 51.5477 418.186 51.2648L411.723 29.9524C411.676 29.8109 411.582 29.7638 411.44 29.7638H399.458C399.317 29.7638 399.175 29.9052 399.175 30.0467V84.4594C399.175 84.6008 399.317 84.7423 399.458 84.7423H407.336C407.478 84.7423 407.619 84.6008 407.619 84.4594V43.1076C407.619 42.7776 408.091 42.7304 408.185 43.0133L414.695 64.4672L415.167 65.9761C415.214 66.1175 415.308 66.1647 415.45 66.1647H421.488C421.629 66.1647 421.724 66.0704 421.771 65.9761L422.243 64.4672L428.753 43.0133C428.847 42.6833 429.319 42.7776 429.319 43.1076V84.4594C429.319 84.6008 429.46 84.7423 429.602 84.7423H437.479C437.621 84.7423 437.763 84.6008 437.763 84.4594V30.0467C437.763 29.9052 437.621 29.7638 437.479 29.7638H425.498Z"
              fill={TEXT_COLOR}
            />
            <path
              d="M323.887 29.7638H309.216H301.339H286.668C286.526 29.7638 286.385 29.9052 286.385 30.0467V36.8365C286.385 36.978 286.526 37.1194 286.668 37.1194H301.056V84.4594C301.056 84.6008 301.197 84.7423 301.339 84.7423H309.216C309.358 84.7423 309.499 84.6008 309.499 84.4594V37.1194H323.887C324.029 37.1194 324.17 36.978 324.17 36.8365V30.0467C324.17 29.9052 324.076 29.7638 323.887 29.7638Z"
              fill={TEXT_COLOR}
            />
            <path
              d="M370.353 84.7419H377.523C377.712 84.7419 377.853 84.5533 377.806 84.3647L362.994 29.7633C362.947 29.6219 362.852 29.5747 362.711 29.5747H359.975H355.163H352.427C352.286 29.5747 352.191 29.669 352.144 29.7633L337.332 84.3647C337.285 84.5533 337.426 84.7419 337.615 84.7419H344.785C344.927 84.7419 345.021 84.6476 345.068 84.5533L349.361 68.6633C349.408 68.5218 349.503 68.4747 349.644 68.4747H365.494C365.636 68.4747 365.73 68.569 365.777 68.6633L370.07 84.5533C370.117 84.6476 370.259 84.7419 370.353 84.7419ZM351.531 60.6947L357.286 39.4294C357.38 39.1465 357.758 39.1465 357.852 39.4294L363.607 60.6947C363.654 60.8833 363.513 61.0719 363.324 61.0719H351.814C351.625 61.0719 351.484 60.8833 351.531 60.6947Z"
              fill={TEXT_COLOR}
            />
            <path
              d="M492.625 84.7419H499.795C499.984 84.7419 500.126 84.5533 500.078 84.3647L485.266 29.7633C485.219 29.6219 485.125 29.5747 484.983 29.5747H482.247H477.436H474.699C474.558 29.5747 474.464 29.669 474.416 29.7633L459.604 84.3647C459.557 84.5533 459.699 84.7419 459.887 84.7419H467.057C467.199 84.7419 467.293 84.6476 467.341 84.5533L471.633 68.6633C471.68 68.5218 471.775 68.4747 471.916 68.4747H487.766C487.908 68.4747 488.002 68.569 488.049 68.6633L492.342 84.5533C492.389 84.6476 492.484 84.7419 492.625 84.7419ZM473.803 60.6947L479.558 39.4294C479.653 39.1465 480.03 39.1465 480.124 39.4294L485.879 60.6947C485.927 60.8833 485.785 61.0719 485.596 61.0719H474.086C473.898 61.0719 473.756 60.8833 473.803 60.6947Z"
              fill={TEXT_COLOR}
            />
            <path
              d="M240.957 76.6786V59.7985C240.957 59.657 241.098 59.5155 241.24 59.5155H262.232C262.373 59.5155 262.515 59.3741 262.515 59.2326V52.4428C262.515 52.3014 262.373 52.1599 262.232 52.1599H241.24C241.098 52.1599 240.957 52.0185 240.957 51.877V37.4487C240.957 37.3073 241.098 37.1658 241.24 37.1658H265.109C265.251 37.1658 265.392 37.0243 265.392 36.8829V30.0931C265.392 29.9516 265.251 29.8102 265.109 29.8102H240.957H232.796C232.654 29.8102 232.513 29.9516 232.513 30.0931V37.1658V52.2071V59.5627V77.0087V84.4586C232.513 84.6001 232.654 84.7415 232.796 84.7415H240.957H266.1C266.242 84.7415 266.383 84.6001 266.383 84.4586V77.2916C266.383 77.1502 266.242 77.0087 266.1 77.0087H241.193C241.051 76.9616 240.957 76.8673 240.957 76.6786Z"
              fill={TEXT_COLOR}
            />
            <path
              d="M618.103 84.2701L590.837 56.1207C590.742 56.0264 590.742 55.8378 590.837 55.7435L615.367 30.2817C615.555 30.0931 615.414 29.8102 615.178 29.8102H605.13C605.036 29.8102 604.989 29.8573 604.941 29.9045L584.138 51.4998C583.95 51.6884 583.667 51.547 583.667 51.3112V30.0931C583.667 29.9516 583.525 29.8102 583.384 29.8102H575.506C575.364 29.8102 575.223 29.9516 575.223 30.0931V84.5058C575.223 84.6473 575.364 84.7887 575.506 84.7887H583.384C583.525 84.7887 583.667 84.6473 583.667 84.5058V60.5529C583.667 60.3172 583.997 60.1757 584.138 60.3643L607.725 84.6944C607.772 84.7416 607.866 84.7887 607.913 84.7887H617.961C618.15 84.7416 618.291 84.4115 618.103 84.2701Z"
              fill={TEXT_COLOR}
            />
            <path
              d="M713.276 103.602H641.398C636.03 103.602 631.674 99.2489 631.674 93.8841V72.7183C631.674 67.3536 636.03 63 641.398 63H713.276C718.644 63 723 67.3536 723 72.7183V93.8841C723 99.2566 718.644 103.602 713.276 103.602Z"
              fill={BETA_PILL_BACKGROUND}
            />
            <path
              d="M646.82 74.3317H653.895C654.652 74.3317 655.378 74.4782 656.058 74.7713C656.737 75.0645 657.332 75.4579 657.85 75.9592C658.359 76.4606 658.761 77.0546 659.055 77.7334C659.348 78.4122 659.495 79.1373 659.495 79.9163C659.495 80.5874 659.371 81.1891 659.124 81.729C658.877 82.269 658.553 82.7395 658.143 83.1483C658.939 83.5572 659.58 84.1434 660.082 84.9225C660.576 85.7015 660.823 86.5886 660.823 87.5991C660.823 88.3782 660.677 89.0955 660.383 89.7666C660.09 90.4377 659.688 91.024 659.178 91.5253C658.668 92.0267 658.058 92.4201 657.363 92.7055C656.668 92.9909 655.911 93.1298 655.1 93.1298H646.828V74.3317H646.82ZM653.416 81.9296C653.98 81.9296 654.451 81.7522 654.822 81.3896C655.193 81.0271 655.378 80.5951 655.378 80.0783C655.378 79.5692 655.193 79.1218 654.822 78.7439C654.451 78.3659 653.98 78.1731 653.416 78.1731H651.03V81.9296H653.416V81.9296ZM654.745 89.2575C655.309 89.2575 655.78 89.0801 656.15 88.7176C656.521 88.355 656.707 87.9076 656.707 87.3831C656.707 86.874 656.513 86.4266 656.135 86.0564C655.757 85.6861 655.285 85.501 654.714 85.501H651.03V89.2575H654.745Z"
              fill={BETA_PIL_TEXT}
            />
            <path
              d="M663.65 74.3242H675.576V78.3507H667.86V81.7139H673.985V85.7404H667.86V89.1035H675.576V93.13H663.65V74.3242Z"
              fill={BETA_PIL_TEXT}
            />
            <path
              d="M682.172 78.3424H677.376V74.3159H691.263V78.3424H686.412V93.114H682.172V78.3424Z"
              fill={BETA_PIL_TEXT}
            />
            <path
              d="M697.966 74.3242H701.782L709.838 93.1146H705.435L703.767 89.1421H695.973L694.305 93.1146H689.902L697.966 74.3242ZM697.495 85.4935H702.237L699.882 79.8549L697.495 85.4935Z"
              fill={BETA_PIL_TEXT}
            />
            <path
              d="M116.318 0L68.514 35.3718L77.4034 14.526L116.318 0Z"
              fill="#E17726"
              stroke="#E17726"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M6.05249 0L53.4311 35.702L44.9672 14.526L6.05249 0Z"
              fill="#E27625"
              stroke="#E27625"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M99.1075 82.0154L86.3881 101.446L113.624 108.945L121.426 82.4398L99.1075 82.0154Z"
              fill="#E27625"
              stroke="#E27625"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M0.99292 82.4398L8.7475 108.945L35.9358 101.446L23.2637 82.0154L0.99292 82.4398Z"
              fill="#E27625"
              stroke="#E27625"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M34.4699 49.1904L26.9044 60.6037L53.8563 61.83L52.9579 32.8251L34.4699 49.1904Z"
              fill="#E27625"
              stroke="#E27625"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M87.9012 49.1902L69.1295 32.4948L68.5148 61.8298L95.4667 60.6035L87.9012 49.1902Z"
              fill="#E27625"
              stroke="#E27625"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M35.9357 101.446L52.2487 93.5703L38.2053 82.6287L35.9357 101.446Z"
              fill="#E27625"
              stroke="#E27625"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M70.1218 93.5703L86.3875 101.446L84.1652 82.6287L70.1218 93.5703Z"
              fill="#E27625"
              stroke="#E27625"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M86.3879 101.446L70.1222 93.5702L71.4461 104.135L71.3043 108.615L86.3879 101.446Z"
              fill="#D5BFB2"
              stroke="#D5BFB2"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M35.9359 101.446L51.0668 108.615L50.9722 104.135L52.2489 93.5703L35.9359 101.446Z"
              fill="#D5BFB2"
              stroke="#D5BFB2"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M51.3504 75.6485L37.8271 71.6869L47.3785 67.3008L51.3504 75.6485Z"
              fill="#233447"
              stroke="#233447"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M71.0199 75.6485L74.9918 67.3008L84.5904 71.6869L71.0199 75.6485Z"
              fill="#233447"
              stroke="#233447"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M35.9357 101.446L38.2999 82.0154L23.2635 82.4398L35.9357 101.446Z"
              fill="#CC6228"
              stroke="#CC6228"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M84.0706 82.0154L86.3875 101.446L99.1069 82.4398L84.0706 82.0154Z"
              fill="#CC6228"
              stroke="#CC6228"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M95.4661 60.6036L68.5142 61.8299L71.0202 75.6484L74.9921 67.3007L84.5907 71.6868L95.4661 60.6036Z"
              fill="#CC6228"
              stroke="#CC6228"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M37.827 71.6868L47.3784 67.3007L51.3503 75.6484L53.8563 61.8299L26.9044 60.6036L37.827 71.6868Z"
              fill="#CC6228"
              stroke="#CC6228"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M26.9044 60.6038L38.2053 82.6286L37.827 71.6869L26.9044 60.6038Z"
              fill="#E27525"
              stroke="#E27525"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M84.5912 71.6868L84.1656 82.6285L95.4665 60.6036L84.5912 71.6868Z"
              fill="#E27525"
              stroke="#E27525"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M53.8565 61.83L51.3505 75.6485L54.5185 91.9667L55.2278 70.4607L53.8565 61.83Z"
              fill="#E27525"
              stroke="#E27525"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M68.5146 61.83L67.1907 70.4135L67.8526 91.9667L71.0207 75.6485L68.5146 61.83Z"
              fill="#E27525"
              stroke="#E27525"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M71.0207 75.6484L67.8527 91.9666L70.1223 93.5701L84.1656 82.6284L84.5912 71.6868L71.0207 75.6484Z"
              fill="#F5841F"
              stroke="#F5841F"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M37.8271 71.6868L38.2054 82.6284L52.2488 93.5701L54.5184 91.9666L51.3504 75.6484L37.8271 71.6868Z"
              fill="#F5841F"
              stroke="#F5841F"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M71.3044 108.615L71.4462 104.135L70.2168 103.097H52.1543L50.9722 104.135L51.0668 108.615L35.9359 101.446L41.2317 105.785L51.9652 113.19H70.3587L81.1394 105.785L86.388 101.446L71.3044 108.615Z"
              fill="#C0AC9D"
              stroke="#C0AC9D"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M70.122 93.5702L67.8523 91.9667H54.5182L52.2486 93.5702L50.9719 104.135L52.154 103.097H70.2165L71.4459 104.135L70.122 93.5702Z"
              fill="#161616"
              stroke="#161616"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M118.352 37.6828L122.371 18.1575L116.319 0L70.1222 34.1928L87.901 49.1904L113.009 56.5006L118.541 50.0393L116.13 48.2943L119.96 44.8043L117.028 42.5405L120.858 39.6164L118.352 37.6828Z"
              fill="#763E1A"
              stroke="#763E1A"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M0 18.1575L4.06643 37.6828L1.4658 39.6164L5.34309 42.5405L2.41149 44.8043L6.24149 48.2943L3.83001 50.0393L9.36224 56.5006L34.4701 49.1904L52.2488 34.1928L6.05236 0L0 18.1575Z"
              fill="#763E1A"
              stroke="#763E1A"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M113.009 56.5005L87.9011 49.1903L95.4665 60.6036L84.1656 82.6285L99.1074 82.4398H121.425L113.009 56.5005Z"
              fill="#F5841F"
              stroke="#F5841F"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M34.47 49.1903L9.36219 56.5005L0.99292 82.4398H23.2637L38.2054 82.6285L26.9046 60.6036L34.47 49.1903Z"
              fill="#F5841F"
              stroke="#F5841F"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M68.5148 61.83L70.1225 34.1929L77.4042 14.5261H44.9674L52.2491 34.1929L53.8568 61.83L54.4715 70.5079L54.5188 91.9668H67.8529L67.9002 70.5079L68.5148 61.83Z"
              fill="#F5841F"
              stroke="#F5841F"
              strokeWidth="0.353718"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
          </g>
          <defs>
            <clipPath id="clip0_3375_9161">
              <rect
                width="723"
                height="114.133"
                fill="var(--color-text-default)"
              />
            </clipPath>
          </defs>
        </svg>
      );
    case 'flask':
      return (
        <svg
          width={LOGO_WIDTH}
          height={LOGO_HEIGHT}
          viewBox="0 0 1532 247"
          fill="none"
          xmlns="http://www.w3.org/2000/svg"
          className={className}
        >
          <g clipPath="url(#clip0)">
            <path
              d="M148.354 134.603L152.72 74.4431L170.498 31.5908H94.5015L112.279 74.4431L116.645 134.603L117.997 153.579L118.101 200.289H146.898L147.002 153.579L148.354 134.603Z"
              fill="url(#paint0_linear)"
            />
            <path
              d="M244.727 123.029L190.355 107.077L206.781 131.996L182.246 179.957L214.682 179.54H262.92L244.727 123.029Z"
              fill="url(#paint1_linear)"
            />
            <path
              d="M74.6449 107.077L20.2726 123.029L2.18311 179.54H50.4216L82.7539 179.957L58.2188 131.996L74.6449 107.077Z"
              fill="url(#paint2_linear)"
            />
            <path
              d="M153.76 164.735L146.899 200.289L151.889 203.729L182.246 179.957L183.182 156.081L153.76 164.735Z"
              fill="#ACACAC"
            />
            <path
              d="M81.9224 156.081L82.7541 179.957L113.111 203.729L118.101 200.289L111.24 164.735L81.9224 156.081Z"
              fill="#ACACAC"
            />
            <path
              d="M256.267 82.0553L265 39.5158L251.9 0L151.889 74.4441L189.211 108.017L244.727 123.031L256.683 108.955L251.485 105.202L259.802 97.5906L253.46 92.5859L261.777 86.2258L256.267 82.0553Z"
              fill="url(#paint3_linear)"
            />
            <path
              d="M8.73266 82.0553L-0.000171178 39.5158L13.0991 0L113.111 74.4441L75.7884 108.017L20.2725 123.031L8.31682 108.955L13.5149 105.202L5.19795 97.5906L11.5396 92.5859L3.22265 86.2258L8.73266 82.0553Z"
              fill="url(#paint4_linear)"
            />
            <path
              d="M58.2188 131.997L81.9222 156.082L82.7539 179.958L58.2188 131.997Z"
              fill="#8D8D8D"
            />
            <path
              d="M206.781 131.997L182.246 179.958L183.181 156.082L206.781 131.997Z"
              fill="#8D8D8D"
            />
            <path
              d="M187.132 220.935L151.889 203.731L154.696 226.774L154.384 236.47L187.132 220.935Z"
              fill="#FF9F5A"
            />
            <path
              d="M77.8677 220.934L110.616 236.469L110.408 226.773L113.111 203.73L77.8677 220.934Z"
              fill="#FF9F5A"
            />
            <path
              d="M214.682 179.542L187.132 220.935L246.079 237.2L262.921 179.542H214.682Z"
              fill="url(#paint5_linear)"
            />
            <path
              d="M2.18311 179.542L18.921 237.2L77.8677 220.935L50.4216 179.542H2.18311Z"
              fill="url(#paint6_linear)"
            />
            <path
              d="M13.0991 0L113.111 74.4441L97.4126 31.5918L13.0991 0Z"
              fill="#757575"
            />
            <path
              d="M167.587 31.5918L151.889 74.4441L251.9 0L167.587 31.5918Z"
              fill="#757575"
            />
            <path
              d="M74.6448 107.079L58.2188 131.998L116.646 134.604L113.111 74.4443L74.6448 107.079Z"
              fill="url(#paint7_linear)"
            />
            <path
              d="M190.355 107.079L151.889 74.4443L148.354 134.604L206.781 131.998L190.355 107.079Z"
              fill="url(#paint8_linear)"
            />
            <path
              d="M77.8677 220.934L113.111 203.731L82.7539 179.959L77.8677 220.934Z"
              fill="url(#paint9_linear)"
            />
            <path
              d="M151.889 203.731L187.132 220.934L182.246 179.959L151.889 203.731Z"
              fill="url(#paint10_linear)"
            />
            <path
              d="M182.246 179.958L187.132 220.934L214.682 179.541L182.246 179.958Z"
              fill="url(#paint11_linear)"
            />
            <path
              d="M82.7539 179.958L77.8677 220.934L50.3177 179.541L82.7539 179.958Z"
              fill="url(#paint12_linear)"
            />
            <path
              d="M206.781 131.997L148.354 134.604L153.761 164.736L162.389 146.594L183.182 156.082L206.781 131.997Z"
              fill="#666666"
            />
            <path
              d="M81.9222 156.082L102.611 146.594L111.24 164.736L116.646 134.604L58.2188 131.997L81.9222 156.082Z"
              fill="#666666"
            />
            <path
              d="M153.76 164.736L147.002 153.579L148.354 134.604L153.76 164.736Z"
              fill="#8D8D8D"
            />
            <path
              d="M111.24 164.736L116.646 134.604L117.997 153.579L111.24 164.736Z"
              fill="#8D8D8D"
            />
            <path
              d="M147.003 153.58L153.76 164.736L146.899 200.29L147.003 153.58Z"
              fill="#8D8D8D"
            />
            <path
              d="M117.997 153.58L118.101 200.29L111.24 164.736L117.997 153.58Z"
              fill="#8D8D8D"
            />
            <path
              d="M154.571 236.345L154.696 226.773L152.097 224.48H112.903L110.408 226.773L110.616 236.47L77.8677 220.935L89.3035 230.318L112.591 246.479H152.409L175.696 230.318L187.132 220.935L154.571 236.345Z"
              fill="#DF7554"
            />
            <path
              d="M151.889 203.731L146.899 200.29H118.101L113.111 203.731L110.408 226.773L112.903 224.479H152.097L154.696 226.773L151.889 203.731Z"
              fill="#161616"
              stroke="#161616"
              strokeWidth="0.0657594"
              strokeMiterlimit="10"
              strokeLinejoin="round"
            />
            <path
              d="M162.389 146.594L153.76 164.736L183.182 156.082L162.389 146.594Z"
              fill="#161616"
            />
            <path
              d="M102.611 146.594L111.24 164.736L81.9224 156.082L102.611 146.594Z"
              fill="#161616"
            />
            <path
              d="M256.683 108.955L251.485 105.202L259.802 97.5905L253.46 92.5859L261.777 86.2258L256.267 82.0553L265 39.5158L251.901 0L167.587 31.5918H97.4127L13.0993 0L0 39.5158L8.8368 82.0553L3.22283 86.2258L11.5398 92.5859L5.19812 97.5905L13.5151 105.202L8.31699 108.955L20.2727 123.031L2.18321 179.542L18.9211 237.199L77.8678 220.934L113.111 203.731L110.231 227.044L112.903 224.583L152.097 224.479L154.696 226.773L151.889 203.731L187.132 220.934L246.079 237.199L262.921 179.542L244.727 123.031L256.683 108.955Z"
              fill="url(#paint13_linear)"
              fillOpacity="0.1"
              style={{ mixBlendMode: 'color-dodge' }}
            />
            <path
              d="M256.683 108.955L251.485 105.202L259.802 97.5905L253.46 92.5859L261.777 86.2258L256.267 82.0553L265 39.5158L251.901 0L167.587 31.5918H97.4127L13.0993 0L0 39.5158L8.8368 82.0553L3.22283 86.2258L11.5398 92.5859L5.19812 97.5905L13.5151 105.202L8.31699 108.955L20.2727 123.031L2.18321 179.542L18.9211 237.199L77.8678 220.934L113.111 203.731L117.997 200.186H125.275H139.829H147.107L151.889 203.731L187.132 220.934L246.079 237.199L262.921 179.542L244.727 123.031L256.683 108.955Z"
              fill="url(#paint14_radial)"
              style={{ mixBlendMode: 'overlay' }}
            />
          </g>
          <path
            d="M1166.17 120.732C1159.42 116.127 1151.72 112.742 1144.35 108.759C1139.75 106.295 1134.84 103.855 1130.83 100.47C1124.08 94.944 1125.3 83.5933 1132.67 78.6647C1143.11 71.9189 1160.02 75.603 1161.86 89.7167C1161.86 90.0154 1162.16 90.339 1162.48 90.339H1178.15C1178.44 90.339 1178.77 90.0403 1178.77 89.7167C1177.85 79.8844 1174.16 71.9189 1167.41 66.6916C1160.94 61.763 1153.27 59 1145.27 59C1104.11 59 1100.42 102.611 1122.54 116.426C1125 117.969 1146.82 129.021 1154.49 133.626C1162.16 138.53 1164.62 147.143 1161.24 153.888C1158.17 160.335 1150.18 164.318 1142.48 164.019C1133.89 163.721 1127.12 158.792 1124.98 151.424C1124.68 150.204 1124.36 147.74 1124.36 146.52C1124.36 146.222 1124.06 145.898 1123.73 145.898H1106.85C1106.55 145.898 1106.23 146.197 1106.23 146.52C1106.23 158.792 1109.29 165.563 1117.58 171.711C1125.25 177.536 1133.87 180 1142.78 180C1165.82 180 1177.8 166.807 1180.26 153.291C1182.13 140.372 1178.14 128.399 1166.17 120.732Z"
            fill={TEXT_COLOR}
          />
          <path
            d="M433.192 61.4634H425.522H417.229C416.931 61.4634 416.607 61.7621 416.607 61.7621L402.786 107.514C402.487 108.136 401.865 108.136 401.566 107.514L388.044 61.7621C388.044 61.4634 387.745 61.4634 387.421 61.4634H379.129H371.758H361.623C361.299 61.4634 361 61.7621 361 62.0608V178.754C361 179.053 361.299 179.377 361.623 179.377H378.506C378.805 179.377 379.129 179.078 379.129 178.754V90.0145C379.129 89.3922 380.05 89.0935 380.349 89.7158L394.469 135.766L395.39 138.828C395.39 139.126 395.689 139.126 396.013 139.126H408.912C409.211 139.126 409.535 138.828 409.535 138.828L410.456 135.766L424.576 89.7158C424.576 89.0935 425.497 89.4171 425.497 90.0145V178.754C425.497 179.053 425.796 179.377 426.12 179.377H443.003C443.302 179.377 443.626 179.078 443.626 178.754V62.0608C443.626 61.7621 443.327 61.4385 443.003 61.4385L433.192 61.4634Z"
            fill={TEXT_COLOR}
          />
          <path
            d="M907.506 61.4634C907.207 61.4634 906.883 61.7621 906.883 61.7621L893.063 107.514C892.764 108.136 892.141 108.136 891.842 107.514L878.022 61.7621C878.022 61.4634 877.723 61.4634 877.399 61.4634H851.6C851.301 61.4634 850.978 61.7621 850.978 62.0857V178.779C850.978 179.078 851.276 179.402 851.6 179.402H868.484C868.783 179.402 869.106 179.103 869.106 178.779V90.0145C869.106 89.3922 870.028 89.0935 870.327 89.7158L884.446 135.766L885.368 138.828C885.368 139.126 885.667 139.126 885.99 139.126H898.89C899.189 139.126 899.512 138.828 899.512 138.828L900.434 135.766L914.553 89.7158C914.852 89.0935 915.773 89.0935 915.773 90.0145V178.754C915.773 179.053 916.072 179.377 916.396 179.377H933.28C933.579 179.377 933.902 179.078 933.902 178.754V62.0608C933.902 61.7621 933.604 61.4385 933.28 61.4385L907.506 61.4634Z"
            fill={TEXT_COLOR}
          />
          <path
            d="M690.01 61.4648H658.359H641.475H610.148C609.849 61.4648 609.525 61.7635 609.525 62.0871V76.5245C609.525 76.8232 609.824 77.1468 610.148 77.1468H640.877V178.482C640.877 178.781 641.176 179.104 641.5 179.104H658.384C658.683 179.104 659.006 178.806 659.006 178.482V77.1219H689.711C690.01 77.1219 690.333 76.8232 690.333 76.4996V62.0623C690.632 61.7635 690.309 61.4648 690.01 61.4648Z"
            fill={TEXT_COLOR}
          />
          <path
            d="M789.545 179.377H804.91C805.208 179.377 805.532 179.078 805.532 178.456L773.582 61.4637C773.582 61.165 773.284 61.165 772.96 61.165H767.133H756.699H751.17C750.872 61.165 750.548 61.4637 750.548 61.4637L718.897 178.456C718.897 178.755 719.196 179.377 719.52 179.377H734.884C735.183 179.377 735.507 179.078 735.507 179.078L744.721 145.001C744.721 144.703 745.02 144.703 745.343 144.703H779.435C779.733 144.703 780.057 145.001 780.057 145.001L789.271 179.078C788.922 179.054 789.246 179.377 789.545 179.377ZM749.004 127.776L761.281 82.3232C761.58 81.7009 762.202 81.7009 762.501 82.3232L774.778 127.776C774.778 128.075 774.479 128.697 774.155 128.697H749.577C749.303 128.398 749.004 128.1 749.004 127.776Z"
            fill={TEXT_COLOR}
          />
          <path
            d="M1051.59 179.377H1066.96C1067.26 179.377 1067.58 179.078 1067.58 178.456L1035.63 61.4637C1035.63 61.165 1035.33 61.165 1035.01 61.165H1029.18H1018.75H1012.92C1012.62 61.165 1012.3 61.4637 1012.3 61.4637L980.646 178.456C980.646 178.755 980.944 179.377 981.268 179.377H996.633C996.932 179.377 997.255 179.078 997.255 179.078L1006.47 145.001C1006.47 144.703 1006.77 144.703 1007.09 144.703H1041.18C1041.48 144.703 1041.81 145.001 1041.81 145.001L1051.02 179.078C1050.97 179.054 1051.27 179.377 1051.59 179.377ZM1011.03 127.776L1023.3 82.3232C1023.6 81.7009 1024.22 81.7009 1024.52 82.3232L1036.8 127.776C1036.8 128.075 1036.5 128.697 1036.18 128.697H1011.6C1011.35 128.398 1011.03 128.1 1011.03 127.776Z"
            fill={TEXT_COLOR}
          />
          <path
            d="M512.132 162.176V125.934C512.132 125.635 512.431 125.311 512.755 125.311H557.604C557.903 125.311 558.227 125.013 558.227 124.689V110.252C558.227 109.953 557.928 109.629 557.604 109.629H512.755C512.456 109.629 512.132 109.331 512.132 109.007V77.7427C512.132 77.444 512.431 77.1204 512.755 77.1204H563.755C564.054 77.1204 564.377 76.8217 564.377 76.4981V62.0608C564.377 61.7621 564.079 61.4385 563.755 61.4385H512.132H494.626C494.327 61.4385 494.003 61.7372 494.003 62.0608V77.0955V109.331V124.988V162.45V178.406C494.003 178.705 494.302 179.028 494.626 179.028H512.132H566.195C566.494 179.028 566.818 178.73 566.818 178.406V163.048C566.818 162.749 566.519 162.425 566.195 162.425H512.755C512.456 162.799 512.132 162.475 512.132 162.176Z"
            fill={TEXT_COLOR}
          />
          <path
            d="M1320.39 178.132L1262.02 117.645C1261.72 117.346 1261.72 117.022 1262.02 116.724L1314.54 62.3844C1314.83 62.0857 1314.54 61.4634 1314.24 61.4634H1292.72C1292.42 61.4634 1292.42 61.4634 1292.42 61.7621L1247.87 108.136C1247.57 108.435 1246.95 108.136 1246.95 107.837V62.0608C1246.95 61.7621 1246.65 61.4385 1246.33 61.4385H1229.44C1229.15 61.4385 1228.82 61.7372 1228.82 62.0608V178.754C1228.82 179.053 1229.12 179.377 1229.44 179.377H1246.33C1246.63 179.377 1246.95 179.078 1246.95 178.754V127.178C1246.95 126.556 1247.57 126.257 1247.87 126.88L1298.25 179.078L1298.55 179.377H1320.06C1320.69 179.377 1320.99 178.754 1320.39 178.132Z"
            fill={TEXT_COLOR}
          />
          <rect
            x="1338"
            y="27"
            width="194"
            height="84"
            rx="12"
            fill={FLASK_PILL_BACKGROUND}
          />
          <path
            d="M1358 50.6376H1380.89V58.7139H1366.33V65.515H1377.7V73.5913H1366.33V88.3624H1358V50.6376Z"
            fill={FLASK_PILL_TEXT}
          />
          <path
            d="M1386.55 50.6376H1394.87V80.2861H1410.28V88.3624H1386.55V50.6376Z"
            fill={FLASK_PILL_TEXT}
          />
          <path
            d="M1427.39 50.6376H1434.94L1450.86 88.3624H1442.17L1438.87 80.3924H1423.46L1420.16 88.3624H1411.47L1427.39 50.6376ZM1426.45 73.0599H1435.83L1431.16 61.7425L1426.45 73.0599Z"
            fill={FLASK_PILL_TEXT}
          />
          <path
            d="M1464.82 89C1461.85 89 1459.18 88.4155 1456.81 87.2466C1454.43 86.0422 1452.51 84.3774 1451.04 82.252L1457.43 76.7793C1458.34 78.1253 1459.51 79.188 1460.94 79.9673C1462.38 80.7112 1463.77 81.0831 1465.13 81.0831C1466.53 81.0831 1467.63 80.7997 1468.43 80.233C1469.24 79.6308 1469.64 78.8692 1469.64 77.9482C1469.64 76.9918 1469.24 76.1594 1468.43 75.451C1467.67 74.7425 1466.34 74.0695 1464.45 73.4319L1461.83 72.5286C1458.8 71.5014 1456.47 70.0845 1454.87 68.2779C1453.26 66.436 1452.46 64.2221 1452.46 61.6362C1452.46 59.7943 1452.77 58.1649 1453.4 56.748C1454.06 55.2956 1454.95 54.0736 1456.07 53.0817C1457.22 52.0899 1458.59 51.3283 1460.16 50.797C1461.73 50.2657 1463.44 50 1465.29 50C1467.56 50 1469.69 50.3896 1471.68 51.1689C1473.67 51.9482 1475.54 53.2943 1477.29 55.2071L1471.84 61.0518C1470.97 59.9891 1469.97 59.2098 1468.85 58.7139C1467.74 58.1826 1466.58 57.9169 1465.4 57.9169C1464.84 57.9169 1464.28 57.97 1463.72 58.0763C1463.2 58.1826 1462.73 58.3597 1462.31 58.6076C1461.89 58.8556 1461.54 59.1567 1461.26 59.5109C1461.01 59.8651 1460.89 60.2902 1460.89 60.7861C1460.89 61.8134 1461.35 62.6281 1462.25 63.2302C1463.2 63.797 1464.66 64.4346 1466.65 65.1431L1469.27 66.0995C1471.96 67.0913 1474.11 68.5082 1475.72 70.3501C1477.36 72.1921 1478.16 74.53 1478.13 77.3638C1478.13 79.064 1477.79 80.6403 1477.13 82.0926C1476.47 83.5095 1475.54 84.7316 1474.35 85.7589C1473.2 86.7861 1471.81 87.5831 1470.16 88.1499C1468.56 88.7166 1466.78 89 1464.82 89Z"
            fill={FLASK_PILL_TEXT}
          />
          <path
            d="M1492.17 71.4659V88.3624H1483.9V50.6376H1492.17V66.4183L1504.8 50.6376H1515.01L1500.35 68.7561L1518 88.3624H1507.31L1492.17 71.4659Z"
            fill={FLASK_PILL_TEXT}
          />
          <defs>
            <linearGradient
              id="paint0_linear"
              x1="132.5"
              y1="31.5908"
              x2="132.5"
              y2="200.289"
              gradientUnits="userSpaceOnUse"
            >
              <stop stopColor="#8F8F8F" />
              <stop offset="1" stopColor="#AEAEAE" />
            </linearGradient>
            <linearGradient
              id="paint1_linear"
              x1="222.583"
              y1="107.077"
              x2="222.583"
              y2="179.957"
              gradientUnits="userSpaceOnUse"
            >
              <stop stopColor="#696969" />
              <stop offset="1" stopColor="#A6A6A6" />
            </linearGradient>
            <linearGradient
              id="paint2_linear"
              x1="42.4685"
              y1="107.077"
              x2="42.4685"
              y2="179.957"
              gradientUnits="userSpaceOnUse"
            >
              <stop stopColor="#696969" />
              <stop offset="1" stopColor="#A6A6A6" />
            </linearGradient>
            <linearGradient
              id="paint3_linear"
              x1="184.533"
              y1="102.178"
              x2="279.867"
              y2="27.8973"
              gradientUnits="userSpaceOnUse"
            >
              <stop stopColor="#1B1B1B" />
              <stop offset="1" stopColor="#565656" />
            </linearGradient>
            <linearGradient
              id="paint4_linear"
              x1="80.4668"
              y1="102.178"
              x2="-14.8672"
              y2="27.8973"
              gradientUnits="userSpaceOnUse"
            >
              <stop stopColor="#1B1B1B" />
              <stop offset="1" stopColor="#565656" />
            </linearGradient>
            <linearGradient
              id="paint5_linear"
              x1="225.027"
              y1="179.542"
              x2="225.027"
              y2="237.2"
              gradientUnits="userSpaceOnUse"
            >
              <stop stopColor="#787878" />
              <stop offset="1" stopColor="#5E5E5E" />
            </linearGradient>
            <linearGradient
              id="paint6_linear"
              x1="40.0254"
              y1="179.542"
              x2="40.0254"
              y2="237.2"
              gradientUnits="userSpaceOnUse"
            >
              <stop stopColor="#787878" />
              <stop offset="1" stopColor="#5E5E5E" />
            </linearGradient>
            <linearGradient
              id="paint7_linear"
              x1="87.4322"
              y1="74.4443"
              x2="87.4322"
              y2="134.604"
              gradientUnits="userSpaceOnUse"
            >
              <stop stopColor="#7A7A7A" />
              <stop offset="1" stopColor="#949494" />
            </linearGradient>
            <linearGradient
              id="paint8_linear"
              x1="177.568"
              y1="74.4443"
              x2="177.568"
              y2="134.604"
              gradientUnits="userSpaceOnUse"
            >
              <stop stopColor="#7A7A7A" />
              <stop offset="1" stopColor="#949494" />
            </linearGradient>
            <linearGradient
              id="paint9_linear"
              x1="95.4893"
              y1="245.645"
              x2="95.4893"
              y2="-25.2885"
              gradientUnits="userSpaceOnUse"
            >
              <stop stopColor="#7A7C7D" />
              <stop offset="1" stopColor="#CECECF" />
            </linearGradient>
            <linearGradient
              id="paint10_linear"
              x1="169.51"
              y1="245.645"
              x2="169.51"
              y2="-25.2885"
              gradientUnits="userSpaceOnUse"
            >
              <stop stopColor="#7A7C7D" />
              <stop offset="1" stopColor="#CECECF" />
            </linearGradient>
            <linearGradient
              id="paint11_linear"
              x1="198.464"
              y1="126.784"
              x2="198.464"
              y2="234.065"
              gradientUnits="userSpaceOnUse"
            >
              <stop stopColor="#3E3E3E" />
              <stop offset="1" stopColor="#616161" />
            </linearGradient>
            <linearGradient
              id="paint12_linear"
              x1="66.5358"
              y1="126.784"
              x2="66.5358"
              y2="234.065"
              gradientUnits="userSpaceOnUse"
            >
              <stop stopColor="#3E3E3E" />
              <stop offset="1" stopColor="#616161" />
            </linearGradient>
            <linearGradient
              id="paint13_linear"
              x1="132.032"
              y1="31.279"
              x2="132.032"
              y2="258.573"
              gradientUnits="userSpaceOnUse"
            >
              <stop stopColor="#FF60DC" />
              <stop offset="1" stopColor="#6B71FF" />
            </linearGradient>
            <radialGradient
              id="paint14_radial"
              cx="0"
              cy="0"
              r="1"
              gradientUnits="userSpaceOnUse"
              gradientTransform="translate(132.032 26.5872) rotate(90) scale(218.953 244.615)"
            >
              <stop stopColor="#FF60DC" />
              <stop offset="1" stopColor="#6B71FF" />
            </radialGradient>
            <clipPath id="clip0">
              <rect width="265" height="247" fill="white" />
            </clipPath>
          </defs>
        </svg>
      );
    case 'mmi':
      return (
        <svg
          height={45}
          viewBox="0 0 723 115"
          fill="none"
          xmlns="http://www.w3.org/2000/svg"
          className={className}
        >
          <g transform="matrix(0.998558,0,0,1,0.000632449,0)">
            <rect
              x="411.318"
              y="4.847"
              width="2.481"
              height="61.306"
              style={{ fill }}
            />
            <path
              d="M437.965,19.099L441.766,19.099L441.766,48.117L437.965,48.117L437.965,19.099ZM448.849,27.682L452.364,27.682L452.364,30.829C453.073,29.603 453.999,28.704 455.143,28.132C456.288,27.559 457.527,27.273 458.863,27.273C460.007,27.273 461.056,27.464 462.01,27.845C462.963,28.227 463.767,28.785 464.421,29.521C465.102,30.23 465.634,31.101 466.015,32.137C466.396,33.145 466.587,34.276 466.587,35.529L466.587,48.117L463.113,48.117L463.113,36.06C463.113,34.344 462.664,32.995 461.764,32.014C460.893,31.006 459.734,30.502 458.29,30.502C457.473,30.502 456.696,30.666 455.961,30.992C455.252,31.319 454.626,31.81 454.081,32.464C453.563,33.091 453.141,33.867 452.814,34.793C452.514,35.72 452.364,36.783 452.364,37.981L452.364,48.117L448.849,48.117L448.849,27.682ZM479.088,48.526C477.263,48.526 475.628,48.145 474.184,47.382C472.74,46.592 471.704,45.393 471.078,43.785L473.938,42.191C474.32,43.226 474.988,44.03 475.941,44.602C476.922,45.147 477.985,45.42 479.129,45.42C480.11,45.42 480.941,45.188 481.622,44.725C482.331,44.235 482.685,43.553 482.685,42.682C482.685,41.946 482.426,41.333 481.908,40.842C481.391,40.352 480.464,39.902 479.129,39.494L477.086,38.84C475.396,38.349 474.116,37.6 473.244,36.592C472.399,35.556 471.977,34.317 471.977,32.873C471.977,32.001 472.154,31.224 472.508,30.543C472.889,29.834 473.394,29.249 474.02,28.785C474.674,28.295 475.423,27.927 476.268,27.682C477.113,27.409 478.026,27.273 479.006,27.273C480.532,27.273 481.867,27.587 483.012,28.213C484.156,28.813 485.069,29.685 485.75,30.829L483.134,32.627C482.671,31.973 482.085,31.428 481.377,30.992C480.696,30.529 479.865,30.298 478.884,30.298C478.012,30.298 477.222,30.516 476.513,30.952C475.832,31.388 475.492,31.987 475.492,32.75C475.492,33.377 475.682,33.935 476.064,34.426C476.472,34.916 477.249,35.338 478.393,35.693L480.641,36.387C482.412,36.932 483.775,37.682 484.728,38.635C485.709,39.589 486.2,40.842 486.2,42.395C486.2,43.376 486.023,44.248 485.668,45.011C485.314,45.774 484.81,46.414 484.156,46.932C483.53,47.45 482.78,47.845 481.908,48.117C481.036,48.39 480.096,48.526 479.088,48.526ZM499.046,48.322C498.147,48.322 497.316,48.199 496.553,47.954C495.79,47.681 495.122,47.3 494.55,46.809C494.005,46.292 493.569,45.638 493.242,44.848C492.943,44.058 492.793,43.131 492.793,42.068L492.793,30.911L488.46,30.911L488.46,27.682L492.793,27.682L492.793,22.001L496.308,22.001L496.308,27.682L502.193,27.682L502.193,30.911L496.308,30.911L496.308,41.619C496.308,42.927 496.594,43.84 497.166,44.357C497.738,44.848 498.583,45.093 499.7,45.093C500.136,45.093 500.572,45.066 501.008,45.011C501.471,44.929 501.866,44.82 502.193,44.684L502.193,47.831C501.757,47.967 501.28,48.076 500.763,48.158C500.245,48.267 499.673,48.322 499.046,48.322ZM508.481,22.205C507.773,22.205 507.174,21.974 506.683,21.51C506.193,21.02 505.947,20.421 505.947,19.712C505.947,19.031 506.193,18.445 506.683,17.955C507.174,17.464 507.773,17.219 508.481,17.219C509.19,17.219 509.776,17.464 510.239,17.955C510.702,18.445 510.934,19.031 510.934,19.712C510.934,20.421 510.702,21.02 510.239,21.51C509.776,21.974 509.19,22.205 508.481,22.205ZM506.683,27.682L510.198,27.682L510.198,48.117L506.683,48.117L506.683,27.682ZM524.79,48.322C523.891,48.322 523.06,48.199 522.297,47.954C521.534,47.681 520.866,47.3 520.294,46.809C519.749,46.292 519.313,45.638 518.986,44.848C518.686,44.058 518.537,43.131 518.537,42.068L518.537,30.911L514.204,30.911L514.204,27.682L518.537,27.682L518.537,22.001L522.051,22.001L522.051,27.682L527.937,27.682L527.937,30.911L522.051,30.911L522.051,41.619C522.051,42.927 522.338,43.84 522.91,44.357C523.482,44.848 524.327,45.093 525.444,45.093C525.88,45.093 526.316,45.066 526.752,45.011C527.215,44.929 527.61,44.82 527.937,44.684L527.937,47.831C527.501,47.967 527.024,48.076 526.506,48.158C525.989,48.267 525.416,48.322 524.79,48.322ZM539.661,48.526C538.544,48.526 537.522,48.335 536.596,47.954C535.669,47.545 534.879,46.987 534.225,46.278C533.571,45.57 533.054,44.711 532.672,43.703C532.318,42.668 532.141,41.51 532.141,40.229L532.141,27.682L535.656,27.682L535.656,39.698C535.656,41.414 536.064,42.777 536.882,43.785C537.726,44.793 538.857,45.297 540.274,45.297C541.064,45.297 541.8,45.134 542.481,44.807C543.19,44.453 543.789,43.962 544.279,43.335C544.797,42.682 545.206,41.891 545.506,40.965C545.805,40.039 545.955,38.99 545.955,37.818L545.955,27.682L549.47,27.682L549.47,48.117L545.955,48.117L545.955,44.97C545.274,46.169 544.375,47.068 543.258,47.668C542.168,48.24 540.969,48.526 539.661,48.526ZM564.024,48.322C563.125,48.322 562.294,48.199 561.531,47.954C560.768,47.681 560.101,47.3 559.528,46.809C558.983,46.292 558.548,45.638 558.221,44.848C557.921,44.058 557.771,43.131 557.771,42.068L557.771,30.911L553.439,30.911L553.439,27.682L557.771,27.682L557.771,22.001L561.286,22.001L561.286,27.682L567.171,27.682L567.171,30.911L561.286,30.911L561.286,41.619C561.286,42.927 561.572,43.84 562.144,44.357C562.716,44.848 563.561,45.093 564.678,45.093C565.114,45.093 565.55,45.066 565.986,45.011C566.449,44.929 566.844,44.82 567.171,44.684L567.171,47.831C566.735,47.967 566.258,48.076 565.741,48.158C565.223,48.267 564.651,48.322 564.024,48.322ZM573.46,22.205C572.751,22.205 572.152,21.974 571.661,21.51C571.171,21.02 570.926,20.421 570.926,19.712C570.926,19.031 571.171,18.445 571.661,17.955C572.152,17.464 572.751,17.219 573.46,17.219C574.168,17.219 574.754,17.464 575.217,17.955C575.68,18.445 575.912,19.031 575.912,19.712C575.912,20.421 575.68,21.02 575.217,21.51C574.754,21.974 574.168,22.205 573.46,22.205ZM571.661,27.682L575.176,27.682L575.176,48.117L571.661,48.117L571.661,27.682ZM590.912,48.526C589.359,48.526 587.929,48.254 586.621,47.709C585.313,47.136 584.182,46.374 583.229,45.42C582.275,44.466 581.526,43.349 580.981,42.068C580.463,40.761 580.204,39.371 580.204,37.9C580.204,36.428 580.463,35.052 580.981,33.772C581.526,32.464 582.275,31.333 583.229,30.379C584.182,29.426 585.313,28.676 586.621,28.132C587.929,27.559 589.359,27.273 590.912,27.273C592.438,27.273 593.855,27.559 595.163,28.132C596.471,28.676 597.602,29.426 598.555,30.379C599.509,31.333 600.245,32.464 600.762,33.772C601.307,35.052 601.58,36.428 601.58,37.9C601.58,39.371 601.307,40.761 600.762,42.068C600.245,43.349 599.509,44.466 598.555,45.42C597.602,46.374 596.471,47.136 595.163,47.709C593.855,48.254 592.438,48.526 590.912,48.526ZM590.912,45.256C591.975,45.256 592.942,45.066 593.814,44.684C594.686,44.303 595.422,43.785 596.021,43.131C596.648,42.45 597.125,41.673 597.452,40.801C597.806,39.902 597.983,38.935 597.983,37.9C597.983,36.892 597.806,35.938 597.452,35.039C597.125,34.14 596.648,33.363 596.021,32.709C595.422,32.028 594.686,31.497 593.814,31.115C592.942,30.734 591.975,30.543 590.912,30.543C589.85,30.543 588.883,30.734 588.011,31.115C587.139,31.497 586.389,32.028 585.763,32.709C585.136,33.363 584.646,34.14 584.291,35.039C583.964,35.938 583.801,36.892 583.801,37.9C583.801,38.935 583.964,39.902 584.291,40.801C584.646,41.673 585.136,42.45 585.763,43.131C586.389,43.785 587.139,44.303 588.011,44.684C588.883,45.066 589.85,45.256 590.912,45.256ZM606.625,27.682L610.14,27.682L610.14,30.829C610.848,29.603 611.775,28.704 612.919,28.132C614.064,27.559 615.303,27.273 616.638,27.273C617.783,27.273 618.832,27.464 619.785,27.845C620.739,28.227 621.543,28.785 622.197,29.521C622.878,30.23 623.409,31.101 623.791,32.137C624.172,33.145 624.363,34.276 624.363,35.529L624.363,48.117L620.889,48.117L620.889,36.06C620.889,34.344 620.439,32.995 619.54,32.014C618.668,31.006 617.51,30.502 616.066,30.502C615.249,30.502 614.472,30.666 613.737,30.992C613.028,31.319 612.401,31.81 611.857,32.464C611.339,33.091 610.916,33.867 610.59,34.793C610.29,35.72 610.14,36.783 610.14,37.981L610.14,48.117L606.625,48.117L606.625,27.682ZM639.112,48.526C637.668,48.526 636.333,48.254 635.107,47.709C633.908,47.136 632.859,46.374 631.96,45.42C631.06,44.439 630.352,43.308 629.834,42.028C629.344,40.747 629.099,39.371 629.099,37.9C629.099,36.428 629.344,35.052 629.834,33.772C630.352,32.491 631.06,31.374 631.96,30.42C632.859,29.439 633.908,28.676 635.107,28.132C636.333,27.559 637.668,27.273 639.112,27.273C640.665,27.273 642.082,27.627 643.362,28.336C644.643,29.017 645.624,29.848 646.305,30.829L646.305,27.682L649.82,27.682L649.82,48.117L646.305,48.117L646.305,44.97C645.624,45.951 644.643,46.796 643.362,47.504C642.082,48.185 640.665,48.526 639.112,48.526ZM639.643,45.297C640.679,45.297 641.619,45.106 642.463,44.725C643.308,44.344 644.03,43.826 644.629,43.172C645.256,42.491 645.733,41.701 646.06,40.801C646.414,39.902 646.591,38.935 646.591,37.9C646.591,36.864 646.414,35.897 646.06,34.998C645.733,34.099 645.256,33.322 644.629,32.668C644.03,31.987 643.308,31.456 642.463,31.074C641.619,30.693 640.679,30.502 639.643,30.502C638.608,30.502 637.654,30.693 636.782,31.074C635.938,31.456 635.202,31.987 634.575,32.668C633.976,33.322 633.499,34.099 633.145,34.998C632.818,35.897 632.654,36.864 632.654,37.9C632.654,38.935 632.818,39.902 633.145,40.801C633.499,41.701 633.976,42.491 634.575,43.172C635.202,43.826 635.938,44.344 636.782,44.725C637.654,45.106 638.608,45.297 639.643,45.297ZM656.436,17.464L659.951,17.464L659.951,48.117L656.436,48.117L656.436,17.464Z"
              style={{ fill, fillRule: 'nonzero' }}
            />
            <g>
              <path
                d="M341.696,35.934C339.688,34.605 337.473,33.66 335.377,32.479C334.018,31.711 332.571,31.032 331.39,30.058C329.382,28.404 329.796,25.156 331.892,23.738C334.904,21.73 339.895,22.853 340.426,26.957C340.426,27.046 340.515,27.105 340.603,27.105L345.151,27.105C345.269,27.105 345.358,27.016 345.328,26.898C345.092,24.063 343.999,21.701 341.991,20.195C340.072,18.748 337.887,17.98 335.554,17.98C323.535,17.98 322.443,30.707 328.91,34.723C329.648,35.196 335.997,38.385 338.241,39.773C340.485,41.161 341.194,43.7 340.22,45.708C339.334,47.539 337.03,48.809 334.727,48.661C332.217,48.514 330.268,47.155 329.589,45.029C329.471,44.645 329.412,43.907 329.412,43.582C329.412,43.494 329.323,43.405 329.235,43.405L324.303,43.405C324.215,43.405 324.126,43.494 324.126,43.582C324.126,47.155 325.012,49.134 327.433,50.935C329.707,52.648 332.188,53.356 334.757,53.356C341.489,53.356 344.974,49.547 345.683,45.59C346.303,41.722 345.151,38.237 341.696,35.934Z"
                style={{ fill, fillRule: 'nonzero' }}
              />
              <path
                d="M130.465,18.618L122.994,18.618C122.905,18.618 122.846,18.677 122.816,18.736L118.771,32.084C118.712,32.261 118.476,32.261 118.417,32.084L114.371,18.736C114.342,18.648 114.282,18.618 114.194,18.618L106.664,18.618C106.575,18.618 106.487,18.707 106.487,18.795L106.487,52.872C106.487,52.961 106.575,53.05 106.664,53.05L111.595,53.05C111.684,53.05 111.772,52.961 111.772,52.872L111.772,26.975C111.772,26.768 112.068,26.739 112.127,26.916L116.202,40.352L116.497,41.297C116.527,41.385 116.586,41.415 116.674,41.415L120.454,41.415C120.543,41.415 120.602,41.356 120.631,41.297L120.927,40.352L125.002,26.916C125.061,26.709 125.356,26.768 125.356,26.975L125.356,52.872C125.356,52.961 125.445,53.05 125.533,53.05L130.465,53.05C130.553,53.05 130.642,52.961 130.642,52.872L130.642,18.795C130.642,18.707 130.553,18.618 130.465,18.618Z"
                style={{ fill, fillRule: 'nonzero' }}
              />
              <path
                d="M266.19,18.618C266.102,18.618 266.043,18.677 266.013,18.736L261.968,32.084C261.908,32.261 261.672,32.261 261.613,32.084L257.568,18.736C257.538,18.648 257.479,18.618 257.39,18.618L249.89,18.618C249.801,18.618 249.713,18.707 249.713,18.795L249.713,52.872C249.713,52.961 249.801,53.05 249.89,53.05L254.821,53.05C254.91,53.05 254.999,52.961 254.999,52.872L254.999,26.975C254.999,26.768 255.294,26.739 255.353,26.916L259.428,40.352L259.723,41.297C259.753,41.385 259.812,41.415 259.9,41.415L263.68,41.415C263.769,41.415 263.828,41.356 263.857,41.297L264.153,40.352L268.228,26.916C268.287,26.709 268.582,26.768 268.582,26.975L268.582,52.872C268.582,52.961 268.671,53.05 268.759,53.05L273.691,53.05C273.779,53.05 273.868,52.961 273.868,52.872L273.868,18.795C273.868,18.707 273.779,18.618 273.691,18.618L266.19,18.618Z"
                style={{ fill, fillRule: 'nonzero' }}
              />
              <path
                d="M202.58,18.618L179.281,18.618C179.193,18.618 179.104,18.707 179.104,18.795L179.104,23.048C179.104,23.136 179.193,23.225 179.281,23.225L188.288,23.225L188.288,52.872C188.288,52.961 188.376,53.05 188.465,53.05L193.396,53.05C193.485,53.05 193.574,52.961 193.574,52.872L193.574,23.225L202.58,23.225C202.669,23.225 202.757,23.136 202.757,23.048L202.757,18.795C202.757,18.707 202.698,18.618 202.58,18.618Z"
                style={{ fill, fillRule: 'nonzero' }}
              />
              <path
                d="M231.658,53.049L236.147,53.049C236.265,53.049 236.353,52.931 236.324,52.813L227.052,18.618C227.022,18.53 226.963,18.5 226.875,18.5L220.437,18.5C220.349,18.5 220.289,18.559 220.26,18.618L210.988,52.813C210.958,52.931 211.047,53.049 211.165,53.049L215.653,53.049C215.742,53.049 215.801,52.99 215.831,52.931L218.518,42.98C218.547,42.891 218.606,42.862 218.695,42.862L228.617,42.862C228.705,42.862 228.764,42.921 228.794,42.98L231.481,52.931C231.511,52.99 231.599,53.049 231.658,53.049ZM219.876,37.989L223.479,24.672C223.538,24.494 223.774,24.494 223.833,24.672L227.436,37.989C227.465,38.108 227.376,38.226 227.258,38.226L220.053,38.226C219.935,38.226 219.846,38.108 219.876,37.989Z"
                style={{ fill, fillRule: 'nonzero' }}
              />
              <path
                d="M308.198,53.049L312.687,53.049C312.805,53.049 312.893,52.931 312.864,52.813L303.592,18.618C303.562,18.53 303.503,18.5 303.415,18.5L296.977,18.5C296.889,18.5 296.829,18.559 296.8,18.618L287.528,52.813C287.498,52.931 287.587,53.049 287.705,53.049L292.193,53.049C292.282,53.049 292.341,52.99 292.371,52.931L295.058,42.98C295.087,42.891 295.146,42.862 295.235,42.862L305.157,42.862C305.245,42.862 305.304,42.921 305.334,42.98L308.021,52.931C308.051,52.99 308.11,53.049 308.198,53.049ZM296.416,37.989L300.019,24.672C300.078,24.494 300.314,24.494 300.373,24.672L303.976,37.989C304.005,38.108 303.917,38.226 303.798,38.226L296.593,38.226C296.475,38.226 296.387,38.108 296.416,37.989Z"
                style={{ fill, fillRule: 'nonzero' }}
              />
              <path
                d="M150.669,48.018L150.669,37.446C150.669,37.358 150.757,37.269 150.846,37.269L163.986,37.269C164.075,37.269 164.164,37.18 164.164,37.092L164.164,32.84C164.164,32.751 164.075,32.662 163.986,32.662L150.846,32.662C150.757,32.662 150.669,32.574 150.669,32.485L150.669,23.449C150.669,23.361 150.757,23.272 150.846,23.272L165.788,23.272C165.876,23.272 165.965,23.183 165.965,23.095L165.965,18.843C165.965,18.754 165.876,18.665 165.788,18.665L145.56,18.665C145.472,18.665 145.383,18.754 145.383,18.843L145.383,52.89C145.383,52.979 145.472,53.067 145.56,53.067L166.408,53.067C166.497,53.067 166.585,52.979 166.585,52.89L166.585,48.402C166.585,48.313 166.497,48.224 166.408,48.224L150.816,48.224C150.728,48.195 150.669,48.136 150.669,48.018Z"
                style={{ fill, fillRule: 'nonzero' }}
              />
              <path
                d="M386.745,52.772L369.677,35.143C369.618,35.084 369.618,34.966 369.677,34.907L385.033,18.961C385.151,18.843 385.062,18.665 384.914,18.665L378.625,18.665C378.566,18.665 378.536,18.695 378.506,18.724L365.484,32.249C365.366,32.367 365.189,32.279 365.189,32.131L365.189,18.843C365.189,18.754 365.1,18.665 365.012,18.665L360.08,18.665C359.992,18.665 359.903,18.754 359.903,18.843L359.903,52.92C359.903,53.008 359.992,53.097 360.08,53.097L365.012,53.097C365.1,53.097 365.189,53.008 365.189,52.92L365.189,37.919C365.189,37.771 365.395,37.682 365.484,37.801L380.249,53.038C380.278,53.067 380.337,53.097 380.367,53.097L386.657,53.097C386.775,53.067 386.863,52.861 386.745,52.772Z"
                style={{ fill, fillRule: 'nonzero' }}
              />
              <path
                d="M72.896,0.305L43.118,22.493L48.655,9.417L72.896,0.305Z"
                style={{ fill: 'rgb(109,149,249)', fillRule: 'nonzero' }}
              />
              <path
                d="M4.209,0.306L33.722,22.7L28.45,9.417L4.209,0.306Z"
                style={{ fill: 'rgb(109,149,249)', fillRule: 'nonzero' }}
              />
              <path
                d="M62.175,51.752L54.252,63.94L71.217,68.644L76.077,52.018L62.175,51.752Z"
                style={{ fill: 'rgb(109,149,249)', fillRule: 'nonzero' }}
              />
              <path
                d="M1.057,52.018L5.888,68.644L22.824,63.94L14.93,51.752L1.057,52.018Z"
                style={{ fill: 'rgb(109,149,249)', fillRule: 'nonzero' }}
              />
              <path
                d="M21.911,31.161L17.198,38.32L33.987,39.089L33.428,20.895L21.911,31.161Z"
                style={{ fill: 'rgb(109,149,249)', fillRule: 'nonzero' }}
              />
              <path
                d="M55.194,31.161L43.501,20.688L43.118,39.089L59.907,38.32L55.194,31.161Z"
                style={{ fill: 'rgb(109,149,249)', fillRule: 'nonzero' }}
              />
              <path
                d="M22.824,63.939L32.986,58.999L24.238,52.136L22.824,63.939Z"
                style={{ fill: 'rgb(109,149,249)', fillRule: 'nonzero' }}
              />
              <path
                d="M44.12,58.999L54.252,63.939L52.867,52.136L44.12,58.999Z"
                style={{ fill: 'rgb(109,149,249)', fillRule: 'nonzero' }}
              />
              <path
                d="M54.252,63.939L44.12,58.999L44.944,65.626L44.856,68.436L54.252,63.939Z"
                style={{ fill: 'rgb(215,193,179)', fillRule: 'nonzero' }}
              />
              <path
                d="M22.824,63.941L32.249,68.437L32.19,65.627L32.986,59L22.824,63.941Z"
                style={{ fill: 'rgb(215,193,179)', fillRule: 'nonzero' }}
              />
              <path
                d="M32.426,47.757L24.002,45.272L29.952,42.521L32.426,47.757Z"
                style={{ fill: 'rgb(47,52,59)', fillRule: 'nonzero' }}
              />
              <path
                d="M44.679,47.757L47.153,42.521L53.132,45.272L44.679,47.757Z"
                style={{ fill: 'rgb(47,52,59)', fillRule: 'nonzero' }}
              />
              <path
                d="M22.824,63.94L24.297,51.751L14.93,52.018L22.824,63.94Z"
                style={{ fill: 'rgb(73,123,248)', fillRule: 'nonzero' }}
              />
              <path
                d="M52.808,51.751L54.252,63.94L62.175,52.018L52.808,51.751Z"
                style={{ fill: 'rgb(73,123,248)', fillRule: 'nonzero' }}
              />
              <path
                d="M59.907,38.32L43.118,39.089L44.679,47.757L47.153,42.521L53.132,45.272L59.907,38.32Z"
                style={{ fill: 'rgb(73,123,248)', fillRule: 'nonzero' }}
              />
              <path
                d="M24.002,45.272L29.952,42.521L32.426,47.757L33.987,39.089L17.198,38.32L24.002,45.272Z"
                style={{ fill: 'rgb(73,123,248)', fillRule: 'nonzero' }}
              />
              <path
                d="M17.198,38.322L24.238,52.137L24.002,45.274L17.198,38.322Z"
                style={{ fill: 'rgb(109,149,249)', fillRule: 'nonzero' }}
              />
              <path
                d="M53.133,45.272L52.867,52.135L59.907,38.32L53.133,45.272Z"
                style={{ fill: 'rgb(109,149,249)', fillRule: 'nonzero' }}
              />
              <path
                d="M33.987,39.089L32.426,47.757L34.4,57.993L34.841,44.503L33.987,39.089Z"
                style={{ fill: 'rgb(109,149,249)', fillRule: 'nonzero' }}
              />
              <path
                d="M43.118,39.089L42.293,44.473L42.706,57.993L44.679,47.757L43.118,39.089Z"
                style={{ fill: 'rgb(109,149,249)', fillRule: 'nonzero' }}
              />
              <path
                d="M44.679,47.758L42.706,57.994L44.12,59L52.867,52.136L53.133,45.273L44.679,47.758Z"
                style={{ fill: 'rgb(182,202,252)', fillRule: 'nonzero' }}
              />
              <path
                d="M24.002,45.273L24.238,52.136L32.986,59L34.399,57.994L32.426,47.758L24.002,45.273Z"
                style={{ fill: 'rgb(182,202,252)', fillRule: 'nonzero' }}
              />
              <path
                d="M44.856,68.436L44.944,65.625L44.178,64.975L32.927,64.975L32.19,65.625L32.249,68.436L22.824,63.939L26.123,66.661L32.809,71.305L44.267,71.305L50.982,66.661L54.252,63.939L44.856,68.436Z"
                style={{ fill: 'rgb(192,173,158)', fillRule: 'nonzero' }}
              />
              <path
                d="M44.119,58.999L42.706,57.993L34.4,57.993L32.986,58.999L32.19,65.625L32.927,64.975L44.178,64.975L44.944,65.625L44.119,58.999Z"
                style={{ fill: 'rgb(47,52,59)', fillRule: 'nonzero' }}
              />
              <path
                d="M74.163,23.943L76.667,11.695L72.896,0.305L44.12,21.753L55.194,31.161L70.835,35.746L74.281,31.693L72.778,30.599L75.164,28.41L73.338,26.99L75.724,25.156L74.163,23.943Z"
                style={{ fill: 'rgb(44,86,221)', fillRule: 'nonzero' }}
              />
              <path
                d="M0.439,11.697L2.972,23.945L1.352,25.158L3.767,26.992L1.941,28.412L4.327,30.601L2.824,31.695L6.271,35.748L21.911,31.163L32.986,21.755L4.209,0.307L0.439,11.697Z"
                style={{ fill: 'rgb(44,86,221)', fillRule: 'nonzero' }}
              />
              <path
                d="M70.834,35.747L55.194,31.161L59.907,38.32L52.867,52.136L62.175,52.018L76.077,52.018L70.834,35.747Z"
                style={{ fill: 'rgb(182,202,252)', fillRule: 'nonzero' }}
              />
              <path
                d="M21.911,31.161L6.271,35.747L1.057,52.018L14.93,52.018L24.238,52.136L17.198,38.32L21.911,31.161Z"
                style={{ fill: 'rgb(182,202,252)', fillRule: 'nonzero' }}
              />
              <path
                d="M43.118,39.089L44.119,21.753L48.655,9.417L28.45,9.417L32.985,21.753L33.987,39.089L34.37,44.532L34.399,57.993L42.705,57.993L42.735,44.532L43.118,39.089Z"
                style={{ fill: 'rgb(182,202,252)', fillRule: 'nonzero' }}
              />
            </g>
          </g>
        </svg>
      );
    default:
      return (
        <svg
          height={LOGO_HEIGHT}
          viewBox="0 0 1311 242"
          width={LOGO_WIDTH}
          xmlns="http://www.w3.org/2000/svg"
          className={className}
        >
          <g fill="none">
            <g fill={TEXT_COLOR} transform="translate(361 61)">
              <path d="m796.7 60.9c-6.8-4.5-14.3-7.7-21.4-11.7-4.6-2.6-9.5-4.9-13.5-8.2-6.8-5.6-5.4-16.6 1.7-21.4 10.2-6.8 27.1-3 28.9 10.9 0 .3.3.5.6.5h15.4c.4 0 .7-.3.6-.7-.8-9.6-4.5-17.6-11.3-22.7-6.5-4.9-13.9-7.5-21.8-7.5-40.7 0-44.4 43.1-22.5 56.7 2.5 1.6 24 12.4 31.6 17.1s10 13.3 6.7 20.1c-3 6.2-10.8 10.5-18.6 10-8.5-.5-15.1-5.1-17.4-12.3-.4-1.3-.6-3.8-.6-4.9 0-.3-.3-.6-.6-.6h-16.7c-.3 0-.6.3-.6.6 0 12.1 3 18.8 11.2 24.9 7.7 5.8 16.1 8.2 24.8 8.2 22.8 0 34.6-12.9 37-26.3 2.1-13.1-1.8-24.9-13.5-32.7z" />
              <path d="m71.6 2.3h-7.4-8.1c-.3 0-.5.2-.6.4l-13.7 45.2c-.2.6-1 .6-1.2 0l-13.7-45.2c-.1-.3-.3-.4-.6-.4h-8.1-7.4-10c-.3 0-.6.3-.6.6v115.4c0 .3.3.6.6.6h16.7c.3 0 .6-.3.6-.6v-87.7c0-.7 1-.8 1.2-.2l13.8 45.5 1 3.2c.1.3.3.4.6.4h12.8c.3 0 .5-.2.6-.4l1-3.2 13.8-45.5c.2-.7 1.2-.5 1.2.2v87.7c0 .3.3.6.6.6h16.7c.3 0 .6-.3.6-.6v-115.4c0-.3-.3-.6-.6-.6z" />
              <path d="m541 2.3c-.3 0-.5.2-.6.4l-13.7 45.2c-.2.6-1 .6-1.2 0l-13.7-45.2c-.1-.3-.3-.4-.6-.4h-25.4c-.3 0-.6.3-.6.6v115.4c0 .3.3.6.6.6h16.7c.3 0 .6-.3.6-.6v-87.7c0-.7 1-.8 1.2-.2l13.8 45.5 1 3.2c.1.3.3.4.6.4h12.8c.3 0 .5-.2.6-.4l1-3.2 13.8-45.5c.2-.7 1.2-.5 1.2.2v87.7c0 .3.3.6.6.6h16.7c.3 0 .6-.3.6-.6v-115.4c0-.3-.3-.6-.6-.6z" />
              <path d="m325.6 2.3h-31.1-16.7-31.1c-.3 0-.6.3-.6.6v14.4c0 .3.3.6.6.6h30.5v100.4c0 .3.3.6.6.6h16.7c.3 0 .6-.3.6-.6v-100.4h30.5c.3 0 .6-.3.6-.6v-14.4c0-.3-.2-.6-.6-.6z" />
              <path d="m424.1 118.9h15.2c.4 0 .7-.4.6-.8l-31.4-115.8c-.1-.3-.3-.4-.6-.4h-5.8-10.2-5.8c-.3 0-.5.2-.6.4l-31.4 115.8c-.1.4.2.8.6.8h15.2c.3 0 .5-.2.6-.4l9.1-33.7c.1-.3.3-.4.6-.4h33.6c.3 0 .5.2.6.4l9.1 33.7c.1.2.4.4.6.4zm-39.9-51 12.2-45.1c.2-.6 1-.6 1.2 0l12.2 45.1c.1.4-.2.8-.6.8h-24.4c-.4 0-.7-.4-.6-.8z" />
              <path d="m683.3 118.9h15.2c.4 0 .7-.4.6-.8l-31.4-115.8c-.1-.3-.3-.4-.6-.4h-5.8-10.2-5.8c-.3 0-.5.2-.6.4l-31.4 115.8c-.1.4.2.8.6.8h15.2c.3 0 .5-.2.6-.4l9.1-33.7c.1-.3.3-.4.6-.4h33.6c.3 0 .5.2.6.4l9.1 33.7c.1.2.3.4.6.4zm-39.9-51 12.2-45.1c.2-.6 1-.6 1.2 0l12.2 45.1c.1.4-.2.8-.6.8h-24.4c-.4 0-.7-.4-.6-.8z" />
              <path d="m149.8 101.8v-35.8c0-.3.3-.6.6-.6h44.5c.3 0 .6-.3.6-.6v-14.4c0-.3-.3-.6-.6-.6h-44.5c-.3 0-.6-.3-.6-.6v-30.6c0-.3.3-.6.6-.6h50.6c.3 0 .6-.3.6-.6v-14.4c0-.3-.3-.6-.6-.6h-51.2-17.3c-.3 0-.6.3-.6.6v15 31.9 15.6 37 15.8c0 .3.3.6.6.6h17.3 53.3c.3 0 .6-.3.6-.6v-15.2c0-.3-.3-.6-.6-.6h-52.8c-.3-.1-.5-.3-.5-.7z" />
              <path d="m949.3 117.9-57.8-59.7c-.2-.2-.2-.6 0-.8l52-54c.4-.4.1-1-.4-1h-21.3c-.2 0-.3.1-.4.2l-44.1 45.8c-.4.4-1 .1-1-.4v-45c0-.3-.3-.6-.6-.6h-16.7c-.3 0-.6.3-.6.6v115.4c0 .3.3.6.6.6h16.7c.3 0 .6-.3.6-.6v-50.8c0-.5.7-.8 1-.4l50 51.6c.1.1.3.2.4.2h21.3c.4-.1.7-.8.3-1.1z" />
            </g>
            <g
              strokeLinecap="round"
              strokeLinejoin="round"
              transform="translate(1 1)"
            >
              <path
                d="m246.1.2-101.1 75 18.8-44.2z"
                fill="#e17726"
                stroke="#e17726"
              />
              <g fill="#e27625" stroke="#e27625" transform="translate(2)">
                <path d="m10.9.2 100.2 75.7-17.9-44.9z" />
                <path d="m207.7 174.1-26.9 41.2 57.6 15.9 16.5-56.2z" />
                <path d="m.2 175 16.4 56.2 57.5-15.9-26.8-41.2z" />
                <path d="m71 104.5-16 24.2 57 2.6-1.9-61.5z" />
                <path d="m184 104.5-39.7-35.4-1.3 62.2 57-2.6z" />
                <path d="m74.1 215.3 34.5-16.7-29.7-23.2z" />
                <path d="m146.4 198.6 34.4 16.7-4.7-39.9z" />
              </g>
              <g fill="#d5bfb2" stroke="#d5bfb2" transform="translate(76 198)">
                <path d="m106.8 17.3-34.4-16.7 2.8 22.4-.3 9.5z" />
                <path d="m.1 17.3 32 15.2-.2-9.5 2.7-22.4z" />
              </g>
              <path
                d="m108.7 160.6-28.6-8.4 20.2-9.3z"
                fill="#233447"
                stroke="#233447"
              />
              <path
                d="m150.3 160.6 8.4-17.7 20.3 9.3z"
                fill="#233447"
                stroke="#233447"
              />
              <g fill="#cc6228" stroke="#cc6228" transform="translate(49 128)">
                <path d="m27.1 87.3 5-41.2-31.8.9z" />
                <path d="m128.9 46.1 4.9 41.2 26.9-40.3z" />
                <path d="m153 .7-57 2.6 5.3 29.3 8.4-17.7 20.3 9.3z" />
                <path d="m31.1 24.2 20.2-9.3 8.4 17.7 5.3-29.3-57-2.6z" />
              </g>
              <g fill="#e27525" stroke="#e27525" transform="translate(57 128)">
                <path d="m0 .7 23.9 46.7-.8-23.2z" />
                <path d="m122 24.2-.9 23.2 23.9-46.7z" />
                <path d="m57 3.3-5.3 29.3 6.7 34.6 1.5-45.6z" />
                <path d="m88 3.3-2.8 18.2 1.4 45.7 6.7-34.6z" />
              </g>
              <path
                d="m150.3 160.6-6.7 34.6 4.8 3.4 29.7-23.2.9-23.2z"
                fill="#f5841f"
                stroke="#f5841f"
              />
              <path
                d="m80.1 152.2.8 23.2 29.7 23.2 4.8-3.4-6.7-34.6z"
                fill="#f5841f"
                stroke="#f5841f"
              />
              <path
                d="m150.9 230.5.3-9.5-2.6-2.2h-38.2l-2.5 2.2.2 9.5-32-15.2 11.2 9.2 22.7 15.7h38.9l22.8-15.7 11.1-9.2z"
                fill="#c0ac9d"
                stroke="#c0ac9d"
              />
              <path
                d="m148.4 198.6-4.8-3.4h-28.2l-4.8 3.4-2.7 22.4 2.5-2.2h38.2l2.6 2.2z"
                fill="#161616"
                stroke="#161616"
              />
              <g fill="#763e1a" stroke="#763e1a">
                <path d="m250.4 80.1 8.5-41.4-12.8-38.5-97.7 72.5 37.6 31.8 53.1 15.5 11.7-13.7-5.1-3.7 8.1-7.4-6.2-4.8 8.1-6.2z" />
                <path d="m.1 38.7 8.6 41.4-5.5 4.1 8.2 6.2-6.2 4.8 8.1 7.4-5.1 3.7 11.7 13.7 53.1-15.5 37.6-31.8-97.7-72.5z" />
              </g>
              <g fill="#f5841f" stroke="#f5841f">
                <path d="m239.1 120-53.1-15.5 16 24.2-23.9 46.7 31.6-.4h47.2z" />
                <path d="m73 104.5-53.1 15.5-17.7 55h47.1l31.6.4-23.9-46.7z" />
                <path d="m145 131.3 3.4-58.6 15.4-41.7h-68.6l15.4 41.7 3.4 58.6 1.3 18.4.1 45.5h28.2l.1-45.5z" />
              </g>
            </g>
          </g>
        </svg>
      );
  }
}

MetaFoxHorizontalLogo.propTypes = {
  theme: PropTypes.oneOf([ThemeType.light, ThemeType.dark, ThemeType.os]),
  className: PropTypes.string,
};
