export const ALL_NETWORKS_DATA = {
  '0x1': {
    nativeCurrency: 'ETH',
    chainId: '0x1',
    defaultRpcEndpointIndex: 0,
    name: 'Ethereum Mainnet',
    blockExplorerUrls: [],
    rpcEndpoints: [
      {
        networkClientId: 'mainnet',
      },
    ],
  },
  '0xe708': {
    nativeCurrency: 'ETH',
    chainId: '0xe708',
    defaultRpcEndpointIndex: 0,
    name: 'Linea Mainnet',
    blockExplorerUrls: [],
    rpcEndpoints: [
      {
        networkClientId: 'linea-mainnet',
      },
    ],
  },
  '0xfa': {
    nativeCurrency: 'FTM',
    chainId: '0xfa',
    defaultRpcEndpointIndex: 0,
    name: 'FANTOM',
    blockExplorerUrls: [],
    rpcEndpoints: [
      {
        networkClientId: 'fantom-network-client-id',
      },
    ],
  },
  '0x5': {
    nativeCurrency: 'GoerliETH',
    chainId: '0x5',
    defaultRpcEndpointIndex: 0,
    name: 'Goerli',
    blockExplorerUrls: [],
    rpcEndpoints: [
      {
        networkClientId: 'goerli',
      },
    ],
  },
  '0xaa36a7': {
    nativeCurrency: 'SepoliaETH',
    chainId: '0xaa36a7',
    name: 'Sepolia',
    blockExplorerUrls: [],
    defaultRpcEndpointIndex: 0,
    rpcEndpoints: [
      {
        networkClientId: 'sepolia',
      },
    ],
  },
  '0xe704': {
    nativeCurrency: 'LineaETH',
    chainId: '0xe704',
    name: 'Linea Goerli',
    blockExplorerUrls: [],
    defaultRpcEndpointIndex: 0,
    rpcEndpoints: [
      {
        networkClientId: 'linea-goerli',
      },
    ],
  },
  '0xe705': {
    nativeCurrency: 'LineaETH',
    chainId: '0xe705',
    name: 'Linea Sepolia',
    blockExplorerUrls: [],
    defaultRpcEndpointIndex: 0,
    rpcEndpoints: [
      {
        networkClientId: 'linea-sepolia',
      },
    ],
  },
};

export const INCOMING_DATA = {
  '0x1': true,
  '0xe708': false,
  '0xfa': true,
  '0x5': false,
  '0xaa36a7': true,
  '0xe704': true,
  '0xe705': true,
};
