const MOCK_BLOCK_NUMBER = '0x1';

export type mockJsonRpcResultType = {
  // TODO: Replace `any` with type
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  [methodName: string]: { [arbitraryVariantName: string]: any };
};

export const mockJsonRpcResult: mockJsonRpcResultType = {
  eth_blockNumber: {
    default: MOCK_BLOCK_NUMBER,
    custom: '0x130E45F',
  },

  eth_estimateGas: {
    default: '0x5cec',
  },

  eth_call: {
    balance:
      '0x000000000000000000000000000000000000000000000000000000000001ea4c',
    balanceApprove:
      '0x0000000000000000000000000000000000000000000000000000000000000000',
    balanceChecker:
      '0x0000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000a00000000000000000000000000000000000000000000000000047c04ab071c390000000000000000000000000000000000000000000000000001699651aa88200000000000000000000000000000000000000000000000000001beca58919dc0000000000000000000000000000000000000000000000000000974189179054f0000000000000000000000000000000000000000000000000001d9ae54845818000000000000000000000000000000000000000000000000000009184e72a00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110d9316ec0000000000000000000000000000000000000000000000000000000000000000000',
    default: '0x4563918244F40000',
    offchainOracle:
      '0x0000000000000000000000000000000000000000000000000ddfe4d79cbd3de5',
  },

  eth_feeHistory: {
    default: {
      baseFeePerGas: [
        '0x69b11e562',
        '0x666a7c239',
        '0x6d9e609f6',
        '0x6e9ab5408',
        '0x6bca983cb',
        '0x6a6f790c3',
      ],
      gasUsedRatio: [
        0.37602026666666666, 0.7813118333333333, 0.5359671, 0.39827006666666664,
        0.44968263333333336,
      ],
      oldestBlock: '0x115e9c0',
      reward: [
        ['0xfbc521', '0x21239e6', '0x5f5e100'],
        ['0x5f5e100', '0x68e7780', '0x314050eb'],
        ['0xfbc521', '0xfbc521', '0xfbc521'],
        ['0x21239e6', '0x5f5e100', '0x5f5e100'],
        ['0x21239e6', '0x5f5e100', '0x5f5e100'],
      ],
    },
  },

  eth_gasPrice: {
    default: '0x09184e72a000',
  },

  eth_getBalance: {
    default: '0x11560353150064891483127808',
  },

  eth_getBlockByNumber: {
    default: {
      baseFeePerGas: '0x16c696eb7',
      difficulty: '0x0',
      extraData: '0x6631622e696f',
      gasLimit: '0x1c9c380',
      gasUsed: '0xa0056a',
      hash: '0x46be2982228b663026adae2bcedf1fcff63e244deeb1092a9bf498be54215d0c',
      logsBloom:
        '0x2937858c6d9cfb38c4d80264a351d63c9128489348959c00413114802722281e0048c4e3038ac093709089b0809a2192e6c185500811b86e2074c92d092a386c0342f1084e3828786823ee6b77080b7cbc9732020058d48c4d5348e78a6440c83bc06011ba0abbc94145107218404cf306b00a63216604053e4aa018000e902795c30170819001002bce21443b1aa083e84029559b61182c694110c0d8340efa8f0d117328a464460c1ec6f4305bac8275b4ce2ec90740a694e2884f810b0320c0c68492e781434908a160a30ced3a1c5041628bb4bc201d9e1502121421e6472e59ac58b6240680128499a9a4fb892083e692155b58a3559eaa123be01f0619',
      miner: '0x5124fcc2b3f99f571ad67d075643c743f38f1c34',
      mixHash:
        '0xdcf58909059bf2c21d9f84862e5f038b622443395b8e91a147353d0403019c6f',
      nonce: '0x0000000000000000',
      number: MOCK_BLOCK_NUMBER,
      parentHash:
        '0x40bbc17240a659f2df8f3392a9d6d97f1ec60dd6407ee4553ddf40f32187a5cc',
      receiptsRoot:
        '0x8daf2c9ec0110723e3332be6de9d2ec7cc616bd6f2cab65c8db3f1116cc92076',
      sha3Uncles:
        '0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347',
      size: '0xf903',
      stateRoot:
        '0x8329c5c0838396dd640d00ab34f7aad71bf5d3d98a121e182a171f96e811e1dd',
      timestamp: '0x651e594f',
      totalDifficulty: '0xc70d815d562d3cfa955',
      transactions: [
        '0x025d6db129bae563f653c7d0095a308f0fb605a6e519269753df46e9aaa7aeaf',
        '0xe01dbeef9af2c47742a1c26069a71a9f70c544c6d80c4f63e5cfb56a6ba5e3db',
        '0xc68b76b00344181378fc50e4914e99b6720470bb01d064f42fe721c5473918e2',
        '0xe2d4323739c218a04013803f9961309f60b99db49b43e0b2215ac3624ff2da2f',
        '0xd132b4a8f258e379bd0d4995347b333abca91b3d83ddba245595dafbb6cdac1a',
        '0x0d9e5189abcf712e938bacd595240cd5467fb33ecac8f49ecd828db9eae5d842',
        '0x4b9da2de3480e6431e0edc74c6000229417a761372701777dabe0fcc8582d228',
        '0x4ab6221a5a2a1bb00e1b6583e9dc6dec05b27873b59ddf8955bfb0173d8f0f69',
        '0x3e98a84a91cd8d6a54824804776c22a2f4dbe6d4b62b665d6fa41793c2ed64cc',
        '0xb80f1371a9b541dd83c45fe450b54040a0bb949b697896874f73169156829225',
        '0x60801d230e5a87cc0f5acae9e9be25a8ff89728a8e8a7f7694452a469cc890a7',
        '0x089cb61bababa3a5d9f9aa2c65bba1fe4f659d2931069242d614fa53c991c858',
        '0xb301035281c8001d8b1f8bd9423f00c56d144f92da40411a49ef73884dad0565',
        '0x994553a9b9aa2348c9eb62165915af53d6aeba33558005fac5fa53953ba87eab',
        '0x9f367bfc18e62885a8f9d71edfdeb86bf8256d218dd637015bbb185f1c228e1e',
        '0x0c21e73c66d009dab799574510ed5b533256da2332e46f265d2a2ecf4df2f5d4',
        '0x54e1fad4103782f1fe2304d1da249e6948dcb7d27646307f7c0f111460ab27e3',
        '0xe793c71314eb429a249f26d62c82d588f76022eec775013f25841a441307ac20',
        '0x9c33cb549884f94f4b05f095b75735b59ca01341cd8f3399bf9f7b4685f8017b',
        '0x2f91e57ef968004af9105642f5b12d9955ff57799b1e983fe74ad3430ffe531c',
        '0x617af6cf35eecbed22ac1b1d94e54ec105edf05a6c0d9cc4a5b7bcfdae942942',
        '0xd31edbb8f112de1bd194853a0c4d50e9ee3e9a7a079253d50d5b10cb77afa3cd',
        '0x0c37629d50b0c9e755c727522112cc381cd7f2ca3b201f1f0332e5b76b0d2eba',
        '0xe6ae038c038df8d0091bb043b95c3c335e4ce538324fb1048ca98662a5d3fd8a',
        '0xdb369684b55c236cfbcd6a9871621d796a626c43ecf8048d3365bd6854106e77',
        '0xe084e6a6c86b9896d8ad654e348f29bba534431d187d32cc348b4c1fbdfb6ac2',
        '0x137cbc7fb3cfbc868787c2a35cebc881ce3c130b4eade5592c004d348113e6cc',
        '0xe037a224f579ebb494fb7789c99f059039204efca53c69a80259944d866397d6',
        '0xc1f78a716f9b14e2f06947212c90b4c06c067574932e9a3d16aa111ea7a08325',
        '0x74f30f6f2810711bd580b07cf0df42d71fc1404e555b6bcafbe8f83fbbf0613a',
        '0x258ac5c91a8c34c4ece04b66882522d55639051468244a2adfbd421e96411c03',
        '0x3eb7f91ae3d16d453d0ca327d02efe4cc46368c8d0148450afd4fbe23b6cd189',
        '0x69b9d46d3a380cb836475fd8d7d89230f3cb1d12955ece13adba5ef289b7171f',
        '0x9f3196f0211844deb3a84a00efd0224c4c2a1b4bd4ce4ab8289b36cb4083c202',
        '0x4c203a40e9affc4f4be28ba9ba22f1c4a5c9e6c4226ebada8e63170e6e127183',
        '0xc40a188843a35d90ac44e86b4ef738bf183bf3f44a037a8c5bf172fa1e6b3d82',
        '0x87663321079a2233fd0c62f0714508aa03681ba17bbaf1b136668200ec91f94f',
        '0xdd6ff72cab1d17bdcb274b67e9daedf142c909a05e0e9f1143c819f42ddc5d85',
        '0xb4a922f6582276fdc2dd4d2f8cc87fc318a213e7ba0d87adb388cc2afa948aad',
        '0xf48c8fd81c25dc5134d4327696f95cb90345b765658890ccba4842b09a3ee79e',
        '0x1cdc4c9ec42401ee52a730c40062054826c518020704ff5afd706037299a3f4c',
        '0x4384719429ce682f300c72a4e6d1de302571c53dcb9b925ac19919243027898f',
        '0x2d1c5e589bbf1c3d84ac6a48cf6fffe73848add4d2606f2bc164d45d0a539bc5',
        '0xcf095997048953d46637f4b23de28a7a0937387ee673aeac78956a4a2d18938e',
        '0x4af3b1a11feabd6cdff5957737064abebbb3707aecf8f6f1d19d427f3ea6b88d',
        '0xc8d426d5c0b342b1e34e205fec815a4e81dc440d14b2464eda894817746d583c',
        '0xc1c83af1aff7327d5ad44eea78290eb25f308ef1d037fd152dc00db23163fac7',
        '0x7b612d292c8bc245aac485a48c93e6ab510f79d260f0039c2dbc88cc53153ccf',
        '0xcea5beff384c7defa0c290f803303531d68cdd3ea824c1169283206128edb824',
        '0xc7ec7fca044fbe37bfeec938a9792f42ab1a3d8255feb00be93e68152ef130f2',
        '0x370411cf89cd5e75b12136a0ba61070c0f072ebe877a313d2c55f2b0db96c233',
        '0x62ded18451fb7ef92c5f8b3c888f8a304437095725c33691a9cacdc0665174eb',
        '0x3be8d2cd758594cedd8a3e249f47ebed0d95ca1c8cbf109941811f0974daae6d',
        '0x7eebdbdedf238af9ec6e0fb8860660db88d613b9a1c747de5b38b02763f2901b',
        '0x337f14eab5bfdd58af32f28e115a1e2735c6bd52818e407a090d991bcacf900d',
        '0xf9b377921e51e97b9a302d69dc55b99eeb96f8232b5fa8518f1cfddc4acd78aa',
        '0x6a957b8481ad0935c6c864308ff09e78123daeb64a349b007ed714d810d14f54',
        '0x3fafa02783759c232e9d06b65b3104f554e24410eb0ba8a6f02ba33f3e5f0bdb',
        '0xaa3dff89f379cbb1f4c916885bb83763455c6cbd2ab4fb466032ada29c16bce0',
        '0xc559e193f4abb05bd90f82525a3e14e345106da19cf405c73c462b7e17d4896a',
        '0xfd487c02e24f2fbc8306027c459bb6559f8641596051e5dc56477c807324841a',
        '0xfd62e1e1c9050034f11cb9e0109bd64cb727b261ca1c94fb4dbe6cdd2e4f8199',
        '0xeaf0a50c8b204989689d827cd9ef7704d4fd0ee33fbfd1b6dc49c5ccd025068b',
        '0x3fec28b8a00046992cb68b594cd98bf5aa9c11813c88e6d2a3a83a8ff2b1efd8',
        '0x43cbfd77dbab4fca9cc310e90ce3e7b5b05e390968bfd43b71bd4e17ce73ae77',
        '0x808e4b342458f54c258ce1dafc865d6cac2bdc263a488a988f1c2862fe02beda',
        '0xafe2a9c974044d255669e8033d6c2a367c82ba2708f2a7d98c4cab2e1f8e1426',
        '0x1aeb33eb00070c71fbb4649f718dff2e559bdfab80027932bbd8bff3e74ea6a6',
        '0x9a64a51fdc0ad112b0ac516114e16efe281ed68f0a3eb39837aebbaab1bcbf9c',
        '0xa0fe376754f08bbd2d9154283802e4259e46b178580169be0c21abdb8ef1ded8',
        '0x8c68f0fbbfbe4ecfb2bc4c859538ee62531bd32dd488dd1b029d9bc2a639db64',
        '0xa49bf5d42110fd52c30573bf2aba77b17d4ab081c0b8f68436eb40cf9b5ba3d6',
        '0x115bc870a989ae86ad745015bf11cf3c66773ed2d26e80e11b8bc5a065194c13',
        '0x316ac31966733f8c6b47aa75d5326a696bf5c4a651cb964df18f90f267dec789',
        '0x8008670e8eba15b6d06bf6a7a3cbe9aca543d4e83a3a7369b0433e0b3e3ceae1',
        '0x554ff6c269a97976ed8284cbfd024b04024bcf3b25d515d72dbcf038e47a1a08',
        '0xa8b227e912c564b0a80aac19e3a618299985264d02a1b6baacf86df40e1ad758',
        '0xf1cf308519a9025566d5210f7daf8195fe9c44e38e9cdc6f471c6b2699a7e5f0',
        '0x7223a0b7cd4e47fc7b40ded2784cb2af6cb3ffd14674171f1c4c60b1ddb97b9c',
        '0xc507db1b36a662139c09c232c00a2ae6c7dd45c1bc05e8d942037fae9d2c8833',
        '0xbc15f576fb8e63dc0f7b70255ea0de87efb1082d86ca7f70f1bdef563b584426',
        '0xa8d7889cf487e501ce6e3f019eed74f570def855fd47415fed45f3e0cd6e9e7f',
        '0x52f950bd0ecb8ba81e6cd20ecf7a6e66371807c624123065adbe3c3d6c288500',
        '0xfee006db800181afc124844c31b06924d25f60e8d2296288338af0e7e9f7044f',
        '0x82d8d09880a7cab32dd3be06dac2dea0afea41e9f3fd9707a5e25f032dcb966f',
        '0x7da65bbc41064b24bb5f272b187fa05df30ea22c768d2e6d336df313a266cb82',
        '0x3c13b7c7e236d68d8c4799b71b9b6bd4ce36c520f3b2f29635421950f8a56e03',
        '0x72aaefd1673c10dd0d8e5d4726a5eafd3a8726022ab382cf38cbce96c16dc728',
        '0x90b5a4a70051fcc4e8312b563e43a1dd02c366f14659111225052d4bcac3a258',
        '0xf4aa46063de8baa2ad61b3eabd1f12113e20a16eafd4c2a2e3b93cf94d8c9fcd',
        '0xc18d5fa6f953d257cdb4699b58eb3132ad763c20fface4ec13b722e954aefbcf',
        '0xd12e95ec8bfea56f712171dbc36c90a5c4bfa945e1dd6b87de9a01568856c23f',
        '0x0142e97265b78e5e49b2bd552829753974872b0ebbeebb60257008fed298a203',
        '0x532a433729da0def288b673ccbc5a192dffee962c93f1977719b6f8f76269a3d',
        '0x1154125dcacd088953bb3eb1b28c547efe50bd40f74ac7e582154d22bcc15c36',
        '0xd4bd5c72901df585e344a20125a4be4bc582a7d5ebf07d7999fae27daa31cce5',
        '0x4fb02170dfd47274e00db7a23a9ec3446b8d89032438f6b9b5822178e8ad7e77',
        '0xc8e62f9804f5e9934601245222a381c2571069fd4a939563517cc59f7b024cde',
        '0x86ad26c2223eb7830306e57964e2050acc699ff5a50068ea8e940221fb08679e',
        '0x7b96fd3e0f467ee48b6e249175feae53b6cc2a12482d2b2e4ba71774cfbd62cc',
        '0xa0336d44a6f2f804fb0b1d83eadc27423242f79676545002da772899dfeea0b3',
        '0x28e47bdefa59405e0e3267f047bf46d20304c98661f920fd87fd9f8bbc29e9d3',
        '0xb498d5300881fd5f8482b991504876cbe51edcd14b6abda326f48201fc9f2234',
        '0xd94762cee129d65e8178eba2c7b2aed14d340cea0bd8e777869003919b186712',
        '0x47b50e56928b2b5bfa63adfb411ebf5b20b0fd9e1d3b445867cdfae52ae0aeef',
        '0x56cf1b42f63e7718400fd465fa1af37397e5fa2cbe85fd6879f83473f5e3995a',
        '0x8a1490011374ffe25b45862d41be4735e08d9e18b1b8b726d4a9d4d8e0194a27',
        '0x3489042ecae7846b58488aa770bedd81ad7f1783efd1bee7756b00de4024b65d',
        '0x44f85f310884644c48efe8f07cf549408ce942652a8f1f7ad7b01b4bc78399de',
      ],
      transactionsRoot:
        '0xfc1f88c241dff40c33cc8cf48b18b1a59c86346f0f4ea15317142265f20f8b03',
      uncles: [],
      withdrawals: [
        {
          address: '0x036c9c0aae7a8268f332ba968dac5963c6adaca5',
          amount: '0xfbd866',
          index: '0x1309706',
          validatorIndex: '0x90fe9',
        },
        {
          address: '0x036c9c0aae7a8268f332ba968dac5963c6adaca5',
          amount: '0xfbb65d',
          index: '0x1309707',
          validatorIndex: '0x90fea',
        },
        {
          address: '0x036c9c0aae7a8268f332ba968dac5963c6adaca5',
          amount: '0xfc42ba',
          index: '0x1309708',
          validatorIndex: '0x90feb',
        },
        {
          address: '0x036c9c0aae7a8268f332ba968dac5963c6adaca5',
          amount: '0x3682aae',
          index: '0x1309709',
          validatorIndex: '0x90fec',
        },
        {
          address: '0x036c9c0aae7a8268f332ba968dac5963c6adaca5',
          amount: '0xfc16c5',
          index: '0x130970a',
          validatorIndex: '0x90fed',
        },
        {
          address: '0x036c9c0aae7a8268f332ba968dac5963c6adaca5',
          amount: '0xfc672a',
          index: '0x130970b',
          validatorIndex: '0x90fee',
        },
        {
          address: '0x036c9c0aae7a8268f332ba968dac5963c6adaca5',
          amount: '0xfbf672',
          index: '0x130970c',
          validatorIndex: '0x90fef',
        },
        {
          address: '0x036c9c0aae7a8268f332ba968dac5963c6adaca5',
          amount: '0x3664440',
          index: '0x130970d',
          validatorIndex: '0x90ff0',
        },
        {
          address: '0x036c9c0aae7a8268f332ba968dac5963c6adaca5',
          amount: '0xfbf9c4',
          index: '0x130970e',
          validatorIndex: '0x90ff1',
        },
        {
          address: '0x036c9c0aae7a8268f332ba968dac5963c6adaca5',
          amount: '0xfc54c4',
          index: '0x130970f',
          validatorIndex: '0x90ff2',
        },
        {
          address: '0xd33cd8e9accd0b58a501e6076ad5c41a8702ca62',
          amount: '0xdde150',
          index: '0x1309710',
          validatorIndex: '0x90ff3',
        },
        {
          address: '0x036c9c0aae7a8268f332ba968dac5963c6adaca5',
          amount: '0xfc4959',
          index: '0x1309711',
          validatorIndex: '0x90ff4',
        },
        {
          address: '0xd33cd8e9accd0b58a501e6076ad5c41a8702ca62',
          amount: '0xde3e8c',
          index: '0x1309712',
          validatorIndex: '0x90ff5',
        },
        {
          address: '0x036c9c0aae7a8268f332ba968dac5963c6adaca5',
          amount: '0xfc7dbb',
          index: '0x1309713',
          validatorIndex: '0x90ff6',
        },
        {
          address: '0x036c9c0aae7a8268f332ba968dac5963c6adaca5',
          amount: '0xfc8f5b',
          index: '0x1309714',
          validatorIndex: '0x90ff7',
        },
        {
          address: '0x036c9c0aae7a8268f332ba968dac5963c6adaca5',
          amount: '0xfc9028',
          index: '0x1309715',
          validatorIndex: '0x90ff8',
        },
      ],
      withdrawalsRoot:
        '0x43efdf43ed0f1ede09f4ab425311ea16ea229cda5878a44eecc2d0f6d5fc618f',
    },
  },

  eth_getCode: {
    default: '0x',
    BUSD: '0x60806040526004361061006c5763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633659cfe681146100765780634f1ef286146100975780635c60da1b146100b75780638f283970146100e8578063f851a44014610109575b61007461011e565b005b34801561008257600080fd5b50610074600160a060020a0360043516610138565b61007460048035600160a060020a03169060248035908101910135610172565b3480156100c357600080fd5b506100cc6101ea565b60408051600160a060020a039092168252519081900360200190f35b3480156100f457600080fd5b50610074600160a060020a0360043516610227565b34801561011557600080fd5b506100cc610339565b610126610364565b610136610131610411565b610436565b565b61014061045a565b600160a060020a031633600160a060020a03161415610167576101628161047f565b61016f565b61016f61011e565b50565b61017a61045a565b600160a060020a031633600160a060020a031614156101dd5761019c8361047f565b30600160a060020a03163483836040518083838082843782019150509250505060006040518083038185875af19250505015156101d857600080fd5b6101e5565b6101e561011e565b505050565b60006101f461045a565b600160a060020a031633600160a060020a0316141561021c57610215610411565b9050610224565b61022461011e565b90565b61022f61045a565b600160a060020a031633600160a060020a0316141561016757600160a060020a03811615156102e557604080517f08c379a000000000000000000000000000000000000000000000000000000000815260206004820152603660248201527f43616e6e6f74206368616e6765207468652061646d696e206f6620612070726f60448201527f787920746f20746865207a65726f206164647265737300000000000000000000606482015290519081900360840190fd5b7f7e644d79422f17c01e4894b5f4f588d331ebfa28653d42ae832dc59e38c9798f61030e61045a565b60408051600160a060020a03928316815291841660208301528051918290030190a1610162816104c7565b600061034361045a565b600160a060020a031633600160a060020a0316141561021c5761021561045a565b61036c61045a565b600160a060020a031633141561040957604080517f08c379a000000000000000000000000000000000000000000000000000000000815260206004820152603260248201527f43616e6e6f742063616c6c2066616c6c6261636b2066756e6374696f6e20667260448201527f6f6d207468652070726f78792061646d696e0000000000000000000000000000606482015290519081900360840190fd5b610136610136565b7f7050c9e0f4ca769c69bd3a8ef740bc37934f8e2c036e5a723fd8ee048ed3f8c35490565b3660008037600080366000845af43d6000803e808015610455573d6000f35b3d6000fd5b7f10d6a54a4754c8869d6886b5f5d7fbfa5b4522237ea5c60d11bc4e7a1ff9390b5490565b610488816104eb565b60408051600160a060020a038316815290517fbc7cd75a20ee27fd9adebab32041f755214dbc6bffa90cc0225b39da2e5c2d3b9181900360200190a150565b7f10d6a54a4754c8869d6886b5f5d7fbfa5b4522237ea5c60d11bc4e7a1ff9390b55565b60006104f6826105ae565b151561058957604080517f08c379a000000000000000000000000000000000000000000000000000000000815260206004820152603b60248201527f43616e6e6f742073657420612070726f787920696d706c656d656e746174696f60448201527f6e20746f2061206e6f6e2d636f6e747261637420616464726573730000000000606482015290519081900360840190fd5b507f7050c9e0f4ca769c69bd3a8ef740bc37934f8e2c036e5a723fd8ee048ed3f8c355565b6000903b11905600a165627a7a72305820b274fe16b200679a229fcce27c65314a32b3cff995c434133f535dd565bba4740029',
    BUSD_IMPL:
      '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',
    SELECTED_ADDR: '0x',
    USDC: '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',
    BAYC: '0x60806040526004361061021a5760003560e01c80636c0360eb11610123578063b0f67427116100ab578063e36d64981161006f578063e36d649814610ddf578063e985e9c514610e0a578063e986655014610e91578063eb8d244414610ea8578063f2fde38b14610ed55761021a565b8063b0f6742714610bac578063b88d4fde14610bc3578063bb8a16bd14610cd5578063c87b56dd14610d00578063cb774d4714610db45761021a565b80637d17fcbe116100f25780637d17fcbe14610a395780638da5cb5b14610a5057806395d89b4114610a91578063a22cb46514610b21578063a723533e14610b7e5761021a565b80636c0360eb1461090257806370a0823114610992578063715018a6146109f75780637a3f451e14610a0e5761021a565b80632f745c59116101a65780634f6ccce7116101755780634f6ccce7146106cb57806355f804b31461071a578063571dff3b146107e2578063607e20e31461080d5780636352211e1461089d5761021a565b80632f745c59146105b357806334918dfd146106225780633ccfd60b1461063957806342842e0e146106505761021a565b8063095ea7b3116101ed578063095ea7b3146103bf578063109695231461041a57806318160ddd146104e257806318e20a381461050d57806323b872dd146105385761021a565b8063018a2c371461021f57806301ffc9a71461025a57806306fdde03146102ca578063081812fc1461035a575b600080fd5b34801561022b57600080fd5b506102586004803603602081101561024257600080fd5b8101908080359060200190929190505050610f26565b005b34801561026657600080fd5b506102b26004803603602081101561027d57600080fd5b8101908080357bffffffffffffffffffffffffffffffffffffffffffffffffffffffff19169060200190929190505050610fdf565b60405180821515815260200191505060405180910390f35b3480156102d657600080fd5b506102df611046565b6040518080602001828103825283818151815260200191508051906020019080838360005b8381101561031f578082015181840152602081019050610304565b50505050905090810190601f16801561034c5780820380516001836020036101000a031916815260200191505b509250505060405180910390f35b34801561036657600080fd5b506103936004803603602081101561037d57600080fd5b81019080803590602001909291905050506110e8565b604051808273ffffffffffffffffffffffffffffffffffffffff16815260200191505060405180910390f35b3480156103cb57600080fd5b50610418600480360360408110156103e257600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff16906020019092919080359060200190929190505050611183565b005b34801561042657600080fd5b506104e06004803603602081101561043d57600080fd5b810190808035906020019064010000000081111561045a57600080fd5b82018360208201111561046c57600080fd5b8035906020019184600183028401116401000000008311171561048e57600080fd5b91908080601f016020809104026020016040519081016040528093929190818152602001838380828437600081840152601f19601f8201169050808301925050505050505091929192905050506112c7565b005b3480156104ee57600080fd5b506104f7611390565b6040518082815260200191505060405180910390f35b34801561051957600080fd5b506105226113a1565b6040518082815260200191505060405180910390f35b34801561054457600080fd5b506105b16004803603606081101561055b57600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff169060200190929190803573ffffffffffffffffffffffffffffffffffffffff169060200190929190803590602001909291905050506113a7565b005b3480156105bf57600080fd5b5061060c600480360360408110156105d657600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff1690602001909291908035906020019092919050505061141d565b6040518082815260200191505060405180910390f35b34801561062e57600080fd5b50610637611478565b005b34801561064557600080fd5b5061064e611553565b005b34801561065c57600080fd5b506106c96004803603606081101561067357600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff169060200190929190803573ffffffffffffffffffffffffffffffffffffffff16906020019092919080359060200190929190505050611651565b005b3480156106d757600080fd5b50610704600480360360208110156106ee57600080fd5b8101908080359060200190929190505050611671565b6040518082815260200191505060405180910390f35b34801561072657600080fd5b506107e06004803603602081101561073d57600080fd5b810190808035906020019064010000000081111561075a57600080fd5b82018360208201111561076c57600080fd5b8035906020019184600183028401116401000000008311171561078e57600080fd5b91908080601f016020809104026020016040519081016040528093929190818152602001838380828437600081840152601f19601f820116905080830192505050505050509192919290505050611694565b005b3480156107ee57600080fd5b506107f761174f565b6040518082815260200191505060405180910390f35b34801561081957600080fd5b50610822611754565b6040518080602001828103825283818151815260200191508051906020019080838360005b83811015610862578082015181840152602081019050610847565b50505050905090810190601f16801561088f5780820380516001836020036101000a031916815260200191505b509250505060405180910390f35b3480156108a957600080fd5b506108d6600480360360208110156108c057600080fd5b81019080803590602001909291905050506117f2565b604051808273ffffffffffffffffffffffffffffffffffffffff16815260200191505060405180910390f35b34801561090e57600080fd5b50610917611829565b6040518080602001828103825283818151815260200191508051906020019080838360005b8381101561095757808201518184015260208101905061093c565b50505050905090810190601f1680156109845780820380516001836020036101000a031916815260200191505b509250505060405180910390f35b34801561099e57600080fd5b506109e1600480360360208110156109b557600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff1690602001909291905050506118cb565b6040518082815260200191505060405180910390f35b348015610a0357600080fd5b50610a0c6119a0565b005b348015610a1a57600080fd5b50610a23611b10565b6040518082815260200191505060405180910390f35b348015610a4557600080fd5b50610a4e611b1c565b005b348015610a5c57600080fd5b50610a65611c4c565b604051808273ffffffffffffffffffffffffffffffffffffffff16815260200191505060405180910390f35b348015610a9d57600080fd5b50610aa6611c76565b6040518080602001828103825283818151815260200191508051906020019080838360005b83811015610ae6578082015181840152602081019050610acb565b50505050905090810190601f168015610b135780820380516001836020036101000a031916815260200191505b509250505060405180910390f35b348015610b2d57600080fd5b50610b7c60048036036040811015610b4457600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff169060200190929190803515159060200190929190505050611d18565b005b610baa60048036036020811015610b9457600080fd5b8101908080359060200190929190505050611ece565b005b348015610bb857600080fd5b50610bc1612127565b005b348015610bcf57600080fd5b50610cd360048036036080811015610be657600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff169060200190929190803573ffffffffffffffffffffffffffffffffffffffff1690602001909291908035906020019092919080359060200190640100000000811115610c4d57600080fd5b820183602082011115610c5f57600080fd5b80359060200191846001830284011164010000000083111715610c8157600080fd5b91908080601f016020809104026020016040519081016040528093929190818152602001838380828437600081840152601f19601f82011690508083019250505050505050919291929050505061220b565b005b348015610ce157600080fd5b50610cea612283565b6040518082815260200191505060405180910390f35b348015610d0c57600080fd5b50610d3960048036036020811015610d2357600080fd5b8101908080359060200190929190505050612289565b6040518080602001828103825283818151815260200191508051906020019080838360005b83811015610d79578082015181840152602081019050610d5e565b50505050905090810190601f168015610da65780820380516001836020036101000a031916815260200191505b509250505060405180910390f35b348015610dc057600080fd5b50610dc961255a565b6040518082815260200191505060405180910390f35b348015610deb57600080fd5b50610df4612560565b6040518082815260200191505060405180910390f35b348015610e1657600080fd5b50610e7960048036036040811015610e2d57600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff169060200190929190803573ffffffffffffffffffffffffffffffffffffffff169060200190929190505050612566565b60405180821515815260200191505060405180910390f35b348015610e9d57600080fd5b50610ea66125fa565b005b348015610eb457600080fd5b50610ebd612764565b60405180821515815260200191505060405180910390f35b348015610ee157600080fd5b50610f2460048036036020811015610ef857600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff169060200190929190505050612777565b005b610f2e61296c565b73ffffffffffffffffffffffffffffffffffffffff16610f4c611c4c565b73ffffffffffffffffffffffffffffffffffffffff1614610fd5576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260208152602001807f4f776e61626c653a2063616c6c6572206973206e6f7420746865206f776e657281525060200191505060405180910390fd5b8060108190555050565b6000806000837bffffffffffffffffffffffffffffffffffffffffffffffffffffffff19167bffffffffffffffffffffffffffffffffffffffffffffffffffffffff1916815260200190815260200160002060009054906101000a900460ff169050919050565b606060068054600181600116156101000203166002900480601f0160208091040260200160405190810160405280929190818152602001828054600181600116156101000203166002900480156110de5780601f106110b3576101008083540402835291602001916110de565b820191906000526020600020905b8154815290600101906020018083116110c157829003601f168201915b5050505050905090565b60006110f382612974565b611148576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252602c81526020018061408b602c913960400191505060405180910390fd5b6004600083815260200190815260200160002060009054906101000a900473ffffffffffffffffffffffffffffffffffffffff169050919050565b600061118e826117f2565b90508073ffffffffffffffffffffffffffffffffffffffff168373ffffffffffffffffffffffffffffffffffffffff161415611215576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252602181526020018061410f6021913960400191505060405180910390fd5b8073ffffffffffffffffffffffffffffffffffffffff1661123461296c565b73ffffffffffffffffffffffffffffffffffffffff16148061126357506112628161125d61296c565b612566565b5b6112b8576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401808060200182810382526038815260200180613f956038913960400191505060405180910390fd5b6112c28383612991565b505050565b6112cf61296c565b73ffffffffffffffffffffffffffffffffffffffff166112ed611c4c565b73ffffffffffffffffffffffffffffffffffffffff1614611376576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260208152602001807f4f776e61626c653a2063616c6c6572206973206e6f7420746865206f776e657281525060200191505060405180910390fd5b80600b908051906020019061138c929190613de6565b5050565b600061139c6002612a4a565b905090565b60105481565b6113b86113b261296c565b82612a5f565b61140d576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260318152602001806141306031913960400191505060405180910390fd5b611418838383612b53565b505050565b600061147082600160008673ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff168152602001908152602001600020612d9690919063ffffffff16565b905092915050565b61148061296c565b73ffffffffffffffffffffffffffffffffffffffff1661149e611c4c565b73ffffffffffffffffffffffffffffffffffffffff1614611527576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260208152602001807f4f776e61626c653a2063616c6c6572206973206e6f7420746865206f776e657281525060200191505060405180910390fd5b600f60009054906101000a900460ff1615600f60006101000a81548160ff021916908315150217905550565b61155b61296c565b73ffffffffffffffffffffffffffffffffffffffff16611579611c4c565b73ffffffffffffffffffffffffffffffffffffffff1614611602576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260208152602001807f4f776e61626c653a2063616c6c6572206973206e6f7420746865206f776e657281525060200191505060405180910390fd5b60004790503373ffffffffffffffffffffffffffffffffffffffff166108fc829081150290604051600060405180830381858888f1935050505015801561164d573d6000803e3d6000fd5b5050565b61166c8383836040518060200160405280600081525061220b565b505050565b600080611688836002612db090919063ffffffff16565b50905080915050919050565b61169c61296c565b73ffffffffffffffffffffffffffffffffffffffff166116ba611c4c565b73ffffffffffffffffffffffffffffffffffffffff1614611743576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260208152602001807f4f776e61626c653a2063616c6c6572206973206e6f7420746865206f776e657281525060200191505060405180910390fd5b61174c81612ddc565b50565b601481565b600b8054600181600116156101000203166002900480601f0160208091040260200160405190810160405280929190818152602001828054600181600116156101000203166002900480156117ea5780601f106117bf576101008083540402835291602001916117ea565b820191906000526020600020905b8154815290600101906020018083116117cd57829003601f168201915b505050505081565b600061182282604051806060016040528060298152602001613ff7602991396002612df69092919063ffffffff16565b9050919050565b606060098054600181600116156101000203166002900480601f0160208091040260200160405190810160405280929190818152602001828054600181600116156101000203166002900480156118c15780601f10611896576101008083540402835291602001916118c1565b820191906000526020600020905b8154815290600101906020018083116118a457829003601f168201915b5050505050905090565b60008073ffffffffffffffffffffffffffffffffffffffff168273ffffffffffffffffffffffffffffffffffffffff161415611952576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252602a815260200180613fcd602a913960400191505060405180910390fd5b611999600160008473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff168152602001908152602001600020612e15565b9050919050565b6119a861296c565b73ffffffffffffffffffffffffffffffffffffffff166119c6611c4c565b73ffffffffffffffffffffffffffffffffffffffff1614611a4f576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260208152602001807f4f776e61626c653a2063616c6c6572206973206e6f7420746865206f776e657281525060200191505060405180910390fd5b600073ffffffffffffffffffffffffffffffffffffffff16600a60009054906101000a900473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff167f8be0079c531659141344cd1fd0a4f28419497f9722a3daafe3b4186f6b6457e060405160405180910390a36000600a60006101000a81548173ffffffffffffffffffffffffffffffffffffffff021916908373ffffffffffffffffffffffffffffffffffffffff160217905550565b67011c37937e08000081565b611b2461296c565b73ffffffffffffffffffffffffffffffffffffffff16611b42611c4c565b73ffffffffffffffffffffffffffffffffffffffff1614611bcb576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260208152602001807f4f776e61626c653a2063616c6c6572206973206e6f7420746865206f776e657281525060200191505060405180910390fd5b6000600d5414611c43576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252601d8152602001807f5374617274696e6720696e64657820697320616c72656164792073657400000081525060200191505060405180910390fd5b43600c81905550565b6000600a60009054906101000a900473ffffffffffffffffffffffffffffffffffffffff16905090565b606060078054600181600116156101000203166002900480601f016020809104026020016040519081016040528092919081815260200182805460018160011615610100020316600290048015611d0e5780601f10611ce357610100808354040283529160200191611d0e565b820191906000526020600020905b815481529060010190602001808311611cf157829003601f168201915b5050505050905090565b611d2061296c565b73ffffffffffffffffffffffffffffffffffffffff168273ffffffffffffffffffffffffffffffffffffffff161415611dc1576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260198152602001807f4552433732313a20617070726f766520746f2063616c6c65720000000000000081525060200191505060405180910390fd5b8060056000611dce61296c565b73ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060008473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060006101000a81548160ff0219169083151502179055508173ffffffffffffffffffffffffffffffffffffffff16611e7b61296c565b73ffffffffffffffffffffffffffffffffffffffff167f17307eab39ab6107e8899845ad3d59bd9653f200f220920489ca2b5937696c318360405180821515815260200191505060405180910390a35050565b600f60009054906101000a900460ff16611f50576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252601f8152602001807f53616c65206d7573742062652061637469766520746f206d696e74204170650081525060200191505060405180910390fd5b6014811115611faa576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401808060200182810382526021815260200180613f746021913960400191505060405180910390fd5b600e54611fc782611fb9611390565b612e2a90919063ffffffff16565b111561201e576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260288152602001806140426028913960400191505060405180910390fd5b3461203a8267011c37937e080000612eb290919063ffffffff16565b11156120ae576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252601f8152602001807f45746865722076616c75652073656e74206973206e6f7420636f72726563740081525060200191505060405180910390fd5b60005b818110156120ef5760006120c3611390565b9050600e546120d0611390565b10156120e1576120e03382612f38565b5b5080806001019150506120b1565b506000600c541480156121175750600e54612108611390565b148061211657506010544210155b5b156121245743600c819055505b50565b61212f61296c565b73ffffffffffffffffffffffffffffffffffffffff1661214d611c4c565b73ffffffffffffffffffffffffffffffffffffffff16146121d6576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260208152602001807f4f776e61626c653a2063616c6c6572206973206e6f7420746865206f776e657281525060200191505060405180910390fd5b60006121e0611390565b905060005b601e811015612207576121fa33828401612f38565b80806001019150506121e5565b5050565b61221c61221661296c565b83612a5f565b612271576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260318152602001806141306031913960400191505060405180910390fd5b61227d84848484612f56565b50505050565b600e5481565b606061229482612974565b6122e9576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252602f8152602001806140e0602f913960400191505060405180910390fd5b6060600860008481526020019081526020016000208054600181600116156101000203166002900480601f0160208091040260200160405190810160405280929190818152602001828054600181600116156101000203166002900480156123925780601f1061236757610100808354040283529160200191612392565b820191906000526020600020905b81548152906001019060200180831161237557829003601f168201915b5050505050905060606123a3611829565b90506000815114156123b9578192505050612555565b60008251111561248a5780826040516020018083805190602001908083835b602083106123fb57805182526020820191506020810190506020830392506123d8565b6001836020036101000a03801982511681845116808217855250505050505090500182805190602001908083835b6020831061244c5780518252602082019150602081019050602083039250612429565b6001836020036101000a0380198251168184511680821785525050505050509050019250505060405160208183030381529060405292505050612555565b8061249485612fc8565b6040516020018083805190602001908083835b602083106124ca57805182526020820191506020810190506020830392506124a7565b6001836020036101000a03801982511681845116808217855250505050505090500182805190602001908083835b6020831061251b57805182526020820191506020810190506020830392506124f8565b6001836020036101000a03801982511681845116808217855250505050505090500192505050604051602081830303815290604052925050505b919050565b600d5481565b600c5481565b6000600560008473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060008373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060009054906101000a900460ff16905092915050565b6000600d5414612672576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252601d8152602001807f5374617274696e6720696e64657820697320616c72656164792073657400000081525060200191505060405180910390fd5b6000600c5414156126eb576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260208152602001807f5374617274696e6720696e64657820626c6f636b206d7573742062652073657481525060200191505060405180910390fd5b600e54600c544060001c816126fc57fe5b06600d8190555060ff61271a600c544361310f90919063ffffffff16565b111561273a57600e54600143034060001c8161273257fe5b06600d819055505b6000600d5414156127625761275b6001600d54612e2a90919063ffffffff16565b600d819055505b565b600f60009054906101000a900460ff1681565b61277f61296c565b73ffffffffffffffffffffffffffffffffffffffff1661279d611c4c565b73ffffffffffffffffffffffffffffffffffffffff1614612826576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260208152602001807f4f776e61626c653a2063616c6c6572206973206e6f7420746865206f776e657281525060200191505060405180910390fd5b600073ffffffffffffffffffffffffffffffffffffffff168173ffffffffffffffffffffffffffffffffffffffff1614156128ac576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401808060200182810382526026815260200180613ed86026913960400191505060405180910390fd5b8073ffffffffffffffffffffffffffffffffffffffff16600a60009054906101000a900473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff167f8be0079c531659141344cd1fd0a4f28419497f9722a3daafe3b4186f6b6457e060405160405180910390a380600a60006101000a81548173ffffffffffffffffffffffffffffffffffffffff021916908373ffffffffffffffffffffffffffffffffffffffff16021790555050565b600033905090565b600061298a82600261319290919063ffffffff16565b9050919050565b816004600083815260200190815260200160002060006101000a81548173ffffffffffffffffffffffffffffffffffffffff021916908373ffffffffffffffffffffffffffffffffffffffff160217905550808273ffffffffffffffffffffffffffffffffffffffff16612a04836117f2565b73ffffffffffffffffffffffffffffffffffffffff167f8c5be1e5ebec7d5bd14f71427d1e84f3dd0314c0f7b2291e5b200ac8c7c3b92560405160405180910390a45050565b6000612a58826000016131ac565b9050919050565b6000612a6a82612974565b612abf576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252602c815260200180613f48602c913960400191505060405180910390fd5b6000612aca836117f2565b90508073ffffffffffffffffffffffffffffffffffffffff168473ffffffffffffffffffffffffffffffffffffffff161480612b3957508373ffffffffffffffffffffffffffffffffffffffff16612b21846110e8565b73ffffffffffffffffffffffffffffffffffffffff16145b80612b4a5750612b498185612566565b5b91505092915050565b8273ffffffffffffffffffffffffffffffffffffffff16612b73826117f2565b73ffffffffffffffffffffffffffffffffffffffff1614612bdf576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260298152602001806140b76029913960400191505060405180910390fd5b600073ffffffffffffffffffffffffffffffffffffffff168273ffffffffffffffffffffffffffffffffffffffff161415612c65576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401808060200182810382526024815260200180613efe6024913960400191505060405180910390fd5b612c708383836131bd565b612c7b600082612991565b612ccc81600160008673ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020019081526020016000206131c290919063ffffffff16565b50612d1e81600160008573ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020019081526020016000206131dc90919063ffffffff16565b50612d35818360026131f69092919063ffffffff16565b50808273ffffffffffffffffffffffffffffffffffffffff168473ffffffffffffffffffffffffffffffffffffffff167fddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef60405160405180910390a4505050565b6000612da5836000018361322b565b60001c905092915050565b600080600080612dc386600001866132ae565b915091508160001c8160001c9350935050509250929050565b8060099080519060200190612df2929190613de6565b5050565b6000612e09846000018460001b84613347565b60001c90509392505050565b6000612e238260000161343d565b9050919050565b600080828401905083811015612ea8576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252601b8152602001807f536166654d6174683a206164646974696f6e206f766572666c6f77000000000081525060200191505060405180910390fd5b8091505092915050565b600080831415612ec55760009050612f32565b6000828402905082848281612ed657fe5b0414612f2d576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252602181526020018061406a6021913960400191505060405180910390fd5b809150505b92915050565b612f5282826040518060200160405280600081525061344e565b5050565b612f61848484612b53565b612f6d848484846134bf565b612fc2576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401808060200182810382526032815260200180613ea66032913960400191505060405180910390fd5b50505050565b60606000821415613010576040518060400160405280600181526020017f3000000000000000000000000000000000000000000000000000000000000000815250905061310a565b600082905060005b6000821461303a578080600101915050600a828161303257fe5b049150613018565b60608167ffffffffffffffff8111801561305357600080fd5b506040519080825280601f01601f1916602001820160405280156130865781602001600182028036833780820191505090505b50905060006001830390508593505b6000841461310257600a84816130a757fe5b0660300160f81b828280600190039350815181106130c157fe5b60200101907effffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff1916908160001a905350600a84816130fa57fe5b049350613095565b819450505050505b919050565b600082821115613187576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252601e8152602001807f536166654d6174683a207375627472616374696f6e206f766572666c6f77000081525060200191505060405180910390fd5b818303905092915050565b60006131a4836000018360001b6136d8565b905092915050565b600081600001805490509050919050565b505050565b60006131d4836000018360001b6136fb565b905092915050565b60006131ee836000018360001b6137e3565b905092915050565b6000613222846000018460001b8473ffffffffffffffffffffffffffffffffffffffff1660001b613853565b90509392505050565b60008183600001805490501161328c576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401808060200182810382526022815260200180613e846022913960400191505060405180910390fd5b82600001828154811061329b57fe5b9060005260206000200154905092915050565b60008082846000018054905011613310576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260228152602001806140206022913960400191505060405180910390fd5b600084600001848154811061332157fe5b906000526020600020906002020190508060000154816001015492509250509250929050565b6000808460010160008581526020019081526020016000205490506000811415839061340e576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825283818151815260200191508051906020019080838360005b838110156133d35780820151818401526020810190506133b8565b50505050905090810190601f1680156134005780820380516001836020036101000a031916815260200191505b509250505060405180910390fd5b5084600001600182038154811061342157fe5b9060005260206000209060020201600101549150509392505050565b600081600001805490509050919050565b613458838361392f565b61346560008484846134bf565b6134ba576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401808060200182810382526032815260200180613ea66032913960400191505060405180910390fd5b505050565b60006134e08473ffffffffffffffffffffffffffffffffffffffff16613b23565b6134ed57600190506136d0565b606061365763150b7a0260e01b61350261296c565b888787604051602401808573ffffffffffffffffffffffffffffffffffffffff1681526020018473ffffffffffffffffffffffffffffffffffffffff16815260200183815260200180602001828103825283818151815260200191508051906020019080838360005b8381101561358657808201518184015260208101905061356b565b50505050905090810190601f1680156135b35780820380516001836020036101000a031916815260200191505b5095505050505050604051602081830303815290604052907bffffffffffffffffffffffffffffffffffffffffffffffffffffffff19166020820180517bffffffffffffffffffffffffffffffffffffffffffffffffffffffff8381831617835250505050604051806060016040528060328152602001613ea6603291398773ffffffffffffffffffffffffffffffffffffffff16613b369092919063ffffffff16565b9050600081806020019051602081101561367057600080fd5b8101908080519060200190929190505050905063150b7a0260e01b7bffffffffffffffffffffffffffffffffffffffffffffffffffffffff1916817bffffffffffffffffffffffffffffffffffffffffffffffffffffffff191614925050505b949350505050565b600080836001016000848152602001908152602001600020541415905092915050565b600080836001016000848152602001908152602001600020549050600081146137d7576000600182039050600060018660000180549050039050600086600001828154811061374657fe5b906000526020600020015490508087600001848154811061376357fe5b906000526020600020018190555060018301876001016000838152602001908152602001600020819055508660000180548061379b57fe5b600190038181906000526020600020016000905590558660010160008781526020019081526020016000206000905560019450505050506137dd565b60009150505b92915050565b60006137ef8383613b4e565b61384857826000018290806001815401808255809150506001900390600052602060002001600090919091909150558260000180549050836001016000848152602001908152602001600020819055506001905061384d565b600090505b92915050565b60008084600101600085815260200190815260200160002054905060008114156138fa57846000016040518060400160405280868152602001858152509080600181540180825580915050600190039060005260206000209060020201600090919091909150600082015181600001556020820151816001015550508460000180549050856001016000868152602001908152602001600020819055506001915050613928565b8285600001600183038154811061390d57fe5b90600052602060002090600202016001018190555060009150505b9392505050565b600073ffffffffffffffffffffffffffffffffffffffff168273ffffffffffffffffffffffffffffffffffffffff1614156139d2576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260208152602001807f4552433732313a206d696e7420746f20746865207a65726f206164647265737381525060200191505060405180910390fd5b6139db81612974565b15613a4e576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252601c8152602001807f4552433732313a20746f6b656e20616c7265616479206d696e7465640000000081525060200191505060405180910390fd5b613a5a600083836131bd565b613aab81600160008573ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020019081526020016000206131dc90919063ffffffff16565b50613ac2818360026131f69092919063ffffffff16565b50808273ffffffffffffffffffffffffffffffffffffffff16600073ffffffffffffffffffffffffffffffffffffffff167fddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef60405160405180910390a45050565b600080823b905060008111915050919050565b6060613b458484600085613b71565b90509392505050565b600080836001016000848152602001908152602001600020541415905092915050565b606082471015613bcc576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401808060200182810382526026815260200180613f226026913960400191505060405180910390fd5b613bd585613b23565b613c47576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252601d8152602001807f416464726573733a2063616c6c20746f206e6f6e2d636f6e747261637400000081525060200191505060405180910390fd5b600060608673ffffffffffffffffffffffffffffffffffffffff1685876040518082805190602001908083835b60208310613c975780518252602082019150602081019050602083039250613c74565b6001836020036101000a03801982511681845116808217855250505050505090500191505060006040518083038185875af1925050503d8060008114613cf9576040519150601f19603f3d011682016040523d82523d6000602084013e613cfe565b606091505b5091509150613d0e828286613d1a565b92505050949350505050565b60608315613d2a57829050613ddf565b600083511115613d3d5782518084602001fd5b816040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825283818151815260200191508051906020019080838360005b83811015613da4578082015181840152602081019050613d89565b50505050905090810190601f168015613dd15780820380516001836020036101000a031916815260200191505b509250505060405180910390fd5b9392505050565b828054600181600116156101000203166002900490600052602060002090601f016020900481019282601f10613e2757805160ff1916838001178555613e55565b82800160010185558215613e55579182015b82811115613e54578251825591602001919060010190613e39565b5b509050613e629190613e66565b5090565b5b80821115613e7f576000816000905550600101613e67565b509056fe456e756d657261626c655365743a20696e646578206f7574206f6620626f756e64734552433732313a207472616e7366657220746f206e6f6e20455243373231526563656976657220696d706c656d656e7465724f776e61626c653a206e6577206f776e657220697320746865207a65726f20616464726573734552433732313a207472616e7366657220746f20746865207a65726f2061646472657373416464726573733a20696e73756666696369656e742062616c616e636520666f722063616c6c4552433732313a206f70657261746f7220717565727920666f72206e6f6e6578697374656e7420746f6b656e43616e206f6e6c79206d696e7420323020746f6b656e7320617420612074696d654552433732313a20617070726f76652063616c6c6572206973206e6f74206f776e6572206e6f7220617070726f76656420666f7220616c6c4552433732313a2062616c616e636520717565727920666f7220746865207a65726f20616464726573734552433732313a206f776e657220717565727920666f72206e6f6e6578697374656e7420746f6b656e456e756d657261626c654d61703a20696e646578206f7574206f6620626f756e6473507572636861736520776f756c6420657863656564206d617820737570706c79206f662041706573536166654d6174683a206d756c7469706c69636174696f6e206f766572666c6f774552433732313a20617070726f76656420717565727920666f72206e6f6e6578697374656e7420746f6b656e4552433732313a207472616e73666572206f6620746f6b656e2074686174206973206e6f74206f776e4552433732314d657461646174613a2055524920717565727920666f72206e6f6e6578697374656e7420746f6b656e4552433732313a20617070726f76616c20746f2063757272656e74206f776e65724552433732313a207472616e736665722063616c6c6572206973206e6f74206f776e6572206e6f7220617070726f766564a2646970667358221220b0e64d1fa6c4dbeb9c6f54607d7e1996943fe27624a80652f57b53fda084621b64736f6c63430007000033',
  },

  eth_getTransactionCount: {
    default: MOCK_BLOCK_NUMBER,
  },

  eth_createAccessList: {
    default: {
      accessList: [
        {
          address: '0x4fabb145d64652a948d72533023f6e7a623c7c53',
          storageKeys: [
            '0x10d6a54a4754c8869d6886b5f5d7fbfa5b4522237ea5c60d11bc4e7a1ff9390b',
            '0x7050c9e0f4ca769c69bd3a8ef740bc37934f8e2c036e5a723fd8ee048ed3f8c3',
            '0x0000000000000000000000000000000000000000000000000000000000000005',
            '0x65f8466d33444ff2fe5b1a94331f505044aa57575eaaca413289dbdc8e83f9ab',
            '0x71905be97ba55c950fbad68bae631b6ca8325c6e850c070264db76500c7bcb82',
            '0xc10ad393ebf8f525153197a95112800b06397a61c80d05f25d2187b3019cdb37',
          ],
        },
        {
          address: '0x2a3f1a37c04f82aa274f5353834b2d002db91015',
          storageKeys: [],
        },
      ],
      gasUsed: '0xf105',
    },
  },

  trace_call: {
    default: {
      output:
        '0x0000000000000000000000000000000000000000000000000000000000000001',
      stateDiff: {
        '0x5cfe73b6021e818b776b421b1c4db2474086a7e1': {
          balance: {
            '*': {
              from: '0x47c04ab071c39',
              to: '0x11317b7e190ba6502',
            },
          },
          code: '=',
          nonce: {
            '*': {
              from: '0x7d',
              to: '0x7e',
            },
          },
          storage: {},
        },
        '0x4fabb145d64652a948d72533023f6e7a623c7c53': {
          balance: '=',
          code: '=',
          nonce: '=',
          storage: {
            '0xc10ad393ebf8f525153197a95112800b06397a61c80d05f25d2187b3019cdb37':
              {
                '*': {
                  from: '0x0000000000000000000000000000000000000000000000000000000000000000',
                  to: '0x000000000000000000000000000000000000000000000000ffffffffffffffff',
                },
              },
          },
        },
      },
      trace: [],
      vmTrace: null,
    },
  },

  eth_getStorageAt: {
    BUSD_STORAGE_1:
      '0x0000000000000000000000002a3f1a37c04f82aa274f5353834b2d002db91015',
    BUSD_STORAGE_2:
      '0x000000000000000000000000137dcd97872de27a4d3bf36a4643c5e18fa40713',
  },
  net_version: {
    default: '1',
  },
};
