/* eslint-disable @typescript-eslint/no-require-imports, @typescript-eslint/no-var-requires */
import { MockttpServer } from 'mockttp';
import { WINDOW_TITLES } from '../../../helpers';
import { Driver } from '../../../webdriver/driver';
import { scrollAndConfirmAndAssertConfirm } from '../helpers';
import { mocked4BytesApprove } from './erc20-approve-redesign.spec';
import {
  assertChangedSpendingCap,
  editSpendingCap,
} from './increase-token-allowance-redesign.spec';
import { openDAppWithContract, TestSuiteArguments } from './shared';

const {
  defaultGanacheOptions,
  defaultGanacheOptionsForType2Transactions,
  withFixtures,
} = require('../../../helpers');
const FixtureBuilder = require('../../../fixture-builder');
const { SMART_CONTRACTS } = require('../../../seeder/smart-contracts');

describe('Confirmation Redesign ERC20 Revoke Allowance', function () {
  const smartContract = SMART_CONTRACTS.HST;

  describe('Submit an revoke transaction @no-mmi', function () {
    it('Sends a type 0 transaction (Legacy)', async function () {
      await withFixtures(
        {
          dapp: true,
          fixtures: new FixtureBuilder()
            .withPermissionControllerConnectedToTestDapp()
            .withPreferencesController({
              preferences: {
                redesignedConfirmationsEnabled: true,
                isRedesignedConfirmationsDeveloperEnabled: true,
              },
            })
            .build(),
          ganacheOptions: defaultGanacheOptions,
          smartContract,
          testSpecificMock: mocks,
          title: this.test?.fullTitle(),
        },
        async ({ driver, contractRegistry }: TestSuiteArguments) => {
          await openDAppWithContract(driver, contractRegistry, smartContract);

          await createERC20ApproveTransaction(driver);

          const NEW_SPENDING_CAP = '0';
          await editSpendingCap(driver, NEW_SPENDING_CAP);

          await driver.waitForSelector({
            css: 'h2',
            text: 'Remove permission',
          });

          await scrollAndConfirmAndAssertConfirm(driver);

          await assertChangedSpendingCap(driver, NEW_SPENDING_CAP);
        },
      );
    });

    it('Sends a type 2 transaction (EIP1559)', async function () {
      await withFixtures(
        {
          dapp: true,
          fixtures: new FixtureBuilder()
            .withPermissionControllerConnectedToTestDapp()
            .withPreferencesController({
              preferences: {
                redesignedConfirmationsEnabled: true,
                isRedesignedConfirmationsDeveloperEnabled: true,
              },
            })
            .build(),
          ganacheOptions: defaultGanacheOptionsForType2Transactions,
          smartContract,
          testSpecificMock: mocks,
          title: this.test?.fullTitle(),
        },
        async ({ driver, contractRegistry }: TestSuiteArguments) => {
          await openDAppWithContract(driver, contractRegistry, smartContract);

          await createERC20ApproveTransaction(driver);

          const NEW_SPENDING_CAP = '0';
          await editSpendingCap(driver, NEW_SPENDING_CAP);

          await driver.waitForSelector({
            css: 'h2',
            text: 'Remove permission',
          });

          await scrollAndConfirmAndAssertConfirm(driver);

          await assertChangedSpendingCap(driver, NEW_SPENDING_CAP);
        },
      );
    });
  });
});

async function mocks(server: MockttpServer) {
  return [await mocked4BytesApprove(server)];
}

async function createERC20ApproveTransaction(driver: Driver) {
  await driver.switchToWindowWithTitle(WINDOW_TITLES.TestDApp);
  await driver.clickElement('#approveTokens');
}
