// https://etherscan.io/address/0x03eA35db422bb24078416965610242913c13A656

export const verifyingPaymasterAbi = [
  {
    inputs: [
      {
        internalType: 'contract IEntryPoint',
        name: '_entryPoint',
        type: 'address',
      },
      {
        internalType: 'address',
        name: '_verifyingSigner',
        type: 'address',
      },
    ],
    stateMutability: 'nonpayable',
    type: 'constructor',
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        internalType: 'address',
        name: 'previousOwner',
        type: 'address',
      },
      {
        indexed: true,
        internalType: 'address',
        name: 'newOwner',
        type: 'address',
      },
    ],
    name: 'OwnershipTransferred',
    type: 'event',
  },
  {
    inputs: [
      { internalType: 'uint32', name: 'unstakeDelaySec', type: 'uint32' },
    ],
    name: 'addStake',
    outputs: [],
    stateMutability: 'payable',
    type: 'function',
  },
  {
    inputs: [],
    name: 'deposit',
    outputs: [],
    stateMutability: 'payable',
    type: 'function',
  },
  {
    inputs: [],
    name: 'entryPoint',
    outputs: [
      { internalType: 'contract IEntryPoint', name: '', type: 'address' },
    ],
    stateMutability: 'view',
    type: 'function',
  },
  {
    inputs: [],
    name: 'getDeposit',
    outputs: [{ internalType: 'uint256', name: '', type: 'uint256' }],
    stateMutability: 'view',
    type: 'function',
  },
  {
    inputs: [
      {
        components: [
          { internalType: 'address', name: 'sender', type: 'address' },
          { internalType: 'uint256', name: 'nonce', type: 'uint256' },
          { internalType: 'bytes', name: 'initCode', type: 'bytes' },
          { internalType: 'bytes', name: 'callData', type: 'bytes' },
          {
            internalType: 'uint256',
            name: 'callGasLimit',
            type: 'uint256',
          },
          {
            internalType: 'uint256',
            name: 'verificationGasLimit',
            type: 'uint256',
          },
          {
            internalType: 'uint256',
            name: 'preVerificationGas',
            type: 'uint256',
          },
          {
            internalType: 'uint256',
            name: 'maxFeePerGas',
            type: 'uint256',
          },
          {
            internalType: 'uint256',
            name: 'maxPriorityFeePerGas',
            type: 'uint256',
          },
          {
            internalType: 'bytes',
            name: 'paymasterAndData',
            type: 'bytes',
          },
          { internalType: 'bytes', name: 'signature', type: 'bytes' },
        ],
        internalType: 'struct UserOperation',
        name: 'userOp',
        type: 'tuple',
      },
      { internalType: 'uint48', name: 'validUntil', type: 'uint48' },
      { internalType: 'uint48', name: 'validAfter', type: 'uint48' },
    ],
    name: 'getHash',
    outputs: [{ internalType: 'bytes32', name: '', type: 'bytes32' }],
    stateMutability: 'view',
    type: 'function',
  },
  {
    inputs: [],
    name: 'owner',
    outputs: [{ internalType: 'address', name: '', type: 'address' }],
    stateMutability: 'view',
    type: 'function',
  },
  {
    inputs: [
      { internalType: 'bytes', name: 'paymasterAndData', type: 'bytes' },
    ],
    name: 'parsePaymasterAndData',
    outputs: [
      { internalType: 'uint48', name: 'validUntil', type: 'uint48' },
      { internalType: 'uint48', name: 'validAfter', type: 'uint48' },
      { internalType: 'bytes', name: 'signature', type: 'bytes' },
    ],
    stateMutability: 'pure',
    type: 'function',
  },
  {
    inputs: [
      {
        internalType: 'enum IPaymaster.PostOpMode',
        name: 'mode',
        type: 'uint8',
      },
      { internalType: 'bytes', name: 'context', type: 'bytes' },
      { internalType: 'uint256', name: 'actualGasCost', type: 'uint256' },
    ],
    name: 'postOp',
    outputs: [],
    stateMutability: 'nonpayable',
    type: 'function',
  },
  {
    inputs: [],
    name: 'renounceOwnership',
    outputs: [],
    stateMutability: 'nonpayable',
    type: 'function',
  },
  {
    inputs: [{ internalType: 'address', name: '', type: 'address' }],
    name: 'senderNonce',
    outputs: [{ internalType: 'uint256', name: '', type: 'uint256' }],
    stateMutability: 'view',
    type: 'function',
  },
  {
    inputs: [{ internalType: 'address', name: 'newOwner', type: 'address' }],
    name: 'transferOwnership',
    outputs: [],
    stateMutability: 'nonpayable',
    type: 'function',
  },
  {
    inputs: [],
    name: 'unlockStake',
    outputs: [],
    stateMutability: 'nonpayable',
    type: 'function',
  },
  {
    inputs: [
      {
        components: [
          { internalType: 'address', name: 'sender', type: 'address' },
          { internalType: 'uint256', name: 'nonce', type: 'uint256' },
          { internalType: 'bytes', name: 'initCode', type: 'bytes' },
          { internalType: 'bytes', name: 'callData', type: 'bytes' },
          {
            internalType: 'uint256',
            name: 'callGasLimit',
            type: 'uint256',
          },
          {
            internalType: 'uint256',
            name: 'verificationGasLimit',
            type: 'uint256',
          },
          {
            internalType: 'uint256',
            name: 'preVerificationGas',
            type: 'uint256',
          },
          {
            internalType: 'uint256',
            name: 'maxFeePerGas',
            type: 'uint256',
          },
          {
            internalType: 'uint256',
            name: 'maxPriorityFeePerGas',
            type: 'uint256',
          },
          {
            internalType: 'bytes',
            name: 'paymasterAndData',
            type: 'bytes',
          },
          { internalType: 'bytes', name: 'signature', type: 'bytes' },
        ],
        internalType: 'struct UserOperation',
        name: 'userOp',
        type: 'tuple',
      },
      { internalType: 'bytes32', name: 'userOpHash', type: 'bytes32' },
      { internalType: 'uint256', name: 'maxCost', type: 'uint256' },
    ],
    name: 'validatePaymasterUserOp',
    outputs: [
      { internalType: 'bytes', name: 'context', type: 'bytes' },
      { internalType: 'uint256', name: 'validationData', type: 'uint256' },
    ],
    stateMutability: 'nonpayable',
    type: 'function',
  },
  {
    inputs: [],
    name: 'verifyingSigner',
    outputs: [{ internalType: 'address', name: '', type: 'address' }],
    stateMutability: 'view',
    type: 'function',
  },
  {
    inputs: [
      {
        internalType: 'address payable',
        name: 'withdrawAddress',
        type: 'address',
      },
    ],
    name: 'withdrawStake',
    outputs: [],
    stateMutability: 'nonpayable',
    type: 'function',
  },
  {
    inputs: [
      {
        internalType: 'address payable',
        name: 'withdrawAddress',
        type: 'address',
      },
      { internalType: 'uint256', name: 'amount', type: 'uint256' },
    ],
    name: 'withdrawTo',
    outputs: [],
    stateMutability: 'nonpayable',
    type: 'function',
  },
];

export const verifyingPaymasterBytecode =
  '0x60c0604052346200007b576200001f620000186200014f565b9062000176565b6040516114f96200026382396080518181816104ce015281816108f5015281816109d201528181610a4d01528181610adb01528181610b7901528181610bed0152610c8f015260a0518181816101f80152610ff601526114f990f35b600080fd5b634e487b7160e01b600052604160045260246000fd5b90601f01601f191681019081106001600160401b03821117620000b857604052565b62000080565b90620000d5620000cd60405190565b928362000096565b565b6001600160a01b031690565b90565b6001600160a01b0381165b036200007b57565b90505190620000d582620000e6565b6001600160a01b038116620000f1565b90505190620000d58262000108565b91906040838203126200007b57620000e390620001458185620000f9565b9360200162000118565b620001726200175c803803806200016681620000be565b92833981019062000127565b9091565b620001819062000186565b60a052565b6200019062000195565b608052565b620000d53362000200565b620000e390620000d7906001600160a01b031682565b620000e390620001a0565b620000e390620001b6565b90620001e0620000e3620001fc92620001c1565b82546001600160a01b0319166001600160a01b03919091161790565b9055565b6000546001600160a01b0316906200021a816000620001cc565b620002516200024a7f8be0079c531659141344cd1fd0a4f28419497f9722a3daafe3b4186f6b6457e093620001c1565b91620001c1565b916200025c60405190565b600090a356fe6080604052600436101561001257600080fd5b60003560e01c80630396cb6014610102578063205c2878146100fd57806323d9ac9b146100f8578063715018a6146100f35780638da5cb5b146100ee57806394d4ad60146100e957806394e1fc19146100e4578063a9a23409146100df578063b0d691fe146100da578063bb9fe6bf146100d5578063c23a5cea146100d0578063c399ec88146100cb578063d0e30db0146100c6578063f2fde38b146100c15763f465c77e036101165761062f565b610565565b610552565b610537565b61051f565b6104f3565b6104b5565b61045d565b6103d6565b610337565b61024a565b610232565b6101e3565b6101bb565b610141565b63ffffffff81165b0361011657565b600080fd5b9050359061012882610107565b565b906020828203126101165761013e9161011b565b90565b61015461014f36600461012a565b610aa7565b604051005b0390f35b6001600160a01b031690565b6001600160a01b03811661010f565b9050359061012882610169565b8061010f565b9050359061012882610185565b91906040838203126101165761013e906101b28185610178565b9360200161018b565b34610116576101546101ce366004610198565b90610a2f565b600091031261011657565b9052565b34610116576101f33660046101d4565b6101597f00000000000000000000000000000000000000000000000000000000000000005b604051918291826001600160a01b03909116815260200190565b34610116576102423660046101d4565b610154610729565b346101165761025a3660046101d4565b610159610218610671565b909182601f830112156101165781359167ffffffffffffffff831161011657602001926001830284011161011657565b9060208282031261011657813567ffffffffffffffff8111610116576102bb9201610265565b9091565b90826000939282370152565b91906102e9816102e2816102f39560209181520190565b80956102bf565b601f01601f191690565b0190565b61032a61013e959394929461031b6060840196600085019065ffffffffffff169052565b65ffffffffffff166020830152565b60408185039101526102cb565b346101165761015961035361034d366004610295565b9061148b565b9061036094929460405190565b948594856102f7565b90816101609103126101165790565b65ffffffffffff811661010f565b9050359061012882610378565b909160608284031261011657813567ffffffffffffffff8111610116576103bf8461013e928501610369565b936103cd8160208601610386565b93604001610386565b34610116576101596103f26103ec366004610393565b91610dec565b6040519182918290815260200190565b6003111561011657565b9050359061012882610402565b906060828203126101165761042e818361040c565b92602083013567ffffffffffffffff8111610116576104528361013e928601610265565b93909460400161018b565b346101165761046d366004610419565b9291909161086a565b61013e9061015d906001600160a01b031682565b61013e90610476565b61013e9061048a565b6101df90610493565b602081019291610128919061049c565b34610116576104c53660046101d4565b604051806101597f0000000000000000000000000000000000000000000000000000000000000000826104a5565b34610116576105033660046101d4565b610154610bd1565b906020828203126101165761013e91610178565b346101165761015461053236600461050b565b610c33565b34610116576105473660046101d4565b6101596103f2610ad1565b61055d3660046101d4565b6101546108f0565b346101165761015461057836600461050b565b6107c5565b909160608284031261011657813567ffffffffffffffff8111610116576105a98461013e928501610369565b936105b7816020860161018b565b9360400161018b565b60005b8381106105d35750506000910152565b81810151838201526020016105c3565b6106046102e96020936102f3936105f8815190565b80835293849260200190565b958691016105c0565b9291602061062a61012893604087019087820360008901526105e3565b940152565b346101165761064861064236600461057d565b91610857565b9061015961065560405190565b9283928361060d565b61013e9061015d565b61013e905461065e565b61013e6000610667565b1561068257565b60405162461bcd60e51b8152806106cb600482016020808252818101527f4f776e61626c653a2063616c6c6572206973206e6f7420746865206f776e6572604082015260600190565b0390fd5b6106f96106da610671565b6106f36106e63361015d565b916001600160a01b031690565b1461067b565b610128610717565b61015d61013e61013e9290565b61013e90610701565b610128610724600061070e565b6107fe565b6101286106cf565b610128906107406106da610671565b6107a0565b1561074c57565b60405162461bcd60e51b815260206004820152602660248201527f4f776e61626c653a206e6577206f776e657220697320746865207a65726f206160448201526564647265737360d01b6064820152608490fd5b610128906107246107b461015d600061070e565b6001600160a01b0383161415610745565b61012890610731565b906107de61013e6107fa92610493565b82546001600160a01b0319166001600160a01b03919091161790565b9055565b6108086000610667565b906108148160006107ce565b6108476108417f8be0079c531659141344cd1fd0a4f28419497f9722a3daafe3b4186f6b6457e093610493565b91610493565b9161085160405190565b600090a3565b6102bb929190610865610c80565b610f93565b610872610c80565b60405162461bcd60e51b815260206004820152600d60248201526c6d757374206f7665727269646560981b6044820152606490fd5b634e487b7160e01b600052604160045260246000fd5b90601f01601f1916810190811067ffffffffffffffff8211176108df57604052565b6108a7565b6040513d6000823e3d90fd5b6109197f0000000000000000000000000000000000000000000000000000000000000000610493565b63b760faf990349061092a30610493565b90803b15610116576109526000936109699561094560405190565b9687958694859360e01b90565b83526001600160a01b031660048301526024820190565b03925af180156109925761097a5750565b61012890600061098a81836108bd565b8101906101d4565b6108e4565b90610128916109a76106da610671565b6109cd565b6001600160a01b0390911681526040810192916101289160200152565b0152565b6109f67f0000000000000000000000000000000000000000000000000000000000000000610493565b9063205c287891803b1561011657610a2460008094610969610a1760405190565b9788968795869460e01b90565b8452600484016109ac565b9061012891610997565b61012890610a486106da610671565b610a717f0000000000000000000000000000000000000000000000000000000000000000610493565b630396cb60913491803b1561011657610a936000936109699561094560405190565b835263ffffffff1660048301526024820190565b61012890610a39565b9050519061012882610185565b906020828203126101165761013e91610ab0565b610b286020610aff7f0000000000000000000000000000000000000000000000000000000000000000610493565b6370a0823190610952610b1130610493565b92610b1b60405190565b9586948593849360e01b90565b03915afa90811561099257600091610b3e575090565b61013e915060203d8111610b5f575b610b5781836108bd565b810190610abd565b503d610b4d565b610b716106da610671565b610128610b9d7f0000000000000000000000000000000000000000000000000000000000000000610493565b63bb9fe6bf90803b1561011657610bc391600091610bba60405190565b93849260e01b90565b825281838160048101610969565b610128610b66565b61012890610be86106da610671565b610c117f0000000000000000000000000000000000000000000000000000000000000000610493565b9063c23a5cea90823b1561011657610969926109526000809461094560405190565b61012890610bd9565b15610c4357565b60405162461bcd60e51b815260206004820152601560248201527414d95b99195c881b9bdd08115b9d1c9e541bda5b9d605a1b6044820152606490fd5b61012833610cb36106e661015d7f0000000000000000000000000000000000000000000000000000000000000000610493565b14610c3c565b3561013e81610185565b903590601e193682900301821215610116570180359067ffffffffffffffff8211610116576020019136829003831361011657565b90610128610d0560405190565b92836108bd565b67ffffffffffffffff81116108df57602090601f01601f19160190565b90929192610d3e610d3982610d0c565b610cf8565b9381855260208501908284011161011657610128926102bf565b61013e913691610d29565b9a98969492909d9c9b99979593916101a08c019e60008d01610d8c916001600160a01b03169052565b60208c015260408b015260608a0152608089015260a088015260c087015260e08601526101008501526101208401526001600160a01b031661014083015265ffffffffffff16610160820152610180016101289165ffffffffffff169052565b91610df683610ec7565b610e0260208501610cb9565b91610e106040860186610cc3565b610e1991610d58565b8051906020012093610e2e6060870187610cc3565b610e3791610d58565b8051906020012095610e4b60808201610cb9565b90610e5860a08201610cb9565b90610e6560c08201610cb9565b90610e7260e08201610cb9565b9061010001610e8090610cb9565b91469330610e8d90610493565b95610e9760405190565b9c8d9c60208e019c610ea99c8e610d63565b908103825203610eb990826108bd565b8051906020012090565b2090565b610edd61013e91610ed6600090565b503561048a565b61048a565b61013e61013e61013e9290565b602080825261013e91016040808252906020017f566572696679696e675061796d61737465723a20696e76616c6964207369676e81527f6174757265206c656e67746820696e207061796d6173746572416e644461746160208201520190565b15610f5657565b60405162461bcd60e51b8152806106cb60048201610eef565b90610f7c610d3983610d0c565b918252565b61013e6000610f6f565b61013e610f81565b610ff39250610fee91506110216106e661015d61101b610fba61034d610120870187610cc3565b939299918a8299610fe9610fcf88859e965090565b610fd96040610ee2565b8114908115611049575b50610f4f565b610dec565b61135d565b917f000000000000000000000000000000000000000000000000000000000000000096610d58565b9061105f565b0361103e576110319160006113d5565b9061103a610f8b565b9190565b6110319160016113d5565b905061105861103a6041610ee2565b1438610fe3565b815161106e61103a6041610ee2565b036110915761013e91906020820151906060604084015193015160001a90611262565b8151916040926110a361103a85610ee2565b036110ba5761013e926020820151910151916110ff565b60405162461bcd60e51b815260206004820152601f60248201527f45434453413a20696e76616c6964207369676e6174757265206c656e677468006044820152606490fd5b61013e9291906001600160ff1b0383169260ff1c601b0190611262565b61013e90610ee2565b1561112c57565b60405162461bcd60e51b815260206004820152602260248201527f45434453413a20696e76616c6964207369676e6174757265202773272076616c604482015261756560f01b6064820152608490fd5b61118961013e61013e9290565b60ff1690565b1561119657565b60405162461bcd60e51b815260206004820152602260248201527f45434453413a20696e76616c6964207369676e6174757265202776272076616c604482015261756560f01b6064820152608490fd5b6109c96101289461120f606094989795611205608086019a6000870152565b60ff166020850152565b6040830152565b1561121d57565b60405162461bcd60e51b815260206004820152601860248201527f45434453413a20696e76616c6964207369676e617475726500000000000000006044820152606490fd5b6112de602094600094611273600090565b506112b36112808361111c565b6112ac61103a7f7fffffffffffffffffffffffffffffff5d576e7357a4501ddfe92f46681b20a0610ee2565b1115611125565b6112bd601b61117c565b60ff8616148015611310575b6112d29061118f565b604051948594856111e6565b838052039060015afa156109925760005161013e6112ff61015d600061070e565b6001600160a01b0383161415611216565b506112d261131e601c61117c565b60ff87161490506112c9565b906102f3610f7c6020937f19457468657265756d205369676e6564204d6573736167653a0a3332000000008152601c0190565b61138561136960405190565b809261137960208301918261132a565b908103825203826108bd565b610ec3611390825190565b9160200190565b61013e61013e61013e9265ffffffffffff1690565b61013e906113c061103a61013e9460ff1690565b901b90565b61013e61013e61013e9260ff1690565b6114269161141c916000901561142a575061141561140f6113ff6113f9600161117c565b93611397565b61140960a061117c565b906113ac565b916113c5565b1792611397565b61140960d061117c565b1790565b61140f6113ff6113f96114159361117c565b61013e6014610ee2565b61013e6054610ee2565b90939293848311610116578411610116578101920390565b91906040838203126101165761013e906114828185610386565b93602001610386565b916102bb808361149961143c565b6114bb6114b36102bb6114aa611446565b8094868c611450565b810190611468565b96909761145056fea26469706673582212208899fb33dd8c69445c982f410a39c7677f7257ec7ab219d04e93a9f633a42ddb64736f6c63430008140033';
