// https://etherscan.io/address/0xE8Df82fA4E10e6A12a9Dab552bceA2acd26De9bb

export const simpleAccountFactoryAbi = [
  {
    inputs: [
      {
        internalType: 'contract IEntryPoint',
        name: '_entryPoint',
        type: 'address',
      },
    ],
    stateMutability: 'nonpayable',
    type: 'constructor',
  },
  {
    inputs: [],
    name: 'accountImplementation',
    outputs: [
      {
        internalType: 'contract SimpleAccount',
        name: '',
        type: 'address',
      },
    ],
    stateMutability: 'view',
    type: 'function',
  },
  {
    inputs: [
      {
        internalType: 'address',
        name: 'owner',
        type: 'address',
      },
      {
        internalType: 'uint256',
        name: 'salt',
        type: 'uint256',
      },
    ],
    name: 'createAccount',
    outputs: [
      {
        internalType: 'contract SimpleAccount',
        name: 'ret',
        type: 'address',
      },
    ],
    stateMutability: 'nonpayable',
    type: 'function',
  },
  {
    inputs: [
      {
        internalType: 'address',
        name: 'owner',
        type: 'address',
      },
      {
        internalType: 'uint256',
        name: 'salt',
        type: 'uint256',
      },
    ],
    name: 'getAccountAddress',
    outputs: [
      {
        internalType: 'address',
        name: '',
        type: 'address',
      },
    ],
    stateMutability: 'view',
    type: 'function',
  },
];

export const simpleAccountFactoryBytecode =
  '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';
