// Generated by dts-bundle-generator v9.0.0

import { List, Map } from 'immutable';
import { Stream as $$stream } from 'most';
import { Group } from 'three';

export type nullable<Value extends any> = Value | null | undefined;
export type strictNullable<Value extends any> = Value | null;
export type contributeType = any;
export type extensionName = string;
export type extensionProtocolName = string;
export type contributeProtocolName = string;
export type packageProtocolName = string;
// export abstract class state { protected opaque: any } /* simulate opaque types */
export type state = any;
// tslint:disable-next-line:interface-over-type-literal
export type nullableAPI = {
	getExn: <data>(data: nullable<data>) => data;
	isNullable: <data>(data: nullable<data>) => boolean;
	return: <data>(data: data) => nullable<data>;
	getWithDefault: <data>(data: nullable<data>, defaultValue: data) => data;
	map: <data1, data2>(func: (data: data1) => data2, data: nullable<data1>) => nullable<data2>;
	bind: <data1, data2>(func: (data: data1) => nullable<data2>, data: nullable<data1>) => nullable<data2>;
	getEmpty: <data>() => nullable<data>;
};
export type onUploadProgressFunc = (progress: number) => void;
export type appName = string;
export type account = string;
export type description = string;
export type previewBase64 = string;
export type isRecommend = boolean;
export type publishFinalApp = (onUploadProgressFunc: onUploadProgressFunc, sceneGLB: ArrayBuffer, 
// singleEventBinaryFile: ArrayBuffer,
appName: appName, account: account, description: description, previewBase64: strictNullable<previewBase64>, isRecommend: isRecommend) => Promise<void>;
export type backendAPI = {
	init: (env: string) => Promise<void>;
	publishFinalApp: publishFinalApp;
};
export type messageAPI = {
	success: (message: string) => void;
	warn: (message: string) => void;
	error: (message: string) => void;
};
// tslint:disable-next-line:interface-over-type-literal
export type immutableAPI = {
	createList: <T>() => List<T>;
	createListOfData: <T>(data: Array<T>) => List<T>;
	createMap: <K, V>() => Map<K, V>;
	createMapOfData: <K extends string, V>(data: Record<K, V>) => Map<K, V>;
};
// tslint:disable-next-line:interface-over-type-literal
export type actionAPI = {
	getActionState: <actionState>(state: state, actionName: string) => nullable<actionState>;
	setActionState: <actionState>(state: state, actionName: string, actionState: actionState) => state;
};
// tslint:disable-next-line:interface-over-type-literal
export type uiControlAPI = {
	getUIControlState: <uiControlState>(state: state, uiControlName: string) => uiControlState;
	setUIControlState: <uiControlState>(state: state, uiControlName: string, uiControlState: uiControlState) => state;
};
// tslint:disable-next-line:interface-over-type-literal
export type api = {
	registerExtension<getExtensionServiceFunc, getLifeFunc, extensionState>(state: state, extensionProtocolName: extensionProtocolName, getExtensionServiceFunc: getExtensionServiceFunc, getLifeFunc: getLifeFunc, extensionState: extensionState): state;
	getExtensionService<extensionService>(state: state, extensionProtocolName: extensionProtocolName): extensionService;
	getExtensionState<extensionState>(state: state, extensionProtocolName: extensionProtocolName): extensionState;
	setExtensionState<extensionState>(state: state, extensionProtocolName: extensionProtocolName, extensionState: extensionState): state;
	getPackageService<packageService>(state: state, packageProtocolName: packageProtocolName): nullable<packageService>;
	registerContribute<getContributeFunc>(state: state, contributeProtocolName: contributeProtocolName, getContributeFunc: getContributeFunc): state;
	getContribute<contribute>(state: state, contributeProtocolName: contributeProtocolName): contribute;
	getAllContributesByType<contribute>(state: state, contributeType: contributeType): Array<contribute>;
	getPackage(state: state, packageProtocolName: packageProtocolName): nullable<ArrayBuffer>;
	restore(currentState: state, targetState: state): state;
	deepCopy(state: state): state;
	nullable: nullableAPI;
	immutable: immutableAPI;
	action: actionAPI;
	uiControl: uiControlAPI;
	backend: backendAPI;
	message: messageAPI;
};
export type canvasData = {
	width: number;
	height: number;
};
// export type Merge<A, B> = { [K in keyof (A | B)]: K extends keyof B ? B[K] : A[K] };
export type Merge<A, B> = A & {
	[K in Exclude<keyof B, keyof A>]: B[K];
};
export type uid = number;
export type gameObject = uid;
export type name = string;
export type config = {
	isDebug: boolean;
};
export type cloneConfig = {
	isShareMaterial: boolean;
};
export type directionLight = number;
export type color = [
	number,
	number,
	number
];
export type intensity = number;
export type geometry = number;
export type geometry$1 = geometry;
export type transform = number;
export type localToWorldMatrix = Float32Array;
export type transform$1 = transform;
export type parent = transform$1;
export type children = Array<transform$1>;
export type localPosition = [
	number,
	number,
	number
];
// export type position = [number, number, number];
export type localRotation = [
	number,
	number,
	number,
	number
];
// export type rotation = [number, number, number, number];
export type localScale = [
	number,
	number,
	number
];
// export type scale = [number, number, number];
export type localEulerAngles = [
	number,
	number,
	number
];
export type pbrMaterial = number;
export type pbrMaterial$1 = pbrMaterial;
export type diffuseColor = [
	number,
	number,
	number
];
export type specularColor = diffuseColor;
export type specular = number;
export type basicCameraView = number;
export type perspectiveCameraProjection = number;
export type pMatrix = Float32Array;
export type fovy = number;
export type aspect = number;
export type near = number;
export type far = number;
export type attributeValue = any;
export type assetData = {
	name: string;
	eventFileStr: string;
};
export type allAssetData = Array<assetData>;
export type script = number;
export type gameObject$1 = gameObject;
// tslint:disable-next-line:interface-over-type-literal
export type createStateFunc<state> = () => state;
// tslint:disable-next-line:interface-over-type-literal
export type createGameObjectFunc<state> = (_1: state) => [
	state,
	gameObject$1
];
// tslint:disable-next-line:interface-over-type-literal
export type getAllGameObjectsFunc<state> = (_1: state) => gameObject$1[];
export type clonedGameObjects = Array<Array<gameObject$1>>;
export type restore<state> = (_1: state, _2: state) => state;
export type deepCopy<state> = (_1: state) => state;
// export type cloneGameObjectFunc<state> = (_1: state) => gameObject[];
// tslint:disable-next-line:interface-over-type-literal
export type gameObjectContribute<state> = {
	readonly createStateFunc: createStateFunc<state>;
	readonly createGameObjectFunc: createGameObjectFunc<state>;
	readonly getAllGameObjectsFunc: getAllGameObjectsFunc<state>;
	readonly restore: restore<state>;
	readonly deepCopy: deepCopy<state>;
};
export type arcballCameraController = number;
export type distance = number;
export type wheelSpeed = number;
export type phi = number;
export type theta = number;
export type target = [
	number,
	number,
	number
];
export type createGameObject = (meta3dState: state) => [
	state,
	gameObject
];
// export type createUnUseGameObject = (meta3dState: meta3dState) => [meta3dState, gameObject]
export type getAllGameObjects = (meta3dState: state) => Array<gameObject>;
export type getTransform = (meta3dState: state, gameObject: gameObject) => transform$1;
export type addTransform = (meta3dState: state, gameObject: gameObject, transform: transform$1) => state;
export type hasTransform = (meta3dState: state, gameObject: gameObject) => boolean;
export type getDirectionLight = (meta3dState: state, gameObject: gameObject) => directionLight;
export type addDirectionLight = (meta3dState: state, gameObject: gameObject, directionLight: directionLight) => state;
export type hasDirectionLight = (meta3dState: state, gameObject: gameObject) => boolean;
export type getGeometry = (meta3dState: state, gameObject: gameObject) => geometry$1;
export type addGeometry = (meta3dState: state, gameObject: gameObject, geometry: geometry$1) => state;
export type hasGeometry = (meta3dState: state, gameObject: gameObject) => boolean;
export type getPBRMaterial = (meta3dState: state, gameObject: gameObject) => pbrMaterial$1;
export type addPBRMaterial = (meta3dState: state, gameObject: gameObject, pbrMaterial: pbrMaterial$1) => state;
export type hasPBRMaterial = (meta3dState: state, gameObject: gameObject) => boolean;
export type getBasicCameraView = (meta3dState: state, gameObject: gameObject) => basicCameraView;
export type addBasicCameraView = (meta3dState: state, gameObject: gameObject, basicCameraView: basicCameraView) => state;
export type hasBasicCameraView = (meta3dState: state, gameObject: gameObject) => boolean;
export type getPerspectiveCameraProjection = (meta3dState: state, gameObject: gameObject) => perspectiveCameraProjection;
export type addPerspectiveCameraProjection = (meta3dState: state, gameObject: gameObject, perspectiveCameraProjection: perspectiveCameraProjection) => state;
export type hasPerspectiveCameraProjection = (meta3dState: state, gameObject: gameObject) => boolean;
export type getScript = (meta3dState: state, gameObject: gameObject) => script;
export type addScript = (meta3dState: state, gameObject: gameObject, script: script) => state;
export type hasScript = (meta3dState: state, gameObject: gameObject) => boolean;
export type getArcballCameraController = (meta3dState: state, gameObject: gameObject) => arcballCameraController;
export type addArcballCameraController = (meta3dState: state, gameObject: gameObject, arcballCameraController: arcballCameraController) => state;
export type hasArcballCameraController = (meta3dState: state, gameObject: gameObject) => boolean;
// export type getArcballCameraController = (meta3dState: meta3dState, { unsafeGetUsedComponentContribute, getComponent }: engineCoreService, gameObject => gameObject) 
// export type addArcballCameraController = (meta3dState: meta3dState, { unsafeGetUsedComponentContribute, setUsedComponentContribute, addComponent }: engineCoreService, gameObject: gameObject, arcballCameraController => arcballCameraController) 
// export type hasArcballCameraController = (meta3dState: meta3dState, { unsafeGetUsedComponentContribute, hasComponent }: engineCoreService, gameObject => gameObject) 
export type cloneGameObject = (meta3dState: state, count: number, cloneConfig: cloneConfig, sourceGameObject: gameObject) => [
	state,
	clonedGameObjects
];
export type getNeedDisposedGameObjects = (meta3dState: state) => gameObject[];
export type disposeGameObjects = (meta3dState: state, gameObjects: gameObject[]) => state;
export type disposeGameObjectTransformComponent = (meta3dState: state, gameObject: gameObject, component: transform$1) => state;
export type disposeGameObjectDirectionLightComponent = (meta3dState: state, gameObject: gameObject, component: directionLight) => state;
export type disposeGameObjectPBRMaterialComponent = (meta3dState: state, gameObject: gameObject, component: pbrMaterial$1) => state;
export type disposeGameObjectGeometryComponent = (meta3dState: state, gameObject: gameObject, component: geometry$1) => state;
export type disposeGameObjectBasicCameraViewComponent = (meta3dState: state, gameObject: gameObject, component: basicCameraView) => state;
export type disposeGameObjectPerspectiveCameraProjectionComponent = (meta3dState: state, gameObject: gameObject, component: perspectiveCameraProjection) => state;
export type disposeGameObjectScriptComponent = (meta3dState: state, gameObject: gameObject, component: script) => state;
export type disposeGameObjectArcballCameraControllerComponent = (meta3dState: state, gameObject: gameObject, component: arcballCameraController) => state;
export type getGameObjectName = (meta3dState: state, gameObject: gameObject) => nullable<name>;
export type setGameObjectName = (meta3dState: state, gameObject: gameObject, name: name) => state;
export type getGameObjectAndAllChildren = (meta3dState: state, gameObject: gameObject) => Array<gameObject>;
export type removeGameObjects = (meta3dState: state, gameObjects: Array<gameObject>) => state;
export type removeGameObjectData = {
	gameObject: gameObject;
	name: nullable<name>;
	localScale: localScale;
	localPosition: localPosition;
};
export type restoreRemovedGameObjects = (meta3dState: state, data: Array<removeGameObjectData>) => state;
export type createTransform = (meta3dState: state) => [
	state,
	transform$1
];
export type getGameObjects = (meta3dState: state, transform: transform$1) => Array<gameObject>;
export type getName = (meta3dState: state, transform: transform$1) => nullable<string>;
export type setName = (meta3dState: state, transform: transform$1, name: string) => state;
export type getParent = (meta3dState: state, transform: transform$1) => nullable<parent>;
export type setParent = (meta3dState: state, transform: transform$1, parent: nullable<parent>) => state;
export type getChildren = (meta3dState: state, transform: transform$1) => nullable<children>;
export type getLocalPosition = (meta3dState: state, transform: transform$1) => localPosition;
export type setLocalPosition = (meta3dState: state, transform: transform$1, localPosition: localPosition) => state;
export type getLocalRotation = (meta3dState: state, transform: transform$1) => localRotation;
export type setLocalRotation = (meta3dState: state, transform: transform$1, localRotation: localRotation) => state;
export type getLocalEulerAngles = (meta3dState: state, transform: transform$1) => localEulerAngles;
export type setLocalEulerAngles = (meta3dState: state, transform: transform$1, localEulerAngles: localEulerAngles) => state;
export type getLocalScale = (meta3dState: state, transform: transform$1) => localScale;
export type setLocalScale = (meta3dState: state, transform: transform$1, localScale: localScale) => state;
export type getLocalToWorldMatrix = (meta3dState: state, transform: transform$1) => localToWorldMatrix;
export type lookAt = (meta3dState: state, transform: transform$1, target: [
	number,
	number,
	number
]) => state;
export type createPerspectiveCameraProjection = (meta3dState: state) => [
	state,
	perspectiveCameraProjection
];
export type getName$1 = (meta3dState: state, perspectiveCameraProjection: perspectiveCameraProjection) => nullable<string>;
export type setName$1 = (meta3dState: state, perspectiveCameraProjection: perspectiveCameraProjection, name: string) => state;
export type getPMatrix = (meta3dState: state, perspectiveCameraProjection: perspectiveCameraProjection) => nullable<pMatrix>;
export type getFovy = (meta3dState: state, perspectiveCameraProjection: perspectiveCameraProjection) => nullable<fovy>;
export type setFovy = (meta3dState: state, perspectiveCameraProjection: perspectiveCameraProjection, fovy: number) => state;
export type getNear = (meta3dState: state, perspectiveCameraProjection: perspectiveCameraProjection) => nullable<near>;
export type setNear = (meta3dState: state, perspectiveCameraProjection: perspectiveCameraProjection, near: number) => state;
export type getFar = (meta3dState: state, perspectiveCameraProjection: perspectiveCameraProjection) => nullable<far>;
export type setFar = (meta3dState: state, perspectiveCameraProjection: perspectiveCameraProjection, far: number) => state;
export type getAspect = (meta3dState: state, perspectiveCameraProjection: perspectiveCameraProjection) => nullable<aspect>;
export type setAspect = (meta3dState: state, perspectiveCameraProjection: perspectiveCameraProjection, aspect: number) => state;
export type htmlImageElement = TexImageSource;
export type material = number;
// tslint:disable-next-line:interface-over-type-literal
export type uid$1 = number;
// tslint:disable-next-line:interface-over-type-literal
export type texture = uid$1;
declare enum filter {
	Nearest,
	Linear,
	Nearest_mipmap_nearest,
	Linear_mipmap_nearest,
	Nearest_mipmap_linear,
	Linear_mipmap_linear
}
declare enum wrap {
	Clamp_to_edge,
	Mirrored_repeat,
	Repeat
}
declare enum format {
	AlphaFormat = 1021,
	LuminanceFormat = 1024,
	LuminanceAlphaFormat = 1025,
	DepthFormat = 1026,
	DepthStencilFormat = 1027,
	RedFormat = 1028,
	RedIntegerFormat = 1029,
	RGFormat = 1030,
	SRGBAFormat = 1035
}
declare enum textureDataType {
	UnsignedByteType = 1009,
	ByteType = 1010,
	ShortType = 1011,
	UnsignedShortType = 1012,
	IntType = 1013,
	UnsignedIntType = 1014,
	FloatType = 1015,
	HalfFloatType = 1016,
	UnsignedShort4444Type = 1017,
	UnsignedShort5551Type = 1018,
	UnsignedInt248Type = 1020
}
export type createPBRMaterial = (meta3dState: state) => [
	state,
	pbrMaterial$1
];
export type getName$2 = (meta3dState: state, pbrMaterial: pbrMaterial$1) => nullable<string>;
export type setName$2 = (meta3dState: state, pbrMaterial: pbrMaterial$1, name: string) => state;
export type getDiffuseColor = (meta3dState: state, pbrMaterial: pbrMaterial$1) => nullable<diffuseColor>;
export type setDiffuseColor = (meta3dState: state, pbrMaterial: pbrMaterial$1, diffuseColor: diffuseColor) => state;
export type getSpecular = (meta3dState: state, pbrMaterial: pbrMaterial$1) => nullable<specular>;
export type setSpecular = (meta3dState: state, pbrMaterial: pbrMaterial$1, specular: specular) => state;
export type getSpecularColor = (meta3dState: state, pbrMaterial: pbrMaterial$1) => nullable<specularColor>;
export type setSpecularColor = (meta3dState: state, pbrMaterial: pbrMaterial$1, specularColor: specularColor) => state;
export type getRoughness = (meta3dState: state, pbrMaterial: pbrMaterial$1) => nullable<number>;
export type setRoughness = (meta3dState: state, pbrMaterial: pbrMaterial$1, roughness: number) => state;
export type getMetalness = (meta3dState: state, pbrMaterial: pbrMaterial$1) => nullable<number>;
export type setMetalness = (meta3dState: state, pbrMaterial: pbrMaterial$1, metalness: number) => state;
export type getTransmission = (meta3dState: state, pbrMaterial: pbrMaterial$1) => nullable<number>;
export type setTransmission = (meta3dState: state, pbrMaterial: pbrMaterial$1, transmission: number) => state;
export type getIOR = (meta3dState: state, pbrMaterial: pbrMaterial$1) => nullable<number>;
export type setIOR = (meta3dState: state, pbrMaterial: pbrMaterial$1, ior: number) => state;
export type getDiffuseMap = (meta3dState: state, pbrMaterial: pbrMaterial$1) => nullable<texture>;
export type setDiffuseMap = (meta3dState: state, pbrMaterial: pbrMaterial$1, texture: texture) => state;
export type getRoughnessMap = (meta3dState: state, pbrMaterial: pbrMaterial$1) => nullable<texture>;
export type setRoughnessMap = (meta3dState: state, pbrMaterial: pbrMaterial$1, texture: texture) => state;
export type getMetalnessMap = (meta3dState: state, pbrMaterial: pbrMaterial$1) => nullable<texture>;
export type setMetalnessMap = (meta3dState: state, pbrMaterial: pbrMaterial$1, texture: texture) => state;
export type getNormalMap = (meta3dState: state, pbrMaterial: pbrMaterial$1) => nullable<texture>;
export type setNormalMap = (meta3dState: state, pbrMaterial: pbrMaterial$1, texture: texture) => state;
// export type getAllPBRMaterials = (meta3dState: meta3dState) => pbrMaterial[]
export type getGameObjects$1 = (meta3dState: state, pbrMaterial: pbrMaterial$1) => Array<gameObject>;
export type createTexture = (meta3dState: state) => [
	state,
	texture
];
export type disposeTexture = (meta3dState: state, texture: texture, material: material) => state;
export type addMaterial = (meta3dState: state, texture: texture, material: material) => state;
export type getName$3 = (meta3dState: state, texture: texture) => nullable<string>;
export type setName$3 = (meta3dState: state, texture: texture, name: string) => state;
export type getWrapS = (meta3dState: state, _2: texture) => wrap;
export type setWrapS = (meta3dState: state, _2: texture, _3: wrap) => state;
export type getWrapT = (meta3dState: state, _2: texture) => wrap;
export type setWrapT = (meta3dState: state, _2: texture, _3: wrap) => state;
export type getMagFilter = (meta3dState: state, _2: texture) => filter;
export type setMagFilter = (meta3dState: state, _2: texture, _3: filter) => state;
export type getMinFilter = (meta3dState: state, _2: texture) => filter;
export type setMinFilter = (meta3dState: state, _2: texture, _3: filter) => state;
export type getFormat = (meta3dState: state, _2: texture) => format;
export type setFormat = (meta3dState: state, _2: texture, _3: format) => state;
export type getType = (meta3dState: state, _2: texture) => textureDataType;
export type setType = (meta3dState: state, _2: texture, _3: textureDataType) => state;
export type getIsNeedUpdate = (meta3dState: state, _2: texture) => boolean;
export type setIsNeedUpdate = (meta3dState: state, _2: texture, _3: boolean) => state;
export type getFlipY = (meta3dState: state, _2: texture) => boolean;
export type setFlipY = (meta3dState: state, _2: texture, _3: boolean) => state;
export type getImage = (meta3dState: state, _2: texture) => htmlImageElement;
export type setImage = (meta3dState: state, _2: texture, _3: htmlImageElement) => state;
export type createGeometry = (meta3dState: state) => [
	state,
	geometry$1
];
export type getName$4 = (meta3dState: state, geometry: geometry$1) => nullable<string>;
export type setName$4 = (meta3dState: state, geometry: geometry$1, name: string) => state;
export type getVertices = (meta3dState: state, geometry: geometry$1) => nullable<Float32Array>;
export type setVertices = (meta3dState: state, geometry: geometry$1, vertices: Float32Array) => state;
export type getNormals = (meta3dState: state, geometry: geometry$1) => nullable<Float32Array>;
export type setNormals = (meta3dState: state, geometry: geometry$1, normals: Float32Array) => state;
export type getTexCoords = (meta3dState: state, geometry: geometry$1) => nullable<Float32Array>;
export type setTexCoords = (meta3dState: state, geometry: geometry$1, texCoords: Float32Array) => state;
export type getTangents = (meta3dState: state, geometry: geometry$1) => nullable<Float32Array>;
export type setTangents = (meta3dState: state, geometry: geometry$1, tangents: Float32Array) => state;
export type getIndices = (meta3dState: state, geometry: geometry$1) => nullable<Uint32Array>;
export type setIndices = (meta3dState: state, geometry: geometry$1, indices: Uint32Array) => state;
export type getGameObjects$2 = (meta3dState: state, geometry: geometry$1) => Array<gameObject>;
export type createBasicCameraView = (meta3dState: state) => [
	state,
	basicCameraView
];
export type getGameObjects$3 = (meta3dState: state, basicCameraView: basicCameraView) => Array<gameObject>;
export type active = (meta3dState: state, basicCameraView: basicCameraView) => state;
export type notActive = (meta3dState: state, basicCameraView: basicCameraView) => state;
export type getViewWorldToCameraMatrix = (meta3dState: state, basicCameraView: basicCameraView) => nullable<Float32Array>;
export type getActiveCameraView = (meta3dState: state, isDebug: boolean) => nullable<basicCameraView>;
export type getName$5 = (meta3dState: state, basicCameraView: basicCameraView) => nullable<string>;
export type setName$5 = (meta3dState: state, basicCameraView: basicCameraView, name: string) => state;
export type createArcballCameraController = (meta3dState: state) => [
	state,
	arcballCameraController
];
export type getGameObjects$4 = (meta3dState: state, arcballCameraController: arcballCameraController) => Array<gameObject>;
export type getName$6 = (meta3dState: state, arcballCameraController: arcballCameraController) => nullable<string>;
export type setName$6 = (meta3dState: state, arcballCameraController: arcballCameraController, name: string) => state;
export type getDistance = (meta3dState: state, arcballCameraController: arcballCameraController) => nullable<distance>;
export type setDistance = (meta3dState: state, arcballCameraController: arcballCameraController, distance: distance) => state;
export type getWheelSpeed = (meta3dState: state, arcballCameraController: arcballCameraController) => nullable<wheelSpeed>;
export type setWheelSpeed = (meta3dState: state, arcballCameraController: arcballCameraController, wheelSpeed: wheelSpeed) => state;
export type getPhi = (meta3dState: state, arcballCameraController: arcballCameraController) => nullable<phi>;
export type setPhi = (meta3dState: state, arcballCameraController: arcballCameraController, phi: phi) => state;
export type getTheta = (meta3dState: state, arcballCameraController: arcballCameraController) => nullable<theta>;
export type setTheta = (meta3dState: state, arcballCameraController: arcballCameraController, theta: theta) => state;
export type getTarget = (meta3dState: state, arcballCameraController: arcballCameraController) => nullable<target>;
export type setTarget = (meta3dState: state, arcballCameraController: arcballCameraController, target: target) => state;
export type createDirectionLight = (meta3dState: state) => [
	state,
	directionLight
];
export type getName$7 = (meta3dState: state, directionLight: directionLight) => nullable<string>;
export type setName$7 = (meta3dState: state, directionLight: directionLight, name: string) => state;
export type getColor = (meta3dState: state, directionLight: directionLight) => nullable<color>;
export type setColor = (meta3dState: state, directionLight: directionLight, color: color) => state;
export type getIntensity = (meta3dState: state, directionLight: directionLight) => nullable<intensity>;
export type setIntensity = (meta3dState: state, directionLight: directionLight, intensity: intensity) => state;
export type getDirection = (meta3dState: state, directionLight: directionLight) => nullable<[
	number,
	number,
	number
]>;
export type setDirection = (meta3dState: state, directionLight: directionLight, direction: [
	number,
	number,
	number
]) => state;
// export type getAllDirectionLights = (meta3dState: meta3dState) => directionLight[]
export type getGameObjects$5 = (meta3dState: state, directionLight: directionLight) => Array<gameObject>;
export type createScript = (meta3dState: state) => [
	state,
	script
];
export type getName$8 = (meta3dState: state, script: script) => nullable<string>;
export type setName$8 = (meta3dState: state, script: script, name: string) => state;
export type getAllAssetData = (meta3dState: state, script: script) => nullable<allAssetData>;
export type setAllAssetData = (meta3dState: state, script: script, allAssetData: allAssetData) => state;
export type getAttribute = (meta3dState: state, script: script) => nullable<attributeValue>;
export type setAttribute = (meta3dState: state, script: script, attribute: number) => state;
export type ecsConfig = {
	float9Array1: Float32Array;
	float32Array1: Float32Array;
	transformCount: number;
	geometryCount: number;
	geometryPointCount: number;
	pbrMaterialCount: number;
};
export type scene = {
	gameObject: {
		addBasicCameraView: addBasicCameraView;
		addDirectionLight: addDirectionLight;
		addGeometry: addGeometry;
		addPBRMaterial: addPBRMaterial;
		addPerspectiveCameraProjection: addPerspectiveCameraProjection;
		addScript: addScript;
		addTransform: addTransform;
		addArcballCameraController: addArcballCameraController;
		cloneGameObject: cloneGameObject;
		createGameObject: createGameObject;
		// createUnUseGameObject: createUnUseGameObject,
		disposeGameObjectArcballCameraControllerComponent: disposeGameObjectArcballCameraControllerComponent;
		disposeGameObjectBasicCameraViewComponent: disposeGameObjectBasicCameraViewComponent;
		disposeGameObjectDirectionLightComponent: disposeGameObjectDirectionLightComponent;
		disposeGameObjectGeometryComponent: disposeGameObjectGeometryComponent;
		disposeGameObjectPBRMaterialComponent: disposeGameObjectPBRMaterialComponent;
		disposeGameObjectPerspectiveCameraProjectionComponent: disposeGameObjectPerspectiveCameraProjectionComponent;
		disposeGameObjectScriptComponent: disposeGameObjectScriptComponent;
		disposeGameObjects: disposeGameObjects;
		disposeGameObjectTransformComponent: disposeGameObjectTransformComponent;
		getAllGameObjects: getAllGameObjects;
		getArcballCameraController: getArcballCameraController;
		getBasicCameraView: getBasicCameraView;
		getDirectionLight: getDirectionLight;
		getGeometry: getGeometry;
		getNeedDisposedGameObjects: getNeedDisposedGameObjects;
		getPBRMaterial: getPBRMaterial;
		getPerspectiveCameraProjection: getPerspectiveCameraProjection;
		getScript: getScript;
		getTransform: getTransform;
		hasArcballCameraController: hasArcballCameraController;
		hasBasicCameraView: hasBasicCameraView;
		hasDirectionLight: hasDirectionLight;
		hasGeometry: hasGeometry;
		hasPBRMaterial: hasPBRMaterial;
		hasPerspectiveCameraProjection: hasPerspectiveCameraProjection;
		hasScript: hasScript;
		hasTransform: hasTransform;
		getGameObjectName: getGameObjectName;
		setGameObjectName: setGameObjectName;
		getGameObjectAndAllChildren: getGameObjectAndAllChildren;
		removeGameObjects: removeGameObjects;
		restoreRemovedGameObjects: restoreRemovedGameObjects;
	};
	transform: {
		createTransform: createTransform;
		getGameObjects: getGameObjects;
		getName: getName;
		setName: setName;
		getParent: getParent;
		setParent: setParent;
		getChildren: getChildren;
		getLocalPosition: getLocalPosition;
		setLocalPosition: setLocalPosition;
		getLocalEulerAngles: getLocalEulerAngles;
		setLocalEulerAngles: setLocalEulerAngles;
		getLocalRotation: getLocalRotation;
		setLocalRotation: setLocalRotation;
		getLocalScale: getLocalScale;
		setLocalScale: setLocalScale;
		getLocalToWorldMatrix: getLocalToWorldMatrix;
		lookAt: lookAt;
	};
	directionLight: {
		createDirectionLight: createDirectionLight;
		getName: getName$7;
		setName: setName$7;
		getGameObjects: getGameObjects$5;
		getColor: getColor;
		setColor: setColor;
		getIntensity: getIntensity;
		setIntensity: setIntensity;
		getDirection: getDirection;
		setDirection: setDirection;
	};
	perspectiveCameraProjection: {
		createPerspectiveCameraProjection: createPerspectiveCameraProjection;
		getName: getName$1;
		setName: setName$1;
		getPMatrix: getPMatrix;
		getFovy: getFovy;
		setFovy: setFovy;
		getNear: getNear;
		setNear: setNear;
		getFar: getFar;
		setFar: setFar;
		getAspect: getAspect;
		setAspect: setAspect;
	};
	script: {
		createScript: createScript;
		getName: getName$8;
		setName: setName$8;
		getAttribute: getAttribute;
		setAttribute: setAttribute;
		getAllAssetData: getAllAssetData;
		setAllAssetData: setAllAssetData;
	};
	pbrMaterial: {
		createPBRMaterial: createPBRMaterial;
		getName: getName$2;
		setName: setName$2;
		getDiffuseColor: getDiffuseColor;
		setDiffuseColor: setDiffuseColor;
		getSpecular: getSpecular;
		setSpecular: setSpecular;
		getSpecularColor: getSpecularColor;
		setSpecularColor: setSpecularColor;
		getRoughness: getRoughness;
		setRoughness: setRoughness;
		getMetalness: getMetalness;
		setMetalness: setMetalness;
		getTransmission: getTransmission;
		setTransmission: setTransmission;
		getIOR: getIOR;
		setIOR: setIOR;
		getDiffuseMap: getDiffuseMap;
		setDiffuseMap: setDiffuseMap;
		getRoughnessMap: getRoughnessMap;
		setRoughnessMap: setRoughnessMap;
		getMetalnessMap: getMetalnessMap;
		setMetalnessMap: setMetalnessMap;
		getNormalMap: getNormalMap;
		setNormalMap: setNormalMap;
		// getAllPBRMaterials: getAllPBRMaterials,
		getGameObjects: getGameObjects$1;
	};
	basicSourceTexture: {
		createTexture: createTexture;
		disposeTexture: disposeTexture;
		addMaterial: addMaterial;
		getName: getName$3;
		setName: setName$3;
		getWrapS: getWrapS;
		setWrapS: setWrapS;
		getWrapT: getWrapT;
		setWrapT: setWrapT;
		getMagFilter: getMagFilter;
		setMagFilter: setMagFilter;
		getMinFilter: getMinFilter;
		setMinFilter: setMinFilter;
		getFormat: getFormat;
		setFormat: setFormat;
		getType: getType;
		setType: setType;
		getIsNeedUpdate: getIsNeedUpdate;
		setIsNeedUpdate: setIsNeedUpdate;
		getFlipY: getFlipY;
		setFlipY: setFlipY;
		getImage: getImage;
		setImage: setImage;
	};
	geometry: {
		createGeometry: createGeometry;
		getName: getName$4;
		setName: setName$4;
		getVertices: getVertices;
		setVertices: setVertices;
		getNormals: getNormals;
		setNormals: setNormals;
		getTexCoords: getTexCoords;
		setTexCoords: setTexCoords;
		getTangents: getTangents;
		setTangents: setTangents;
		getIndices: getIndices;
		setIndices: setIndices;
		getGameObjects: getGameObjects$2;
	};
	basicCameraView: {
		createBasicCameraView: createBasicCameraView;
		getGameObjects: getGameObjects$3;
		getName: getName$5;
		setName: setName$5;
		getViewWorldToCameraMatrix: getViewWorldToCameraMatrix;
		getActiveCameraView: getActiveCameraView;
		active: active;
		notActive: notActive;
	};
	arcballCameraController: {
		createArcballCameraController: createArcballCameraController;
		// getAllDirtyArcballCameraControllers: getAllDirtyArcballCameraControllers,
		// clearDirtyList: clearDirtyList,
		getName: getName$6;
		setName: setName$6;
		getDistance: getDistance;
		setDistance: setDistance;
		getWheelSpeed: getWheelSpeed;
		setWheelSpeed: setWheelSpeed;
		getPhi: getPhi;
		setPhi: setPhi;
		getTheta: getTheta;
		setTheta: setTheta;
		getTarget: getTarget;
		setTarget: setTarget;
		getGameObjects: getGameObjects$4;
	};
};
export type service$123 = Merge<scene, {
	prepare: (meta3dState: state, isDebug: boolean, ecsConfig: ecsConfig) => state;
}>;
// import type { Map } from "immutable";
export type elementName = string;
export type elementFunc<elementState> = (_1: state, elementState: elementState) => Promise<state>;
// type handler = {
//     actionName: string,
//     updatedElementStateFieldName: string,
// }
// type reducers = {
//     role: string,
//     handlers: Array<handler>,
// }
// type uiControlName = string
// type uiControlState = any
export type elementContribute<elementState> = {
	elementName: elementName;
	execOrder: number;
	elementFunc: elementFunc<elementState>;
	elementState: elementState;
};
export type elementState = any;
export type textureID = string;
// tslint:disable-next-line:interface-over-type-literal
export type skinName = string;
// tslint:disable-next-line:interface-over-type-literal
export type skinContribute<skin> = {
	readonly skinName: skinName;
	readonly skin: skin;
};
export type rect = {
	x: number;
	y: number;
	width: number;
	height: number;
};
// tslint:disable-next-line:interface-over-type-literal
export type uiControlName = string;
// type getInputFunc<data> = (_1: Meta3dType_Index_state) => Promise<data>
// tslint:disable-next-line:interface-over-type-literal
export type uiControlFunc<inputFunc, specificData, outputData> = (_1: state, _2: inputFunc, _3: rect, _4: specificData) => Promise<[
	state,
	outputData
]>;
// tslint:disable-next-line:interface-over-type-literal
// export type uiControlContribute<uiControlState, specificData, outputData> = {
//     uiControlName: uiControlName;
//     createStateFunc: () => uiControlState;
//     func: uiControlFunc<specificData, outputData>
// };
export type init = (meta3dState: state) => Promise<state>;
export type uiControlContribute<inputFunc, specificData, outputData> = {
	uiControlName: uiControlName;
	func: uiControlFunc<inputFunc, specificData, outputData>;
	init: init;
};
declare abstract class texture$1 {
	protected opaque: any;
}
export type inputName = string;
export type inputFunc<data> = (_1: state) => Promise<data>;
export type inputContribute<data> = {
	inputName: inputName;
	func: inputFunc<data>;
};
// tslint:disable-next-line:interface-over-type-literal
export type rect$1 = {
	readonly x: number;
	readonly y: number;
	readonly width: number;
	readonly height: number;
};
// tslint:disable-next-line:interface-over-type-literal
export type label = string;
// tslint:disable-next-line:interface-over-type-literal
export type size = [
	number,
	number
];
// tslint:disable-next-line:interface-over-type-literal
export type pos = [
	number,
	number
];
export type style = string;
export type texture$2 = texture$1;
// export type context = webgl1Context
export type context = any;
export type imageSrc = string;
export type imguiImplTexture = any;
export type menuLabel = string;
export type menuAllLabels = Array<[
	menuLabel,
	Array<menuLabel>
]>;
export type treeNodeLabel = string;
export type treeData = Array<[
	treeNodeLabel,
	imguiImplTexture,
	treeData
]>;
// export type level = number
export type index = number;
// export type treeIndexData = [level, index]
export type treeIndexData = Array<index>;
export type treeDragData = {
	source: treeIndexData;
	target: treeIndexData;
};
export type treeReturnData = [
	nullable<treeIndexData>,
	nullable<treeDragData>
];
declare enum windowFlags {
	None,
	NoTitleBar
}
declare enum cond {
	// None,
	Always,
	Once
}
export type vec2 = {
	x: number;
	y: number;
};
export type uiExtensionProtocolName = extensionProtocolName;
export type imguiRendererExtensionProtocolName = extensionProtocolName;
export type time = number;
// type elementStateField = any
export type updateElementStateFunc = (elementState: elementState) => elementState;
export type clearColor = [
	number,
	number,
	number,
	number
];
export type texture$3 = texture$2;
export type service$1 = {
	readonly registerElement: <elementState>(meta3dState: state, elementContribute: elementContribute<elementState>) => state;
	readonly registerSkin: <skin>(meta3dState: state, skinContribute: skinContribute<skin>) => state;
	readonly registerUIControl: <inputData, specificData, outputData>(meta3dState: state, uiControlContribute: uiControlContribute<inputData, specificData, outputData>) => state;
	readonly registerInput: <data>(meta3dState: state, inputContribute: inputContribute<data>) => state;
	readonly getSkin: <skin>(meta3dState: state, skinName: skinName) => nullable<skinContribute<skin>>;
	readonly getUIControlFunc: <inputData, specificData, outputData>(meta3dState: state, uiControlName: uiControlName) => uiControlFunc<inputData, specificData, outputData>;
	readonly getInputFunc: <data>(meta3dState: state, inputName: inputName) => nullable<inputFunc<data>>;
	// readonly updateUIControlName: (
	//     meta3dState: meta3dState,
	//     [api, uiExtensionProtocolName]: [api, uiExtensionProtocolName],
	//     [oldUIControlName, newUIControlName]: [uiControlName, uiControlName]
	// ) => meta3dState;
	readonly getUIControlState: <uiControlState>(meta3dState: state, uiControlName: uiControlName) => nullable<uiControlState>;
	readonly setUIControlState: <uiControlState>(meta3dState: state, uiControlName: uiControlName, uiControlState: uiControlState) => state;
	readonly init: (meta3dState: state, [api, imguiRendererExtensionProtocolName]: [
		api,
		imguiRendererExtensionProtocolName
	], isInitEvent: boolean, isDebug: boolean, canvas: HTMLCanvasElement) => Promise<state>;
	readonly clear: (meta3dState: state, [api, imguiRendererExtensionProtocolName]: [
		api,
		imguiRendererExtensionProtocolName
	], clearColor: clearColor) => state;
	readonly render: (meta3dState: state, [uiExtensionProtocolName, imguiRendererExtensionProtocolName]: [
		uiExtensionProtocolName,
		imguiRendererExtensionProtocolName
	], time: time) => Promise<state>;
	readonly getCurrentElementState: (meta3dState: state) => nullable<elementState>;
	readonly show: (meta3dState: state, elementName: elementName) => state;
	readonly hide: (meta3dState: state, elementName: elementName) => state;
	readonly isStateChange: (meta3dState: state, elementName: elementName) => boolean;
	readonly getElementState: <elementState>(meta3dState: state, elementName: elementName) => nullable<elementState>;
	// readonly dispatch: <action> (
	//     meta3dState: meta3dState,
	//     actionName: string,
	//     role: string,
	//     updateElementStateFieldFunc: updateElementStateFieldFunc
	// ) => meta3dState;
	readonly updateElementState: (meta3dState: state, updateElementStateFunc: updateElementStateFunc) => state;
	readonly setStyle: (meta3dState: state, style: style) => state;
	readonly beginWindow: (meta3dState: state, label: label, flags: windowFlags) => state;
	readonly endWindow: (meta3dState: state) => state;
	readonly beginChild: (meta3dState: state, label: label) => state;
	readonly endChild: (meta3dState: state) => state;
	readonly setNextWindowRect: (meta3dState: state, rect: rect$1) => state;
	readonly addFBOTexture: (meta3dState: state, texture: strictNullable<texture$3>, rect: rect$1) => state;
	readonly getFBOTexture: (meta3dState: state, textureID: textureID) => nullable<texture$3>;
	readonly setFBOTexture: (meta3dState: state, textureID: textureID, texture: texture$3) => state;
	readonly getWindowBarHeight: (meta3dState: state) => number;
	readonly getContext: (meta3dState: state) => context;
	readonly button: (meta3dState: state, label: label, size: size) => [
		state,
		boolean
	];
	readonly setCursorPos: (meta3dState: state, pos: pos) => state;
	readonly loadImage: (meta3dState: state, _1: imageSrc) => Promise<imguiImplTexture>;
	readonly asset: (meta3dState: state, 
	// textures: { "loadGlbTexture": imguiImplTexture, "removeAssetTexture": imguiImplTexture, "glbTexture": imguiImplTexture },
	// fileTexture: imguiImplTexture,
	files: Array<[
		string,
		string,
		imguiImplTexture
	]>, label: label, rect: rect$1) => [
		state,
		nullable<string>
	];
	readonly menu: (meta3dState: state, allLabels: menuAllLabels, windowName: string, rect: rect$1) => [
		state,
		nullable<menuLabel>
	];
	readonly tree: (meta3dState: state, treeData: treeData, rootNodeLabel: treeNodeLabel, lastTreeSelectedData: nullable<treeIndexData>, 
	// textures:
	// {
	//     "addCubeTexture": imguiImplTexture,
	//     "disposeTexture": imguiImplTexture,
	//     "cloneTexture": imguiImplTexture,
	//     // "cameraIconTexture": imguiImplTexture,
	//     // "meshIconTexture": imguiImplTexture,
	//     // "lightIconTexture": imguiImplTexture,
	// },
	windowName: string, rect: rect$1) => [
		state,
		treeReturnData
	];
	readonly inspector: (meta3dState: state, 
	// [
	//     getGameObjectNameFunc, setGameObjectNameFunc,
	//     getLocalPositionXFunc, setLocalPositionXFunc,
	//     getLocalPositionYFunc, setLocalPositionYFunc,
	//     getLocalPositionZFunc, setLocalPositionZFunc,
	//     getLocalEulerXFunc, setLocalEulerXFunc,
	//     getLocalEulerYFunc, setLocalEulerYFunc,
	//     getLocalEulerZFunc, setLocalEulerZFunc,
	//     getLocalScaleXFunc, setLocalScaleXFunc,
	//     getLocalScaleYFunc, setLocalScaleYFunc,
	//     getLocalScaleZFunc, setLocalScaleZFunc,
	// ]: [getValueFunc<name>, setValueFunc<name>,
	//         getValueFunc<number>, setValueFunc<number>,
	//         getValueFunc<number>, setValueFunc<number>,
	//         getValueFunc<number>, setValueFunc<number>,
	//         getValueFunc<number>, setValueFunc<number>,
	//         getValueFunc<number>, setValueFunc<number>,
	//         getValueFunc<number>, setValueFunc<number>,
	//         getValueFunc<number>, setValueFunc<number>,
	//         getValueFunc<number>, setValueFunc<number>,
	//         getValueFunc<number>, setValueFunc<number>,
	//     ],
	gameObjectName: name, localPosition: localPosition, localEulerAngles: localEulerAngles, localScale: localScale, windowName: string, rect: rect$1) => [
		state,
		[
			nullable<name>,
			nullable<localPosition>,
			nullable<localEulerAngles>,
			nullable<localScale>
		]
	];
	readonly switchButton: (meta3dState: state, isRunState: boolean, textures: {
		"click1Texture": imguiImplTexture;
		"click2Texture": imguiImplTexture;
	}, size: size) => [
		state,
		[
			boolean,
			boolean
		]
	];
	readonly imageButton: (meta3dState: state, clickTexture: imguiImplTexture, size: size) => [
		state,
		boolean
	];
	readonly image: (meta3dState: state, clickTexture: imguiImplTexture, size: size) => state;
	readonly inputText: (meta3dState: state, label: label, value: string, maxLength: number, width: number) => [
		state,
		nullable<string>
	];
	readonly inputFloat1: (meta3dState: state, label: label, value: number, step: number, stepFast: number, width: number) => [
		state,
		nullable<number>
	];
	readonly inputFloat3: (meta3dState: state, label: label, value: [
		number,
		number,
		number
	], step: number, stepFast: number, width: number) => [
		state,
		nullable<[
			number,
			number,
			number
		]>
	];
	readonly checkbox: (meta3dState: state, label: label, value: boolean) => [
		state,
		nullable<boolean>
	];
	readonly collapsing: (meta3dState: state, label: label, isOpen: boolean, cond: cond) => [
		state,
		boolean
	];
	readonly openModal: (meta3dState: state, label: label) => state;
	readonly closeCurrentModal: (meta3dState: state) => state;
	readonly beginModal: (meta3dState: state, label: label) => [
		state,
		boolean
	];
	readonly endModal: (meta3dState: state) => state;
	readonly popup: (meta3dState: state, label: label, selectedValues: Array<string>, id: string) => [
		state,
		nullable<number>
	];
	readonly imagePopup: (meta3dState: state, clickTexture: imguiImplTexture, rect: rect$1, selectedValues: Array<string>, id: string) => [
		state,
		nullable<number>
	];
	readonly handleDragDropTarget: <data>(meta3dState: state, type: string) => [
		state,
		nullable<data>
	];
	readonly dummy: (meta3dState: state, width: number, height: number) => state;
	readonly list: (meta3dState: state, label: label, [width, height]: [
		number,
		number
	], items: Array<string>, [itemWidth, itemHeight]: [
		number,
		number
	], isRemoveable: boolean, removeTexture: nullable<imguiImplTexture>) => [
		state,
		[
			nullable<[
				number,
				string
			]>,
			nullable<boolean>
		]
	];
	readonly getItemRectMax: (meta3dState: state) => vec2;
	readonly getItemRectSize: (meta3dState: state) => vec2;
	readonly getWindowPos: (meta3dState: state) => vec2;
	readonly getWindowSize: (meta3dState: state) => vec2;
};
export type actionName = string;
export type eventHandler<uiData> = (meta3dState: state, uiData: uiData) => Promise<state>;
export type createState<state> = (meta3dState: state) => state;
export type init$1 = (meta3dState: state) => Promise<state>;
export type restore$1<state> = (currentState: state, targetState: state) => state;
export type deepCopy$1<state> = (state: state) => state;
export type actionContribute<uiData, state> = {
	actionName: actionName;
	handler: eventHandler<uiData>;
	createState: createState<state>;
	init: init$1;
	restore?: restore$1<state>;
	deepCopy?: deepCopy$1<state>;
};
// tslint:disable-next-line:interface-over-type-literal
export type phaseType = "Broadcast" | "Emit";
declare abstract class userData {
	protected opaque: any;
}
// tslint:disable-next-line:interface-over-type-literal
export type customEvent = {
	readonly name: string;
	readonly isStopPropagation: boolean;
	readonly phase: (undefined | phaseType);
	readonly userData: (undefined | userData);
};
/* TypeScript file generated from BrowserType.res by genType. */
/* eslint-disable import/first */
// tslint:disable-next-line:interface-over-type-literal
export type browser = "Chrome" | "Firefox" | "Android" | "IOS" | "Unknown";
export type events = List<eventData<Array<singleInputData>>>;
export type component = number;
export type domainModelId = gameObject | component;
export type primitiveData = string | number | boolean | Object | Array<primitiveData>;
export type valueObject = primitiveData;
export type outsideImmutableData = ArrayBuffer;
export type outsideImmutableDataId = string;
export type singleInputData = nullable<outsideImmutableDataId | domainModelId | valueObject | outsideImmutableData>;
export type eventName = string;
export type eventData<inputData> = {
	name: eventName;
	isOnlyRead?: boolean;
	// parent?: eventName,
	inputData: inputData;
};
// type getOuptputData<outputData extends Array<any>> = outputData extends [] ? Promise<meta3dState> :
//     Promise<[meta3dState, ...outputData]>
// type handleFunc<inputData extends Array<singleInputData>, outputData extends Array<any>> = (meta3dState: meta3dState, ...inputData: inputData) =>
//     getOuptputData<outputData>
export type handleFunc<inputData extends Array<singleInputData>> = (meta3dState: state, ...inputData: inputData) => Promise<state>;
export type service$2 = {
	init: (meta3dState: state) => state;
	on: <inputData extends Array<singleInputData>>(meta3dState: state, eventName: eventName, priority: number, forwardHandleFunc: handleFunc<inputData>, backwardHandleFunc: handleFunc<inputData>) => state;
	addEvent: <inputData extends Array<singleInputData>>(meta3dState: state, eventData: eventData<inputData>) => state;
	createAllEvents: <inputData extends Array<singleInputData>>(allEventData: Array<eventData<inputData>>, meta3dState: state) => List<eventData<inputData>>;
	// addOutsideImmutableData: (meta3dState: meta3dState, outsideImmutableDataId: outsideImmutableDataId, outsideImmutableData: outsideImmutableData) => meta3dState,
	// removeOutsideImmutableData: (meta3dState: meta3dState, outsideImmutableDataId: outsideImmutableDataId) => meta3dState,
	generateOutsideImmutableDataId: (meta3dState: state) => outsideImmutableDataId;
	// getOutsideImmutableData: (meta3dState: meta3dState, outsideImmutableDataId: outsideImmutableDataId) => outsideImmutableData,
	// // TODO remove?
	// getAllOutsideImmutableData: (meta3dState: meta3dState) => Seq.Indexed<[outsideImmutableDataId, outsideImmutableData]>,
	// // TODO remove?
	// getAllOutsideImmutableDataFromGlobalThis: () => Seq.Indexed<[outsideImmutableDataId, outsideImmutableData]>,
	getAllEvents: <inputData extends Array<singleInputData>>(meta3dState: state) => List<eventData<inputData>>;
	getAllEventsFromGlobalThis: <inputData extends Array<singleInputData>>(meta3dState: state) => List<eventData<inputData>>;
	replaceAllEvents: <inputData extends Array<singleInputData>>(meta3dState: state, allEvents: List<eventData<inputData>>) => state;
	getNeedReplaceAllEvents: (meta3dState: state) => events;
	setNeedReplaceAllEvents: <inputData extends Array<singleInputData>>(meta3dState: state, allEvents: List<eventData<inputData>>) => state;
	getNeedBackwardEvents: (meta3dState: state) => events;
	setNeedBackwardEvents: <inputData extends Array<singleInputData>>(meta3dState: state, events: List<eventData<inputData>>) => state;
	cleanAllNeedReplaceEvents: (meta3dState: state) => state;
	cleanAllNeedBackwardEvents: (meta3dState: state) => state;
	forwardView: <inputData extends Array<singleInputData>>(meta3dState: state, events: List<eventData<inputData>>) => Promise<state>;
	backwardView: <inputData extends Array<singleInputData>>(meta3dState: state, events: List<eventData<inputData>>) => Promise<state>;
};
export type service$3 = {
	parseEventData: (eventData: ArrayBuffer) => Array<eventData<Array<singleInputData>>>;
	// exportEventData: (allEvents: Array<eventData<Array<singleInputData>>>, filename: string, extension: string) => void,
	exportEventData: (allEvents: Array<eventData<Array<singleInputData>>>) => void;
	generateEventDataBuffer: (allEvents: Array<eventData<Array<singleInputData>>>) => ArrayBuffer;
};
export type eventExtensionProtocolName = extensionName;
export type pointEventName = "meta3d_pointdown" | "meta3d_pointup" | "meta3d_pointtap" | "meta3d_pointmove" | "meta3d_pointscale" | "meta3d_pointdragstart" | "meta3d_pointdragover" | "meta3d_pointdragdrop";
export type customEventName = string;
export type priority = number;
export type handleFunc$1 = (customEvent: customEvent) => void;
export type handleFunc2 = (meta3dState: state, customEvent: customEvent) => state;
export type handleFunc3 = (meta3dState: state, customEvent: customEvent) => Promise<state>;
export type service$4 = {
	eventData: (meta3dState: state) => service$3;
	eventSourcing: (meta3dState: state) => service$2;
	trigger: <uiData>(meta3dState: state, eventExtensionProtocolName: eventExtensionProtocolName, actionName: actionName, uiData: uiData) => Promise<state>;
	registerAction: <uiData>(meta3dState: state, 
	// actionContribute: actionContribute<uiData, state>
	actionContribute: actionContribute<uiData, any>) => state;
	onPointEvent(eventExtensionProtocolName: eventExtensionProtocolName, [pointEventName, priority, handleFunc]: [
		pointEventName,
		priority,
		handleFunc$1
	]): void;
	onCustomGlobalEvent(eventExtensionProtocolName: eventExtensionProtocolName, [customEventName, priority, handleFunc]: [
		customEventName,
		priority,
		handleFunc$1
	]): void;
	offCustomGlobalEventByHandleFunc(eventExtensionProtocolName: eventExtensionProtocolName, [customEventName, handleFunc]: [
		customEventName,
		handleFunc$1
	]): void;
	onCustomGlobalEvent2(meta3dState: state, eventExtensionProtocolName: eventExtensionProtocolName, [customEventName, priority, handleFunc]: [
		customEventName,
		priority,
		handleFunc2
	]): state;
	triggerCustomGlobalEvent2(meta3dState: state, eventExtensionProtocolName: eventExtensionProtocolName, customEvent: customEvent): state;
	onCustomGlobalEvent3(meta3dState: state, eventExtensionProtocolName: eventExtensionProtocolName, [customEventName, priority, handleFunc]: [
		customEventName,
		priority,
		handleFunc3
	]): state;
	triggerCustomGlobalEvent3(meta3dState: state, eventExtensionProtocolName: eventExtensionProtocolName, customEvent: customEvent): Promise<state>;
	createCustomEvent(customEventName: customEventName, userData: nullable<userData>): customEvent;
	initEvent(meta3dState: state, eventExtensionProtocolName: eventExtensionProtocolName): state;
	setBrowser(meta3dState: state, eventExtensionProtocolName: eventExtensionProtocolName, browser: browser): state;
	setCanvas(meta3dState: state, eventExtensionProtocolName: eventExtensionProtocolName, canvas: HTMLCanvasElement): state;
	setBody(meta3dState: state, eventExtensionProtocolName: eventExtensionProtocolName, body: HTMLBodyElement): state;
	getBrowserChromeType(): browser;
	getBrowserFirefoxType(): browser;
	getBrowserAndroidType(): browser;
	getBrowserIOSType(): browser;
	getBrowserUnknownType(): browser;
	getPointDownEventName(): pointEventName;
	getPointUpEventName(): pointEventName;
	getPointTapEventName(): pointEventName;
	getPointMoveEventName(): pointEventName;
	getPointScaleEventName(): pointEventName;
	getPointDragStartEventName(): pointEventName;
	getPointDragOverEventName(): pointEventName;
	getAllActionContributes: <uiData, state>(state: state) => Array<actionContribute<uiData, state>>;
};
export type service$5 = {
	prepare: (meta3dState: state, isDebug: boolean) => state;
};
// tslint:disable-next-line:interface-over-type-literal
export type stream<a> = $$stream<a>;
// tslint:disable-next-line:interface-over-type-literal
export type componentName = string;
// tslint:disable-next-line:interface-over-type-literal
export type getGameObjectsFunc<state, component> = (_1: state, _2: component) => gameObject$1[];
// tslint:disable-next-line:interface-over-type-literal
export type createComponentFunc<state, component> = (_1: state) => [
	state,
	component
];
// tslint:disable-next-line:interface-over-type-literal
export type addComponentFunc<state, component> = (_1: state, _2: gameObject$1, _3: component) => state;
// tslint:disable-next-line:interface-over-type-literal
export type hasComponentFunc<state> = (_1: state, _2: gameObject$1) => boolean;
// tslint:disable-next-line:interface-over-type-literal
export type getComponentFunc<state, component> = (_1: state, _2: gameObject$1) => (null | undefined | component);
// tslint:disable-next-line:interface-over-type-literal
export type getAllComponentsFunc<state, component> = (_1: state) => component[];
declare abstract class dataValue {
	protected opaque: any;
}
export type dataName = number;
// tslint:disable-next-line:interface-over-type-literal
export type getComponentDataFunc<state, component> = (_1: state, _2: component, _3: dataName) => (null | undefined | dataValue);
// tslint:disable-next-line:interface-over-type-literal
export type setComponentDataFunc<state, component> = (_1: state, _2: component, _3: dataName, _4: dataValue) => state;
export type restore$2<state> = (_1: state, _2: state) => state;
export type deepCopy$2<state> = (_1: state) => state;
declare abstract class state$1 {
	protected opaque: any;
}
// tslint:disable-next-line:interface-over-type-literal
export type gameObjectContribute$1 = gameObjectContribute<state$1>;
/* TypeScript file generated from PipelineType.res by genType. */
/* eslint-disable import/first */
// tslint:disable-next-line:interface-over-type-literal
export type link = "merge" | "concat";
// tslint:disable-next-line:interface-over-type-literal
export type elementType = "job" | "group";
// tslint:disable-next-line:interface-over-type-literal
export type elementName$1 = string;
// tslint:disable-next-line:interface-over-type-literal
export type element = {
	readonly name: elementName$1;
	readonly type_: elementType;
	readonly is_set_state?: boolean;
};
// tslint:disable-next-line:interface-over-type-literal
export type groupName = string;
// tslint:disable-next-line:interface-over-type-literal
export type group = {
	readonly name: groupName;
	readonly link: link;
	readonly elements: element[];
};
// tslint:disable-next-line:interface-over-type-literal
export type groups = group[];
// tslint:disable-next-line:interface-over-type-literal
export type pipelineName = string;
// tslint:disable-next-line:interface-over-type-literal
export type pipelineData = {
	readonly name: pipelineName;
	readonly groups: groups;
	readonly first_group: groupName;
};
// tslint:disable-next-line:interface-over-type-literal
export type insertAction = "before" | "after";
// tslint:disable-next-line:interface-over-type-literal
export type jobOrder = {
	readonly pipelineName: pipelineName;
	readonly insertElementName: elementName$1;
	readonly insertAction: insertAction;
};
// tslint:disable-next-line:interface-over-type-literal
export type jobOrders = jobOrder[];
declare abstract class state$2 {
	protected opaque: any;
}
declare abstract class component$1 {
	protected opaque: any;
}
// tslint:disable-next-line:interface-over-type-literal
export type usedComponentContribute = {
	readonly componentName: componentName;
	state: state$2;
	readonly createComponentFunc: createComponentFunc<state$2, component$1>;
	readonly getGameObjectsFunc: getGameObjectsFunc<state$2, component$1>;
	readonly addComponentFunc: addComponentFunc<state$2, component$1>;
	readonly hasComponentFunc: hasComponentFunc<state$2>;
	readonly getComponentFunc: getComponentFunc<state$2, component$1>;
	readonly getAllComponentsFunc: getAllComponentsFunc<state$2, component$1>;
	readonly getComponentDataFunc: getComponentDataFunc<state$2, component$1>;
	readonly setComponentDataFunc: setComponentDataFunc<state$2, component$1>;
	readonly restore: restore$2<state$2>;
	readonly deepCopy: deepCopy$2<state$2>;
};
export type operateStatesFuncs = {
	api: api;
	getStatesFunc: <states>(_1: state) => states;
	setStatesFunc: <states>(_1: state, _2: states) => state;
	meta3dEngineCoreExtensionProtocolName: extensionProtocolName;
};
// tslint:disable-next-line:interface-over-type-literal
export type jobName = string;
// tslint:disable-next-line:interface-over-type-literal
export type stream$1<a> = stream<a>;
// tslint:disable-next-line:interface-over-type-literal
export type execFunc = (_1: state, _2: operateStatesFuncs) => stream$1<state>;
// tslint:disable-next-line:interface-over-type-literal
export type getExecFunc = (_1: pipelineName, _2: jobName) => (null | undefined | execFunc);
// tslint:disable-next-line:interface-over-type-literal
export type pipelineData$1 = pipelineData;
// tslint:disable-next-line:interface-over-type-literal
// export type createStateFunc<state> = () => state;
// export type createStateFunc<config, state> = (meta3dState: meta3dState, config: nullable<config>) => state
export type createStateFunc$1<config, state> = (meta3dState: state, config: config) => state;
// tslint:disable-next-line:interface-over-type-literal
export type initFunc<state> = (_1: state) => void;
export type restoreFunc<state> = (currentState: state, targetState: state) => state;
export type deepCopyFunc<state> = (state: state) => state;
// tslint:disable-next-line:interface-over-type-literal
export type pipelineName$1 = string;
// tslint:disable-next-line:interface-over-type-literal
export type allPipelineData = pipelineData$1[];
// tslint:disable-next-line:interface-over-type-literal
export type pipelineContribute<config, state> = {
	readonly pipelineName: pipelineName$1;
	readonly createStateFunc: createStateFunc$1<config, state>;
	readonly initFunc: initFunc<state>;
	readonly getExecFunc: getExecFunc;
	readonly allPipelineData: allPipelineData;
	readonly restoreFunc?: restoreFunc<state>;
	readonly deepCopyFunc?: deepCopyFunc<state>;
};
// tslint:disable-next-line:interface-over-type-literal
export type service$6 = {
	readonly getIsDebug: (_1: state) => boolean;
	readonly setIsDebug: (_1: state, isDebug: boolean) => state;
	readonly prepare: () => void;
	readonly init: (_1: state) => state;
	readonly registerPipeline: <config, state>(state: state, contribute: pipelineContribute<config, state>, config?: nullable<config>, jobOrders?: jobOrders) => state;
	readonly unregisterPipeline: (_1: state, _2: pipelineName$1) => state;
	readonly registerComponent: <config>(_1: state, _2: config) => state;
	readonly unregisterComponent: (_1: state, _2: componentName) => state;
	createAndSetComponentState: <config>(_1: state, _2: componentName, _3: config) => state;
	readonly unsafeGetUsedComponentContribute: (_1: state, _2: componentName) => usedComponentContribute;
	readonly setUsedComponentContribute: (_1: state, _2: usedComponentContribute, _3: componentName) => state;
	readonly createComponent: <component>(_1: usedComponentContribute) => [
		usedComponentContribute,
		component
	];
	readonly setComponentData: <component, dataValue>(_1: usedComponentContribute, _2: component, _3: dataName, _4: dataValue) => usedComponentContribute;
	readonly addComponent: <component>(_1: usedComponentContribute, _2: gameObject$1, _3: component) => usedComponentContribute;
	readonly removeComponent: <component>(_1: usedComponentContribute, _2: gameObject$1, _3: component) => usedComponentContribute;
	readonly hasComponent: (_1: usedComponentContribute, _2: gameObject$1) => boolean;
	readonly getComponent: <component>(_1: usedComponentContribute, _2: gameObject$1) => (null | undefined | component);
	readonly getNeedDisposedComponents: <needDisposedComponents>(_1: usedComponentContribute) => needDisposedComponents;
	readonly deferDisposeComponent: <component>(_1: usedComponentContribute, _2: [
		component,
		gameObject$1
	]) => usedComponentContribute;
	readonly disposeComponents: <batchDisposeData>(_1: usedComponentContribute, _2: batchDisposeData) => [
		usedComponentContribute,
		Array<component$1>
	];
	readonly getAllComponents: <component>(_1: usedComponentContribute) => component[];
	readonly getComponentData: <component, dataValue>(_1: usedComponentContribute, _2: component, _3: dataName) => nullable<dataValue>;
	readonly getComponentGameObjects: <component>(_1: usedComponentContribute, _2: component) => gameObject$1[];
	readonly getComponentState: <componentState>(_1: state, _2: componentName) => nullable<componentState>;
	readonly setGameObjectContribute: (_1: state, _2: gameObjectContribute$1) => state;
	readonly createAndSetGameObjectState: (_1: state, _config: config) => state;
	readonly createGameObject: (_1: state) => [
		state,
		gameObject
	];
	readonly getNeedDisposedGameObjects: (_1: state) => gameObject[];
	readonly deferDisposeGameObject: (_1: state, _2: gameObject) => state;
	readonly disposeGameObjects: (_1: state, _2: gameObject[]) => [
		state,
		[
			Array<gameObject>,
			Array<component$1>,
			Array<component$1>,
			Array<component$1>,
			Array<component$1>,
			Array<component$1>,
			Array<component$1>,
			Array<component$1>,
			Array<component$1>
		]
	];
	readonly cloneGameObject: (_1: state, _2: number, _3: cloneConfig, _4: gameObject) => [
		state,
		clonedGameObjects
	];
	readonly getAllGameObjects: (_1: state) => gameObject[];
	readonly getGameObjectName: (_1: state, gameObject: gameObject) => nullable<name>;
	readonly setGameObjectName: (_1: state, gameObject: gameObject, name: name) => state;
	readonly runPipeline: (_1: state, _2: extensionProtocolName, _3: pipelineName) => stream<state>;
};
// type eventTarget = any
// type event = any
export type service$7 = {
	tap<a>(func: (v: a) => void, stream: stream<a>): stream<a>;
	filter<a>(func: (v: a) => boolean, stream: stream<a>): stream<a>;
	take<a>(count: number, stream: stream<a>): stream<a>;
	fromEvent<event, eventTarget>(eventName: string, eventTarget: eventTarget, _3: boolean): stream<event>;
	fromPromise<a>(promise: Promise<a>): stream<a>;
	just<a>(val: a): stream<a>;
	concat<a>(stream1: stream<a>, stream2: stream<a>): stream<a>;
	map<a, b>(func: (v: a) => b, stream: stream<a>): stream<b>;
	flatMap<a, b>(func: (v: a) => stream<b>, stream: stream<a>): stream<b>;
	mergeArray<a>(streams: Array<stream<a>>): stream<a>;
	concatArray<a>(streams: Array<stream<a>>): stream<a>;
	callFunc<a>(func: () => a): stream<a>;
	drain<a>(stream: stream<a>): Promise<void>;
};
export type engineBasicService = service$5;
export type engineCoreService = service$6;
export type mostService = service$7;
export type service$8 = {
	engineBasic: (meta3dState: state) => engineBasicService;
	engineCore: (meta3dState: state) => engineCoreService;
	most: (meta3dState: state) => mostService;
};
export type cleanScene = (meta3dState: state) => state;
export type importScene = (meta3dState: state, sceneGLB: ArrayBuffer) => Promise<state>;
export type onFinishFunc = (glb: ArrayBuffer) => void;
export type onErrorFunc = (error: ErrorEvent) => void;
export type exportScene = ([onFinishFunc, onErrorFunc]: [
	onFinishFunc,
	onErrorFunc
], meta3dState: state) => void;
// import type { GLTF } from "meta3d-load-scene-utils/src/three/GLTFLoader"
export type GLTF = any;
export type loadGlb = (meta3dState: state, glb: ArrayBuffer) => Promise<GLTF>;
export type assetData$1 = ArrayBuffer;
export type service$9 = {
	loadGlb: loadGlb;
	exportAsset: (data: [
		Uint8Array,
		Uint8Array,
		Uint8Array,
		Array<Uint8Array>
	]) => assetData$1;
	parseAsset: (assetData: assetData$1) => [
		Uint8Array,
		Uint8Array,
		Uint8Array,
		Array<Uint8Array>
	];
};
export type zip = any;
export type file = any;
export type fileOption = {
	binary: boolean;
};
export type generateOptionType = "blob" | "arraybuffer";
export type generateOption = {
	type: generateOptionType;
};
export type service$10 = {
	createZip: () => zip;
	file: (zip: zip, filePath: string, file: file, fileOption?: fileOption) => void;
	generateAsync: (zip: zip, generateOption: generateOption) => Promise<any>;
};
export type service$11 = {
	saveAs: (content: any, name: string) => void;
};
export type service$12 = {
	jszip: (meta3dState: state) => service$10;
	filesave: (meta3dState: state) => service$11;
};
export type target$1 = "visual" | "visualRun";
export type env = "local" | "production";
export type initData = {
	target: target$1;
	isDebug: boolean;
	canvas: HTMLCanvasElement;
	env: env;
};
export type updateData = {
	target: target$1;
	clearColor: [
		number,
		number,
		number,
		number
	];
	time: number;
	skinName: nullable<string>;
};
export type initDataForInitFunc = {
	isDebug: boolean;
	canvas: HTMLCanvasElement;
};
export type initFunc$1 = (meta3dState: state, initData: initDataForInitFunc) => Promise<state>;
export type addGroup = (meta3dState: state, group: Group) => [
	state,
	gameObject
];
export type uiTexture = texture$3;
export type configData = [
	canvasData,
	{
		isDebug: boolean;
		clearColor: [
			number,
			number,
			number,
			number
		];
		skinName: nullable<string>;
		env: env;
	}
];
export type addToInitFuncs = (meta3dState: state, func: initFunc$1) => state;
type uiControlContribute$1<inputFunc, specificData, outputData> = uiControlContribute<inputFunc, specificData, outputData>;
type inputContribute$1<data> = inputContribute<data>;
type actionContribute$1<uiData, state> = actionContribute<uiData, state>;
export type engineSceneService = service$123;
export type uiService = service$1;
export type eventService = service$4;
export type coreService = service$8;
export type assetService = service$9;
export type libService = service$12;
type service$13 = {
	scene: (meta3dState: state) => engineSceneService;
	ui: (meta3dState: state) => uiService;
	event: (meta3dState: state) => eventService;
	core: (meta3dState: state) => coreService;
	asset: (meta3dState: state) => assetService;
	lib: (meta3dState: state) => libService;
	addGroup: addGroup;
	cleanScene: cleanScene;
	importScene: importScene;
	exportScene: exportScene;
	// initForVisual: (meta3dState: meta3dState, initData: initData) => Promise<meta3dState>,
	// initForVisualRun: (meta3dState: meta3dState, initData: initData) => Promise<meta3dState>,
	init: (meta3dState: state, initData: initData) => Promise<state>;
	update: (meta3dState: state, updateData: updateData) => Promise<state>;
	// render: (meta3dState: meta3dState) => Promise<meta3dState>,
	// prepare: (meta3dState: meta3dState, isDebug: boolean, ecsConfig: ecsConfig, gl: nullable<webgl1Context>, canvas: HTMLCanvasElement) => meta3dState,
	// addToPrepareFuncs: (meta3dState: meta3dState, func: (meta3dState: meta3dState, isDebug: boolean, canvas: HTMLCanvasElement) => meta3dState) => meta3dState,
	addToInitFuncs: addToInitFuncs;
	// addToUpdateFuncs: addToFuncs,
	// addToRenderFuncs: addToFuncs,
	getPluggablePackageService: <service>(meta3dState: state, packageProtocolName: packageProtocolName) => nullable<service>;
	run: (meta3dState: state, configData: configData) => void;
};

export {
	
	
	service$13 as service,
	
};

export {};
