open BackendCloudbaseType

@module("backend-4everland")
external init: init = "init"

@module("backend-4everland")
external handleLoginForWeb3: handleLoginForWeb3 = "handleLoginForWeb3"

@module("backend-4everland")
external getAllPublishExtensionProtocols: getAllPublishExtensionProtocols =
  "getAllPublishExtensionProtocols"

@module("backend-4everland")
external getAllPublishExtensionProtocolConfigs: getAllPublishExtensionProtocolConfigs =
  "getAllPublishExtensionProtocolConfigs"

@module("backend-4everland")
external batchFindPublishExtensionProtocols: batchFindPublishExtensionProtocols =
  "batchFindPublishExtensionProtocols"

@module("backend-4everland")
external batchFindPublishExtensionProtocolConfigs: batchFindPublishExtensionProtocolConfigs =
  "batchFindPublishExtensionProtocolConfigs"

@module("backend-4everland")
external getAllPublishExtensionInfos: getAllPublishExtensionInfos = "getAllPublishExtensionInfos"

@module("backend-4everland")
external findPublishExtension: findPublishExtension = "findPublishExtension"

@module("backend-4everland")
external getAllPublishContributeProtocols: getAllPublishContributeProtocols =
  "getAllPublishContributeProtocols"

@module("backend-4everland")
external getAllPublishContributeProtocolConfigs: getAllPublishContributeProtocolConfigs =
  "getAllPublishContributeProtocolConfigs"

@module("backend-4everland")
external batchFindPublishContributeProtocols: batchFindPublishContributeProtocols =
  "batchFindPublishContributeProtocols"

@module("backend-4everland")
external batchFindPublishContributeProtocolConfigs: batchFindPublishContributeProtocolConfigs =
  "batchFindPublishContributeProtocolConfigs"

@module("backend-4everland")
external getAllPublishContributeInfos: getAllPublishContributeInfos = "getAllPublishContributeInfos"

@module("backend-4everland")
external findPublishContribute: findPublishContribute = "findPublishContribute"

@module("backend-4everland")
external publishApp: publishApp = "publishApp"

@module("backend-4everland")
external findPublishApp: findPublishApp = "findPublishApp"

@module("backend-4everland")
external findAllPublishApps: findAllPublishApps = "findAllPublishApps"

@module("backend-4everland")
external findAllPublishAppsByAccount: findAllPublishAppsByAccount = "findAllPublishAppsByAccount"

@module("backend-4everland")
external findAllRecommendPublishApps: findAllRecommendPublishApps = "findAllRecommendPublishApps"

// @module("backend-4everland")
// external publishFinalApp: publishFinalApp = "publishFinalApp"

@module("backend-4everland")
external findPublishFinalApp: findPublishFinalApp = "findPublishFinalApp"

@module("backend-4everland")
external findAllPublishFinalApps: findAllPublishFinalApps = "findAllPublishFinalApps"

@module("backend-4everland")
external findAllPublishFinalAppsByAccount: findAllPublishFinalAppsByAccount =
  "findAllPublishFinalAppsByAccount"

@module("backend-4everland")
external findAllRecommendPublishFinalApps: findAllRecommendPublishFinalApps =
  "findAllRecommendPublishFinalApps"

// @module("backend-4everland")
// external publishElementContribute: publishElementContribute = "publishElementContribute"

// @module("backend-4everland")
// external publishElementAssembleData: publishElementAssembleData = "publishElementAssembleData"

// @module("backend-4everland")
// external getAllPublishNewestExtensions: getAllPublishNewestExtensions =
//   "getAllPublishNewestExtensions"

// @module("backend-4everland")
// external getElementAssembleData: getElementAssembleData = "getElementAssembleData"

// @module("backend-4everland")
// external findAllElementAssembleData: findAllElementAssembleData = "findAllElementAssembleData"

@module("backend-4everland")
external findNewestPublishPackage: findNewestPublishPackage = "findNewestPublishPackage"

@module("backend-4everland")
external findNewestPublishExtension: findNewestPublishExtension = "findNewestPublishExtension"

@module("backend-4everland")
external findNewestPublishContribute: findNewestPublishContribute = "findNewestPublishContribute"

@module("backend-4everland")
external publishPackage: publishPackage = "publishPackage"

@module("backend-4everland")
external getAllPublishPackageEntryExtensionProtocols: getAllPublishPackageEntryExtensionProtocols =
  "getAllPublishPackageEntryExtensionProtocols"

@module("backend-4everland")
external getAllPublishPackageInfos: getAllPublishPackageInfos = "getAllPublishPackageInfos"

@module("backend-4everland")
external findPublishPackage: findPublishPackage = "findPublishPackage"

// @module("backend-4everland")
// external findNewestPublishElementAssembleData: findNewestPublishElementAssembleData =
//   "findNewestPublishElementAssembleData"

let buildFrontendService = (): FrontendType.backendService => {
  {
    init,
    handleLoginForWeb3,
    checkUserName: Obj.magic(1),
    registerUser: Obj.magic(1),
    isLoginSuccess: Obj.magic(1),
    getAllPublishExtensionProtocolsCount: Obj.magic(1),
    getAllPublishExtensionProtocols,
    getAllPublishExtensionProtocolConfigs,
    batchFindPublishExtensionProtocols,
    batchFindPublishExtensionProtocolConfigs,
    getAllPublishExtensionInfos,
    findPublishExtension,
    getAllPublishContributeProtocols,
    getAllPublishContributeProtocolConfigs,
    batchFindPublishContributeProtocols,
    batchFindPublishContributeProtocolConfigs,
    getAllPublishContributeInfos,
    findPublishContribute,
    findAllPublishApps,
    findAllPublishAppsByAccount,
    findAllRecommendPublishApps,
    findPublishApp,
    findAllPublishFinalApps,
    findAllPublishFinalAppsByAccount,
    findAllRecommendPublishFinalApps,
    findPublishFinalApp,
    getAllPublishPackageEntryExtensionProtocols,
    getAllPublishPackageInfos,
    findPublishPackage,
    // findAllElementAssembleData,
    findNewestPublishPackage,
    findNewestPublishContribute,
  }
}

let buildAssembleSpaceService = (): AssembleSpaceType.backendService => {
  {
    getAllPublishExtensionProtocols: getAllPublishExtensionProtocols->Obj.magic,
    getAllPublishContributeProtocols: getAllPublishContributeProtocols->Obj.magic,
    getAllPublishContributeProtocolConfigs: getAllPublishContributeProtocolConfigs->Obj.magic,
    getAllPublishExtensionProtocolConfigs: getAllPublishExtensionProtocolConfigs->Obj.magic,
    // getAllPublishNewestExtensions: getAllPublishNewestExtensions->Obj.magic,
    publishApp,
    publishPackage,
    findPublishApp,
    findAllPublishApps,
    // publishElementContribute,
    // publishElementAssembleData,
    // getElementAssembleData,
    findNewestPublishPackage,
    findNewestPublishExtension,
    findNewestPublishContribute,
    // findNewestPublishElementAssembleData,
  }
}
