import { fromPromise, just, skip, Stream } from "most"
import { nullable } from "meta3d-commonlib-ts/src/nullable"
import { removeDuplicateItemsWithBuildKeyFunc } from "meta3d-structure-utils/src/ArrayUtils"
// import { buildPartialKeyByEntryProcoltolData, buildPartialKeyByPackageData } from "../publish/PublishPackageService"
import { protocols } from "./MarketType"
import { packageImplementInfos } from "./PackageMarketType"

export let getAllPublishPackageEntryExtensionProtocols = (
    // [getPackageMarketEntryExtensionProtocolCollectionFunc, getDataFromPackageMarketEntryExtensionProtocolCollection]: [any, any]
    getDataFunc: any,
    limitCount: number,
    skipCount: number
): Stream<protocols> => {
    // return fromPromise(getPackageMarketEntryExtensionProtocolCollectionFunc()).map((res: any) => {
    //     let resData = getDataFromPackageMarketEntryExtensionProtocolCollection(res)

    //     return resData.map(({
    //         account,
    //         entryExtensionProtocolName,
    //         entryExtensionProtocolVersion,
    //         entryExtensionProtocolIconBase64,
    //     }) => {
    //         return { name: entryExtensionProtocolName, version: entryExtensionProtocolVersion, account, iconBase64: entryExtensionProtocolIconBase64 }
    //     })
    // })

    return fromPromise(getDataFunc("publishedpackages", limitCount, skipCount)).map((data: any) => {
        // let resData = getDataFromPackageMarketEntryExtensionProtocolCollection(res)

        return removeDuplicateItemsWithBuildKeyFunc(data.map(({
            account,
            entryExtensionProtocolName,
            entryExtensionProtocolVersion,
            entryExtensionProtocolIconBase64,

            entryExtensionProtocolDisplayName,
            entryExtensionProtocolRepoLink,
            entryExtensionProtocolDescription,
        }) => {
            return {
                name: entryExtensionProtocolName, version: entryExtensionProtocolVersion, account, iconBase64: entryExtensionProtocolIconBase64,
                displayName: entryExtensionProtocolDisplayName,
                repoLink: entryExtensionProtocolRepoLink,
                description: entryExtensionProtocolDescription,
            }
        }),
            // (({
            //     name, version, account
            // }) => {
            //     return name + "_" + version + "_" + account
            // })
            (({
                name, version
            }) => {
                return name + "_" + version
            })
        )
    })
}


// export let getAllPublishPackageEntryExtensionProtocols = (
//     [getPackageMarketEntryExtensionProtocolCollectionFunc, getDataFromPackageMarketEntryExtensionProtocolCollection]: [any, any]
// ): Stream<protocols> => {
//     return getAllPublishProtocolData([getPackageMarketEntryExtensionProtocolCollectionFunc, getDataFromPackageMarketEntryExtensionProtocolCollection],
//         "publishedpackages"
//     )
// }

export let getAllPublishPackageInfos = (
    getDataByKeyContainFunc: any,
    limitCount: number,
    skipCount: number,
    entryExtensionProtocolName: string,
    entryExtensionProtocolVersion: string,
): Stream<packageImplementInfos> => {
    return getDataByKeyContainFunc(
        "publishedpackages",
        // buildPartialKeyByEntryProcoltolData(entryExtensionProtocolName, entryExtensionProtocolVersion)
        limitCount,
        skipCount,
        [
            entryExtensionProtocolName, entryExtensionProtocolVersion
        ]
    ).map((data: any) => {
        return data.map(({
            account,
            entryExtensionProtocolName,
            entryExtensionProtocolVersion,
            entryExtensionProtocolVersionRange,
            entryExtensionProtocolIconBase64,
            entryExtensionProtocolConfigStr,
            entryExtensionName,
            packageName,
            packageVersion,
            description,
            fileID
        }) => {
            return {
                id: fileID,
                account,
                entryExtensionProtocolName,
                entryExtensionProtocolVersion,
                entryExtensionProtocolVersionRange,
                entryExtensionProtocolIconBase64,
                entryExtensionProtocolConfigStr,
                entryExtensionName,
                name: packageName,
                version: packageVersion,
                description
            }
        })
    })
}

export let findPublishPackage = ([getDataByKeyContainFunc, downloadFileFunc]: [any, any],
    limitCount: number,
    skipCount: number,
    account: string,
    packageName: string,
    packageVersion: string
): Stream<nullable<ArrayBuffer>> => {
    return getDataByKeyContainFunc(
        "publishedpackages",
        limitCount,
        skipCount,
        // buildPartialKeyByPackageData(
        //     packageName,
        //     packageVersion,
        //     account
        // )
        [

            packageName,
            packageVersion,
            account
        ]
    ).flatMap((data: any) => {
        if (data.length === 0) {
            return just(null)
        }

        return downloadFileFunc(data[0].fileID)
    })
}