let _createSpecialKeyMap = %raw(`
  function() {
  var resultMap = [];
  var special_key_map = {
            8: "backspace",
            9: "tab",
            10: "return",
            13: "return",
            16: "shift",
            17: "ctrl",
            18: "alt",
            19: "pause",
            20: "capslock",
            27: "esc",
            32: "space",
            33: "pageup",
            34: "pagedown",
            35: "end",
            36: "home",
            37: "left",
            38: "up",
            39: "right",
            40: "down",
            45: "insert",
            46: "del",
            59: ";",
            61: "=",
            65: "a",
            66: "b",
            67: "c",
            68: "d",
            69: "e",
            70: "f",
            71: "g",
            72: "h",
            73: "i",
            74: "j",
            75: "k",
            76: "l",
            77: "m",
            78: "n",
            79: "o",
            80: "p",
            81: "q",
            82: "r",
            83: "s",
            84: "t",
            85: "u",
            86: "v",
            87: "w",
            88: "x",
            89: "y",
            90: "z",
            96: "0",
            97: "1",
            98: "2",
            99: "3",
            100: "4",
            101: "5",
            102: "6",
            103: "7",
            104: "8",
            105: "9",
            106: "*",
            107: "+",
            109: "-",
            110: ".",
            111: "/",
            112: "f1",
            113: "f2",
            114: "f3",
            115: "f4",
            116: "f5",
            117: "f6",
            118: "f7",
            119: "f8",
            120: "f9",
            121: "f10",
            122: "f11",
            123: "f12",
            144: "numlock",
            145: "scroll",
            173: "-",
            186: ";",
            187: "=",
            188: ",",
            189: "-",
            190: ".",
            191: "/",
            192: "\`",
            219: "[",
            220: "\\\\",
            221: "]",
            222: "'"
        };

        for(let key in special_key_map){
          if(special_key_map.hasOwnProperty(key)){
resultMap[key] = special_key_map[key];
          }
        }

        return resultMap;
        }
  `)

let _createShiftKeyByKeyCodeMap = %raw(`
function(){
  var resultMap = [];
  var map = {
            59: ":",
            61: "+",
            65: "A",
            66: "B",
            67: "C",
            68: "D",
            69: "E",
            70: "F",
            71: "G",
            72: "H",
            73: "I",
            74: "J",
            75: "K",
            76: "L",
            77: "M",
            78: "N",
            79: "O",
            80: "P",
            81: "Q",
            82: "R",
            83: "S",
            84: "T",
            85: "U",
            86: "V",
            87: "W",
            88: "X",
            89: "Y",
            90: "Z",
            96: ")",
            97: "!",
            98: "@",
            99: "#",
            100: "$",
            101: "%",
            102: "^",
            103: "&",
            104: "*",
            105: "(",
            173: "_",
            186: ":",
            187: "+",
            188: "<",
            189: "_",
            190: ">",
            191: "?",
            192: "~",
            219: "{",
            220: "|",
            221: "}",
            // TODO should restore after upgrade rescrip!
            // 222: "\\""
        };

        for(let key in map){
          if(map.hasOwnProperty(key)){
resultMap[key] = map[key];
          }
        }

        return resultMap;
        }
  `)

let _createShiftKeyByCharCodeMap = %raw(`
function(){
  return {
            "\`": "~",
            "1": "!",
            "2": "@",
            "3": "#",
            "4": "$",
            "5": "%",
            "6": "^",
            "7": "&",
            "8": "*",
            "9": "(",
            "0": ")",
            "-": "_",
            "=": "+",
            ";": ":",
            // TODO should restore after upgrade rescrip!
            // "'": "\\"",
            ",": "<",
            ".": ">",
            "/": "?",
            "\\\\": "|"
        }
        }
  `)

let create = (): EventManagerStateType.state => {
  eventData: {
    domEventStreamSubscription: None,
    mouseDomEventDataArrMap: Meta3dCommonlib.MutableSparseMap.createEmpty(),
    keyboardDomEventDataArrMap: Meta3dCommonlib.MutableSparseMap.createEmpty(),
    touchDomEventDataArrMap: Meta3dCommonlib.MutableSparseMap.createEmpty(),
    customGlobalEventArrMap: Meta3dCommonlib.MutableHashMap.createEmpty(),
    customGlobalEventArrMap2: Meta3dCommonlib.MutableHashMap.createEmpty(),
    customGlobalEventArrMap3: Meta3dCommonlib.MutableHashMap.createEmpty(),
    // customGameObjectEventArrMap: Meta3dCommonlib.MutableHashMap.createEmpty(),
    mouseEventData: {
      lastX: None,
      lastY: None,
      isDrag: false,
    },
    keyboardEventData: {
      specialKeyMap: _createSpecialKeyMap(.),
      shiftKeyByKeyCodeMap: _createShiftKeyByKeyCodeMap(.),
      shiftKeyByCharCodeMap: _createShiftKeyByCharCodeMap(.),
    },
    touchEventData: {
      lastX: None,
      lastY: None,
      isDrag: false,
    },
  },
  canvas: None,
  body: None,
  browser: Meta3dEventProtocol.BrowserType.Chrome,
}

let deepCopy = (eventManagerState: EventManagerStateType.state) => {
  ...eventManagerState,
  eventData: {
    ...eventManagerState.eventData,
    mouseDomEventDataArrMap: eventManagerState.eventData.mouseDomEventDataArrMap->Meta3dCommonlib.MutableSparseMap.copy,
    keyboardDomEventDataArrMap: eventManagerState.eventData.keyboardDomEventDataArrMap->Meta3dCommonlib.MutableSparseMap.copy,
    touchDomEventDataArrMap: eventManagerState.eventData.touchDomEventDataArrMap->Meta3dCommonlib.MutableSparseMap.copy,
    customGlobalEventArrMap: eventManagerState.eventData.customGlobalEventArrMap->Meta3dCommonlib.MutableHashMap.copy,
    customGlobalEventArrMap2: eventManagerState.eventData.customGlobalEventArrMap2->Meta3dCommonlib.MutableHashMap.copy,
  },
}
