open StateType

let _createClonedGameObjects = (gameObjectState, countRange, sourceGameObject) => {
  let nameOpt = gameObjectState.names->Meta3dCommonlib.ImmutableSparseMap.get(sourceGameObject)

  countRange->Meta3dCommonlib.ArraySt.reduceOneParam(
    (. (gameObjectState, clonedGameObjects), _) => {
      let (gameObjectState, gameObject) = CreateGameObjectUtils.create(gameObjectState)

      let gameObjectState = switch nameOpt {
      | Some(name) => {
          ...gameObjectState,
          names: gameObjectState.names->Meta3dCommonlib.ImmutableSparseMap.set(gameObject, name),
        }
      | None => gameObjectState
      }

      (gameObjectState, clonedGameObjects->Meta3dCommonlib.ArraySt.push(gameObject))
    },
    (gameObjectState, []),
  )
}

let _setParent = (
  transformState,
  setTransformDataFunc,
  clonedParentTransforms,
  clonedTransforms,
) => {
  clonedParentTransforms->Meta3dCommonlib.ArraySt.reduceOneParami(
    (. transformState, clonedParentTransform, i) => {
      setTransformDataFunc(.
        transformState,
        clonedTransforms[i],
        Meta3dComponentTransformProtocol.Index.dataName.parent,
        clonedParentTransform->Obj.magic,
      )
    },
    transformState,
  )
}

let rec _clone = (
  (
    gameObjectState,
    transformState,
    pbrMaterialState,
    geometryState,
    directionLightState,
    arcballCameraControllerState,
    basicCameraViewState,
    perspectiveCameraProjectionState,
    scriptState,
  ),
  (
    (
      getTransformFunc,
      cloneTransformFunc,
      addTransformFunc,
      getTransformGameObjectsFunc,
      getTransformDataFunc,
      setTransformDataFunc,
    ),
    (getPBRMaterialFunc, clonePBRMaterialFunc, addPBRMaterialFunc),
    (getGeometryFunc, cloneGeometryFunc, addGeometryFunc),
    (getDirectionLightFunc, cloneDirectionLightFunc, addDirectionLightFunc),
    (
      getArcballCameraControllerFunc,
      cloneArcballCameraControllerFunc,
      addArcballCameraControllerFunc,
    ),
    (getBasicCameraViewFunc, cloneBasicCameraViewFunc, addBasicCameraViewFunc),
    (
      getPerspectiveCameraProjectionFunc,
      clonePerspectiveCameraProjectionFunc,
      addPerspectiveCameraProjectionFunc,
    ),
    (
      getScriptFunc,
      cloneScriptFunc,
      addScriptFunc,
    ),
  ) as funcs,
  isDebug,
  countRange,
  cloneConfig,
  (sourceTransform, clonedParentTransforms),
  (sourceGameObject, totalClonedGameObjects),
) => {
  let (gameObjectState, clonedGameObjects) = _createClonedGameObjects(
    gameObjectState,
    countRange,
    sourceGameObject,
  )

  let totalClonedGameObjects =
    totalClonedGameObjects->Meta3dCommonlib.ListSt.push(clonedGameObjects)

  let (
    (
      transformState,
      pbrMaterialState,
      geometryState,
      directionLightState,
      arcballCameraControllerState,
      basicCameraViewState,
      perspectiveCameraProjectionState,
      scriptState,
    ),
    clonedTransforms,
  ) = CloneGameObjectComponentUtils.clone(
    (
      transformState,
      pbrMaterialState,
      geometryState,
      directionLightState,
      arcballCameraControllerState,
      basicCameraViewState,
      perspectiveCameraProjectionState,
      scriptState,
    ),
    (
      (cloneTransformFunc, addTransformFunc),
      (getPBRMaterialFunc, clonePBRMaterialFunc, addPBRMaterialFunc),
      (getGeometryFunc, cloneGeometryFunc, addGeometryFunc),
      (getDirectionLightFunc, cloneDirectionLightFunc, addDirectionLightFunc),
      (
        getArcballCameraControllerFunc,
        cloneArcballCameraControllerFunc,
        addArcballCameraControllerFunc,
      ),
      (getBasicCameraViewFunc, cloneBasicCameraViewFunc, addBasicCameraViewFunc),
      (
        getPerspectiveCameraProjectionFunc,
        clonePerspectiveCameraProjectionFunc,
        addPerspectiveCameraProjectionFunc,
      ),
      (
        getScriptFunc,
        cloneScriptFunc,
        addScriptFunc,
      ),
    ),
    isDebug,
    countRange,
    cloneConfig,
    sourceTransform,
    (sourceGameObject, clonedGameObjects),
  )

  let transformState =
    transformState->_setParent(setTransformDataFunc, clonedParentTransforms, clonedTransforms)

  getTransformDataFunc(.
    transformState,
    sourceTransform,
    Meta3dComponentTransformProtocol.Index.dataName.children,
  )
  ->Meta3dCommonlib.NullableSt.map((. children) => {
    children
    ->Obj.magic
    ->Meta3dCommonlib.ArraySt.reduceOneParam(
      (. (states, totalClonedGameObjects), childTransform) => {
        _clone(
          states,
          funcs,
          isDebug,
          countRange,
          cloneConfig,
          (childTransform, clonedTransforms),
          (
            getTransformGameObjectsFunc(.
              transformState,
              childTransform,
            )->Meta3dCommonlib.ArraySt.unsafeGetFirst,
            totalClonedGameObjects,
          ),
        )
      },
      (
        (
          gameObjectState,
          transformState,
          pbrMaterialState,
          geometryState,
          directionLightState,
          arcballCameraControllerState,
          basicCameraViewState,
          perspectiveCameraProjectionState,
          scriptState,
        ),
        totalClonedGameObjects,
      ),
    )
  })
  ->Meta3dCommonlib.NullableSt.getWithDefault((
    (
      gameObjectState,
      transformState,
      pbrMaterialState,
      geometryState,
      directionLightState,
      arcballCameraControllerState,
      basicCameraViewState,
      perspectiveCameraProjectionState,
      scriptState
    ),
    totalClonedGameObjects,
  ))
}

let clone = (
  (
    gameObjectState,
    transformState,
    pbrMaterialState,
    geometryState,
    directionLightState,
    arcballCameraControllerState,
    basicCameraViewState,
    perspectiveCameraProjectionState,
    scriptState
  ) as states,
  ((getTransformFunc, _, _, _, _, _), _, _, _, _, _, _, _) as funcs,
  isDebug,
  count,
  cloneConfig,
  sourceGameObject,
) => {
  let countRange = Meta3dCommonlib.ArraySt.range(0, count - 1)

  getTransformFunc(. transformState, sourceGameObject)
  ->Meta3dCommonlib.NullableSt.map((. sourceTransform) => {
    let (states, clonedGameObjects) = _clone(
      states,
      funcs,
      isDebug,
      countRange,
      cloneConfig,
      (sourceTransform, []),
      (sourceGameObject, list{}),
    )

    (states, clonedGameObjects->Meta3dCommonlib.ListSt.toArray)
  })
  ->Meta3dCommonlib.NullableSt.getWithDefault((states, []))
}
