# Welcome to the Pentesting-Methodology

## Networking
| slash notation | net mask        | hex        | binary representation               | number of hosts |
|----------------|-----------------|------------|-------------------------------------|-----------------|
| /0             | 0.0.0.0         | 0x00000000 | 00000000 00000000 00000000 00000000 | 4294967296      |
| /1             | 128.0.0.0       | 0x80000000 | 10000000 00000000 00000000 00000000 | 2147483648      |
| /2             | 192.0.0.0       | 0xc0000000 | 11000000 00000000 00000000 00000000 | 1073741824      |
| /3             | 224.0.0.0       | 0xe0000000 | 11100000 00000000 00000000 00000000 | 536870912       |
| /4             | 240.0.0.0       | 0xf0000000 | 11110000 00000000 00000000 00000000 | 268435456       |
| /5             | 248.0.0.0       | 0xf8000000 | 11111000 00000000 00000000 00000000 | 134217728       |
| /6             | 252.0.0.0       | 0xfc000000 | 11111100 00000000 00000000 00000000 | 67108864        |
| /7             | 254.0.0.0       | 0xfe000000 | 11111110 00000000 00000000 00000000 | 33554432        |
| /8             | 255.0.0.0       | 0xff000000 | 11111111 00000000 00000000 00000000 | 16777216        |
| /9             | 255.128.0.0     | 0xff800000 | 11111111 10000000 00000000 00000000 | 8388608         |
| /10            | 255.192.0.0     | 0xffc00000 | 11111111 11000000 00000000 00000000 | 4194304         |
| /11            | 255.224.0.0     | 0xffe00000 | 11111111 11100000 00000000 00000000 | 2097152         |
| /12            | 255.240.0.0     | 0xfff00000 | 11111111 11110000 00000000 00000000 | 1048576         |
| /13            | 255.248.0.0     | 0xfff80000 | 11111111 11111000 00000000 00000000 | 524288          |
| /14            | 255.252.0.0     | 0xfffc0000 | 11111111 11111100 00000000 00000000 | 262144          |
| /15            | 255.254.0.0     | 0xfffe0000 | 11111111 11111110 00000000 00000000 | 131072          |
| /16            | 255.255.0.0     | 0xffff0000 | 11111111 11111111 00000000 00000000 | 65536           |
| /17            | 255.255.128.0   | 0xffff8000 | 11111111 11111111 10000000 00000000 | 32768           |
| /18            | 255.255.192.0   | 0xffffc000 | 11111111 11111111 11000000 00000000 | 16384           |
| /19            | 255.255.224.0   | 0xffffe000 | 11111111 11111111 11100000 00000000 | 8192            |
| /20            | 255.255.240.0   | 0xfffff000 | 11111111 11111111 11110000 00000000 | 4096            |
| /21            | 255.255.248.0   | 0xfffff800 | 11111111 11111111 11111000 00000000 | 2048            |
| /22            | 255.255.252.0   | 0xfffffc00 | 11111111 11111111 11111100 00000000 | 1024            |
| /23            | 255.255.254.0   | 0xfffffe00 | 11111111 11111111 11111110 00000000 | 512             |
| /24            | 255.255.255.0   | 0xffffff00 | 11111111 11111111 11111111 00000000 | 256             |
| /25            | 255.255.255.128 | 0xffffff80 | 11111111 11111111 11111111 10000000 | 128             |
| /26            | 255.255.255.192 | 0xffffffc0 | 11111111 11111111 11111111 11000000 | 64              |
| /27            | 255.255.255.224 | 0xffffffe0 | 11111111 11111111 11111111 11100000 | 32              |
| /28            | 255.255.255.240 | 0xfffffff0 | 11111111 11111111 11111111 11110000 | 16              |
| /29            | 255.255.255.248 | 0xfffffff8 | 11111111 11111111 11111111 11111000 | 8               |
| /30            | 255.255.255.252 | 0xfffffffc | 11111111 11111111 11111111 11111100 | 4               |
| /31            | 255.255.255.254 | 0xfffffffe | 11111111 11111111 11111111 11111110 | 2               |
| /32            | 255.255.255.255 | 0xffffffff | 11111111 11111111 11111111 11111111 | 1               |


## **Recon & Analysis** 
- **Identify web server and technologies**
- **Bruteforce subdomains**
    - Sublist3r
    - Knock 
    - Amass
    - Subbrute
    - dnsrecon
- **Directory enumeration**
    - dirb
    - gobuster 
    - dirsearch
    - ffuf
    - nikto
- **Find users, leaked emails, ids, etc**
- **Always try _/robots..txt,/sitemap.xml,/crossdomain.xml_**
- **Google Dorking**


    `site:`  You can use this command to include only results on a given hostname. 
    
    `intitle:` This command filters according to the title page.
    
    `inurl:` Similar to intitle but works on the URL of a resource. 
    
    `filetype:` This filters by using the file extension of a resource.
    
    `AND, OR, &, |` Use of logical operators to combine expressions.

- **Wayback urls**

## **Routing/Pivoting** 
`ip route - prints the routing table for the host you are on`

`ip route add ROUTETO via ROUTEFROM - add a route to a new network if on a switched network and you need to pivot`

## Network Enumeration 

- Using material found on the machine. The hosts file or ARP cache, for example

- Using pre-installed tools

- Using statically compiled tools

- Using scripting techniques

- Using local tools through a proxy

    `arp -a (can be used to check the arp cache of the machine)` 
    
    `nano /etc/hosts (on linux, static mappings may be found)` 
    
    `/etc/resolv.conf (on Linux, may identify any local DNS servers, which may be misconfigured to allow a DNS zone transfer attack)`
    
    `nmcli dev show (reading resolve.conf)` 
    
    `C:\Windows\System32\drivers\etc\hosts (On windows)` 
    
    `ipconfig /all (Check the DNS servers for an interface)` 
    
 ### Proxychains 
    - /etc/proxychains.conf 
    [proxylist] & [proxy_dns]
    
    sock4[5] 127.0.0.1 <port>
    
    proxychains telnet 172.16.0.100 23
    
    

### IP

```bash
ip route add 192.168.72.23 via 10.10.10.10(VPN Gateway)
```

### Network

```bash
ip route add 192.168.72.0/24 via 10.10.10.10(VPN Gateway)
```


## **Enumeration (Ping Sweep)**

**`fping -a -g 10.10.10.0/24 2>/dev/null`**

**`nmap -sn 10.10.10.0/24`**

#### Nmap Scan (Full)
`nmap -sC -sV -p- <IP>`
    
    
#### Nmap Scan (UDP quick) 

`nmap -sU -sV <IP>`

## Web Applications 

### Banner Grabbing
    nc -v 10.10.10.10 port
    HEAD / HTTP/1.0
### OpenSSL for HTTPS services
    openssl s_client -connect 10.10.10.10:443
    HEAD / HTTP/1.0
### Httprint
    httprint -P0 -h 10.10.10.10 -s /path/to/signaturefile.txt
### HTTP Verbs
    GET, POST, HEAD, PUT, DELETE, OPTIONS
#### Use the OPTIONS verb to see if other verbs are avaliable on the web server 

    nc 10.10.10.10 80
    OPTIONS / HTPP/1.0
#### You can use HTTP verbs to upload a php shell. Find the content length, then use PUT to upload the shell. Make sure you include the size of the payload when using the PUT command.
    wc -m shell.php
    x shell.php

    PUT /shell.php
    Content-type: text/html
    Content-length: x
    Directory and File Scanning
    
### Windows Shares Using Null sessions and Exploitation 
   `nmblookup -A <target IP>` - NetBIOS over TCP/IP client used to lookup NetBIOS names   
   
   `nbtstat -A <IP>` - (Windows) Displays protocols satistics and current TCP/IP connections using NBT 
       
   `net view <target ip>` - Tool for administration of Samba and remote CIFS servers 
   
   `exlpoit/windows/localbypassuac` - (Metasploit module) Windows UAC protection bypass
   
    <20> record tells us that the file sharing service is up and running

    
### Enum4linux    
 
    enum4linux -a 10.10.10.10
    
    enum4linux -S(enumerate shares) X.X.X.X
    
    enum4linux -U(enumerate users) X.X.X.X
    
    enum4linux -P(check password policy) X.X.X.X
 
 
####  Nmap scripts for smb 

    nmap -script=smb-enum-shares
    
    nmap -script=smb-enum-users
    
    nmap -script=smb-brute
    
    nmap --script smb-check-vulns.nse --script-args=unsafe-1 

    exlpoit/windows/localbypassuac
    
### Using SAMBA 

    -L - allows you to look at what services are avaliable on a target. prepend //<IP ADDRESS>
    
    -N - forces the tool to not ask for a password 
    
    smbclient [-U username] [-P password or -N for no password] -L \\\\X.X.X.X
    
    smbclient [-U username] [-P password or -N for no password] \\\\X.X.X.X\\share
    
    smbclient -L //10.10.10.10 -N (list shares)
    
    smbclient //10.10.10.10/share -N (mount share)
    
    smbclient //X.X.X.X/IPC$ -N 
    

 ### ArpSpoofing 
 
    echo 1 > /proc/sys/net/ipv4/ip_forward
    
    arpspoof -i <interface> -t <target> -r <host>
    
    
### SQLMap 
    sqlmap -u <URL> -p <injection parameter> [options]
    
    sqlmap -u http://10.10.10.10 -p parameter
    
    sqlmap -u http://10.10.10.10  --data POSTstring -p parameter
    
    sqlmap -u http://10.10.10.10 --os-shell
    
    sqlmap -u http://10.10.10.10 --dump
    
    --cookie (specifiying cookie)
    
### SQL commands 

    update <table> set <parameter>="yes" where <Parameter>="<data";

    
### Password Attacks

#### Unshadow
This prepares a file for use with John the Ripper
    
    unshadow passwd shadow > unshadow

#### Hash Cracking
    john -wordlist /path/to/wordlist -users=users.txt hashfile

### SCP - securely transfering files from machine to machine 
    scp <user>@<ip>/etc/passwd .

### SQL injection 
   `user()` returns the name of the user currently using the database
   
   `substring()` returns a substring of a given arguement. It takes three parameters: the input string, the position of the substring and its length
   
   
#### Port fowarding 

   `Use of Metasploit - (portfwd) -h`
    
    Port forwarding is accomplished with the -L switch, which creates a link to a Local port.
    
    ssh -L 8000:172.16.0.10:80 user@172.16.0.5 -fN 
    
   -f backgrounds the shell, -N tells SSH that it doesn't need to execute any commands - only set up connection
    
    Proxies are made using the -D switch, for example: -D 1337
    
    ssh -D 1337 user@172.16.0.5 -fN 
    
   This again uses the -fN switches to background the shell. The choice of port 1337 is completely arbitrary -- all that matters is that the port is available and correctly set up in your proxychains (or equivalent) configuration file. Having this proxy set up would allow us to route all of our traffic through into the target network.

    
     


