/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVariable;

public class CPPField
extends CPPVariable
implements ICPPField {
    public CPPField(IASTName name) {
        super(name);
    }

    public IASTDeclaration getPrimaryDeclaration() {
        IASTDeclaration[] members;
        IASTDeclaration decl = this.findDeclaration(this.getDefinition());
        if (decl != null) {
            return decl;
        }
        IASTName[] declarations = (IASTName[])this.getDeclarations();
        if (declarations != null) {
            IASTName[] iASTNameArray = declarations;
            int n = declarations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName name = iASTNameArray[n2];
                decl = this.findDeclaration(name);
                if (decl != null) {
                    return decl;
                }
                ++n2;
            }
        }
        char[] myName = this.getNameCharArray();
        ICPPClassScope scope = (ICPPClassScope)this.getScope();
        ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)ASTInternal.getPhysicalNodeOfScope(scope);
        IASTDeclaration[] iASTDeclarationArray = members = compSpec.getMembers();
        int n = members.length;
        int n3 = 0;
        while (n3 < n) {
            IASTDeclaration member = iASTDeclarationArray[n3];
            if (member instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors;
                IASTDeclarator[] iASTDeclaratorArray = dtors = ((IASTSimpleDeclaration)member).getDeclarators();
                int n4 = dtors.length;
                int n5 = 0;
                while (n5 < n4) {
                    IASTDeclarator dtor = iASTDeclaratorArray[n5];
                    IASTName name = dtor.getName();
                    if (CharArrayUtils.equals(name.getLookupKey(), myName) && name.resolveBinding() == this) {
                        return member;
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        return null;
    }

    private IASTDeclaration findDeclaration(IASTNode node) {
        while (node != null && !(node instanceof IASTDeclaration)) {
            node = node.getParent();
        }
        if (node != null && node.getParent() instanceof ICPPASTCompositeTypeSpecifier) {
            return (IASTDeclaration)node;
        }
        return null;
    }

    @Override
    public int getVisibility() {
        ICPPASTVisibilityLabel vis = null;
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl != null) {
            IASTDeclaration[] members;
            IASTCompositeTypeSpecifier cls = (IASTCompositeTypeSpecifier)decl.getParent();
            IASTDeclaration[] iASTDeclarationArray = members = cls.getMembers();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration member = iASTDeclarationArray[n2];
                if (member instanceof ICPPASTVisibilityLabel) {
                    vis = (ICPPASTVisibilityLabel)member;
                } else if (member == decl) break;
                ++n2;
            }
            if (vis != null) {
                return vis.getVisibility();
            }
            if (cls.getKey() == 3) {
                return 3;
            }
        }
        return 1;
    }

    @Override
    public ICPPClassType getClassOwner() {
        ICPPClassScope scope = (ICPPClassScope)this.getScope();
        return scope.getClassType();
    }

    @Override
    public boolean isStatic() {
        IASTNode def;
        if (this.getDeclarations() == null && (def = this.getDefinition()) instanceof ICPPASTQualifiedName) {
            return true;
        }
        return super.isStatic();
    }

    @Override
    public boolean isMutable() {
        return this.hasStorageClass(6);
    }

    @Override
    public boolean isExtern() {
        return false;
    }

    @Override
    public ICompositeType getCompositeTypeOwner() {
        return this.getClassOwner();
    }

    public static class CPPFieldProblem
    extends ProblemBinding
    implements ICPPField {
        private ICPPClassType fOwner;

        public CPPFieldProblem(ICPPClassType owner, IASTNode node, int id, char[] arg) {
            super(node, id, arg);
            this.fOwner = owner;
        }

        @Override
        public int getVisibility() {
            return 3;
        }

        @Override
        public ICPPClassType getClassOwner() {
            return this.fOwner;
        }

        @Override
        public ICompositeType getCompositeTypeOwner() {
            return this.getClassOwner();
        }
    }
}

