/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model;

import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.util.LanguageSettingEntriesSerializer;
import org.eclipse.cdt.internal.core.SafeStringInterner;

public abstract class ACSettingEntry
implements ICSettingEntry {
    private final int fFlags;
    private final String fName;

    ACSettingEntry(String name, int flags) {
        this.fName = SafeStringInterner.safeIntern(name);
        this.fFlags = flags;
    }

    @Override
    public boolean isBuiltIn() {
        return this.checkFlags(1);
    }

    @Override
    public boolean isReadOnly() {
        return this.checkFlags(2);
    }

    protected boolean checkFlags(int flags) {
        return (this.fFlags & flags) == flags;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getValue() {
        return this.fName;
    }

    @Override
    public boolean isResolved() {
        return this.checkFlags(16);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ACSettingEntry other = (ACSettingEntry)obj;
        if (this.fFlags != other.fFlags) {
            return false;
        }
        return !(this.fName == null ? other.fName != null : !this.fName.equals(other.fName));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.fFlags;
        result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
        return result;
    }

    @Override
    public int getFlags() {
        return this.fFlags;
    }

    @Override
    public boolean equalsByContents(ICSettingEntry entry) {
        return this.equalsByName(entry);
    }

    protected int getByNameMatchFlags() {
        return this.fFlags & 0xFFFFFFEC;
    }

    @Override
    public final boolean equalsByName(ICSettingEntry entry) {
        if (entry == this) {
            return true;
        }
        if (!(entry instanceof ACSettingEntry)) {
            return false;
        }
        ACSettingEntry e = (ACSettingEntry)entry;
        if (this.getKind() != e.getKind()) {
            return false;
        }
        if (this.getByNameMatchFlags() != e.getByNameMatchFlags()) {
            return false;
        }
        return this.fName.equals(e.fName);
    }

    public final int codeForNameKey() {
        return this.getKind() + this.getByNameMatchFlags() + this.fName.hashCode();
    }

    public int codeForContentsKey() {
        return this.codeForNameKey();
    }

    public final String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(LanguageSettingEntriesSerializer.kindToString(this.getKind())).append(']').append(' ');
        buf.append(this.contentsToString());
        buf.append("; flags: ").append(LanguageSettingEntriesSerializer.composeFlagsString(this.getFlags()));
        return buf.toString();
    }

    protected abstract String contentsToString();
}

