/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.Context;
import com.microsoft.z3.IntSymbol;
import com.microsoft.z3.Native;
import com.microsoft.z3.StringSymbol;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.enumerations.Z3_symbol_kind;

public class Symbol
extends Z3Object {
    protected Z3_symbol_kind getKind() {
        return Z3_symbol_kind.fromInt(Native.getSymbolKind(this.getContext().nCtx(), this.getNativeObject()));
    }

    public boolean isIntSymbol() {
        return this.getKind() == Z3_symbol_kind.Z3_INT_SYMBOL;
    }

    public boolean isStringSymbol() {
        return this.getKind() == Z3_symbol_kind.Z3_STRING_SYMBOL;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Symbol)) {
            return false;
        }
        Symbol symbol = (Symbol)object;
        return this.getNativeObject() == symbol.getNativeObject();
    }

    public String toString() {
        try {
            if (this.isIntSymbol()) {
                return Integer.toString(((IntSymbol)this).getInt());
            }
            if (this.isStringSymbol()) {
                return ((StringSymbol)this).getString();
            }
            return "Z3Exception: Unknown symbol kind encountered.";
        }
        catch (Z3Exception z3Exception) {
            return "Z3Exception: " + z3Exception.getMessage();
        }
    }

    protected Symbol(Context context, long l) {
        super(context, l);
    }

    static Symbol create(Context context, long l) {
        switch (Z3_symbol_kind.fromInt(Native.getSymbolKind(context.nCtx(), l))) {
            case Z3_INT_SYMBOL: {
                return new IntSymbol(context, l);
            }
            case Z3_STRING_SYMBOL: {
                return new StringSymbol(context, l);
            }
        }
        throw new Z3Exception("Unknown symbol kind encountered");
    }
}

