//
// This file adds some things that are needed by VisualUefi. It should not be included under [Sources] of EDK2 .inf files.
//
#ifdef VISUALUEFI

#include <Uefi.h>
#include <Protocol/DriverSupportedEfiVersion.h>
#include <Protocol/SimpleTextInEx.h>
#include <Protocol/EfiGuard.h>
#include <Guid/Acpi.h>
#include <Library/DebugLib.h>


//
// The following fields are automatically generated by the EDK2 build system, but VisualUefi expects them in the source code.
//
CONST UINT8 _gDriverUnloadImageCount = 1;
CONST UINT32 _gUefiDriverRevision = 0x210;
CONST UINT32 _gDxeRevision = 0x210;
CHAR8 *gEfiCallerBaseName = "EfiGuardDxe";
BOOLEAN mPostEBS = FALSE;
EFI_SYSTEM_TABLE *mDebugST = NULL;


//
// EfiGuard Bootkit Driver Protocol
//
EFI_GUID gEfiGuardDriverProtocolGuid = EFI_EFIGUARD_DRIVER_PROTOCOL_GUID;


//
// GUIDs
//
EFI_GUID gEfiDriverSupportedEfiVersionProtocolGuid = EFI_DRIVER_SUPPORTED_EFI_VERSION_PROTOCOL_GUID;
EFI_GUID gEfiSimpleTextInputExProtocolGuid = EFI_SIMPLE_TEXT_INPUT_EX_PROTOCOL_GUID;
EFI_GUID gEfiAcpi20TableGuid = EFI_ACPI_20_TABLE_GUID;


//
// Placeholder definitions to make linking against BaseSynchronizationLib possible. See https://github.com/ionescu007/VisualUefi/issues/25
// This is not a problem for us because we don't use spinlocks, only interlocked operations.
//
UINTN
EFIAPI
InternalGetSpinLockProperties(
	VOID
	)
{
	ASSERT(FALSE);
	return (UINTN)-1;
}

UINT64
EFIAPI
GetPerformanceCounter(
	VOID
	)
{
	ASSERT(FALSE);
	return (UINT64)-1;
}

UINT64
EFIAPI
GetPerformanceCounterProperties(
	OUT UINT64 *StartValue OPTIONAL,
	OUT UINT64 *EndValue OPTIONAL
	)
{
	ASSERT(FALSE);
	return (UINT64)-1;
}


//
// Entry/unload handlers that VisualUefi expects with predefined names
//
EFI_STATUS
EFIAPI
EfiGuardInitialize(
	IN EFI_HANDLE ImageHandle,
	IN EFI_SYSTEM_TABLE *SystemTable
	);

EFI_STATUS
EFIAPI
UefiMain(
	IN EFI_HANDLE ImageHandle,
	IN EFI_SYSTEM_TABLE *SystemTable
	)
{
	return EfiGuardInitialize(ImageHandle, SystemTable);
}

EFI_STATUS
EFIAPI
EfiGuardUnload(
	IN EFI_HANDLE ImageHandle
	);

EFI_STATUS
EFIAPI
UefiUnload(
	IN EFI_HANDLE ImageHandle
	)
{
	return EfiGuardUnload(ImageHandle);
}

#endif // VISUALUEFI
