import mergeTW from '@/utils/mergeTW';

export const IconFirstWinnerBadge = ({
  w = '60',
  h = '60',
  className = '',
}: {
  w?: string | number;
  h?: string | number;
  className?: string;
}) => (
  <svg className={mergeTW(className)} width={w} height={h} viewBox="0 0 217 304" fill="none" xmlns="http://www.w3.org/2000/svg">
    <g filter="url(#filter0_d_3_75)">
      <rect x="96.0005" y="154.804" width="13.0851" height="46.1421" fill="url(#paint0_linear_3_75)" />
      <path d="M46.3564 57.3978H6C6.00001 88.6931 8.4 106.695 52.9887 106.695" stroke="#FFDD66" stroke-width="9" />
      <path
        d="M161.553 98.3862C161.553 131.119 135.018 157.653 102.286 157.653C69.5535 157.653 43.0187 131.119 43.0187 98.3862C43.0187 65.6538 69.5535 39.119 102.286 39.119C135.018 39.119 161.553 65.6538 161.553 98.3862Z"
        fill="#FFDD66"
      />
      <path
        d="M102.286 198.642C78.119 198.642 58.5278 205.709 58.5278 214.428H146.044C146.044 205.709 126.453 198.642 102.286 198.642Z"
        fill="#FFDD66"
      />
      <path d="M43.0187 27.7286H161.553V95.6167H43.0187V27.7286Z" fill="#FFDD66" />
      <path d="M146.044 217.474H58.5278V214.151H146.044V217.474Z" fill="#FFDD66" />
      <path d="M159.877 57.3978H200.233C200.233 88.6931 197.833 106.695 153.244 106.695" stroke="#DE9300" stroke-width="9" />
      <path
        d="M161.553 98.3862C161.553 131.119 135.018 157.653 102.286 157.653C102.286 157.653 102.286 131.119 102.286 98.3862C102.286 65.6539 102.286 39.1191 102.286 39.1191C135.018 39.1191 161.553 65.6539 161.553 98.3862Z"
        fill="url(#paint1_linear_3_75)"
      />
      <path
        d="M102.286 198.642C102.286 198.642 102.286 205.709 102.286 214.428H146.044C146.044 205.709 126.453 198.642 102.286 198.642Z"
        fill="url(#paint2_linear_3_75)"
      />
      <path d="M102.286 27.7331H161.553V95.6167H102.286V27.7331Z" fill="url(#paint3_linear_3_75)" />
      <path
        d="M146.044 217.474H102.286C102.286 217.474 102.188 215.445 102.286 214.151C103.58 197.111 146.044 214.151 146.044 214.151V217.474Z"
        fill="url(#paint4_linear_3_75)"
      />
      <circle cx="103.449" cy="91.789" r="35.4674" fill="#DCAE0C" />
      <circle cx="103.378" cy="91.3518" r="42.2857" fill="#DE9300" stroke="#FFE176" stroke-width="4.55437" />
      <path
        d="M103.378 62.1934L112.364 80.1653L130.336 82.4118L117.995 96.2501L121.35 116.109L103.378 107.123L85.4064 116.109L88.7911 96.2501L76.4204 82.4118L94.3923 80.1653L103.378 62.1934Z"
        fill="#FFF4BC"
      />
      <path
        d="M104.273 61.7462L103.378 59.9573L102.484 61.7462L93.7372 79.2394L76.2964 81.4195L74.4036 81.6561L75.6749 83.0782L87.7243 96.5572L84.4206 115.941L84.0891 117.886L85.8536 117.003L103.378 108.241L120.903 117.003L122.664 117.884L122.336 115.942L119.061 96.5572L131.082 83.0773L132.35 81.6557L130.46 81.4195L113.019 79.2394L104.273 61.7462Z"
        stroke="#C98500"
        stroke-opacity="0.7"
        stroke-width="2"
      />
      <path
        d="M30.0463 42.2268L36.2957 28.4729L30.0463 14.7189L43.8003 20.9683L57.5543 14.7189L51.3048 28.4729L57.5543 42.2268L43.8003 35.9774L30.0463 42.2268Z"
        fill="white"
      />
      <path
        d="M40.5917 229.994C40.5917 221.61 47.3886 214.813 55.7729 214.813H149.553C157.937 214.813 164.734 221.61 164.734 229.994V278.404H40.5917V229.994Z"
        fill="#243B6D"
      />
      <rect x="59.6737" y="232.501" width="88.5093" height="30.1924" fill="#F9B50E" stroke="#FFEC86" stroke-width="3.91749" />
      <path d="M64.3169 230.542H106.129L139.139 264.652H97.3265L64.3169 230.542Z" fill="#FFEC86" />
      <rect x="33.6949" y="278.404" width="137.936" height="13.2038" fill="#DE9300" />
    </g>
    <defs>
      <filter
        id="filter0_d_3_75"
        x="0.716502"
        y="13.9354"
        width="215.769"
        height="289.425"
        filterUnits="userSpaceOnUse"
        color-interpolation-filters="sRGB"
      >
        <feFlood flood-opacity="0" result="BackgroundImageFix" />
        <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha" />
        <feOffset dx="5.48449" dy="5.48449" />
        <feGaussianBlur stdDeviation="3.13399" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0" />
        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_3_75" />
        <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_3_75" result="shape" />
      </filter>
      <linearGradient id="paint0_linear_3_75" x1="102.543" y1="154.804" x2="102.543" y2="200.946" gradientUnits="userSpaceOnUse">
        <stop stop-color="#C07F00" />
        <stop offset="1" stop-color="#DE9300" />
      </linearGradient>
      <linearGradient id="paint1_linear_3_75" x1="161.145" y1="87.5007" x2="101.728" y2="87.5007" gradientUnits="userSpaceOnUse">
        <stop stop-color="#DE9300" />
        <stop offset="1" stop-color="#FFBC11" />
      </linearGradient>
      <linearGradient id="paint2_linear_3_75" x1="161.145" y1="87.5007" x2="101.728" y2="87.5007" gradientUnits="userSpaceOnUse">
        <stop stop-color="#DE9300" />
        <stop offset="1" stop-color="#FFBC11" />
      </linearGradient>
      <linearGradient id="paint3_linear_3_75" x1="161.145" y1="87.5007" x2="101.728" y2="87.5007" gradientUnits="userSpaceOnUse">
        <stop stop-color="#DE9300" />
        <stop offset="1" stop-color="#FFBC11" />
      </linearGradient>
      <linearGradient id="paint4_linear_3_75" x1="161.145" y1="87.5007" x2="101.728" y2="87.5007" gradientUnits="userSpaceOnUse">
        <stop stop-color="#DE9300" />
        <stop offset="1" stop-color="#FFBC11" />
      </linearGradient>
    </defs>
  </svg>
);
