# Contribution Guidelines

Thank you for your interest in contributing to the DevHunt project! We appreciate your support and welcome any contributions that can help improve the project. To ensure a smooth collaboration, please follow these guidelines when making contributions:

## How to Contribute 
- Please create an issue before creating a pull request.
- Before creating a new issue, please check the existing issues to ensure that it hasn't already been reported. When creating a new issue, provide as much detail as possible.
- Fork the repository and create a branch for any issue that you are working on.
- Create a pull request which will be promptly reviewed and suggestions would be added to improve it.
- Add Screenshots or screen record to help us know what you contribute.

## Pull Requests 🚀:
We appreciate and value contributions from the community. If you would like to contribute to the DevHunt project, please follow these steps to submit a pull request:

**1.** Fork the Repository:
Start by forking the DevHunt repository to your GitHub account. This will create a copy of the project under your account, which you can freely modify.

**2.** Clone the forked repository:

**3.** Navigate to the project directory.

**4.** Create a new branch:

**5.** Make the necessary changes.
If you're introducing new features or modifying existing ones, it is important to include appropriate tests to validate the functionality of your changes. Run the existing tests locally to confirm that they pass before submitting your pull request.

**6.**  Submitting Pull Requests:
When you're ready to submit your changes, create a pull request (PR) from your branch to the main branch of the original DevHunt repository. Include a detailed description of the changes introduced by your PR. If your PR addresses an existing issue, please mention it in the description.

**7.** Congratulations! You've made your first pull request ☺!
The project maintainers will review your pull request. Be prepared to make any necessary changes or address any feedback provided by the reviewers. Your contributions will be evaluated based on their quality, adherence to guidelines, and their overall impact on the project.


Thank you for considering contributing to the DevHunt project. We greatly appreciate your support and look forward to your valuable contributions.





