## ✨大厂面经
> 2023年的秋招面经不多，面试机会几乎都没有，并且有很多大厂简历挂、笔试挂(注：笔试挂有可能是被系统判定作弊，可参考[在线笔试作弊评判标准](https://github.com/Mapshiny/CampusRecruit/tree/main/%E8%B8%A9%E5%9D%91%E7%BB%8F%E9%AA%8C))，不给丝毫面试机会。因此，本目录暂时仅提供部分公司面经，后续会陆续更新。如果有面经，欢迎提交PR。

## 📖目录

| 公司     | 面经直达             |
| -------- | -------------------- |
| 阿里巴巴 | [阿里巴巴面经汇总](./阿里巴巴) |
| 百度     | [百度面经汇总](./百度)     |
| 华为     | [华为面经汇总](./华为)     |
| 腾讯     | [腾讯面经汇总](./腾讯)     |
| 字节     | [字节跳动面经汇总](./字节) |
| 蔚来     | [蔚来面经汇总](./蔚来)     |
| 深信服   | [深信服面经汇总](./深信服)   |
| 美团     | [美团面经汇总](./美团)     |
| 其他公司 | [其他公司面经汇总](./其他) |


## 🐻面经

> 本文档主要记录23届面试的一些常见问题以及一些面试经验，按[通用](#common)、[Java](#java)、[C++](#cpp)、[前端](#frontend)、[Linux](#linux)、[Mysql](#mysql)、[Redis](#redis)进行内容整理，希望能帮助到大家。

## <span id="common">通用面经</span>

- 项目中遇到了什么困难? 如何解决的?
- 最近遇到过的困难？**注意：**不要小瞧这些生活问题，非常容易尬住回答不出！
- 快速排序算法的原理是什么?
- Git
- 介绍研究生期间的课题和项目
- 实习内容



## <span id="java">Java</span>

- DAO层怎么开发的 
- 数据库表怎么设计的，表之间的关联怎么实现的 
- 项目里面用到了什么设计模式 
- Kafka在项目里怎么用的 
- Redis在项目里怎么用的，为什么用redis ？
- redis为什么这么快（从线程模型6.0之前和之后，多路复用select，poll和epoll，数据结构展开） 

- finally 块中的代码什么时候被执行？
- finally 是不是一定会被执行到？
- try-catch-finally 中，如果 catch 中 return 了，finally 还会执行吗？
- try-catch-finally 中那个部分可以省略？
- Error 和 Exception 的区别？
- 运行时异常与受检异常有何异同？
- throw 和 throws 的区别？
- 常见的异常类有哪些？
- 主线程可以捕获到子线程的异常吗？

- HashMap 的 get 方法能否判断某个元素是否在 map 中？
- HashMap 与 HashTable 的区别是什么？
- HashMap 与 ConcurrentHashMap 的区别是什么?
- HashTable 和 ConcurrentHashMap 的区别？
- ConcurrentHashMap 的实现原理是什么？
- HashSet 的实现原理？
- HashSet 怎么保证元素不重复的？
- LinkedHashMap 的实现原理?
- Iterator 怎么使用？有什么特点？
- Iterator 和 ListIterator 有什么区别？
- Iterator 和 Enumeration 接口的区别？
- fail-fast 与 fail-safe 有什么区别？
- Collection 和 Collections 有什么区别？

- 乐观锁的缺点有哪些？
- CAS 和 synchronized 的使用场景？
- 简单说下对 Java 中的原子类的理解？
- atomic 的原理是什么？
- 说下对同步器 AQS 的理解？
- AQS 的原理是什么？
- AQS 对资源的共享模式有哪些？
- AQS 底层使用了模板方法模式，你能说出几个需要重写的方法吗？
- 说下对信号量 Semaphore 的理解？
- CountDownLatch 和 CyclicBarrier 有什么区别？
- 说下对线程池的理解？为什么要使用线程池？
- 创建线程池的参数有哪些？
- 如何创建线程池？
- 线程池中的的线程数一般怎么设置？需要考虑哪些问题？
- 执行 execute() 方法和 submit() 方法的区别是什么呢？
- 说下对 Fork和Join 并行计算框架的理解？
- JDK 中提供了哪些并发容器？
- 谈谈对 CopyOnWriteArrayList 的理解？
- 谈谈对 BlockingQueue 的理解？分别有哪些实现类？
- 谈谈对 ConcurrentSkipListMap 的理解？

- 什么是浮动垃圾？
- 什么是内存碎片？如何解决？
- 常用的垃圾收集器有哪些？
- 谈谈你对 CMS 垃圾收集器的理解？
- 谈谈你对 G1 收集器的理解？
- 说下你对垃圾回收策略的理解/垃圾回收时机？
- 谈谈你对内存分配的理解？大对象怎么分配？空间分配担保？
- 说下你用过的 JVM 监控工具？
- 如何利用监控工具调优？
- JVM 的一些参数？
- 谈谈你对类文件结构的理解？有哪些部分组成？
- 谈谈你对类加载机制的了解？
- 类加载各阶段的作用分别是什么？
- 有哪些类加载器？分别有什么作用？
- 类与类加载器的关系?
- 谈谈你对双亲委派模型的理解？工作过程？为什么要使用
- 怎么实现一个自定义的类加载器？需要注意什么？
- 怎么打破双亲委派模型？
- 有哪些实际场景是需要打破双亲委派模型的？
- 谈谈你对编译期优化和运行期优化的理解？
- 为何 HotSpot 虚拟机要使用解释器与编译器并存的架构？
- 说下你对 Java 内存模型的理解？

- 谈谈你对 MVC 模式的理解？
- SpringMVC 的工作原理/执行流程？
- SpringMVC 的核心组件有哪些？
- SpringMVC 常用的注解有哪些？
- @RequestMapping 的作用是什么？
- 如何解决 POST 请求中文乱码问题，GET 的又如何处理呢？
- SpringMVC 的控制器是不是单例模式，如果是会有什么问题，怎么解决？
- SpringMVC 怎么样设定重定向和转发的？
- SpringMVC 里面拦截器是怎么写的？
- SpringMVC 和 Struts2 的区别有哪些?
- 谈谈你对 MyBatis 的理解？
- MyBaits 的优缺点有哪些？
- MyBatis 与 Hibernate 有哪些不同？
- MyBatis 中 #{} 和 ${}的区别是什么？
- MyBatis 是如何进行分页的？分页插件的原理是什么？
- MyBatis 有几种分页方式？
- MyBatis 逻辑分页和物理分页的区别是什么？
- MyBatis 是否支持延迟加载？如果支持，它的实现原理是什么？
- 说一下 MyBatis 的一级缓存和二级缓存？

## <span id="cpp">C/C++</span>

- 内存泄露，你是怎么定位的? gdb 调试定位到具体的模块，然后分析代码实现部分。
- malloc 和 new 区别？虚拟内存和物理内存
- 左值右值
- 内存对齐, 为什么要对齐？（计算机取数据按总线宽度进行取，一次取整个总线宽度的数据，对齐保证一次取完）
- Cache line
- new 和 malloc区别
- 软中断和硬中断的区别
- 讲一下系统调用，以及为什么要系统调用
- 用户态和内核态的区别，以及系统为什么要分用户态与内核态 
- static修饰的函数外部文件能调用吗？为什么不可以？
- STL容器有哪些，实现原理讲一下？vector的扩容过程？hash表出现hash冲突后采用什么方法？
- 继承 多态，使用场景？ 重载和覆盖的区别？为什么C++可以有重名函数？虚函数考察？在C程序中直接调用C++的库会成功吗？为什么？
- volatile修饰？ 
- C++的类对象可以用memset进行初始化吗？如果只有正常的成员变量和方法可以吗？
- 10万个号码，都是6位数，查找某个号码在不在集合中？最好时间复杂度为O(1) 
- 三次握手？为什么是四次挥手？客户端先发起关闭请求还是服务端？为什么？
- 浏览器访问域名的过程？
- 问了c++文件编译过程
- 静态链接动态链接区别
- 动态链接库具体怎样操作链接的 
- c++多态，volatile、static关键字

- C和C++区别
- 讲讲多态
- http在七层模型和四层模型哪一层
- vector set map
- 红黑树
- linux 讲讲shell  grep查询非这个字符串的命令  
- 写过makefile吗, 说说你知道的makefile的函数
- 用过数据库吗, 说说主键和索引
- 为什么需要索引,索引为什么查询快
- 项目代码几行,有哪些文件,用过什么开源库 


## <span id="linux">Linux</span>

-  Linux 下可以查看系统启动时间的命令 ？ 可以的命令：w，uptime，top；不可以的命令：ps。 
-  select, poll, epoll 的区别? 
-  查看进程的所有命令，根据文件名查找其所在目录，修改文件的权限  
-  线程和进程的区别
-  线程之间如何通信的 

- 简单说下你对并发和并行的理解？
- 同步、异步、阻塞、非阻塞的概念
- 进程和线程的基本概念
- 进程与线程的区别？
- 为什么有了进程，还要有线程呢？
- 进程的状态转换
- 进程间的通信方式有哪些？
- 进程的调度算法有哪些？
- 什么是死锁？
- 产生死锁的原因？
- 死锁产生的必要条件？
- 解决死锁的基本方法？
- 怎么预防死锁？
- 怎么避免死锁？
- 怎么解除死锁？
- 什么是缓冲区溢出？有什么危害？
- 分页与分段的区别？
- 物理地址、逻辑地址、虚拟内存的概念
- 页面置换算法有哪些？
- 谈谈你对动态链接库和静态链接库的理解？
- 外中断和异常有什么区别？
- 一个程序从开始运行到结束的完整过程，你能说出来多少？
- 什么是用户态和内核态
- 用户态和内核态是如何切换的？
- 进程终止的方式
- 守护进程、僵尸进程和孤儿进程
- 如何避免僵尸进程？
- 介绍一下几种典型的锁？
- 常见内存分配内存错误
- 内存交换中，被换出的进程保存在哪里？
- 原子操作的是如何实现的
- 抖动你知道是什么吗？它也叫颠簸现象


## <span id="net">计算机网络</span>

-  粘包？Tcp是面向字节流的无边界协议
-  http和https的区别？https是http的安全版，https需要证书，http不需要...TLS握手等
-  拥塞控制和流量控制
-  http状态码，知道的都说出来 
-  HTTP缓存了解吗？ 强缓存协商缓存区别？ last-midified有什么缺点？etag有什么缺点？
-  HTTP2.0是如何解决“队头阻塞”的问题？ 

- 为什么需要三次握手？两次不行？
- 为什么需要四次挥手？三次不行？
- TCP与UDP有哪些区别？各自应用场景？
- HTTP1.0，1.1，2.0 的版本区别
- POST和GET有哪些区别？各自应用场景？
- HTTP 哪些常用的状态码及使用场景？
- HTTP状态码301和302的区别，都有哪些用途？
- 在交互过程中如果数据传送完了，还不想断开连接怎么办，怎么维持？
- HTTP 如何实现长连接？在什么时候会超时？
- TCP 如何保证有效传输及拥塞控制原理
- IP地址有哪些分类？
- GET请求中URL编码的意义
- 什么是SQL 注入？举个例子？
- 谈一谈 XSS 攻击，举个例子？
- 讲一下网络五层模型，每一层的职责？
- 简单说下 HTTPS 和 HTTP 的区别
- 对称加密与非对称加密的区别
- 简单说下每一层对应的网络协议有哪些？
- ARP 协议的工作原理？
- TCP 的主要特点是什么？
- UDP 的主要特点是什么？
- TCP 和 UDP 分别对应的常见应用层协议有哪些？
- 为什么 TIME-WAIT 状态必须等待 2MSL 的时间呢？
- 保活计时器的作用？
- TCP 协议是如何保证可靠传输的？
- 谈谈你对停止等待协议的理解？
- 谈谈你对 ARQ 协议的理解？
- 谈谈你对滑动窗口的了解？
- 谈下你对流量控制的理解？
- 谈下你对 TCP 拥塞控制的理解？使用了哪些算法？
- 什么是粘包？
- TCP 黏包是怎么产生的？
- 怎么解决拆包和粘包？
- forward 和 redirect 的区别？
- HTTP 方法有哪些？
- 在浏览器中输入 URL 地址到显示主页的过程？
- DNS 的解析过程？
- 谈谈你对域名缓存的了解？
- 谈下你对 HTTP 长连接和短连接的理解？分别应用于哪些场景？
- HTTPS 的工作过程？
- HTTP 和 HTTPS 的区别？
- HTTPS 的优缺点？
- 什么是数字签名？
- 什么是数字证书？
- Cookie 和 Session 有什么区别？



## <span id="frontend">前端</span>


-  Webpack的loader和plugin的区别？
-  前端监控了解吗？我以为是性能监控，面试官提醒是错误监控，然后我说了Vue中的三种方案
-  webpack的source-map了解吗？ 
-  HTTP长连接的缺点?为什么会有队头阻塞？ 
-  说一下回流和重绘？ 
-  CSS transform是如何减少回流和重绘的？ 回答了CSS3硬件加速 
-  那浏览器是如何开启硬件加速的呢？ 回答了浏览器多进程模型，GPU进程负责调度资源 
-  plugin在webpack中的内部运行机制了解吗？ 答了compiler事件钩子相关，但没说清楚，没达到面试官要求 


- HTTP 不同版本的差异
- HTTP2 头部压缩是怎么实现的
- HTTP2 帧传输怎么保证不互串
- HTTPS 加密的过程
- 客户端和服务器端怎么保持互信
- display none 会改变布局树嘛或 DOM 树嘛
- 行内元素会存在在 DOM 树上嘛
- JS 加载运行过程, 为什么 script 标签需要阻塞渲染
- setTimeout 执行过程, 回调时间是谁去判断的, 为什么会有延迟
- requestAnimationFrame 原理是什么, 为什么能保证调用率
- 解释一下作用域和作用域链
- 闭包会造成内存溢出嘛
- 实习 React 为什么要结合 Next.js?
- 聊聊 SSR 过程
- 了解渐进式渲染和流式渲染嘛
- 解释一下单向数据流
- React 组件通信方式
- 性能提升相关 hooks
- 项目整体性能优化有做过嘛
- webpack 如何加快编译速度
- vite 相对于 webpack 原理上的区别 

## <span id="mysql">Mysql</span>

- 请说下你对 MySQL 架构的了解？
- 一条 SQL 语句在数据库框架中的执行流程？
- 数据库的三范式是什么？
- char 和 varchar 的区别？
- varchar(10) 和 varchar(20) 的区别？
- 谈谈你对索引的理解？
- 索引的底层使用的是什么数据结构？
- 谈谈你对 B+ 树的理解？
- 为什么 InnoDB 存储引擎选用 B+ 树而不是 B 树呢？
- 谈谈你对聚簇索引的理解？
- 谈谈你对哈希索引的理解？
- 谈谈你对覆盖索引的认识？
- 索引的分类？
- 谈谈你对最左前缀原则的理解？
- 怎么知道创建的索引有没有被使用到？或者说怎么才可以知道这条语句运行很慢的原因?
- 什么情况下索引会失效？即查询不走索引？
- 查询性能的优化方法？
- InnoDB 和 MyISAM 的比较？
- 谈谈你对水平切分和垂直切分的理解？
- 主从复制中涉及到哪三个线程？
- 主从同步的延迟原因及解决办法？
- 谈谈你对数据库读写分离的理解？
- 请你描述下事务的特性？
- 谈谈你对事务隔离级别的理解？
- 解释下什么叫脏读、不可重复读和幻读？
- MySQL 默认的隔离级别是什么？
- 谈谈你对MVCC 的了解？
- 说一下 MySQL 的行锁和表锁？
- InnoDB 存储引擎的锁的算法有哪些？
- MySQL 问题排查都有哪些手段？
- MySQL 数据库 CPU 飙升到 500% 的话他怎么处理？


## <span id="redis">Redis</span>

- 谈下你对 Redis 的了解？
- Redis 一般都有哪些使用场景？
- Redis 有哪些常见的功能？
- Redis 支持的数据类型有哪些？
- Redis 为什么这么快？
- 什么是缓存穿透？怎么解决？
- 什么是缓存雪崩？该如何解决？
- 怎么保证缓存和数据库数据的一致性？
- Redis 持久化有几种方式？
- Redis 怎么实现分布式锁？
- Redis 淘汰策略有哪些？
- Redis 常见性能问题和解决方案？