---
id: history
title: Lending & Borrowing
---

## What is Blockchain Based Lending?

Blockchain based lending, also known as decentralized lending or DeFi lending, is a rapidly growing industry which has grown in the last 3 years from a small handful of minor projects into a multi-billion dollar industry. While the approaches to making blockchain based lending possible vary widely, they all rely on the same basic principles. For each of these lending platforms, the rules governing how loans are issued and repaid are written onto the blockchain with immutable smart contracts. Those contracts replace the role of a bank in the traditional banking system, and take on the roles of loan issuer, custodian of collateral, and liquidator in cases where loans are not repaid. As the rules which govern these lending applications are publicly and immutable written in smart contracts on the blockchain, they are transparent and auditable. This is in contrast to traditional loan providers, where the terms and execution of the loan may not be transparent, and are subject to change at the whims of the issuer or local authorities. 

## Origin of Blockchain Based Lending

Bitcoin first emerged in 2008, but it wasn't until 2013 / 2014 that usage really began accelerating. In the following years, the number of Bitcoin and cryptocurrency users as well as the value of most major cryptocurrencies exploded. This resulted in the phenomena of a large group of people who were crypto-rich, but cash poor. As many BTC and other cryptocurrency holders saw the long term potential of crypto, they were reluctant to sell their cryptoassets to pay for their daily needs. This same pattern was mirrored even more extremely by Bitcoin, Ethereum, and other cryptocurrency miners. Miners secure the Bitcoin, Ethereum, or other cryptocurrency blockchains and process transactions by running blockchain software on many expensive, specially designed computers. In return for their service, they are rewarded with newly minted BTC and ETH (or whatever crypto they are mining). Since mining operations require a large upfront cash investment, their crypto-rich, cash-poor problem was even greater than the average crypto holder. 

## 2016 Crypto-Collateralized Lending is Born

In 2016, the Ethereum based SALT Lending became one of the early movers in the crypto-collateralized lending space. Their goal was to allow for users to put their BTC, ETH, or other crypocurrency up as collateral and to receive a loan either to their bank account or as stable coins to their wallet. If the value of the collateral falls close to the value of the lent assets, then the collateral will be liquidated in order to ensure the value of the loan. Users who provide the stable coins which are lent out can earn an interest rate on the assets they provide.

However, SALT is far from perfect. Unlike the the decentralized lending platforms which were to come later, SALT's lending process is entirely centralized and controlled by the SALT company itself. The company takes custody of the assets given to them as collateral by borrowers, and is responsible for managing collateral and loans. The application itself is a typical Web 2.0 web app with centralized servers and databases. They require sign-ups with email and usernames and the real world information of each user. Due to these drawbacks, SALT has been largely eclipsed today by the more decentralized options which emerged not to long after SALT. 

## 2017 to 2018: Decentralized Crypto-Collateralized Lending Makes Its Grand Entrance

2017 saw the emergence and development of both Maker DAO and Compound.Finance, who today make up two of the top three decentralized crypto collateralized lending platforms. Both of these platforms took a dramatic departure from SALT's approach by building their core functionalities entirely on the Ethereum blockchain. This means that collateral is not held and controlled by the Compound or Maker teams, but rather in unchangeable smart contracts written to the Ethereum blockchain. The rules controlling lending rates and liquidations are also controlled by smart contracts, and not by any individual people. In an even more dramatic departure from SALT, both Maker DAO and Compound have established systems of decentralized governance in which the holders of Maker's MKR token and Compound's COMP token control the development of each respective platform with voting rights equivalent to how many tokens they hold. In contrast to SALT, Maker and Compound are far more transparent, and require users to place far less reliance on trusted third parties. Both platforms are also governed entirely by the community of token holders, rather than a small group of individuals running a company. Users never need to be concerned about the safety of their funds or the honesty of someone else managing their assets, as their assets are never placed in the custody of others.

## Over Collateralized Crypto Loans

Up to now, the dominant model of crypt-lending is based on over-collateralized loans. Borrowers put up as collateral worth 150%, 200%, 300%, or even more the value of the the assets which they are borrowing in the form of cryptocurrencies such a ETH or BTC. In turn, they receive stable coins which they can use as they wish. If the value of their collateral falls below the liquidation ratio, then their collateral will be liquidated. For example, if Maker DAO has a 150% collateralization ratio on borrowing USDC, that means that in order to take out a loan of 100 dollars, borrowers must put up at least 150 dollars worth of crypto as collateral. It also means that if the value of the crypto put up as collateral falls below 150% the value of the loan, that the collateral will be liquidated (sold) and a liquidation fee will be taken as well to penalize the borrower for not ensuring their loan is properly collateralized. 

## 2019 to Today: The Decentralized Lending Space Begins to Mature

With the clear advantages to users of decentralized platforms such as Maker and Compound over centralized solutions such as SALT, in the past few years they have seen dramatic growth in both the number of users and the volume of usage. At the start if 2019, there was about 300 million USD in total value locked (TVL) in decentralized lending platforms. Today, that number stands at close to 12 billion dollars, and all signs indicate that it will only continue to grow. Maker and Compound account for over half of that number with Compound's 3 billion and Maker's 4.5 billion. They have been joined more recently by Aave, which now accounts for ~3.5 billion of market's 12 billion dollars. While together, those three platforms dominate the space, there are dozens of smaller platforms out there providing similar services, and new ones launching all the time. The market has spoken, decentralized lending is here to stay. 

## The Future: Undercollateralized Lending — Say Hello to Karma

Now overcollateralized loans work just fine for those individuals who are crypto rich and cash poor, but what about the vast majority of individuals who are not crypto rich but still require loans? For them, they don't have enough crypto to put up as collateral, but still need access to credit. This brings us to the frontier of decentralized lending — undercollateralized crypto loans. With undercollateralized crypto loans, users may borrow funds without putting up more than the value of the loan as collateral. Typically they will be required to put up some small amount of crypto collateral, but will not be required to put up more than the value of the loan itself. Undercollateralized loans are typically guaranteed by some form of social credit system. With a social credit system, users can build credit by behaving honestly. Once they reach a certain credit level, they are eligible for benefits such as access to undercollateralized loans. 

Undercollateralized loans offers credit to a far larger population than would ever be possible with over-collateralized loans. It brings financial freedom and possibilities to those who would otherwise not have them.

MANTRA DAO believes undercollateralized loans are the future decentralized lending, and is committed to making them a reality. The team is currently working on the Karma lending platform, which will allow users to leverage their social scores in order to access undercollateralized loans. Learn more about Karma [here](#).