---
id: governance
title: Governance
---

## What's a DAO?

MANTRA DAO believes in harnessing the wisdom of the crowd, and it's reflected in every part of our vision. Just take our name for example, MANTRA **_"DAO"_**. If you're not familiar, a DAO is a decentralized autonomous organization. In plain language, it is an organization run by its members according rules which are publicly and immutably set on the blockchain. DAOs combined the security and transparency of the blockchain with the power of the crowd. They allow for large groups of individuals who don't know each other to jointly govern an organization in a fair and transparent way.

### First Steps

As a DAO isn't something which can be built easily overnight, MANTRA DAO is currently still in the process of developing its decentralized governance system. Currently, users may participate in governance by voting on [MANTRA DAO's Snapshot page](https://snapshot.page/#/mantra-dao/all). Votes are decided according to votes cast by various forms of OM tokens that are held by voters (OM tokens, staked OM tokens, zenOM tokens etc).

### Next Steps

While Snapshot voting allows OM holders to participate in voting in a provably fair way, it does have some drawbacks. Perhaps the biggest drawback is that it cannot guarantee that the results of votes are carried out. Of course, for some types of votes about off-chain activities this will never be possible, for example a few of the current proposals on Snapshot for [establishing](https://snapshot.page/#/mantra-dao/proposal/QmYGEvf6hK4uCAKX6Myn67ZEHHvWo855SEL73iZDnqrJhS) [partnerships](https://snapshot.page/#/mantra-dao/proposal/QmVxySFjMZq9jTBy4YmfqqgdLEbk192TvSkHNtu7QcscP7) with other projects. However, for many proposals which are for direct modifications to specific parts of MANTRA DAO apps or protocols, guaranteed execution of voting results is possible and desirable.

The addition of guaranteed execution of voting would greatly increase the power of OM token holders, as they will then be able to directly vote for and execute modifications to the MANTRA DAO applications and protocols

Having many products across many blockchains increaces the complexity of on chain govoernance,
Our plans are to approach on chain voting by focusing at an individual product level, to target the specific product / blockchain community, while keeping the control in the domain of the OM holders and the council. The broad level governance will remain on Snapshot for the forseeable future.

While MANTRA DAO is committed to the long-term goal of truly trustless community powered governance, security is our top priority. Therefore we will work to incrementally increase the power of OM token holders to guide the development of the MANTRA DAO ecosystem going forward.

### What's a Snapshot Page?

Snapshot is an application originally developed by the good folks over at [Balancer Labs](https://balancer.finance/). It was built to solve a serious problem which had been plaguing the Ethereum community - the need for an easy to use voting solution combined with soaring gas fees.

While it's certainly possible to build a smart contract based voting system that lives on Ethereum, such a system would require a large amount of gas to use, which might discourage participation from voters who want to save their ETH.

Snapshot's ingenious solution is to simply ask users to vote by signing their vote with their private key. Since only the holder of the private key of an Ethereum address can produce a valid signature for that address, the mere existence of such a signature is enough to prove that the vote came from the owner of a particular address.

The votes are then stored using, IPFS, the popular decentralized storage solution.
