---
id: faq
title: FAQ
---

## What is MANTRA DAO?

MANTRA DAO leverages the wisdom of the crowd to create a community-governed, transparent, and decentralized ecosystem for web 3.0. Built on Parity Substrate based RioChain for the Polkadot ecosystem, MANTRA DAO gives financial control back to the people to store and grow wealth together. Essentially, we are building a community-governed DAO structure for DeFi products. Primarily focusing on Staking, Lending, and Governance. We will offer enhanced interest for our users and governance rights through our native OM TOKEN.

## What is a DAO?

DAOs, otherwise known as Decentralized Autonomous Organizations, represent a massive upgrade on the traditional firm. DAOs use blockchain technology and programmable incentives to solve issues traditionally faced by global organizations, such as financial transparency, process automation, governance, and aligning geographically-separated, individual stakeholders in pursuit of a common goal. By combining state-of-the-art technology with new token economic, governance, and financial models, DAOs can provide substantial benefits for their members. With DAOs, communities are able to leverage the strengths of all members, turning them into active stakeholders to grow the network together.

## What are the uses of OM TOKENs?

OM TOKENs are the native cryptocurrency of MANTRA DAO. OM TOKENs plays a key role in expanding and maintaining the overall MANTRA DAO ecosystem. It has several core functions:

– STAKING & LENDING: In addition to staking rewards in different DPoS+PoS assets, depositors of cryptocurrencies in MANTRA DAO will also receive OM TOKENs.

– OWNERSHIP & GOVERNANCE: OM TOKENs give voting power over certain economic parameters such as interest rates, level of inflation, ecosystem grant allocations, etc. With the structure of MANTRA DAO being a Foundation, every holder of OM is an owner of MANTRA DAO; the token holders are the owners and are who is able to democratically decide the direction the company should go in!

– REPUTATION: OM Tokenholders can grow their reputation via our KARMA Protocol and be rewarded for their contributions to MANTRA DAO.

– MANTRA POOL: OM Tokenholders will also be able to access MANTRA POOL, which is our perpetual savings game that give users the chance to win crypto every week.

## What is Staking?

Staking is a term that has to do with the Proof of Stake (PoS) verification method for transactions on PoS blockchains. Staking is when users lock their crypto assets on PoS blockchains in order to help verify transactions and support/secure the network.

Staking cryptocurrencies can be similarly viewed as putting money away in a savings account that earns you daily passive rewards. Users Stake their cryptocurrencies and are able to unlock high percentage rewards by saving them and not moving or spending them. Like a savings account, Staking accounts can be something you put crypto into and forget about. That Staked crypto is earning daily passive rewards for YOU! It is the easiest way to securely save and earn.

## What is APR?

Annual Percentage Reward (APR) refers to the annual percentage rate at which your Staking assets earn Rewards on a yearly basis.

Annual Percentage Rewards is derived from the term commonly used in traditional capital market, Annual Percentage Rate. Annual Percentage Rate refers to the annual rate of interest charged to borrowers for taking out loans and paid back to the investors who lent that capital. Instead of taking out a loan, members that are Staking crypto are locking their assets to help the blockchcain network validate transactions and be more secure, and in return are being Rewarded in crypto.

## What is DeFi (Decentralized Finance)?

Unlike traditional banking systems and Centralized Finance (CeFi), Decentralized Finance (DeFi) aims to create a financial system that is open to everyone and minimizes one’s need to trust and rely on central authorities. Technologies like the internet, cryptography, and blockchain give us the tools to collectively build and control a financial system without the need for central authorities. There’s a saying in the blockchain space: “Don’t trust, verify.” Because with a blockchain network, you as an individual can verify any and every transaction that occurs on the blockchain.

Besides just the trust factor that Blockchain and DeFi bring, it also breaks down the barriers to enter that currently exist in the traditional financial world and banks. Often times people need a minimum amount of capital to even open up a bank account which is difficult for people from some areas of the world who may only make $10 dollars a month. And this is on top of the fact that many people all over the world don’t even live close enough to a traditional bank for them to even go there. DeFi and MANTRA DAO allow for people from anywhere in the world that have access to a computer or smart phone to be able to have an account and store and grow their wealth. This is what DeFi is able to bring to the world!

## What is Proof of Stake (PoS)?

The alternative to Proof of Work (PoW) is Proof of Stake (PoS). As most recognized with Bitcoin mining, PoW requires raw processing power to verify transactions and solve cryptographic puzzles, the processing of which is wasted on calculations that have no useful purpose but at least secures the blockchain upon which the calculations are being performed. An alternative means to secure a blockchain is to staking your PoS coins on the blockchain, thus proving that you have committed financial resources to the blockchain. The next generation of blockchains, the so-called third-generation blockchains, are almost all based on PoS.

To incentivize token holders to contribute their financial resources to secure a blockchain, PoS systems must offer a reward denominated in the native coins of that blockchain. The result is a bond-like yield that can be derived from staking coins. Combined with the potential price appreciation of those staking coins, investing in PoS systems has the potential to be very rewarding, especially when you factor in the power of compounding those staking rewards.

## Is there a Minimum Staking Amount?

Minimum Staking amounts vary depending on the specific crypto.
Min. OM: 1

## What is the Minimum Amount of time I can Stake?

Staking durations vary depending on the specific crypto and PoS or DPoS blockchain.
OM: No Minimum Stake Duration
DOT: 28 Day Staking Period
KSM: 7 Day Staking Period

## Which Crypto Assets does MANTRA DAO currently support?

We are growing our Staking services every day and look forward to constantly growing this list. Currently MANTRA DAO offers staking for:

OM
RFUEL
OM/ETH UNI V2

## Does MANTRA DAO have any KYC requirements?

MANTRA DAO is currently a fully decentralized application. MANTRA DAO members have full control over their crypto, their private keys, and their identities.

In the future, MANTRA DAO does plan to incorporate specific features that would require some level of verification through providing an email, phone number, and basic KYC information. These services would include being able to participating in the KARMA Protocol and gaining access to under-collatoralized loans.

Users will always have full control over the level of information that they provide or decide not to provide.

## What is Polkadot?

Polkadot is a platform that allows diverse blockchains to transfer messages, including value, in a trust-free fashion; sharing their unique features while pooling their security. In brief, Polkadot is a scalable, heterogeneous, multi-chain technology.

Polkadot is heterogeneous because it is entirely flexible and makes no assumptions about the nature or structure of the chains in the network. Even non-blockchain systems or data structures can become parachains if they fulfill a set of criteria.

Polkadot may be considered equivalent to a set of independent chains (e.g. a set containing Ethereum, Ethereum Classic, Namecoin and Bitcoin) except with important additions: pooled security and trust-free interchain transactability.

Unlike previous blockchain implementations that provide a single chain of varying degrees of generality, Polkadot provides a Relay Chain upon which a large number of verifiable data structures may be hosted. We call these data-structures “parallelized” chains or parachains. Polkadot provides a networking and consensus layer that allows blockchain developers to focus on creating a state machine with unique features, such as formal verification or anonymity.

Polkadot consists of many parachains with potentially differing characteristics. Transactions can be spread out across the chains, allowing many more transactions to be processed in the same period of time. Polkadot ensures that the security of all blockchains in the network is robust and that any dealings between them are faithfully executed. All parachains share security and state, meaning if one chain has a message reverted, all chains get reverted. It is also possible for independent chains with their own validators to be linked to Polkadot via bridges, thereby foregoing Polkadot’s shared state and security system. These chains can benefit from Polkadot’s interoperability without being hosted on the platform, examples of these would be Bitcoin and Ethereum.

Learn more about them [here](https://polkadot.network/).

## What is Web3 foundation

Web3 Foundation is a Swiss Stiftung established under Article 80 et seqq. of the Swiss Civil Code. The Web3 Foundation was founded by Dr. Gavin Wood and has as its focus the development, deployment and maintenance of “Web3”. Web3 Foundation promotes the development of innovative technologies and applications in the field of cryptographically-enabled decentralised software protocols.

Web3 Foundation’s purpose is to nurture and steward cutting-edge technologies and applications at all levels of the Web3 technology stack. Web3’s principal focus is research, development, deployment, funding, and maintenance of Web3 technologies, plus advocacy and education, developer-adoption, support of middleware, and base-layer/demonstration applications.

The Web3 Foundation Council is Web3’s governing body, responsible for the management of the Web3 Foundation. The current members of the Web3 Foundation Council are Dr. Gavin Wood (President and Founder), Dr. Aeron Buchanan (Vice President) and Reto Trinkler.

Swiss foundations are subject to a mandatory supervision by a federal or cantonal authority. The Web3 Foundation’s application for approval by Eidgenössische Stiftungsaufsicht (Federal Foundation Supervisory Authority) was approved July 2018.

Learn more about them [here](https://web3.foundation/).

## What is Parity Substrate?

Parity Substrate is a blockchain development framework with many cool features like upgradable blockchains, modular architecture, customizable block execution logic, and hot-swappable consensus.

Learn more about them [here](https://www.parity.io/).

## Is MANTRA DAO custodial?

The security of cryptocurrency assets is one of the most important elements in the blockchain industry. Many blockchain companies have failed due to poor security procedures. Most security breaches could have been prevented by taking simple precautions to protect critical resources. MANTRA DAO will integrate a mix of noncustodial and custodial wallet solutions depending on the specific service offerings. When custody is required for specific services, MANTRA DAO will use and leverage RioChain’s enterprise-grade security solution that utilizes the strongest encryption technology available in order to have absolute trustworthiness.

As security is of the utmost importance for us, MANTRA DAO will focus on offering non-custodial services for its initial staking business line through Delegated Proof of Stake (DPoS) tokens. By utilizing and working with cryptocurrencies that are DPoS, MANTRA DAO is able to greatly reduce security risk as it will not be handling any of its members’ digital assets, having them remain at all times in the members’ custody. As additional tokens are offered that are Proof of Stake (PoS), we will maintain these through industry-leading security solutions.

The MANTRA DAO Foundation's assets are held and stored by its partner, Hex Trust. Hex Trust is a licensed and insured custody provider, and one of Asia’s leading institutional digital asset custody provider. The MANTRA DAO team will contiue to work with the Hex Trust team to integrate more custody solutions into the ecosystem as more services are rolled out. Read more about their partnership [here](https://medium.com/mantra-dao/uncompromising-security-over-users-assets-90ddaaf1e796).
