import React from 'react';

import { connect } from 'react-redux';

import { addItem } from '../../redux/cart/cart.actions';

import CustomButton from '../custom-button/custom-button.component';

import './collection-item.style.scss';

const CollectionItem = ({ item, addItem }) => {
    const { name, price, imageUrl } = item;
    let rupee = Math.floor(price*10.26).toFixed(2);;

    return (
        <div className='collection-item'>
            <div
                className='image'
                style={{
                    backgroundImage: `url(${imageUrl})`
                }}
            />
            <div className='collection-footer'>
                <span className='name'>{name}</span>
                <span className='price'>₹{rupee}</span>
            </div>
            <CustomButton onClick={() => addItem(item)} inverted>
                Add To Cart
            </CustomButton>
        </div>
    );
}

const mapDispatchToProps = (dispatch) => ({
    addItem: item => dispatch(addItem(item))
});

export default connect(
    null, 
    mapDispatchToProps
)(CollectionItem);
