# Devpost Project

## Elevator Pitch
Sport machen und dabei sich selbst und der Gesellschaft Gutes tun - indem man sich Workout-Ziele steckt und bei Nichterfüllung spenden muss.

**Was für einen gesellschaftlichen Mehrwert leistet GoBonsai?**

Die Ausbreitung von Covid-19 führt zu einem Dilemma: Gesundheitssystem und Hilfsorganisationen sind einer stetig steigenden Belastung ausgesetzt, gleichzeitig sind die Bürger:innen gezwungen, zu Hause zu bleiben, um die Ausbreitung des Erregers nicht zu verstärken. Dadurch entsteht bei ihnen Bewegungsmangel, der sowohl physische wie psychische Probleme zur Folge hat und das Gesundheitssystem langfristig zusätzlich belastet.

Die Web-App GoBonsai löst dieses Dilemma auf, indem die Anwendung einerseits auch in Zeiten von Social Distancing zu Bewegung und Sport anregt (zu Hause oder alleine im Freien) und andererseits Hilfsorganisationen finanziell unterstützt. Wer GoBonsai nutzt, tut nicht nur sich selbst etwas Gutes, sondern auch der Gesellschaft.

**Wie funktioniert GoBonsai?**

GoBonsai fördert wünschenswertes Verhalten (Bewegung) durch einen monetären Anreiz (Spende). Die Spende wird immer dann fällig, wenn man ein selbstgestecktes Ziel nicht erreicht hat. Eine typische Herausforderung könnte lauten: „Wenn ich innerhalb von vier Wochen nicht mindestens 1x pro Woche laufe und dabei nicht insgesamt 50 Kilometer zurücklege, spende ich 50 Euro an das Deutsche Rote Kreuz.“ Oder: „Wenn ich für die Dauer von zwei Wochen nicht jeden Tag 20 Minuten Yoga mache, spende ich 35 Euro an die Tafel.“

Mit GoBonsai fordert man sich selbst heraus. Man steigert so die eigene Motivation, sich zu bewegen, hat im Falle des Scheiterns aber immer noch ein gutes Gefühl, da durch die eigene Spende Sinnvolles getan wird. Beides erhöht das Gefühl der Selbstwirksamkeit und erzeugt ein Gemeinschaftsgefühl trotz Distanz.

Workout-Ziel, Spenden-Umfang und Hilfsorganisation werden selbst gewählt – die Anwendung unterstützt mit Vorschlagslisten, lässt dem Nutzer aber auch die komplett freie Wahl. 

Überprüft wird das Erreichen eines Workout-Ziels zunächst in Selbstkontrolle. Die Zahlung der Spende geschieht durch Weiterleitung auf Paypal. Auch wer sein Ziel erreicht hat, wird gefragt, ob er dennoch den vollen Betrag oder die Hälfte spenden möchte.

**Inwiefern ist GoBonsai skalierbar?**

GoBonsai ist in viele Richtungen skalierbar (s. dazu auch die MindMap im Anhang).

_Technisch:_
- Durch den Einbau von APIs zu anderen Apps wie Fitnesstrackern, wodurch etwa das Eintragen des Workout-Ziels oder die Buchung des Spendenbetrags automatisch geschieht.
- Durch die Ausweitung der Challenge-Funktionen. Denkbar wären hier zum einen Gruppen-Herausforderungen, die ein Gemeinschaftsgefühl entstehen lassen, trotz räumlich Distanz. Zum anderen die Ausweitung über sportliche Ziele hinaus - etwa andere gesundheitsfördernde Challenges wie rein pflanzliche Ernährung über einen bestimmten Zeitraum oder regelmäßige Übungen zur Förderung der mentalen Gesundheit. Auch der Umfang der voreingestellten Workout-Ziele ließe sich beliebig erweitern.
- Durch die Erweiterung der Spenden-Funktionen. Auch wer über kein Geld verfügt, soll einen Beitrag leisten können durch das Spenden von Zeit. Auch hier könnte eine Liste mit Vorschlägen voreingestellt werden (etwa Blutspenden, mit dem Hund des Nachbarn Gassi gehen, Einkäufe für Ältere erledigen, ...). Schnittstellen zu Netzwerken wie nebenan.de könnten gezielt Hilfsgesuche vermitteln.

_Wirtschaftlich:_
- GoBonsai ist eine digitale Anwendung und kann daher von einer unbegrenzten Anzahl an Usern weltweit genutzt werden.
- Da GoBonsai als Web-App konzipiert ist, kann sie unabhängig von Smartphone-Betriebssystemen genutzt werden, aber perspektivisch durch Frameworks wie React Native problemlos in die App Stores portiert werden.
- Die Anwendung kann durch Werbung finanziert werden, aber auch als kostenpflichtige Premium-Version weitere Features bieten. Denkbar ist auch, dass ein Prozentanteil der generierten Spenden einbehalten wird.
- Kooperationen mit Krankenkassen, die das Erreichen bestimmter Workout-Ziele für ihre Bonusprogramme/Präventionsmaßnahmen anerkennen, könnten zusätzliche (Spenden-)Erträge generieren.
- Kooperationen mit Unternehmen oder Influencer:innen, die ihre eigenen Challenges ihren Follower:innen zur Verfügung stellen und so mit ihrer Reichweite zur Verbreitung der App beitragen.

**In Kürze - was GoBonsai kann**

- Menschen zu mehr Bewegung und Gesundheit verhelfen
- Physischen und psychischen Erkrankungen vorbeugen
- Eine neue Quelle für Spendeneinnahmen sein
- Völlig neue Spender:innengruppen erschließen
- Das Gesundheitssystem und Hilfsorganisationen entlasten
- Ein Gefühl der Gemeinschaft und Selbstwirksamkeit erzeugen und stärken

**Zum Hintergrund:**

Der Anwendung liegt eine wissenschaftliche Untersuchung zugrunde, die bestätigt, dass sich die Mechanik eignet, um neue Spender:innengruppen zu erschließen. Auch auf bereits entwickelte Personas konnten wir zurückgreifen. Darauf basierend haben wir einen Prototypen und ein Zielbild entwickelt.

**Social Media Kampagne**
Zu finden auf https://github.com/MalteRei/wirvsvirus-hackathon-spendensport/tree/master/SocialMediaCampaign


[YouTube Video Demo](https://youtu.be/y0UAtoeRgl8)

[Devpost Link](https://devpost.com/software/spendenchallenge)
