# How to contribute

We are happy about contributions to our project, because we need volunteer developers, artists or cooperation partners to help bring this idea to life.

The master branch is protected. We have a GitHub Action in place to deploy changes made to master.

Feel free to create new issues. When doing so please start with the templates to give you a guideline and have uniform looking issues. Of course you can add more details or ommit a section in the template if you see fit. Just be sure that everyone can understand your proposal.


Here are some important resources:

  * ["What Corona, donations and sport have in common"](https://emzudemo.de/txt/was-corona-spenden-und-sport-miteinander-zu-tun-haben-koennten) tells your how this got started,
  * [explination video](https://youtu.be/y0UAtoeRgl8) shows in under 2 minutes what GoBonsai is all about, and
  * at [devpost project](https://devpost.com/software/spendenchallenge) you will find detailed information on where we are going.
  * In [Concept and Archticture](https://github.com/MalteRei/wirvsvirus-hackathon-spendensport/tree/master/Concept_and_Architecture) you can see the what we plan to do 
  * On our [Kanban Board](https://github.com/MalteRei/wirvsvirus-hackathon-spendensport/projects/1) you can find an overview of the current issues

In case you have any questions feel free to write us an email to team@gobonsai.org

## Submitting changes 📮

Please send a [GitHub Pull Request to wirvsvirus-hackathon-spendensport](https://github.com/MalteRei/wirvsvirus-hackathon-spendensport/pull/new/master) with a clear list of what you've done (read more about [pull requests](http://help.github.com/pull-requests/)). When you send a pull request, we will love you forever if you include tests examples. We can always use more test coverage. Please follow our coding conventions (below) and make sure all of your commits are atomic (one feature per commit).

If you have never worked with GitHub you can learn the [GitHub flow](https://guides.github.com/introduction/flow/)

Always write a clear log message for your commits. One-line messages are fine for small changes, but bigger changes should look like this:

    $ git commit -m "A brief summary of the commit
    > 
    > A paragraph describing what changed and its impact."

## Coding conventions ✍🏼

Start reading our code and you'll get the hang of it. We optimize for readability:

  * When writing TypeScript please check your code based on [tslint](https://github.com/MalteRei/wirvsvirus-hackathon-spendensport/blob/master/frontend/spendensport/tslint.json)
  * For the Angular frontend project please have a look at [Angular coding style guide](https://angular.io/guide/styleguide)
  * Even though the code written during the hackathon might not be the best example. Please document your code so others (and you) can understand later on.
  * Quick [guide](https://dev.to/danialmalik/a-beginner-s-guide-to-clean-code-part1-naming-conventions-139l) to clean code.
  
## Communication 💬

We decided to start documentation and communication in English. We are sorry for the mess with all the Documents in German. Feel free to translate them to English and let us know your opinion on the language choice.
Otherwise we have a meeting ever Monday and Thursday at 6:30pm (Central European Standard Time).
Please contact us (team@gobonsai.org) and we'll add you to the slack channel.

Thanks and happy coding,
GoBonsai (now including you)
