# Quick Maths

## About

Quick Maths is a web application using angular 8 that allows users to test their **mental math skills** through three tests:

* **Arithmetic (Addition, Subtraction, Multiplication, Division)**
* **Powers (Squares From 10 - 40 and Exponents From 2 - 20 of Varying Difficulty)**
* **Number Sense (Dynamically Generated Number Sense Questions)**

Quick Maths was inspired by [Zetamac](https://www.arithmetic.zetamac.com), a website that allows users to practice their arithmetic skills, and expands upon the style and mission of the website by providing additional tests as well as a leaderboard.

This project aims to expand the vision of zetamac, allowing users to also practice powers / exponents as well as UIL number sense through dynamicallly generated questions of varying degree. Furthermore, Quick Maths allows users to practice number sense tests online without having to print out previous years' tests.

## Features

### Arithmetic Test

The arithmetic test on Quick Maths allows users to set contraints on the types of arithmetic (+, -, *, /) questions that they will see on their test, as well as the time allotted to take the test. In the time which the users selects, they will have to answer as many randomly generated arithmetic questions as they can, and will be given points for each question answered. Users will not be able to skip a question, and will not be penalized directly for wrong answers.

### Powers Test

The powers test on Quick Maths lets users practice their squares from 0 - 40, cubes from 10 - 20, powers of 2 from 4 to 12, powers of 3 from 3 to 8, powers of 4 from 2 to 6, powers of 5 from 2 to 5, and powers of 6, 7, 8, and 9 from 2 to 4. The powers test also has constraints the users can set on the test such as whether to include exponents or cubes, as well as the time alotted to take the test. This power test was inspired by my high school number sense coach Mr. Newton, who prepared a powers test every time our team met.

### Number Sense Test

The most useful part of the Quick Maths application is the Number Sense Test. This test will allow users 10 minutes to complete 80 dynamically generated number sense questions, alotting 7.5 seconds for each question. The types of questions generated are taken from Bryant Heath's excellent (and free) [UIL Number Sense Tricks Manual](http://bryantheath.com/number-sense-tricks-manual/), which contains ~150 number sense tips and tricks which encompass 95% or more of the questions you are likely to encounter while taking the UIL Number Sense test.
