::MSU.AI <- {
	BehaviorIDToScriptMap = {}, // Is populated during root_state.onInit function
	VanillaSkillIDToBehaviorIDMap = {
		"actives.adrenaline": 65,
		"actives.aimed_shot": 8,
		"actives.alp_teleport": 70,
		"actives.barbarian_fury": 26,
		"actives.bash": 10,
		"actives.batter": 10,
		"actives.break_free": 41,
		"actives.cascade": 10,
		"actives.charge": 7,
		"actives.charm": 8,
		"actives.chop": 10,
		"actives.cleave": 10,
		"actives.command_undead": 30,
		"actives.crack_the_whip": 67,
		"actives.crumble": 10,
		"actives.crush_armor": 16,
		"actives.cudgel": 10,
		"actives.darkflight": 9,
		"actives.decapitate": 19,
		"actives.demolish_armor": 16,
		"actives.disarm": 20,
		"actives.drums_of_war": 66,
		"actives.explode": 67,
		"actives.fake_drink_night_vision": 61,
		"actives.fire_handgonne": 8,
		"actives.fire_mortar": 74,
		"actives.flail": 10,
		"actives.fling_back": 37,
		"actives.flying_skulls": 79,
		"actives.footwork": 46,
		"actives.gash": 72,
		"actives.geomancy": 67,
		"actives.geomancy_once": 67,
		"actives.ghastly_touch": 10,
		"actives.ghost_overhead_strike": 10,
		"actives.ghost_split": 13,
		"actives.ghost_swing": 14,
		"actives.ghoul_claws": 10,
		"actives.goblin_whip": 45,
		"actives.gore": 7,
		"actives.gorge": 10,
		"actives.grant_night_vision": 62,
		"actives.grow_shield": 22,
		"actives.gruesome_feast": 32,
		"actives.hail": 18,
		"actives.hammer": 10,
		"actives.hand_to_hand": 10,
		"actives.headbutt": 10,
		"actives.hex": 57,
		"actives.hook": 24,
		"actives.horrific_scream": 21,
		"actives.horror": 51,
		"actives.hyena_bite": 10,
		"actives.ignite_firelance": 13,
		"actives.impale": 10,
		"actives.indomitable": 69,
		"actives.insects": 44,
		"actives.knock_back": 24,
		"actives.knock_out": 20,
		"actives.kraken_bite": 10,
		"actives.kraken_devour": 10,
		"actives.kraken_ensnare": 42,
		"actives.kraken_move": 60,
		"actives.kraken_move_ensnared": 59,
		"actives.lash": 18,
		"actives.lightning_storm": 80,
		"actives.line_breaker": 37,
		"actives.load_mortar": 67,
		"actives.merge_golem": 75,
		"actives.miasma": 52,
		"actives.mirror_image": 78,
		"actives.move_tail": 54,
		"actives.nightmare": 55,
		"actives.overhead_strike": 10,
		"actives.possess_undead": 49,
		"actives.pound": 10,
		"actives.prong": 10,
		"actives.puncture": 17,
		"actives.quick_shot": 8,
		"actives.raise_all_undead": 67,
		"actives.raise_undead": 31,
		"actives.rally_the_troops": 47,
		"actives.reap": 50,
		"actives.recover": 48,
		"actives.reload_bolt": 38,
		"actives.reload_handgonne": 38,
		"actives.repel": 24,
		"actives.return_favor": 25,
		"actives.riposte": 25,
		"actives.root": 43,
		"actives.rotation": 26,
		"actives.round_swing": 15,
		"actives.rupture": 10,
		"actives.serpent_bite": 10,
		"actives.serpent_disarm": 20,
		"actives.serpent_hook": 24,
		"actives.shatter": 14,
		"actives.shieldwall": 22,
		"actives.shoot_bolt": 8,
		"actives.shoot_stake": 8,
		"actives.slash": 10,
		"actives.slash_lightning": 10,
		"actives.sleep": 64,
		"actives.sling_stone": 8,
		"actives.smite": 10,
		"actives.spearwall": 23,
		"actives.spider_bite": 10,
		"actives.split": 13,
		"actives.split_axe": 13,
		"actives.split_man": 10,
		"actives.split_shield": 12,
		"actives.stab": 10,
		"actives.strike": 10,
		"actives.strike_down": 20,
		"actives.swallow_whole": 53,
		"actives.sweep": 14,
		"actives.swing": 14,
		"actives.tail_slam": 14,
		"actives.tail_slam_big": 15,
		"actives.tail_slam_split": 13,
		"actives.teleport": 68,
		"actives.thresh": 15,
		"actives.throw_axe": 10,
		"actives.throw_balls": 10,
		"actives.throw_daze_bomb": 73,
		"actives.throw_dirt": 76,
		"actives.throw_fire_bomb": 73,
		"actives.throw_golem": 11,
		"actives.throw_javelin": 10,
		"actives.throw_net": 42,
		"actives.throw_smoke_bomb": 73,
		"actives.throw_spear": 10,
		"actives.thrust": 10,
		"actives.unstoppable_charge": 7,
		"actives.uproot": 13,
		"actives.uproot_small": 10,
		"actives.wake_ally": 63,
		"actives.warcry": 36,
		"actives.wardog_bite": 10,
		"actives.warhound_bite": 10,
		"actives.web": 42,
		"actives.werewolf_bite": 10,
		"actives.whip": 10,
		"actives.wither": 81,
		"actives.wolf_bite": 10,
		"actives.zombie_bite": 10
	},

	function getBehaviorScriptFromID( _id )
	{
		if (this.BehaviorIDToScriptMap.len() == 0)
		{
			throw "This function cannot be used before the root_state.onInit function has run";
		}
		if (!(_id in this.BehaviorIDToScriptMap))
		{
			::logError("Invalid behavior id \'" + _id + "\' and/or the associated script file is not located in \'scripts/ai/tactical/behaviors\'");
			throw ::MSU.Exception.KeyNotFound(_id);
		}

		return this.BehaviorIDToScriptMap[_id];
	}

	function addBehavior ( _id, _name, _order, _score )
	{
		if (_id in ::Const.AI.Behavior.ID) throw ::MSU.Exception.DuplicateKey(_id);

		::Const.AI.Behavior.ID[_id] <- ::Const.AI.Behavior.ID.COUNT;
		::Const.AI.Behavior.ID.COUNT += 1;

		::Const.AI.Behavior.Name.push(_name);
		::Const.AI.Behavior.Order[_id] <- _order;
		::Const.AI.Behavior.Score[_id] <- _score;
	}
}
