import React from 'react';
import clsx from 'clsx';
import Layout from '@theme/Layout';
import Link from '@docusaurus/Link';
import useDocusaurusContext from '@docusaurus/useDocusaurusContext';
import useBaseUrl from '@docusaurus/useBaseUrl';
import styles from './styles.module.css';

const features = [
  {
    title: 'Quick Setup',
    imageUrl: 'img/computer.svg',
    description: (
      <>
        Do you sometimes feel that deploying your ML models on the web can be tougher than the 
        actual modeling process? Well not with TorchBlaze anymore! It's all just a few commands away!
      </>
    ),
  },
  {
    title: 'Focus on What Matters',
    imageUrl: 'img/neural.svg',
    description: (
      <>
        When it comes to ML, the model accuracy should be your primary concern. Let TorchBlaze take care 
        of the API wrapping, dockerization and Heroku deployment. 
      </>
    ),
  },
  {
    title: 'Test Before You Deploy',
    imageUrl: 'img/checklist.svg',
    description: (
      <>
        TorchBlaze comes with build-in test suites that automate testing a variety of components in your project.
        Be it an entire model testing package, or testing your API end-points before you deploy, we've got your back! 
      </>
    ),
  },
];

function Feature({imageUrl, title, description}) {
  const imgUrl = useBaseUrl(imageUrl);
  return (
    <div className={clsx('col col--4', styles.feature)}>
      {imgUrl && (
        <div className="text--center">
          <img className={styles.featureImage} src={imgUrl} alt={title} />
        </div>
      )}
      <h3>{title}</h3>
      <p>{description}</p>
    </div>
  );
}

function Home() {
  const context = useDocusaurusContext();
  const {siteConfig = {}} = context;
  return (
    <Layout
      title={`Hello from ${siteConfig.title}`}
      description="Description will go into a meta tag in <head />">
      <header className={clsx('hero hero--primary', styles.heroBanner)}>
        <div className="container">
          <h1 className="hero__title">{siteConfig.title}</h1>
          <p className="hero__subtitle">{siteConfig.tagline}</p>
          <div className={styles.buttons}>
            <Link
              className={clsx(
                'button button--outline button--secondary button--lg',
                styles.getStarted,
              )}
              to={useBaseUrl('docs/installation/')}>
              Get Started
            </Link>
          </div>
        </div>
      </header>
      <main>
        {features && features.length > 0 && (
          <section className={styles.features}>
            <div className="container">
              <div className="row">
                {features.map((props, idx) => (
                  <Feature key={idx} {...props} />
                ))}
              </div>
            </div>
          </section>
        )}
      </main>
    </Layout>
  );
}

export default Home;
