import { describe, expect, it } from 'vitest'

import { uniqueTag } from './uniqueTag'

describe('uniqueTag', () => {
  it('should return tag with hashed id describing the workflow generated', () => {
    const context = {
      owner: 'octocat',
      repo: 'hello-world',
      issueNumber: 1,
      workingDirectory: 'src',
      visualizeType: 'focus',
    } as const
    const hashedId = 'c17e1d41c71eec2561133e44f966dfac3169bbd870fa32c40c20eaa7ca9b583c'
    const tag = `<!-- This comment was generated by dependency-cruiser-report-action. id: ${hashedId} -->`
    expect(uniqueTag(context)).toBe(tag)
  })

  it('should work with extra key/value of passed object', () => {
    const context = {
      owner: 'octocat',
      repo: 'hello-world',
      issueNumber: 1,
      workingDirectory: 'src',
      visualizeType: 'focus',
      extra: 'foo',
    } as const
    const hashedId = 'c17e1d41c71eec2561133e44f966dfac3169bbd870fa32c40c20eaa7ca9b583c'
    const tag = `<!-- This comment was generated by dependency-cruiser-report-action. id: ${hashedId} -->`
    expect(uniqueTag(context)).toBe(tag)
  })
})
