import { describe, expect, it } from 'vitest'

import { reportBody } from './reportBody'

describe('reportBody', () => {
  it('should return body comment', () => {
    const options = {
      owner: 'octocat',
      repo: 'hello-world',
      issueNumber: 1,
      workingDirectory: 'src',
      sha: '8ef39983ce21a9c80821addbeb63bfe4d4068f9a',
      mermaidText: 'flowchart LR\n\nA ---> B',
      cmdText:
        'yarn -s depcruise --output-type mermaid --config .dependency-cruiser.js dist/index.js src/options.ts',
      visualizeType: 'focus',
    } as const
    const expected = `<!-- This comment was generated by dependency-cruiser-report-action. id: c17e1d41c71eec2561133e44f966dfac3169bbd870fa32c40c20eaa7ca9b583c -->
# dependency-cruiser report

visualize dependenices of changed files.

\`\`\`mermaid
flowchart LR

A ---> B
\`\`\`

Report generated by <a href="https://github.com/MH4GF/dependency-cruiser-report-action">dependency-cruiser report action</a> 8ef39983ce21a9c80821addbeb63bfe4d4068f9a

---

working directory: \`src\`

<details>
<summary>execute command</summary>

\`\`\`
yarn -s depcruise --output-type mermaid --config .dependency-cruiser.js dist/index.js src/options.ts
\`\`\`

</details>
`
    expect(reportBody(options)).toBe(expected)
  })

  it('should return the message `No output was found`', () => {
    const options = {
      owner: 'octocat',
      repo: 'hello-world',
      issueNumber: 1,
      workingDirectory: 'src',
      sha: '8ef39983ce21a9c80821addbeb63bfe4d4068f9a',
      mermaidText: 'flowchart LR\n\n\n\n',
      cmdText: 'yarn -s depcruise --output-type mermaid --config .dependency-cruiser.js docs',
      visualizeType: 'focus',
    } as const
    const expected = `<!-- This comment was generated by dependency-cruiser-report-action. id: c17e1d41c71eec2561133e44f966dfac3169bbd870fa32c40c20eaa7ca9b583c -->
# dependency-cruiser report

visualize dependenices of changed files.

No outputs was found.

Report generated by <a href="https://github.com/MH4GF/dependency-cruiser-report-action">dependency-cruiser report action</a> 8ef39983ce21a9c80821addbeb63bfe4d4068f9a

---

working directory: \`src\`

<details>
<summary>execute command</summary>

\`\`\`
yarn -s depcruise --output-type mermaid --config .dependency-cruiser.js docs
\`\`\`

</details>
`
    expect(reportBody(options)).toBe(expected)
  })
})
